/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class XpSelectionDirector
implements XpViewportDirector,
MouseListener,
HierarchyListener {
    Vector viewports = new Vector();
    Set selection = new HashSet();

    @Override
    public void connectViewport(XpViewport vp) {
        this.viewports.add(vp);
        this.addListeners(vp);
    }

    void addListeners(Component root) {
        root.addMouseListener(this);
        root.addHierarchyListener(this);
        if (root instanceof Container) {
            Component[] c2 = ((Container)root).getComponents();
            for (int i2 = 0; i2 < c2.length; ++i2) {
                this.addListeners(c2[i2]);
            }
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e2) {
    }

    Iterator getSelectedViewports() {
        return this.selection.iterator();
    }

    @Override
    public void disconnectViewport(XpViewport vp) {
        this.viewports.remove(vp);
        this.selection.remove(vp);
    }

    @Override
    public void disconnectAllViewports() {
        Iterator i2 = this.viewports.iterator();
        while (i2.hasNext()) {
            this.disconnectViewport((XpViewport)i2.next());
        }
    }

    XpViewport viewportOfEvent(MouseEvent e2) {
        XpViewport vp = this.findViewportAncestor(e2.getComponent());
        if (vp != null) {
            int index = this.viewports.indexOf(vp);
            XpLog.logger().finest("Vp of " + e2 + " (" + e2.getComponent() + ")");
            if (index >= 0) {
                return (XpViewport)this.viewports.get(index);
            }
        }
        return null;
    }

    XpViewport findViewportAncestor(Component c2) {
        if (c2 instanceof XpViewport) {
            return (XpViewport)c2;
        }
        Container p2 = c2.getParent();
        if (p2 != null && p2 instanceof XpViewport) {
            return this.findViewportAncestor(p2);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        XpViewport vp = this.viewportOfEvent(e2);
        if (vp != null) {
            this.selection.add(vp);
        }
        XpLog.logger().finest("Pressed mouse on " + vp);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }
}

