/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpIndexPrism;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class XpSeriesDisplayer
extends XpCompositePort {
    private int currentFrameIndex = -1;
    private XpViewport.IntValueDispatcher framedispatcher = new XpViewport.IntValueDispatcher("FrameIndex");
    private int cineOffset = 0;
    private XpIndexPrism indexPrism = null;
    private int[] anchorPosition = null;
    private int[] position = null;
    private int[] indexMap = null;
    private int prismXDirection = 0;
    private int prismYDirection = 0;
    private int prismZDirection = 0;
    private int[] sceneIndexMap = null;
    private int sceneSkip = 1;

    public XpSeriesDisplayer() {
        this.initSeriesDisplayer();
    }

    public XpSeriesDisplayer(int selectionPolicy, int selectionMode) {
        super(selectionPolicy, selectionMode);
        this.initSeriesDisplayer();
    }

    public XpSeriesDisplayer(String rendererType) {
        super(rendererType);
        this.initSeriesDisplayer();
    }

    public XpSeriesDisplayer(String rendererType, int selectionPolicy, int selectionMode) {
        super(rendererType, selectionPolicy, selectionMode);
        this.initSeriesDisplayer();
    }

    public XpSeriesDisplayer(RmRenderSession rs, String remote2DRenderer) {
        super(rs, remote2DRenderer);
        this.initSeriesDisplayer();
    }

    private void initSeriesDisplayer() {
        this.setSyncRenderAttributes(false);
        this.syncPorts();
    }

    @Override
    public Object clone() {
        int len;
        XpSeriesDisplayer sd = new XpSeriesDisplayer(this.getRendererType(), this.getSelectionPolicy(), this.getSelectionMode());
        this.copyObject(sd);
        sd.currentFrameIndex = this.currentFrameIndex;
        sd.cineOffset = this.cineOffset;
        sd.sceneSkip = this.sceneSkip;
        sd.setIndexPrism((XpIndexPrism)this.getIndexPrism().clone());
        for (int i2 = 0; i2 < this.anchorPosition.length; ++i2) {
            sd.anchorPosition[i2] = this.anchorPosition[i2];
            sd.position[i2] = this.position[i2];
        }
        sd.prismXDirection = this.prismXDirection;
        sd.prismYDirection = this.prismYDirection;
        sd.prismZDirection = this.prismZDirection;
        if (this.indexMap != null) {
            len = this.indexMap.length;
            sd.indexMap = new int[this.indexMap.length];
            System.arraycopy(this.indexMap, 0, sd.indexMap, 0, len);
        }
        if (this.sceneIndexMap != null) {
            len = this.sceneIndexMap.length;
            sd.sceneIndexMap = new int[this.sceneIndexMap.length];
            System.arraycopy(this.sceneIndexMap, 0, sd.sceneIndexMap, 0, len);
        }
        return sd;
    }

    @Override
    public void setImages(XpMedicalImage[] images) {
        if (this.getCine()) {
            return;
        }
        super.setImages(images);
        this.defaultSharedIRA();
        this.sync();
        this.init();
        this.setComponentSelection(0);
    }

    public final int getSceneIndex(int[] pos) {
        int index = this.getIndexPrism().getIndex(pos);
        int mapIdx = this.getIndexMapValue(index);
        return mapIdx;
    }

    private String strPrismIndex(int[] prismpos) {
        String prismPosStr = "[";
        for (int i2 = 0; i2 < prismpos.length; ++i2) {
            prismPosStr = prismPosStr + prismpos[i2];
            if (i2 >= prismpos.length - 1) continue;
            prismPosStr = prismPosStr + ",";
        }
        prismPosStr = prismPosStr + "]";
        return prismPosStr;
    }

    @Override
    protected void syncPortsCB() {
        int portListLen = this.getNumPorts();
        if (this.sceneIndexMap == null || this.sceneIndexMap.length != portListLen) {
            this.sceneIndexMap = new int[portListLen];
        }
    }

    private void snakeLayout() {
        XpFrameVisualizer fv;
        int j2;
        int nports = this.getNumPorts();
        int rows = this.getRows();
        int cols = this.getCols();
        int configLen = rows * cols;
        int size = this.getNumScenes();
        int dim = this.getIndexPrism().getDimensions();
        this.copyVect(this.anchorPosition, this.position);
        int startPos = this.getSceneIndex(this.position);
        int xdir = this.getPrismXDirection();
        int xlen = this.getIndexPrism().getSize(xdir);
        int len = xlen < configLen ? xlen : configLen;
        int px = this.position[xdir];
        boolean adjustfocus = false;
        for (j2 = 0; j2 < len; ++j2) {
            int sceneIndex;
            fv = this.getPort(j2);
            this.sceneIndexMap[j2] = sceneIndex = this.getSceneIndex(this.position);
            XpImageScene fs = null;
            if (sceneIndex >= 0 && sceneIndex < size) {
                fs = this.getScene(sceneIndex);
            }
            XpDicomObject dobj = null;
            if (fs != null) {
                dobj = this.getDicomSource(sceneIndex);
            }
            fv.setFrameScene(fs, dobj);
            if (j2 != 0) {
                boolean f2 = fv.getMedicalImageVc().getImageVc().hasFocus() && fs == null;
                adjustfocus |= f2;
            }
            int n2 = this.prismXDirection;
            this.position[n2] = this.position[n2] + 1;
        }
        for (j2 = len; j2 < nports; ++j2) {
            fv = this.getPort(j2);
            fv.setFrameScene(null, null);
        }
        if (adjustfocus) {
            XpFrameVisualizer fv2 = this.getPort(0);
            fv2.getMedicalImageVc().getImageVc().requestFocus();
        }
    }

    private void gridLayout() {
        int rows = this.getRows();
        int cols = this.getCols();
        int configLen = rows * cols;
        int size = this.getNumScenes();
        boolean adjustfocus = false;
        this.copyVect(this.anchorPosition, this.position);
        int i2 = 0;
        for (int y2 = 0; y2 < rows; ++y2) {
            this.position[this.prismXDirection] = this.anchorPosition[this.prismXDirection];
            for (int x2 = 0; x2 < cols; ++x2) {
                int sceneIndex;
                XpFrameVisualizer fv = this.getPort(i2);
                this.sceneIndexMap[i2] = sceneIndex = this.getSceneIndex(this.position);
                ++i2;
                XpImageScene fs = null;
                if (sceneIndex >= 0 && sceneIndex < size) {
                    fs = this.getScene(sceneIndex);
                }
                XpDicomObject dobj = null;
                if (fs != null) {
                    dobj = this.getDicomSource(sceneIndex);
                }
                fv.setFrameScene(fs, dobj);
                if (i2 != 0) {
                    boolean f2 = fv.getMedicalImageVc().getImageVc().hasFocus() && fs == null;
                    adjustfocus |= f2;
                }
                int n2 = this.prismXDirection;
                this.position[n2] = this.position[n2] + 1;
            }
            int n3 = this.prismYDirection;
            this.position[n3] = this.position[n3] + 1;
        }
        if (adjustfocus) {
            XpFrameVisualizer fv = this.getPort(0);
            fv.getMedicalImageVc().getImageVc().requestFocus();
        }
    }

    private void clearPorts() {
        int rows = this.getRows();
        int cols = this.getCols();
        int configLen = rows * cols;
        for (int j2 = 0; j2 < configLen; ++j2) {
            XpFrameVisualizer fv = this.getPort(j2);
            fv.setFrameScene(null, null);
        }
    }

    @Override
    protected void doLayoutPorts() {
        if (this.getNumScenes() > 0) {
            boolean snake = false;
            if (this.prismXDirection == this.prismYDirection) {
                snake = true;
            }
            if (snake) {
                this.snakeLayout();
            } else {
                this.gridLayout();
            }
        } else {
            this.clearPorts();
        }
    }

    @Override
    public int getSceneIndexAtPort(int portIdx) {
        if (portIdx < 0 || portIdx >= this.sceneIndexMap.length) {
            return -1;
        }
        return this.sceneIndexMap[portIdx];
    }

    private void initDefaultPrism() {
        int[] dims = new int[]{this.getNumFrames()};
        this.prismZDirection = 0;
        this.prismYDirection = 0;
        this.prismXDirection = 0;
        XpIndexPrism dip = new XpIndexPrism(dims);
        dip.loadIdentity();
        this.setIndexPrism(dip);
        this.anchorPosition[this.prismXDirection] = 0;
        this.anchorPosition[this.prismYDirection] = 0;
        this.anchorPosition[this.prismZDirection] = 0;
    }

    private void init() {
        int size = this.getNumPorts();
        for (int i2 = 0; i2 < size; ++i2) {
            XpFrameVisualizer fv = this.getPort(i2);
            fv.getMedicalImageVc().getImageVc().setBorder(null);
            fv.getMedicalImageVc().getAnnotationGenerator().reset();
            XpImageScene fs = this.getScene(i2);
            if (fs == null) continue;
            fs.setSelectedState(0);
        }
        this.resetPortSelection();
        this.setEndOffset(this.getNumFrames() - 1);
    }

    @Override
    protected void sync() {
        this.initDefaultPrism();
        this.syncPorts();
    }

    @Override
    public void setFrameIndex(int index) {
        boolean found;
        if (this.getIndexPrism() != null && (found = this.getIndexPrism().findIndex(index, this.position))) {
            this.setPrismStartPosition(this.position);
        }
    }

    @Override
    public int getFrameIndex() {
        if (this.anchorPosition == null) {
            return -1;
        }
        int index = this.getIndexPrism().getIndex(this.anchorPosition);
        int mapIndex = this.getIndexMapValue(index);
        return mapIndex;
    }

    public XpIndexPrism getIndexPrism() {
        return this.indexPrism;
    }

    protected void copyVect(int[] src, int[] dest) {
        for (int i2 = 0; i2 < dest.length; ++i2) {
            dest[i2] = src[i2];
        }
    }

    public void setIndexPrism(XpIndexPrism indexPrism) {
        this.indexPrism = indexPrism;
        int dimensions = indexPrism.getDimensions();
        this.position = new int[dimensions];
        this.anchorPosition = new int[dimensions];
    }

    public void flip(int nFrames) {
        this.copyVect(this.anchorPosition, this.position);
        int dimSizeX = this.getIndexPrism().getSize(this.prismXDirection);
        if (this.prismXDirection != this.prismYDirection) {
            int posZ = this.position[this.prismZDirection];
            int dZ = this.getIndexPrism().getSize(this.prismZDirection);
            int nZ = posZ + nFrames;
            if (nZ < 0) {
                nZ += nFrames;
            }
            this.position[this.prismZDirection] = nZ %= dZ;
        } else {
            int idx = this.getIndexPrism().getIndex(this.position);
            int len = this.getNumFrames();
            if ((idx += nFrames) < 0) {
                idx = len + idx;
            }
            this.getIndexPrism().findIndex(idx %= len, this.position);
        }
        this.setPrismStartPosition(this.position);
        this.callRepaint();
    }

    protected final int getIndexMapValue(int indexVal) {
        if (this.indexMap != null) {
            return this.indexMap[indexVal];
        }
        return indexVal;
    }

    public void setIndexMap(int[] indexMap) {
        if (indexMap != null && indexMap.length != this.getNumFrames()) {
            return;
        }
        this.indexMap = indexMap;
    }

    public int getPrismDimensions() {
        if (this.getIndexPrism() != null) {
            return this.getIndexPrism().getDimensions();
        }
        return 0;
    }

    public final int getPrismXDirection() {
        return this.prismXDirection;
    }

    public final boolean setPrismXDirection(int dir) {
        if (dir < 0 || dir >= this.getPrismDimensions()) {
            return false;
        }
        this.prismXDirection = dir;
        this.layoutImages();
        return true;
    }

    public final int getPrismYDirection() {
        return this.prismYDirection;
    }

    public final boolean setPrismYDirection(int dir) {
        int pd = this.getPrismDimensions();
        if (dir < 0 || dir >= pd) {
            return false;
        }
        this.prismYDirection = dir;
        this.layoutImages();
        return true;
    }

    public final int getPrismZDirection() {
        return this.prismZDirection;
    }

    public final boolean setPrismZDirection(int dir) {
        if (dir < 0 || dir >= this.getPrismDimensions()) {
            return false;
        }
        this.prismZDirection = dir;
        return true;
    }

    public final void setPrismStartPosition(int[] position) {
        if (position.length != this.anchorPosition.length) {
            return;
        }
        if (position != this.anchorPosition) {
            this.copyVect(position, this.anchorPosition);
        }
        this.layoutImages();
        int new_idx = this.getFrameIndex();
        if (new_idx != this.currentFrameIndex) {
            this.notifyFrameIndexListeners(this.currentFrameIndex, new_idx);
            this.currentFrameIndex = new_idx;
            this.cineOffset = new_idx;
        }
    }

    public final int[] getPrismStartPosition(int[] position) {
        int[] res = position;
        if (res == null) {
            res = new int[this.anchorPosition.length];
        }
        if (res.length != this.anchorPosition.length) {
            return null;
        }
        this.copyVect(this.anchorPosition, res);
        return res;
    }

    public final int[] getComponentSelections() {
        ArrayList<Integer> al2 = new ArrayList<Integer>();
        int idx = -1;
        int size = this.getNumPorts();
        for (int i2 = 0; i2 < size; ++i2) {
            int sel;
            XpFrameVisualizer fv = this.getPort(i2);
            XpImageScene fs = fv.getScene();
            if (fs == null || (sel = fs.getSelectedState()) <= 0) continue;
            al2.add(new Integer(i2));
        }
        int[] idxArr = null;
        size = al2.size();
        if (size > 0) {
            idxArr = new int[size];
            for (int i3 = 0; i3 < size; ++i3) {
                idxArr[i3] = (Integer)al2.get(i3);
            }
        }
        return idxArr;
    }

    @Override
    protected MouseListener getSelectionHandler(int portIdx) {
        return new VpSelector(this, portIdx);
    }

    @Override
    public void setOffset(int offset) {
        if (offset < 0) {
            return;
        }
        int nCineFrames = this.getMaxFrame();
        if (nCineFrames != 0) {
            offset %= nCineFrames;
        }
        this.cineOffset = offset;
        this.copyVect(this.anchorPosition, this.position);
        this.position[this.prismZDirection] = offset;
        this.setPrismStartPosition(this.position);
    }

    @Override
    public int getOffset() {
        return this.cineOffset;
    }

    @Override
    public int getMaxFrame() {
        return this.getIndexPrism().getSize(this.prismZDirection);
    }

    public final int getSceneSkip() {
        return this.sceneSkip;
    }

    public final void setSceneSkip(int sceneSkip) {
        this.sceneSkip = sceneSkip;
    }

    @Override
    public final void setAutoRepaint(boolean autoRepaint) {
        boolean prev = this.isAutoRepaint();
        super.setAutoRepaint(autoRepaint);
        if (!prev && this.isAutoRepaint()) {
            this.callRepaint();
        }
    }

    private void notifyFrameIndexListeners(int oldIndex, int newIndex) {
        this.framedispatcher.setValues(this, newIndex);
        SwingUtilities.invokeLater(this.framedispatcher);
    }

    private static class VpSelector
    implements MouseListener {
        private XpSeriesDisplayer sd = null;
        private int portIdx = 0;

        public VpSelector(XpSeriesDisplayer sd, int portIdx) {
            this.sd = sd;
            this.portIdx = portIdx;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            int clickCount = me.getClickCount();
            if (clickCount == 2) {
                boolean shift;
                XpImage2DVc ivc = (XpImage2DVc)me.getSource();
                int modifier = me.getModifiers();
                boolean ctrl = (modifier & 2) != 0;
                boolean bl = shift = (modifier & 1) != 0;
                if (!ctrl) {
                    this.sd.setPortSelection(this.portIdx, 1, true);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            XpImage2DVc ivc = (XpImage2DVc)me.getSource();
            XpImageRenderAttributes ira = ivc.getImageRenderAttributes();
            this.sd.updatePropRenderAttributes();
            this.sd.callRepaint();
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            boolean shift;
            XpImage2DVc ivc = (XpImage2DVc)me.getSource();
            int modifier = me.getModifiers();
            boolean ctrl = (modifier & 2) != 0;
            boolean bl = shift = (modifier & 1) != 0;
            if (ctrl) {
                this.sd.setPortSelection(this.portIdx, 2, false);
            } else if (!shift) {
                this.sd.setPortSelection(this.portIdx, 1, false);
            }
            ivc.requestFocus();
        }
    }
}

