/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.Replicable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class XpTickMarkRuler
extends XpVisualComponent
implements Replicable {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int orientation;
    private XpImage prevImage;
    private Rectangle r;
    private DecimalFormat df;
    private int tickFreq = 5;
    private int tickLength = 5;
    private double tickSpacing = 10.0;
    private int margin = 30;
    private CTransform imgDispTrans = null;
    private CPoint borderPt = new CPoint(0);
    private CPoint borderPt1 = new CPoint(0);
    private CPoint centerImagePoint = new CPoint(0);
    private CPoint oneImageTick = new CPoint(0);
    private CPoint centerPoint = new CPoint(0);
    private CPoint oneTick = new CPoint(0);

    public XpTickMarkRuler(int orientation) {
        this.orientation = orientation;
        this.prevImage = null;
        this.r = new Rectangle();
        this.df = new DecimalFormat("###0.##");
        this.setForeground(Color.orange);
    }

    @Override
    public Object clone() {
        XpTickMarkRuler ccr = new XpTickMarkRuler(this.orientation);
        this.copyObject(ccr);
        return ccr;
    }

    protected void copyObject(Object o2) {
        XpTickMarkRuler is = (XpTickMarkRuler)o2;
        is.orientation = this.orientation;
        is.r = (Rectangle)this.r.clone();
        is.df = new DecimalFormat("###0.##");
    }

    public XpTickMarkRuler(int orientation, int atickFreq, int atickLength, int atickSpacing, int amargin) {
        this.orientation = 1;
        this.prevImage = null;
        this.r = new Rectangle();
        this.df = new DecimalFormat("###0.##");
        this.setForeground(Color.orange);
        this.tickFreq = atickFreq;
        this.tickLength = atickLength;
        this.tickSpacing = atickSpacing;
        this.margin = amargin;
        this.orientation = orientation;
    }

    @Override
    public final boolean contains(int x2, int y2) {
        return this.r.contains(x2, y2);
    }

    protected final void line(Graphics g2, int x1, int y1, int x2, int y2) {
        g2.setColor(Color.black);
        g2.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
        Color foreground = this.getForeground();
        g2.setColor(foreground);
        g2.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        Rectangle vp = this.getBounds();
        boolean updateInfo = false;
        double pixX = 1.0;
        double pixY = 1.0;
        Container c2 = this.getParent();
        if (c2 instanceof XpImage2DVc) {
            XpImage2DVc mivc = (XpImage2DVc)c2;
            XpImage img = mivc.getFrame();
            if (img != null) {
                pixX = img.getPixelDimensionX();
                pixY = img.getPixelDimensionY();
            } else {
                pixY = 1.0;
                pixX = 1.0;
            }
            if (this.prevImage != img) {
                updateInfo = true;
                this.prevImage = img;
            }
        } else {
            XpLog.logger().warning("Parent container is not a XpImage2DVc.");
        }
        if (this.orientation == 0) {
            this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
            this.oneImageTick.setLocation(this.tickSpacing / pixY, 0.0, 0.0);
            if (this.imgDispTrans == null) {
                this.imgDispTrans = this.getTransform((byte)0, (byte)1);
            }
            this.imgDispTrans.transform(this.centerImagePoint, this.centerPoint);
            this.imgDispTrans.transform(this.oneImageTick, this.oneTick);
            double cmHeight = Math.sqrt(this.square(this.oneTick.x - this.centerPoint.x) + this.square(this.oneTick.y - this.centerPoint.y));
            double maxHeight = (double)vp.height / 3.0;
            int nbOfCm = cmHeight > 0.0 ? (int)(maxHeight / cmHeight) : 1;
            double x2 = vp.width - this.margin;
            double ymargin = ((double)vp.height - (double)nbOfCm * cmHeight) / 2.0;
            int i2 = 0;
            double y1 = 0.0;
            double y2 = 0.0;
            for (i2 = 0; i2 < nbOfCm; ++i2) {
                y1 = (double)i2 * cmHeight + ymargin;
                y2 = y1 + cmHeight;
                if (i2 == 0) {
                    this.borderPt.setLocation(x2, y1, 0.0);
                }
                this.line(g2, (int)x2 - this.getTickLength(i2), (int)y1, (int)x2, (int)y1);
                if (i2 == nbOfCm - 1) {
                    this.borderPt1.setLocation(x2, y2, 0.0);
                }
                this.line(g2, (int)x2, (int)y2, (int)x2 - this.getTickLength(i2 + 1), (int)y2);
            }
            this.line(g2, (int)this.borderPt.x, (int)this.borderPt.y, (int)this.borderPt1.x, (int)this.borderPt1.y);
        } else if (this.orientation == 1) {
            this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
            this.oneImageTick.setLocation(this.tickSpacing / pixX, 0.0, 0.0);
            if (this.imgDispTrans == null) {
                this.imgDispTrans = this.getTransform((byte)0, (byte)1);
            }
            this.imgDispTrans.transform(this.centerImagePoint, this.centerPoint);
            this.imgDispTrans.transform(this.oneImageTick, this.oneTick);
            double maxWidth = (double)vp.width / 2.0;
            double cmWidth = Math.sqrt(this.square(this.oneTick.x - this.centerPoint.x) + this.square(this.oneTick.y - this.centerPoint.y));
            int nbOfCm = cmWidth > 0.0 ? (int)(maxWidth / cmWidth) : 1;
            double xmargin = ((double)vp.width - (double)nbOfCm * cmWidth) / 2.0;
            int i3 = 0;
            double y2 = vp.height - this.margin;
            for (i3 = 0; i3 < nbOfCm; ++i3) {
                double x1 = (double)i3 * cmWidth + xmargin;
                double x2 = x1 + cmWidth;
                if (i3 == 0) {
                    this.borderPt.setLocation(x1, y2, 0.0);
                }
                this.line(g2, (int)x1, (int)(y2 - (double)this.getTickLength(i3)), (int)x1, (int)y2);
                if (i3 == nbOfCm - 1) {
                    this.borderPt1.setLocation(x2, y2, 0.0);
                }
                this.line(g2, (int)x2, (int)y2, (int)x2, (int)y2 - this.getTickLength(i3 + 1));
            }
            this.line(g2, (int)this.borderPt.x, (int)this.borderPt.y, (int)this.borderPt1.x, (int)this.borderPt1.y);
        }
    }

    private double square(double n2) {
        return n2 * n2;
    }

    public int getTickLength(int i2) {
        if (i2 % this.tickFreq == 0) {
            return this.tickLength << 1;
        }
        return this.tickLength;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }
}

