/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.annotation;

import com.ge.med.StdAnno.ApAppearance;
import com.ge.med.StdAnno.ApDicomAccessor;
import com.ge.med.StdAnno.ApDicomElement;
import com.ge.med.StdAnno.ApGroup;
import com.ge.med.StdAnno.ApLocation;
import com.ge.med.StdAnno.ApMultiFrameAccessor;
import com.ge.med.StdAnno.ApSeg;
import com.ge.med.StdAnno.ApSeqItem;
import com.ge.med.StdAnno.ApSequence;
import com.ge.med.StdAnno.ApStyle;
import com.ge.med.StdAnno.ApTextDrawer;
import com.ge.med.StdAnno.CTApStyle;
import com.ge.med.StdAnno.MRApStyle;
import com.ge.med.StdAnno.PETApStyle;
import com.ge.med.StdAnno.SCApStyle;
import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.idc.XjSeqItem;
import com.ge.med.idc.XjSequence;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicyManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class XpApdAnnotation
extends XpAnnotationModel {
    private static final int MAX_LINES = 64;
    private static final int LINE_OFFSET = 32;
    private static Map groupMap = new HashMap();
    private ApStyle _apStyle = null;
    private ApDicomAccessor _accesor = null;
    private AnnotationDrawer _ad = null;
    private int language = 3;
    private boolean doToolTip = true;
    private boolean apdEnabled = true;
    private boolean debug = false;
    private boolean isDrawBlankString = false;
    private boolean isDrawBorder = false;
    private APDAnnotationGroups groups = null;
    private String[] segnames = new String[128];
    private int[] segnumber = new int[128];
    private ArrayList segments = null;
    private static Map configMap;
    private static XpAnnotationPolicyManager apm;

    public XpApdAnnotation(XpDicomObject mi, ApStyle apStyle) {
        super(mi);
        this._apStyle = apStyle;
        this._accesor = mi instanceof XjDicomObjectFrame && ((XjDicomObjectFrame)((Object)mi)).getMultiFrameType() != XjDicomObjectFrame.MultiFrameType.SINGLE_FRAME ? new MultiFrameDicomAccessor() : new StdDicomAccesor();
        this._apStyle.setValueAccessor(this._accesor);
        this._ad = this.createAnnotationDrawer();
        this._apStyle.setTextDrawer(this._ad);
        this._apStyle.reset();
        this._apStyle.setAllGroupsOn();
        this._apStyle.setCurrentPriority(0);
        Class<?> apStyleClass = this._apStyle.getClass();
        XpAnnotationConfig aConfig = this.getAnnotationConfig(apStyleClass);
        this.setAnnotationConfig(aConfig);
        this.groups = (APDAnnotationGroups)groupMap.get(apStyleClass);
        if (this.groups == null) {
            this.groups = new APDAnnotationGroups();
            XpApdAnnotation.parseGroups(this._apStyle, this.groups);
            groupMap.put(apStyleClass, this.groups);
        }
        this.buildSegments();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._apStyle.setTextDrawer(null);
        this._apStyle.setValueAccessor(null);
        this._ad = null;
        this._accesor = null;
    }

    private static int apd2jamiSize(int apSize) {
        switch (apSize) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 1;
    }

    private static int apd2jamiStyle(int apStyle) {
        switch (apStyle) {
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    protected AnnotationDrawer createAnnotationDrawer() {
        return new AnnotationDrawer(this);
    }

    public void setTestRendering(boolean testRendering) {
        this._ad = testRendering ? new DebugAnnotationDrawer(this) : new AnnotationDrawer(this);
        this._apStyle.setTextDrawer(this._ad);
        this._apStyle.reset();
    }

    @Override
    public int getAnnotationKey(String annotationItem) {
        for (int i2 = 0; i2 < this.segnames.length; ++i2) {
            String s2 = this.segnames[i2];
            if (s2 == null || !s2.equals(annotationItem)) continue;
            return i2;
        }
        return -1;
    }

    public String[] getAnnotationSegmentItems(int gnum) {
        ArrayList<String> al2 = new ArrayList<String>();
        for (int i2 = 0; i2 < this.segnumber.length; ++i2) {
            if (this.segnumber[i2] == -1 || this.segnumber[i2] != gnum) continue;
            al2.add(this.segnames[i2]);
        }
        String[] sa = new String[al2.size()];
        System.arraycopy(al2.toArray(), 0, sa, 0, al2.size());
        return sa;
    }

    public String getSegmentName(int annotationKey) {
        return this.segnames[annotationKey];
    }

    private void updatePriority(int priority) {
        if (this._apStyle.getCurrentPriority() != priority) {
            this._apStyle.setCurrentPriority(priority);
        }
    }

    protected void buildSegments() {
        for (int i2 = 0; i2 < 128; ++i2) {
            this.segnumber[i2] = -1;
        }
        int nquads = this._apStyle.getNumQuads();
        for (int q2 = 0; q2 < nquads; ++q2) {
            int startLine = this._apStyle.getStartLine(q2);
            int endLine = this._apStyle.getLastLine(q2);
            for (int l2 = startLine; l2 <= endLine; ++l2) {
                int nsegs = this._apStyle.getNumSegments(q2, l2);
                for (int s2 = 0; s2 < nsegs; ++s2) {
                    ApSeg seg = this._apStyle.getSegAt(q2, l2, s2);
                    if (seg == null) continue;
                    this.segnames[seg.annotationKey] = seg.name;
                    this.segnumber[seg.annotationKey] = seg.groupNumber;
                }
            }
        }
    }

    @Override
    public String[] getAnnotationSegments() {
        if (this.segments == null) {
            this.segments = new ArrayList();
            int nquads = this._apStyle.getNumQuads();
            for (int q2 = 0; q2 < nquads; ++q2) {
                int startLine = this._apStyle.getStartLine(q2);
                int endLine = this._apStyle.getLastLine(q2);
                for (int l2 = startLine; l2 <= endLine; ++l2) {
                    int nsegs = this._apStyle.getNumSegments(q2, l2);
                    for (int s2 = 0; s2 < nsegs; ++s2) {
                        ApSeg seg = this._apStyle.getSegAt(q2, l2, s2);
                        this.segments.add(seg != null ? seg.name : "");
                    }
                }
            }
        }
        String[] segs = new String[this.segments.size()];
        for (int i2 = 0; i2 < segs.length; ++i2) {
            segs[i2] = (String)this.segments.get(i2);
        }
        return segs;
    }

    private static void parseGroups(ApStyle aps, APDAnnotationGroups groups) {
        ApGroup g2 = aps.getFirstGroup();
        while (g2 != null) {
            XpApdAnnotation.parseChildren(g2, groups);
            g2 = aps.getNextGroup();
        }
    }

    public final ApStyle getApStyle() {
        return this._apStyle;
    }

    private static void parseChildren(ApGroup g2, APDAnnotationGroups groups) {
        ApGroup c2 = g2.getFirstChildGroup();
        if (c2 != null) {
            if (!groups.groupContainers.contains(g2)) {
                groups.groupContainers.add(g2);
            }
            while (c2 != null) {
                XpApdAnnotation.parseChildren(c2, groups);
                c2 = g2.getNextChildGroup();
            }
        } else if (!groups.groupLeaves.contains(g2)) {
            groups.groupLeaves.add(g2);
            groups.groupNumberMap.put(g2.getGroupName(), new Integer(g2.getGroupNumber()));
        }
    }

    private static void getChildGroups(ApGroup g2, List l2) {
        ApGroup child = g2.getFirstChildGroup();
        while (child != null) {
            String gName = child.getGroupName();
            if (gName != null) {
                l2.add(gName);
            }
            XpApdAnnotation.getChildGroups(child, l2);
            child = g2.getNextChildGroup();
        }
    }

    @Override
    public String[] getAnnotationGroups() {
        int len = this.groups.groupContainers.size();
        String[] agNames = null;
        if (len > 0) {
            agNames = new String[len];
            for (int i2 = 0; i2 < len; ++i2) {
                ApGroup ag2 = (ApGroup)this.groups.groupContainers.get(i2);
                agNames[i2] = ag2.getGroupName();
            }
        }
        return agNames;
    }

    @Override
    public String[] getAnnotationItems() {
        int len = this.groups.groupLeaves.size();
        String[] agNames = null;
        if (len > 0) {
            agNames = new String[len];
            for (int i2 = 0; i2 < len; ++i2) {
                ApGroup ag2 = (ApGroup)this.groups.groupLeaves.get(i2);
                agNames[i2] = ag2.getGroupName();
            }
        }
        return agNames;
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
        this._apStyle.setAllGroupsOff();
        ApGroup ag2 = this._apStyle.getGroup(agName);
        if (ag2 != null) {
            ag2.setGroupState(activate);
        }
    }

    @Override
    public String[] getAnnotationItems(String agName) {
        int len;
        String[] gnames = null;
        ArrayList l2 = (ArrayList)this.groups.groupMap.get(agName);
        if (l2 == null) {
            ApGroup g2 = this._apStyle.getGroup(agName);
            l2 = new ArrayList();
            XpApdAnnotation.getChildGroups(g2, l2);
        }
        if ((len = l2.size()) > 0) {
            gnames = new String[len];
            for (int i2 = 0; i2 < len; ++i2) {
                gnames[i2] = (String)l2.get(i2);
            }
        }
        return gnames;
    }

    @Override
    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        int len = Math.min(queryRes.length, annoItems.length);
        for (int i2 = 0; i2 < len; ++i2) {
            ApGroup ag2 = this._apStyle.getGroup(annoItems[i2]);
            boolean sval = false;
            if (ag2 != null) {
                sval = ag2.getGroupState();
            }
            queryRes[i2] = sval;
        }
    }

    @Override
    public boolean queryAnnotationItem(String aiName) {
        ApGroup ag2 = this._apStyle.getGroup(aiName);
        boolean sval = false;
        if (ag2 != null) {
            sval = ag2.getGroupState();
        }
        return sval;
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
        for (int i2 = 0; i2 < annoItems.length; ++i2) {
            ApGroup ag2 = this._apStyle.getGroup(annoItems[i2]);
            if (ag2 == null) continue;
            ag2.setGroupState(activate);
        }
    }

    public int queryAnnoGroupNumber(String gname) {
        Integer num = (Integer)this.groups.groupNumberMap.get(gname);
        if (num != null) {
            return num;
        }
        return -1;
    }

    public static boolean registerAnnotationConfig(Class apStyle, String annotConfigClass) {
        if (ApStyle.class.isAssignableFrom(apStyle)) {
            configMap.put(apStyle, annotConfigClass);
            return true;
        }
        return false;
    }

    protected XpAnnotationConfig getAnnotationConfig(Class apStyle) {
        String className = (String)configMap.get(apStyle);
        if (className != null) {
            XpAnnotationConfig ac2 = XpApdAnnotation.createAnnotationConfig(className);
            return ac2;
        }
        return null;
    }

    private static XpAnnotationConfig createAnnotationConfig(String className) {
        XpAnnotationConfig ac2 = null;
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            XpLog.logger().warning("XpAnnotationConfig class not found : " + className);
        }
        if (cl != null) {
            try {
                Class<?>[] paramType = null;
                Constructor<?> c2 = cl.getConstructor(paramType);
                if (c2 != null) {
                    Object[] args = null;
                    ac2 = (XpAnnotationConfig)c2.newInstance(args);
                }
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        } else {
            XpLog.logger().warning("XpAnnotationConfig does not exist: " + className);
        }
        return ac2;
    }

    public static ApStyle createApStyle(String className) {
        ApStyle as;
        block11: {
            as = null;
            try {
                Class<?> cl = Class.forName(className);
                if (cl == null) break block11;
                try {
                    Class<?>[] paramType = null;
                    Constructor<?> c2 = cl.getConstructor(paramType);
                    if (c2 != null) {
                        Object[] args = null;
                        as = (ApStyle)c2.newInstance(args);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    nsme.printStackTrace();
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
            }
            catch (IllegalArgumentException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (as == null) {
            XpLog.logger().warning("Error loading ApStyle " + className);
        }
        return as;
    }

    @Override
    public void loadDicomTags() {
        String[] strTags = this._apStyle.getDicomTags();
        int len = strTags.length;
        XpDicomElement[] de = new XpDicomElement[len];
        for (int i2 = 0; i2 < len; ++i2) {
            StringTokenizer st = new StringTokenizer(strTags[i2], ",");
            int group = Integer.parseInt(st.nextToken());
            int element = Integer.parseInt(st.nextToken());
            de[i2] = new XpDicomElement(group, element);
        }
        this.getDicomObject().getValues(de);
        this.setTagsLoaded(true);
    }

    public final int getNumLanguages() {
        return 15;
    }

    public final void setLanguage(int languageIdx) {
        if (languageIdx >= 0 && languageIdx < 15) {
            this.language = languageIdx;
        }
    }

    public final int getLanguage() {
        return this.language;
    }

    @Override
    public int insideAnnotation(int x2, int y2) {
        if (this.apdEnabled && this.doToolTip && this._ad != null) {
            return this._ad.insideAnnotation(x2, y2);
        }
        return -1;
    }

    @Override
    public String getTooltip(int key) {
        String tooltip = this._apStyle.getTooltip(this.language, key);
        if (tooltip != null) {
            return tooltip;
        }
        return "";
    }

    @Override
    public final void setProperty(String propName, String value) {
        this._apStyle.setRTVar(propName, value);
    }

    @Override
    public final void setProperty(String propName, double value) {
        this._apStyle.setRTVar(propName, value);
    }

    @Override
    public final void setProperty(String propName, long value) {
        this._apStyle.setRTVar(propName, value);
    }

    @Override
    public final void setProperty(String propName, int value) {
        this._apStyle.setRTVar(propName, value);
    }

    @Override
    public final void setProperty(String propName, boolean value) {
        this._apStyle.setRTVar(propName, value);
    }

    @Override
    public void setProperty(String propName, Object value) {
        if (propName.equals("ACTIVE_ANNOT_MAP")) {
            this._ad.setActiveAnnotationMap((boolean[])value);
        }
    }

    @Override
    public void drawAnnotation(Graphics g2, Rectangle bounds) {
        if (!this.isTagsLoaded()) {
            return;
        }
        int w2 = (int)bounds.getWidth();
        int h2 = (int)bounds.getHeight();
        if (w2 > 100 && h2 > 100) {
            XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
            Font f2 = apm.getAnnotationFont(w2, h2);
            g2.setFont(f2);
            this._ad.setGraphicBounds(g2, bounds);
            this._apStyle.paintAnnotation();
            this.apdEnabled = true;
        } else {
            this.apdEnabled = false;
        }
    }

    private static XpAnnotationPolicyManager getAnnotationPolicyManager() {
        XpAnnotationPolicy ap = XpApdAnnotation.getAnnotationPolicy();
        if (ap instanceof XpAnnotationPolicyManager) {
            apm = (XpAnnotationPolicyManager)ap;
        } else if (apm == null) {
            apm = new AnnotationPolicyManager(ap);
        }
        return apm;
    }

    public boolean isDrawBlankString() {
        return this.isDrawBlankString;
    }

    public void setDrawBlankString(boolean isDrawBlankString) {
        this.isDrawBlankString = isDrawBlankString;
    }

    public Font getFont(Graphics2D g2, ApLocation location) {
        Font font = g2.getFont();
        return font;
    }

    public boolean isDrawBorder() {
        return this.isDrawBorder;
    }

    public void setDrawBorder(boolean isDrawBorder) {
        this.isDrawBorder = isDrawBorder;
    }

    public boolean isAnnotationEditable(int key) {
        return false;
    }

    public boolean isApSegSelect(ApSeg seg) {
        return false;
    }

    static {
        XpLog.logger().fine("JAMI APD: Configured with 15 languages.");
        configMap = new HashMap();
        configMap.put(CTApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$CT");
        configMap.put(SCApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$CTScout");
        configMap.put(MRApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$MR");
        configMap.put(PETApStyle.class, "com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig$PETFull");
        apm = null;
    }

    private static class APDAnnotationGroups {
        public List groupContainers = new ArrayList();
        public List groupLeaves = new ArrayList();
        public Map groupMap = new HashMap();
        public Map groupNumberMap = new HashMap();

        private APDAnnotationGroups() {
        }
    }

    private static class DebugAnnotationDrawer
    extends AnnotationDrawer {
        private boolean nwlarge = true;
        private int nwline = -99;
        private boolean swlarge = true;
        private int swline = -99;

        public DebugAnnotationDrawer(XpApdAnnotation apdAnnot) {
            super(apdAnnot);
        }

        @Override
        public void draw(StringBuffer stringBuff, ApLocation location, ApAppearance appearance, int annotKey) {
            ApAppearance ap = new ApAppearance(appearance.fontSize, appearance.fontStyle, appearance.direction, appearance.color);
            if (location.quadrant == 3) {
                if (location.line != this.nwline) {
                    this.nwlarge = !this.nwlarge;
                    this.nwline = location.line;
                }
                ap.fontSize = this.nwlarge ? 2 : 0;
            } else if (location.quadrant == 5) {
                if (location.line != this.swline) {
                    this.swlarge = !this.swlarge;
                    this.swline = location.line;
                }
                if (this.swlarge) {
                    ap.fontSize = 2;
                    ap.fontStyle = 1;
                } else {
                    ap.fontSize = 0;
                }
            } else if (location.quadrant == 1 && location.line == 0) {
                ap.fontSize = 3;
            }
            super.draw(stringBuff, location, ap, annotKey);
        }
    }

    protected static class LineDrawBuffer {
        private final int BUFF_LEN = 16;
        private AnnotationDrawer ad = null;
        private XpApdAnnotation apdAnnot = null;
        private int[][] line_heights = new int[9][64];
        private int lenDB = 0;
        private Point p = new Point();
        private String[] strings = new String[16];
        private boolean[] active = new boolean[16];
        private Point[] pts = new Point[16];
        private double[] width = new double[16];
        private double[] height = new double[16];
        private int[] annotKey = new int[16];
        private double twidth = 0.0;
        private double theight = 0.0;
        private int NORMALSIZE_LINEHEIGHT = 0;

        public LineDrawBuffer(XpApdAnnotation apdAnnot, AnnotationDrawer ad2) {
            this.apdAnnot = apdAnnot;
            this.ad = ad2;
            for (int i2 = 0; i2 < this.pts.length; ++i2) {
                this.pts[i2] = new Point();
            }
        }

        protected XpApdAnnotation getApdAnnot() {
            return this.apdAnnot;
        }

        public final void addString(String str, Rectangle viewport, int fontSize, int fontStyle, int key, FontRenderContext frc, boolean isActive) {
            this.strings[this.lenDB] = str;
            Rectangle2D r2 = this.getStringBounds(str, viewport, fontSize, fontStyle, frc);
            double w2 = r2.getWidth();
            double h2 = r2.getHeight();
            this.width[this.lenDB] = w2;
            this.height[this.lenDB] = h2;
            this.annotKey[this.lenDB] = key;
            this.active[this.lenDB] = isActive;
            this.twidth += w2;
            this.theight = h2;
            ++this.lenDB;
        }

        private Rectangle2D getStringBounds(String s2, Rectangle viewport, int fontSize, int fontStyle, FontRenderContext frc) {
            int style;
            int size;
            int len = s2.length();
            XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
            Font f2 = apm.getAnnotationFont(viewport.width, viewport.height, size = XpApdAnnotation.apd2jamiSize(fontSize), style = XpApdAnnotation.apd2jamiStyle(fontStyle));
            Rectangle2D b2 = f2.getStringBounds(s2, frc);
            if (b2.getHeight() < 5.0) {
                b2 = f2.createGlyphVector(frc, s2).getLogicalBounds();
            }
            if (fontSize == 1) {
                this.NORMALSIZE_LINEHEIGHT = (int)b2.getHeight();
            }
            return b2;
        }

        private int calcPixelLineOffset(int quadrant, int lineno, int itemHeight) {
            this.line_heights[quadrant][32 + lineno] = itemHeight;
            int pixline = 0;
            int nlines = Math.abs(lineno);
            if (lineno < 0) {
                for (int i2 = 0; i2 < nlines; ++i2) {
                    int lh = this.line_heights[quadrant][32 - i2];
                    if (lh == 0) {
                        int n2 = this.NORMALSIZE_LINEHEIGHT;
                        this.line_heights[quadrant][32 - i2] = n2;
                        lh = n2;
                    }
                    pixline -= lh;
                }
            } else {
                for (int i3 = 0; i3 < nlines; ++i3) {
                    int lh = this.line_heights[quadrant][32 + i3];
                    if (lh == 0) {
                        int n3 = this.NORMALSIZE_LINEHEIGHT;
                        this.line_heights[quadrant][32 - i3] = n3;
                        lh = n3;
                    }
                    pixline += lh;
                }
            }
            return pixline;
        }

        private void mapLocation(ApLocation l2, Rectangle viewport, int w2, int h2, Point p2) {
            int quadrant = l2.quadrant;
            int lineno = l2.line;
            int pixline = this.calcPixelLineOffset(quadrant, lineno, h2);
            int pixmargin = this.apdAnnot.getMargin();
            int midHeight = (int)(viewport.getHeight() * 0.5);
            int midWidth = (int)(viewport.getWidth() * 0.5);
            int x2 = pixmargin;
            int y2 = 20;
            switch (quadrant) {
                case 8: {
                    y2 = midHeight + pixline;
                    x2 = midWidth;
                    break;
                }
                case 0: {
                    y2 = midHeight + pixline;
                    x2 = (int)(viewport.getWidth() - 3.0 - (double)w2);
                    break;
                }
                case 4: {
                    y2 = midHeight + pixline;
                    x2 = pixmargin;
                    break;
                }
                case 6: {
                    x2 = midWidth - (w2 >> 1);
                    y2 = (int)(viewport.getHeight() + (double)pixline - 4.0);
                    break;
                }
                case 2: {
                    x2 = midWidth - (w2 >> 1);
                    y2 = pixline + h2;
                    break;
                }
                case 3: {
                    y2 = pixline + h2;
                    x2 = pixmargin;
                    break;
                }
                case 5: {
                    y2 = (int)(viewport.getHeight() + (double)pixline - 4.0);
                    x2 = pixmargin;
                    break;
                }
                case 1: {
                    y2 = pixline + h2;
                    x2 = (int)(viewport.getWidth() - 3.0 - (double)w2);
                    break;
                }
                case 7: {
                    y2 = (int)(viewport.getHeight() + (double)pixline - 4.0);
                    x2 = (int)(viewport.getWidth() - 3.0 - (double)w2);
                }
            }
            p2.x = x2;
            p2.y = y2;
        }

        public final void drawIt(Graphics2D g2, Rectangle viewport, ApLocation l2, ApAppearance appearance) {
            if (this.lenDB <= 0) {
                return;
            }
            int w2 = 0;
            int h2 = 0;
            String outStr = "";
            Color col = Color.white;
            try {
                col = Color.decode(appearance.color);
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
            if (appearance.direction == 0) {
                w2 = (int)this.twidth;
                h2 = (int)this.theight;
                Font oldFont = g2.getFont();
                ApSeg apSeg = this.apdAnnot.getApStyle().getSegAt(l2.quadrant, l2.line, l2.segment);
                Font newFont = this.apdAnnot.getFont(g2, l2);
                if (newFont != null && !newFont.equals(oldFont) && apSeg.result != null) {
                    Rectangle2D newFontRect = newFont.getStringBounds(apSeg.result.toString(), g2.getFontRenderContext());
                    w2 = Math.max((int)newFontRect.getWidth(), w2);
                    h2 = Math.max((int)newFontRect.getHeight(), h2);
                }
                this.mapLocation(l2, viewport, w2, h2, this.p);
                int offset = 0;
                for (int i2 = 0; i2 < this.lenDB; ++i2) {
                    int lw = (int)this.width[i2];
                    boolean isActive = this.active[i2];
                    if (appearance.fontSize == 1) {
                        if (this.isRealSize(viewport) && newFont != null) {
                            g2.setFont(newFont);
                        }
                        this.apdAnnot.line(g2, this.strings[i2], this.p.x + offset, this.p.y, isActive, col);
                        g2.setFont(oldFont);
                    } else {
                        XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
                        int size = XpApdAnnotation.apd2jamiSize(appearance.fontSize);
                        int style = XpApdAnnotation.apd2jamiStyle(appearance.fontStyle);
                        Font f2 = apm.getAnnotationFont(viewport.width, viewport.height, size, style);
                        if (this.isRealSize(viewport) && newFont != null) {
                            f2 = newFont;
                        }
                        this.apdAnnot.line(g2, this.strings[i2], this.p.x + offset, this.p.y, isActive, f2, col);
                    }
                    offset += lw;
                }
                int x2 = this.p.x;
                int y2 = this.p.y - h2;
                for (int i3 = 0; i3 < this.lenDB; ++i3) {
                    int lh = (int)this.height[i3];
                    int lw = (int)this.width[i3];
                    this.ad.updateTooltipDB(l2, this.annotKey[i3], x2, y2, lw, lh);
                    this.postLineDraw(g2, l2, new Rectangle(x2, y2, lw, lh), viewport);
                    x2 += lw;
                }
            } else {
                int dh = 1;
                boolean isActive = false;
                for (int i4 = 0; i4 < this.lenDB; ++i4) {
                    isActive = this.active[i4];
                    int lh = (int)this.height[i4];
                    int lw = (int)this.width[i4];
                    w2 += lw;
                    dh = lh;
                    String str = this.strings[i4];
                    outStr = outStr + str;
                    int len = str.length();
                    this.height[i4] = len * dh;
                    this.width[i4] = this.width[i4] / (double)len;
                }
                int len = outStr.length();
                h2 = len * dh;
                w2 = (int)((double)w2 / (double)len);
                this.mapLocation(l2, viewport, w2, h2, this.p);
                if (appearance.fontSize == 1 && appearance.fontStyle == 0) {
                    this.apdAnnot.lineVertical(g2, outStr, this.p.x, this.p.y, dh, isActive, col);
                } else {
                    XpAnnotationPolicyManager apm = XpApdAnnotation.getAnnotationPolicyManager();
                    int size = XpApdAnnotation.apd2jamiSize(appearance.fontSize);
                    int style = XpApdAnnotation.apd2jamiStyle(appearance.fontStyle);
                    Font f3 = apm.getAnnotationFont(viewport.width, viewport.height, size, style);
                    this.apdAnnot.lineVertical(g2, outStr, this.p.x, this.p.y, dh, isActive, f3, col);
                }
                int x3 = this.p.x;
                int y3 = this.p.y - dh;
                for (int i5 = 0; i5 < this.lenDB; ++i5) {
                    int lh = (int)this.height[i5];
                    int lw = (int)this.width[i5];
                    this.ad.updateTooltipDB(l2, this.annotKey[i5], x3, y3, lw, lh);
                    y3 += lh;
                }
            }
        }

        public final void reset() {
            this.lenDB = 0;
            this.theight = 0.0;
            this.twidth = 0.0;
        }

        public final void resetLineHeights() {
            for (int i2 = 0; i2 < this.line_heights.length; ++i2) {
                for (int j2 = 0; j2 < this.line_heights[i2].length; ++j2) {
                    this.line_heights[i2][j2] = 0;
                }
            }
        }

        protected boolean isRealSize(Rectangle viewportRect) {
            return false;
        }

        protected void postLineDraw(Graphics2D g2, ApLocation l2, Rectangle annoRect, Rectangle viewportRect) {
        }
    }

    public static class AnnotationDrawer
    implements ApTextDrawer {
        private XpApdAnnotation apdAnnot = null;
        private boolean[] actAnnotMap = null;
        private Graphics2D g = null;
        private Rectangle viewport = new Rectangle();
        private FontRenderContext frc = null;
        private StringBuffer outputBuffer = new StringBuffer();
        private LineDrawBuffer ldBuffer = null;
        private boolean flushIt = false;
        private boolean toFlush = false;
        private ApLocation prevLocation = new ApLocation();
        private ApAppearance prevAppearance = new ApAppearance();
        private Map[] locationMap = new Map[10];
        private List annotList = new ArrayList(75);

        public AnnotationDrawer(XpApdAnnotation apdAnnot) {
            this.apdAnnot = apdAnnot;
            this.ldBuffer = new LineDrawBuffer(apdAnnot, this);
        }

        protected void setLdBuffer(LineDrawBuffer ldBuffer) {
            this.ldBuffer = ldBuffer;
        }

        public XpApdAnnotation getApdAnnot() {
            return this.apdAnnot;
        }

        @Override
        public void open() {
            this.flushIt = false;
            this.outputBuffer.setLength(0);
            this.toFlush = false;
            int len = this.annotList.size();
            for (int i2 = 0; i2 < len; ++i2) {
                AnnotationItem ai2 = (AnnotationItem)this.annotList.get(i2);
                if (ai2 == null) continue;
                ai2.visible = false;
            }
        }

        @Override
        public void close() {
            if (this.toFlush) {
                this.ldBuffer.drawIt(this.g, this.viewport, this.prevLocation, this.prevAppearance);
                this.ldBuffer.reset();
                this.flushIt = true;
                this.toFlush = false;
            }
        }

        public int insideAnnotation(int x2, int y2) {
            int len = this.annotList.size();
            for (int i2 = 0; i2 < len; ++i2) {
                AnnotationItem ai2 = (AnnotationItem)this.annotList.get(i2);
                if (ai2 == null || !ai2.visible) continue;
                int x22 = ai2.x + ai2.w;
                int y22 = ai2.y + ai2.h;
                if (x2 < ai2.x || y2 < ai2.y || x2 > x22 || y2 > y22) continue;
                return ai2.key;
            }
            return -1;
        }

        public final void setGraphicBounds(Graphics gr, Rectangle b2) {
            this.g = (Graphics2D)gr;
            this.viewport.setBounds(b2);
            int w2 = (int)b2.getWidth();
            int h2 = (int)b2.getHeight();
            this.ldBuffer.resetLineHeights();
            this.frc = this.g.getFontRenderContext();
            int priority = 1;
            XpAnnotationPolicy policy = XpAnnotationModel.getAnnotationPolicy();
            if (policy != null) {
                priority = policy.getAnnotationPriority(w2, h2);
            }
            this.apdAnnot.updatePriority(priority);
        }

        public void updateTooltipDB(ApLocation l2, int annotKey, int x2, int y2, int w2, int h2) {
            int quadrant = l2.quadrant;
            int lineno = l2.line;
            HashMap m2 = this.locationMap[quadrant];
            if (m2 == null) {
                this.locationMap[quadrant] = m2 = new HashMap(32);
            }
            Integer lineKey = new Integer(lineno);
            Integer keyAnnot = new Integer(annotKey);
            HashMap<Integer, AnnotationItem> aline = (HashMap<Integer, AnnotationItem>)m2.get(lineKey);
            AnnotationItem ai2 = null;
            if (aline == null) {
                aline = new HashMap<Integer, AnnotationItem>();
                ai2 = new AnnotationItem();
                String sname = this.apdAnnot.getSegmentName(annotKey);
                ai2.name = sname != null ? sname : "";
                ai2.key = annotKey;
                aline.put(keyAnnot, ai2);
                m2.put(lineKey, aline);
                this.annotList.add(ai2);
            } else {
                ai2 = (AnnotationItem)aline.get(keyAnnot);
                if (ai2 == null) {
                    ai2 = new AnnotationItem();
                    ai2.key = annotKey;
                    String sname = this.apdAnnot.getSegmentName(annotKey);
                    ai2.name = sname != null ? sname : "";
                    aline.put(keyAnnot, ai2);
                    this.annotList.add(ai2);
                }
            }
            ai2.w = w2;
            ai2.h = h2;
            ai2.x = x2;
            ai2.y = y2;
            ai2.visible = true;
        }

        public void setActiveAnnotationMap(boolean[] actmap) {
            this.actAnnotMap = actmap;
        }

        @Override
        public void draw(StringBuffer stringBuff, ApLocation location, ApAppearance appearance, int annotKey) {
            boolean appearanceChange = false;
            if (this.prevAppearance.fontSize != appearance.fontSize || this.prevAppearance.fontStyle != appearance.fontStyle) {
                appearanceChange = true;
            }
            if ((this.prevLocation.quadrant != location.quadrant || this.prevLocation.line != location.line || appearanceChange) && this.toFlush) {
                this.flushIt = true;
            }
            if (this.flushIt) {
                this.ldBuffer.drawIt(this.g, this.viewport, this.prevLocation, this.prevAppearance);
                this.flushIt = false;
                this.toFlush = false;
                this.ldBuffer.reset();
            }
            if (stringBuff != null) {
                String str = stringBuff.toString();
                if (this.apdAnnot.isDrawBlankString() || str.trim().length() > 0) {
                    boolean isActive = this.actAnnotMap != null ? this.actAnnotMap[annotKey] : false;
                    this.ldBuffer.addString(str, this.viewport, appearance.fontSize, appearance.fontStyle, annotKey, this.frc, isActive);
                    this.toFlush = true;
                }
            }
            this.prevLocation.quadrant = location.quadrant;
            this.prevLocation.line = location.line;
            this.prevLocation.segment = location.segment;
            this.prevAppearance.color = appearance.color;
            this.prevAppearance.direction = appearance.direction;
            this.prevAppearance.fontSize = appearance.fontSize;
            this.prevAppearance.fontStyle = appearance.fontStyle;
        }
    }

    private static class AnnotationPolicyManager
    implements XpAnnotationPolicyManager {
        private XpAnnotationPolicy ap = null;

        public AnnotationPolicyManager(XpAnnotationPolicy ap) {
            this.ap = ap;
        }

        @Override
        public Font getAnnotationFont(int vp_width, int vp_height, int annotationSize, int annotationStyle) {
            return this.ap.getAnnotationFont(vp_width, vp_height);
        }

        @Override
        public Font getAnnotationFont(int vp_width, int vp_height) {
            return this.ap.getAnnotationFont(vp_width, vp_height);
        }

        @Override
        public int getAnnotationPriority(int vp_width, int vp_height) {
            return this.ap.getAnnotationPriority(vp_width, vp_height);
        }
    }

    private static class AnnotationItem {
        public int key;
        public String name = "";
        public int x;
        public int y;
        public int w;
        public int h;
        public boolean visible = false;

        private AnnotationItem() {
        }
    }

    private class StdDicomAccesor
    implements ApDicomAccessor {
        private XpDicomElement de = new XpDicomElement();
        private ApDicomElement val = new ApDicomElement();

        private StdDicomAccesor() {
        }

        @Override
        public ApDicomElement getValue(int group, int element, int index, int vrDataType) {
            Object obj = null;
            double d2 = 0.0;
            this.de.group = group;
            this.de.element = element;
            int result = XpApdAnnotation.this.getDicomObject().getValue(this.de);
            if (result == 1) {
                this.val.isValued = false;
                this.val.apdString = "0";
                this.val.apdFloat = 0.0;
                this.val.apdInteger = 0;
                return this.val;
            }
            obj = this.de.value;
            if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                obj = index >= 0 && index < arr.length ? arr[index] : "XXXX";
            }
            if (obj instanceof String) {
                this.val.isValued = true;
                String str = (String)obj;
                try {
                    switch (vrDataType) {
                        case 0: {
                            d2 = Double.parseDouble(str);
                            this.val.apdInteger = (int)d2;
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: Integer   - " + d2);
                            }
                            break;
                        }
                        case 1: {
                            this.val.apdFloat = d2 = Double.parseDouble(str);
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: Float     - " + d2);
                            }
                            break;
                        }
                        default: {
                            this.val.apdString = (String)obj;
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: String    - " + obj);
                            }
                            break;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    this.val.apdFloat = 0.0;
                    this.val.apdInteger = 0;
                    this.val.apdString = "";
                }
            } else if (obj instanceof Integer) {
                this.val.isValued = true;
                Integer i2 = (Integer)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Integer   - " + i2);
                }
                this.val.apdInteger = i2;
            } else if (obj instanceof Double) {
                this.val.isValued = true;
                Double dd = (Double)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Float     - " + dd);
                }
                this.val.apdFloat = dd.floatValue();
            } else if (obj instanceof Float) {
                this.val.isValued = true;
                Float ff = (Float)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Float     - " + ff);
                }
                this.val.apdFloat = ff.floatValue();
            } else if (obj instanceof Long) {
                this.val.isValued = true;
                Long ll = (Long)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Integer   - " + ll);
                }
                this.val.apdInteger = ll.intValue();
            } else {
                this.val.isValued = false;
                this.val.apdString = "XXXXXXXXXXX";
            }
            return this.val;
        }
    }

    private static class ApdSeqItem
    implements ApSeqItem {
        private XjSeqItem xjitem = null;

        public ApdSeqItem(XjSeqItem item) {
            this.xjitem = item;
        }

        @Override
        public Object getValue(int group, int element) {
            return this.xjitem.getValue(group, element);
        }

        @Override
        public Object getValue(String tag2) {
            return this.xjitem.getValue(tag2);
        }

        @Override
        public int getNumberOfTags() {
            return this.xjitem.getNumberOfTags();
        }
    }

    private static class ApdSequence
    implements ApSequence {
        private XjSequence xjseq = null;

        public ApdSequence(XjSequence obj) {
            this.xjseq = obj;
        }

        @Override
        public Object getValue(int itemNumber, int group, int element) {
            return this.xjseq.getValue(itemNumber, group, element);
        }

        @Override
        public Object getValue(int itemNumber, String tag2) {
            return this.xjseq.getValue(itemNumber, tag2);
        }

        @Override
        public int getNumberOfItems() {
            return this.xjseq.getNumberOfItems();
        }

        @Override
        public ApSeqItem getItem(int n2) {
            ApdSeqItem apseqitem = new ApdSeqItem(this.xjseq.getItem(n2));
            return apseqitem;
        }
    }

    private class MultiFrameDicomAccessor
    extends StdDicomAccesor
    implements ApMultiFrameAccessor {
        private MultiFrameDicomAccessor() {
        }

        @Override
        public ApMultiFrameAccessor.FrameType getType() {
            XjDicomObjectFrame.MultiFrameType frameType = ((XjDicomObjectFrame)((Object)XpApdAnnotation.this.getDicomObject())).getMultiFrameType();
            if (frameType == XjDicomObjectFrame.MultiFrameType.SINGLE_FRAME) {
                return ApMultiFrameAccessor.FrameType.SINGLE;
            }
            if (frameType == XjDicomObjectFrame.MultiFrameType.MULTI_FRAME_ENHANCED) {
                return ApMultiFrameAccessor.FrameType.ENHANCED_MULTI_FRAME;
            }
            if (frameType == XjDicomObjectFrame.MultiFrameType.MULTI_FRAME) {
                return ApMultiFrameAccessor.FrameType.MULTI_FRAME;
            }
            return null;
        }

        @Override
        public int getFrameNumber() {
            return ((XjDicomObjectFrame)((Object)XpApdAnnotation.this.getDicomObject())).getFrameNumber();
        }

        @Override
        public ApDicomElement getFrameValue(int framenumber, int group, int element, int vrDataType) {
            return this.getFrameValue(framenumber, group, element, 0, vrDataType);
        }

        public ApDicomElement getFrameValue(int framenumber, int group, int element, int index, int vrDataType) {
            Object obj = ((XjDicomObjectFrame)((Object)XpApdAnnotation.this.getDicomObject())).getValue(framenumber, group, element);
            return this.Xp2ApDicomElement(obj, index, vrDataType);
        }

        @Override
        public ApDicomElement getValue(String tagQuery, int vrDataType) {
            Object obj = ((XjDicomObjectFrame)((Object)XpApdAnnotation.this.getDicomObject())).getValue(tagQuery);
            return this.Xp2ApDicomElement(obj, 0, vrDataType);
        }

        private ApDicomElement Xp2ApDicomElement(Object dicomobj, int index, int vrDataType) {
            ApDicomElement val = new ApDicomElement();
            Object obj = dicomobj;
            double d2 = 0.0;
            if (obj == null) {
                val.isValued = false;
                val.apdString = "0";
                val.apdFloat = 0.0;
                val.apdInteger = 0;
                val.seq = null;
                return val;
            }
            if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                obj = index >= 0 && index < arr.length ? arr[index] : "XXXX";
            }
            if (obj instanceof String) {
                val.isValued = true;
                String str = (String)obj;
                try {
                    switch (vrDataType) {
                        case 0: {
                            d2 = Double.parseDouble(str);
                            val.apdInteger = (int)d2;
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: Integer   - " + d2);
                            }
                            break;
                        }
                        case 1: {
                            val.apdFloat = d2 = Double.parseDouble(str);
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: Float     - " + d2);
                            }
                            break;
                        }
                        default: {
                            val.apdString = (String)obj;
                            if (XpApdAnnotation.this.debug) {
                                System.out.println("DicomAccesor: String    - " + obj);
                            }
                            break;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    val.apdFloat = 0.0;
                    val.apdInteger = 0;
                    val.apdString = "";
                }
            } else if (obj instanceof Integer) {
                val.isValued = true;
                Integer i2 = (Integer)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Integer   - " + i2);
                }
                val.apdInteger = i2;
            } else if (obj instanceof Double) {
                val.isValued = true;
                Double dd = (Double)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Float     - " + dd);
                }
                val.apdFloat = dd.floatValue();
            } else if (obj instanceof Float) {
                val.isValued = true;
                Float ff = (Float)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Float     - " + ff);
                }
                val.apdFloat = ff.floatValue();
            } else if (obj instanceof Long) {
                val.isValued = true;
                Long ll = (Long)obj;
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: Integer   - " + ll);
                }
                val.apdInteger = ll.intValue();
            } else if (obj instanceof XjSequence) {
                val.isValued = true;
                ApdSequence apseq = new ApdSequence((XjSequence)obj);
                if (XpApdAnnotation.this.debug) {
                    System.out.println("DicomAccesor: ApSequence   - " + apseq);
                }
                val.seq = apseq;
            } else {
                val.isValued = false;
                val.apdString = "XXXXXXXXXXX";
            }
            return val;
        }
    }
}

