/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.filter;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;

public class XpImageLut {
    private static final int SCALE = 16384;
    private static XpImageLut g1 = null;
    private static XpImageLut g2 = null;
    private static XpImageLut g3 = null;
    private short[] lutShort = null;
    private int[] lutByte = null;
    private double _widthRatio = 1.0;
    private double _gamma = 1.0;
    private String lutName = "";
    private IndexColorModel icm = null;

    public XpImageLut(String lutName, double widthRatio, double gamma) {
        int i2;
        this.lutName = lutName;
        this._widthRatio = widthRatio;
        this._gamma = gamma;
        int size = 16384;
        this.lutShort = new short[16384];
        double[] lut = new double[16384];
        int[] rgbs = new int[16384];
        this.calcLut(lut, 16384);
        for (i2 = 0; i2 < 16384; ++i2) {
            this.lutShort[i2] = (short)(16384.0 * lut[i2]);
            long val = (int)((long)(255.0 * lut[i2]) & 0xFFL);
            rgbs[i2] = (int)(val << 16 | val << 8 | val);
        }
        this.icm = new ColorModel(this, rgbs.length, rgbs);
        this.lutByte = new int[256];
        this.calcLut(lut, 256);
        for (i2 = 0; i2 < 256; ++i2) {
            this.lutByte[i2] = (int)(256.0 * lut[i2]);
        }
    }

    public double getScale() {
        return 16384.0;
    }

    public short[] getPLUT() {
        return this.lutShort;
    }

    public IndexColorModel getLUT() {
        return this.icm;
    }

    public static XpImageLut g1() {
        if (g1 == null) {
            g1 = new XpImageLut("g1", 0.390625, 1.2);
        }
        return g1;
    }

    public String getGSEName() {
        return this.lutName;
    }

    public final String toString() {
        return "LUT: " + this.lutName;
    }

    public static XpImageLut g2() {
        if (g2 == null) {
            g2 = new XpImageLut("g2", 0.390625, 1.3);
        }
        return g2;
    }

    public static XpImageLut g3() {
        if (g3 == null) {
            g3 = new XpImageLut("g3", 0.390625, 1.5);
        }
        return g3;
    }

    public final double getGamma() {
        return this._gamma;
    }

    public final double getWidthRatio() {
        return this._widthRatio;
    }

    private void calcLut(double[] lut, int size) {
        if (size < 2) {
            size = 2;
        }
        double halfSize = size / 2;
        int i2 = 0;
        double width = this._widthRatio * (double)size;
        double lim1 = halfSize - 1.0 - width;
        double lim2 = halfSize + 1.0 + width;
        double val = 0.0;
        i2 = 0;
        for (val = 0.0; val < lim1; val += 1.0) {
            lut[i2] = val / (double)size;
            ++i2;
        }
        i2 = (int)lim1;
        for (val = lim1; val < halfSize; val += 1.0) {
            lut[i2] = (Math.pow((val - lim1) / width, this._gamma) * width + lim1) / (double)size;
            ++i2;
        }
        i2 = (int)halfSize;
        for (val = halfSize; val < lim2; val += 1.0) {
            if (i2 < size) {
                lut[i2] = (-Math.pow((width + halfSize - val) / width, this._gamma) * width + (width + halfSize)) / (double)size;
            }
            ++i2;
        }
        i2 = (int)lim2;
        val = lim2;
        while (i2 < size) {
            lut[i2] = val / (double)size;
            ++i2;
            val += 1.0;
        }
        int idx1 = size / 4;
        int idx2 = size / 2;
    }

    public void execute(RenderedImage input, RenderedImage output) {
        block17: {
            DataBuffer dbos;
            DataBuffer dbis;
            DataBuffer db;
            WritableRaster bOutput;
            block18: {
                block16: {
                    Raster bInput = input.getData();
                    BufferedImage bimg = (BufferedImage)output;
                    bOutput = bimg.getRaster();
                    db = bInput.getDataBuffer();
                    if (!(db instanceof DataBufferByte)) break block16;
                    DataBufferByte dbi = (DataBufferByte)db;
                    DataBufferByte dbo = (DataBufferByte)bOutput.getDataBuffer();
                    byte[] data = dbi.getData();
                    byte[] res = dbo.getData();
                    int len = this.lutByte.length;
                    for (int i2 = 0; i2 < data.length; ++i2) {
                        int val = data[i2];
                        if (val < 0) {
                            val = -val;
                        }
                        if (val >= len) {
                            val = len - 1;
                        }
                        res[i2] = (byte)this.lutByte[val];
                    }
                    break block17;
                }
                if (!(db instanceof DataBufferInt)) break block18;
                DataBufferInt dbi = (DataBufferInt)db;
                DataBufferInt dbo = (DataBufferInt)bOutput.getDataBuffer();
                int[] data = dbi.getData();
                int[] res = dbo.getData();
                int len = this.lutByte.length;
                for (int i3 = 0; i3 < data.length; ++i3) {
                    int val = data[i3];
                    int a2 = 255;
                    int r2 = val >> 16 & 0xFF;
                    int g2 = val >> 8 & 0xFF;
                    int b2 = val & 0xFF;
                    if (r2 < 0) {
                        r2 = -r2;
                    }
                    if (g2 < 0) {
                        g2 = -g2;
                    }
                    if (b2 < 0) {
                        b2 = -b2;
                    }
                    if (r2 >= len) {
                        r2 = len - 1;
                    }
                    if (g2 >= len) {
                        g2 = len - 1;
                    }
                    if (b2 >= len) {
                        b2 = len - 1;
                    }
                    byte tr = (byte)this.lutByte[r2];
                    byte tg = (byte)this.lutByte[g2];
                    byte tb = (byte)this.lutByte[b2];
                    long x2 = a2 << 24 | tr << 16 | tg << 8 | tb;
                    res[i3] = (int)x2;
                }
                break block17;
            }
            DataBuffer dbi = db;
            DataBuffer dbo = bOutput.getDataBuffer();
            short[] data = null;
            short[] res = null;
            if (dbi instanceof DataBufferUShort) {
                dbis = (DataBufferUShort)dbi;
                dbos = (DataBufferUShort)dbo;
                data = ((DataBufferUShort)dbis).getData();
                res = ((DataBufferUShort)dbos).getData();
            } else if (dbi instanceof DataBufferShort) {
                dbis = (DataBufferShort)dbi;
                dbos = (DataBufferShort)dbo;
                data = ((DataBufferShort)dbis).getData();
                res = ((DataBufferShort)dbos).getData();
            }
            if (data == null || res == null) break block17;
            int len = this.lutShort.length;
            for (int i4 = 0; i4 < data.length; ++i4) {
                short val = data[i4];
                if (val < 0) {
                    val = 0;
                }
                if (val >= len) {
                    val = (short)(len - 1);
                }
                res[i4] = this.lutShort[val];
            }
        }
    }

    public static class ColorModel
    extends IndexColorModel {
        private int hash = 0;
        private XpImageLut imgLut = null;

        public ColorModel(XpImageLut imgLut, int size, int[] cmap) {
            super(16, size, cmap, 0, false, -1, 1);
            this.imgLut = imgLut;
            this.hash = cmap.hashCode();
        }

        @Override
        public final String toString() {
            return this.imgLut.getGSEName();
        }

        public XpImageLut getImageLut() {
            return this.imgLut;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }
    }
}

