/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import java.awt.Point;

public class Hazed3DCone {
    private int w;
    private int h;

    public void create(byte[] d2, int w2, int h2, int solidR, int decayR, double decayX, int angle, int slice, boolean invert) {
        this.w = w2;
        this.h = h2;
        int max = -1;
        boolean min = false;
        int bgcolor = 0xFFCCCC;
        d2 = this.fillBackGround(d2, bgcolor);
        Point center = new Point(w2 / 2, h2 / 2);
        d2 = this.drawHazed3DCone(d2, solidR, decayR, angle, decayX, invert, slice);
        int radius = solidR < decayR ? decayR : solidR + decayR;
        center.setLocation(w2 / 2, 6 * h2 / 8);
    }

    private byte[] drawSolidEllipse(byte[] d2, int solidR, Point center, int color, int angle) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        double cos = Math.cos((double)angle * Math.PI / 180.0);
        if (cos < 0.0) {
            cos = -cos;
        }
        int compress = (int)(cos * (double)solidR);
        int ytop = y0 - compress;
        int ybottom = y0 + compress;
        for (int y2 = ytop; y2 < ybottom; ++y2) {
            int w2 = (int)(Math.sqrt(1.0 - Math.pow(y2 - y0, 2.0) / Math.pow(compress, 2.0)) * (double)solidR);
            int startPixel = y2 * this.w * 3 + (x0 - w2) * 3;
            int endPixel = startPixel + 2 * w2 * 3;
            for (int i2 = startPixel; i2 < endPixel; i2 += 3) {
                d2[i2] = (byte)(color >> 16 & 0xFF);
                d2[i2 + 1] = (byte)(color >> 8 & 0xFF);
                d2[i2 + 2] = (byte)(color >> 0 & 0xFF);
            }
        }
        return d2;
    }

    private byte[] drawHazedEllipse(byte[] d2, int solidR, int decayR, Point center, int angle, double decayX, boolean invert) {
        int x2 = decayR - solidR;
        int b2 = 0;
        if (x2 < 0) {
            x2 = decayR;
        }
        for (int i2 = 0; i2 < x2; ++i2) {
            b2 = invert ? (int)(255.0 * (1.0 - Math.exp((double)(-i2) / decayX))) & 0xFF : (int)(255.0 * Math.exp((double)(-i2) / decayX)) & 0xFF;
            int color = (b2 << 16) + (b2 << 8) + 0;
            d2 = this.drawSolidEllipse(d2, solidR + (x2 - i2), center, color, angle);
        }
        d2 = this.drawSolidEllipse(d2, solidR, center, 0, angle);
        return d2;
    }

    private byte[] drawHazed3DCone(byte[] d2, int solidR, int decayR, int angle, double decayX, boolean invert, double slice) {
        int temp;
        int top = 4 * this.h / 8 - (int)((double)(3 * this.h / 8) * Math.sin((double)angle * Math.PI / 180.0));
        int bottom = 4 * this.h / 8;
        if (angle > 90 && angle < 270) {
            int temp2 = top;
            top = bottom;
            bottom = temp2;
        }
        Point center = new Point(this.w / 2, 0);
        if (slice < 100.0) {
            slice = 100.0;
        }
        if ((double)(temp = this.h / (int)slice) - (double)this.h / slice != 0.0) {
            slice = this.h / temp;
        }
        if (slice >= (double)this.h) {
            slice = 3 * this.h / 8;
        }
        double posIndex = (double)(bottom - top) / slice;
        double rIndex = (double)solidR / slice;
        double rdIndex = (double)decayR / slice;
        int i2 = 0;
        while ((double)i2 < slice) {
            int dradius;
            int radius;
            center.y = (int)((double)bottom - posIndex * (double)i2);
            if (angle < 90 || angle > 270) {
                radius = (int)((double)solidR - rIndex * (double)i2);
                dradius = (int)((double)decayR - rdIndex * (double)i2);
            } else {
                radius = (int)(rIndex * (double)i2);
                dradius = (int)(rdIndex * (double)i2);
            }
            d2 = this.drawHazedEllipse(d2, radius, dradius, center, angle, decayX, invert);
            ++i2;
        }
        return d2;
    }

    private byte[] fillBackGround(byte[] d2, int color) {
        for (int i2 = 0; i2 < d2.length; i2 += 3) {
            d2[i2] = (byte)(color >> 16 & 0xFF);
            d2[i2 + 1] = (byte)(color >> 8 & 0xFF);
            d2[i2 + 2] = (byte)(color >> 0 & 0xFF);
        }
        return d2;
    }

    private byte[] drawDottedLine(byte[] d2, int radius, Point center, int color, int angle) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        int compress = (int)(Math.cos(angle) * (double)radius);
        int ytop = y0 - compress;
        int ybottom = y0 + compress;
        for (int y2 = ytop; y2 < ybottom; y2 += 2) {
            int w2 = (int)(Math.sqrt(1.0 - Math.pow(y2 - y0, 2.0) / Math.pow(compress, 2.0)) * (double)radius);
            int startPixel = y2 * this.w * 3 + (x0 - w2) * 3;
            int endPixel = startPixel + 2 * w2 * 3 - 3;
            d2[startPixel] = (byte)(color >> 16 & 0xFF);
            d2[startPixel + 1] = (byte)(color >> 8 & 0xFF);
            d2[startPixel + 2] = (byte)(color >> 0 & 0xFF);
            d2[endPixel] = (byte)(color >> 16 & 0xFF);
            d2[endPixel + 1] = (byte)(color >> 8 & 0xFF);
            d2[endPixel + 2] = (byte)(color >> 0 & 0xFF);
        }
        return d2;
    }
}

