/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import com.ge.med.terra.jami.image.patterns.ComplexNumber;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;

public class Mandelbrot {
    protected byte[] pixels;
    protected int h;
    protected int w;
    protected static double COMPLEX_MIN = 0.2;
    protected static double COMPLEX_MAX = 1.2;
    protected static double REAL_MIN = 0.2;
    protected static double REAL_MAX = 1.2;
    protected final double HALF = 0.5;
    protected static final int MAX_ITERATIONS = 83;
    protected static Vector Range = new Vector();
    private static int[] dist = new int[84];

    private Mandelbrot() {
    }

    public Mandelbrot(byte[] pixels, int h2, int w2, String palette) {
        this.pixels = pixels;
        this.h = h2;
        this.w = w2;
        ColorFactory.setPalette(palette);
    }

    public static void setRange(double rMin, double rMax, double cMin, double cMax) {
        REAL_MIN = rMin;
        REAL_MAX = rMax;
        COMPLEX_MIN = cMin;
        COMPLEX_MAX = cMax;
    }

    public void create() {
        ComplexNumber mu = new ComplexNumber();
        ComplexNumber muTemp = null;
        int iterations = 0;
        PlotPoint[] points = new PlotPoint[this.w * this.h];
        for (int real = 0; real < this.w; ++real) {
            for (int complex = 0; complex < this.h; ++complex) {
                double cPart = (double)complex / (double)this.h * (COMPLEX_MAX - COMPLEX_MIN) + COMPLEX_MIN;
                double rPart = (double)real / (double)this.h * (REAL_MAX - REAL_MIN) + REAL_MIN;
                mu.setCPart(cPart);
                mu.setRPart(rPart);
                muTemp = new ComplexNumber(mu);
                for (iterations = 0; iterations < 83 && !((mu = mu.squared().sub(mu)).magnitude() > 2.0); ++iterations) {
                }
                int n2 = iterations;
                dist[n2] = dist[n2] + 1;
                points[real * this.w + complex] = new PlotPoint(muTemp, iterations);
            }
        }
        this.registerColorRange();
        this.plotPoints(points);
    }

    private void registerColorRange() {
        int buffer = 0;
        for (int i2 = 0; i2 < dist.length; ++i2) {
            if (dist[i2] == 0) continue;
            if (dist[i2] > 100) {
                Range.add(new Integer(i2));
                continue;
            }
            if (buffer > 80) {
                Range.add(new Integer(i2));
                buffer = 0;
                continue;
            }
            buffer += dist[i2];
        }
    }

    private void plotPoints(PlotPoint[] points) {
        for (int i2 = 0; i2 < points.length; ++i2) {
            this.plotPoint(points[i2].mu, points[i2].iterations);
        }
    }

    protected void plotPoint(ComplexNumber num, int colorVal) {
        double pixelRatio = COMPLEX_MAX - COMPLEX_MIN;
        int basePixel = (int)((num.getCPart() - COMPLEX_MAX) / -pixelRatio * (double)this.w * (double)this.h);
        pixelRatio = REAL_MAX - REAL_MIN;
        basePixel += (int)((num.getRPart() - REAL_MAX) / -pixelRatio * (double)this.w);
        basePixel -= this.w + 1;
        basePixel *= 3;
        for (int i2 = 0; i2 < Range.size(); ++i2) {
            if (colorVal > (Integer)Range.get(i2)) continue;
            this.setColor(this.pixels, basePixel, ColorFactory.getColor(i2));
            break;
        }
    }

    private void setColor(byte[] pixels, int base, Color c2) {
        pixels[base + 2] = (byte)c2.getRed();
        pixels[base + 1] = (byte)c2.getGreen();
        pixels[base + 0] = (byte)c2.getBlue();
    }

    private class PlotPoint {
        ComplexNumber mu = null;
        int iterations;

        PlotPoint(ComplexNumber mu, int iterations) {
            this.mu = mu;
            this.iterations = iterations;
        }
    }

    private static class ColorFactory {
        private static int[] palette01 = new int[]{255, 0, 0, 193, 0, 3, 193, 40, 3, 193, 70, 3, 200, 55, 10, 200, 200, 5, 255, 255, 10, 100, 120, 0, 120, 150, 5, 120, 240, 10, 40, 250, 10, 0, 80, 120, 0, 40, 200, 0, 0, 255, 127, 127, 0, 80, 10, 10, 210, 25, 185, 63, 85, 0, 250, 0, 0, 80, 40, 140, 255, 255, 255, 255, 0, 0, 0, 0, 0};
        private static int[] palette02 = new int[]{0, 0, 255, 0, 10, 200, 0, 30, 190, 100, 0, 200, 0, 50, 150, 0, 120, 120, 200, 200, 45, 255, 255, 100, 80, 90, 20, 100, 120, 5, 100, 200, 10, 120, 0, 200, 80, 10, 120, 0, 10, 200, 200, 30, 190, 0, 0, 250, 0, 50, 150, 0, 120, 120, 63, 85, 0, 200, 40, 120, 155, 5, 255, 255, 0, 0, 0, 0, 0};
        private static Color[] palette = null;
        private static String paletteName = null;
        private static HashMap colors = null;

        private ColorFactory() {
        }

        public static Color getColor(int current) {
            if (palette == null) {
                ColorFactory.associatePalette();
            }
            return palette[current % palette.length];
        }

        public static void setPalette(String p2) {
            paletteName = p2;
        }

        private static void associatePalette() {
            if (colors == null) {
                colors = new HashMap();
            }
            colors.put("palette01", palette01);
            colors.put("palette02", palette02);
            int[] temp = null;
            temp = (int[])colors.get(paletteName);
            palette = new Color[temp.length / 3];
            for (int i2 = 0; i2 < palette.length; ++i2) {
                ColorFactory.palette[i2] = new Color(temp[3 * i2], temp[3 * i2 + 1], temp[3 * i2 + 2]);
            }
        }
    }
}

