/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.j3d.DefaultT3DMouseController;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MouseInputAdapter;

public class ContextMenuMouseController
extends MouseInputAdapter
implements XpMouseController,
PropertyChangeListener {
    private static final String[][] RENDER_MODES_TABLE = new String[][]{{"VR", "VOLUME"}, {"Reformat", "REFORMAT"}, {"MIP/MPR", "MIP"}, {"Average/MPR", "AVERAGE"}, {"3DMIP", "FULLBODY_MIP"}, {"Fly-Through", "FLYTHROUGH"}};
    static Map nameList = new HashMap();
    JRadioButtonMenuItem[] modeMenuItems;
    private DefaultT3DMouseController controller;
    RenderModeSwitchAction[] renderModeSwitchActions;
    private Object[][] mouseControllerData;
    ActionListener modeSwitchListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e2) {
            int index = Integer.parseInt(e2.getActionCommand());
            ContextMenuMouseController.this.controller.setLeftMouseBinding(index);
        }
    };
    T3DViewport tc;
    private JRadioButtonMenuItem[] renderModeSwitchRadios;
    JPopupMenu menu_;

    public ContextMenuMouseController(DefaultT3DMouseController controller, Object[][] mouseControllerData) {
        this.controller = controller;
        this.mouseControllerData = mouseControllerData;
    }

    @Override
    public void setTarget(JComponent jc) {
        if (jc instanceof T3DViewport) {
            this.tc = (T3DViewport)jc;
            this.tc.addPropertyChangeListener("renderStyle", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ContextMenuMouseController.this.updateModeDisplay();
                }
            });
            this.updateModeDisplay();
        } else {
            this.tc = null;
        }
    }

    private void updateModeDisplay() {
        if (this.tc != null) {
            // empty if block
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.showMenu(e2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.showMenu(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.showMenu(e2);
        }
    }

    private void showMenu(MouseEvent e2) {
        if (this.menu_ == null) {
            this.buildMenu();
        }
        this.menu_.show((Component)e2.getSource(), e2.getX(), e2.getY());
    }

    private void buildMenu() {
        JRadioButtonMenuItem menuI;
        String name;
        this.menu_ = new JPopupMenu();
        this.menu_.add(new JLabel("Left Mouse Button Mode"));
        ButtonGroup bg = new ButtonGroup();
        if (this.mouseControllerData != null) {
            this.modeMenuItems = new JRadioButtonMenuItem[this.mouseControllerData.length];
        }
        for (int i2 = 0; this.mouseControllerData != null && i2 < this.mouseControllerData.length; ++i2) {
            Map props = (Map)this.mouseControllerData[i2][1];
            Icon ico = null;
            name = "";
            if (props != null) {
                ico = (Icon)props.get("Icon");
                name = (String)props.get("Name");
            }
            menuI = new JRadioButtonMenuItem(name, ico, i2 == 0);
            this.menu_.add(menuI);
            menuI.setActionCommand("" + i2);
            menuI.addActionListener(this.modeSwitchListener);
            this.modeMenuItems[i2] = menuI;
            bg.add(menuI);
        }
        if (this.tc != null) {
            this.menu_.addSeparator();
            this.menu_.add(new JLabel("Render Modes"));
            String[] renderStyles = this.tc.getSupportedRenderStyles();
            this.renderModeSwitchActions = new RenderModeSwitchAction[renderStyles.length];
            this.renderModeSwitchRadios = new JRadioButtonMenuItem[renderStyles.length];
            ButtonGroup renderModeGroup = new ButtonGroup();
            for (int i3 = 0; i3 < renderStyles.length; ++i3) {
                name = (String)nameList.get(renderStyles[i3]);
                if (name == null) {
                    name = renderStyles[i3];
                }
                this.renderModeSwitchActions[i3] = new RenderModeSwitchAction(name, renderStyles[i3]);
                menuI = new JRadioButtonMenuItem(this.renderModeSwitchActions[i3]);
                renderModeGroup.add(menuI);
                this.menu_.add(menuI);
                this.renderModeSwitchRadios[i3] = menuI;
                if (!this.tc.getRenderStyle().equals(renderStyles[i3])) continue;
                menuI.setSelected(true);
            }
        }
        this.menu_.addSeparator();
        this.menu_.add(new SaveStateAction());
        this.menu_.add(new RestoreStateAction());
        this.controller.addPropertyChangeListener("leftMouse", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newIndex = (Integer)evt.getNewValue();
        if (this.modeMenuItems != null && this.modeMenuItems.length > newIndex) {
            this.modeMenuItems[newIndex].setSelected(true);
        }
    }

    static {
        for (int i2 = 0; i2 < RENDER_MODES_TABLE.length; ++i2) {
            nameList.put(RENDER_MODES_TABLE[i2][1], RENDER_MODES_TABLE[i2][0]);
        }
    }

    private class RenderModeSwitchAction
    extends AbstractAction {
        private String mode_;

        public RenderModeSwitchAction(String name, String key) {
            super(name);
            this.mode_ = key;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (ContextMenuMouseController.this.tc != null) {
                ContextMenuMouseController.this.tc.setRenderStyle(this.mode_);
            }
        }
    }

    class RestoreStateAction
    extends AbstractAction {
        private JFileChooser fc;

        public RestoreStateAction() {
            super("Restore State...");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int result;
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            if ((result = this.fc.showOpenDialog(null)) == 0) {
                try {
                    FileInputStream is = new FileInputStream(this.fc.getSelectedFile());
                    ContextMenuMouseController.this.tc.setT3DState(is);
                    ((InputStream)is).close();
                }
                catch (FileNotFoundException fnfex) {
                    fnfex.printStackTrace();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
        }
    }

    class SaveStateAction
    extends AbstractAction {
        private JFileChooser fc;

        public SaveStateAction() {
            super("Save State...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e2) {
            int result;
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            if ((result = this.fc.showSaveDialog(null)) == 0) {
                InputStream is = ContextMenuMouseController.this.tc.getT3DState();
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(this.fc.getSelectedFile());
                    byte[] buf = new byte[1024];
                    int n2 = 0;
                    while ((n2 = is.read(buf)) > 0) {
                        ((OutputStream)os).write(buf, 0, n2);
                    }
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
                finally {
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (IOException ioex) {
                            ioex.printStackTrace();
                        }
                    }
                    if (null != os) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException ioex) {
                            ioex.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

