/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;

public class CrossHairCursor3DVc
extends Cursor3DVc {
    private static final int TOL = 5;
    private static final int CENTER_TOL = 20;
    boolean dragx;
    boolean dragy;

    @Override
    public boolean contains(int x2, int y2) {
        boolean b2 = super.contains(x2, y2);
        if (!this.enabled_) {
            return false;
        }
        if (!(this.cursorModel_ == null || activeVc != this && this.cursorModel_.isOutOfObject())) {
            return b2 || Math.abs(x2 - this.centerx_) <= 5 || Math.abs(this.centery_ - y2) <= 5;
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        int cy;
        int cx = this.dragx ? e2.getX() - this.offsetX_ : this.centerx_;
        int n2 = cy = this.dragy ? e2.getY() - this.offsetY_ : this.centery_;
        if (cx < 0 || cx >= this.getWidth() || cy < 0 || cy >= this.getHeight()) {
            return;
        }
        if (this.engine_ != null) {
            double[] projectionRAS = GeomUtils.DisplayToRAS(new int[]{cx, cy, 0}, this.engine_.getEyePoint(null), this.engine_.getLookPoint(null), this.engine_.getUp(null), this.engine_.getViewHeight(), this.getWidth(), this.getHeight(), new double[3]);
            double[] ulc = new double[3];
            double[] xside = new double[3];
            double[] yside = new double[3];
            double[] zside = new double[3];
            this.engine_.getWorldBounds(ulc, xside, yside, zside);
            if (!GeomUtils.isInsideVolume(ulc, xside, yside, zside, projectionRAS)) {
                return;
            }
        }
        CPoint pt = this.computeNewCursorPosition(cx, cy, e2.getComponent().getWidth(), e2.getComponent().getHeight());
        if (this.isContinuousUpdateEnabled()) {
            if (pt == null) {
                XpLog.fine("Out of Object!!!!!!!!!!!");
                this.cursorModel_.setOutOfObject(true);
            } else {
                this.cursorModel_.setOutOfObject(false);
                this.cursorModel_.setPoint(new CPoint(pt.generateArray(), 2));
            }
        }
        this.centerx_ = cx;
        this.centery_ = cy;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        super.mousePressed(e2);
        if (super.contains(e2.getX(), e2.getY())) {
            this.dragx = true;
            this.dragy = true;
        } else {
            this.dragx = Math.abs(e2.getX() - this.centerx_) < 5;
            this.dragy = Math.abs(e2.getY() - this.centery_) < 5;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (!this.driving_ && !this.cursorModel_.isOutOfObject()) {
            this.compute(this.getWidth(), this.getHeight());
        }
        int thickness = 3;
        boolean halft = true;
        if (this.driving_ || !this.cursorModel_.isOutOfObject() || activeVc == this) {
            T3DRenderStyleCapable trc;
            g2d.setColor(SHADOW_COLOR);
            g2d.fillRect(this.centerx_ - 1, 0, 3, this.getHeight());
            g2d.fillRect(0, this.centery_ - 1, this.getWidth(), 3);
            double tol = 0.1;
            g2d.setColor(Math.abs(this.delta_.z * this.delta_.z) > 0.1 || !this.isContinuousUpdateEnabled() && this.driving_ ? this.offPlaneCursorColor_ : this.getCursorColor());
            if (this.engine_ instanceof T3DRenderStyleCapable && "VOLUME".equals((trc = (T3DRenderStyleCapable)((Object)this.engine_)).getRenderStyle())) {
                g2d.setColor(this.getCursorColor());
            }
            if (this.cursorModel_.isOutOfObject() && activeVc == this) {
                g2d.setColor(OOO_COLOR);
            }
            g2d.fillRect(this.centerx_ - 0, 0, 1, this.getHeight());
            g2d.fillRect(0, this.centery_ - 0, this.getWidth(), 1);
        } else if (activeVc != this) {
            graphics.setColor(Color.BLUE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public CrossHairCursor3DVc(Cursor3DModel cursorModel, T3DCapable engine) {
        super(cursorModel, engine);
    }
}

