/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;

public class DefaultCursor3DModel
implements Cursor3DModel {
    protected CPoint pt_ = new CPoint(0, 0, 0, 2);
    private boolean adjusting_ = false;
    protected transient EventObject changeEvent = null;
    protected List listenerList = Collections.synchronizedList(new ArrayList());
    double[] ulc = new double[3];
    double[] xside = new double[3];
    double[] yside = new double[3];
    double[] zside = new double[3];
    protected boolean boundsCheckEnabled = false;
    T3DCapable t3dCapable_;
    private boolean ooo;
    static int count = 0;

    public DefaultCursor3DModel() {
    }

    public DefaultCursor3DModel(T3DCapable t3d) {
        this.t3dCapable_ = t3d;
        if (this.t3dCapable_ != null) {
            this.t3dCapable_.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
            this.pv("ulc", this.ulc);
            this.pv("xs", this.xside);
            this.pv("ys", this.yside);
            this.pv("zs", this.zside);
            double[] center = new double[]{this.ulc[0] + this.xside[0] * 0.5 + this.yside[0] * 0.5 + this.zside[0] * 0.5, this.ulc[1] + this.xside[1] * 0.5 + this.yside[1] * 0.5 + this.zside[1] * 0.5, this.ulc[2] + this.xside[2] * 0.5 + this.yside[2] * 0.5 + this.zside[2] * 0.5};
            this.pt_.setPoint(center[0], center[1], center[2], (byte)2);
        }
    }

    private void pv(String name, double[] ulc2) {
        System.out.print(name + ":[");
        for (int i2 = 0; i2 < ulc2.length; ++i2) {
            System.out.print(" " + ulc2[i2]);
        }
        System.out.println("]");
    }

    public DefaultCursor3DModel(CPoint pt) {
        this.pt_.setPoint(pt);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.adjusting_;
    }

    @Override
    public void addChangeListener(XjChangeListener x2) {
        this.listenerList.add(x2);
    }

    @Override
    public void removeChangeListener(XjChangeListener x2) {
        this.listenerList.remove(x2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged() {
        List list = this.listenerList;
        synchronized (list) {
            ListIterator it = this.listenerList.listIterator();
            while (it.hasNext()) {
                XjChangeListener x2 = (XjChangeListener)it.next();
                if (this.changeEvent == null) {
                    this.changeEvent = new EventObject(this);
                }
                x2.stateChanged(this.changeEvent);
            }
        }
    }

    @Override
    public CPoint getPoint(CPoint pt) {
        if (pt == null) {
            pt = new CPoint();
        }
        pt.setPoint(this.pt_);
        return pt;
    }

    @Override
    public void setPoint(CPoint pt) {
        this.setPoint(pt, this.adjusting_);
    }

    @Override
    public void setValueIsAdjusting(boolean adj) {
        this.setPoint(this.pt_, adj);
    }

    @Override
    public void setPoint(CPoint pt, boolean adj) {
        boolean changed;
        if (pt == null) {
            throw new NullPointerException("Point cannot be null!");
        }
        if (this.boundsCheckEnabled && this.t3dCapable_ != null && !GeomUtils.isInsideVolume(this.ulc, this.xside, this.yside, this.zside, pt.generateArray())) {
            return;
        }
        boolean bl = changed = !this.pt_.equals(pt) || adj != this.adjusting_;
        if (changed) {
            this.pt_.setPoint(pt);
            this.adjusting_ = adj;
            this.fireStateChanged();
        }
    }

    public boolean isBoundsCheckEnabled() {
        return this.boundsCheckEnabled;
    }

    public void setT3D(T3DCapable capable) {
        this.t3dCapable_ = capable;
        if (this.t3dCapable_ != null) {
            this.t3dCapable_.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
        }
    }

    public void setBoundsCheckEnabled(boolean boundsCheckEnabled) {
        this.boundsCheckEnabled = boundsCheckEnabled;
    }

    @Override
    public void setOutOfObject(boolean b2) {
        if (this.ooo != b2) {
            this.ooo = b2;
            this.fireStateChanged();
        }
    }

    @Override
    public boolean isOutOfObject() {
        return this.ooo;
    }
}

