/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjMultiChannelVolume;
import com.ge.med.idc.XjMultiChannelVolumeInfo;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.J3DBaseVolumeModel;
import com.ge.med.terra.jami.j3d.JDataLoader;
import com.ge.med.terra.jami.j3d.vr.VrContext;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.vr;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;

public class J3DVolumeModel
extends J3DBaseVolumeModel {
    public JVolume.LinearVolume j_vol = null;
    private JVolume.LinearVolume[] aux_j_vols = null;
    public VrContext vr_context = null;
    private boolean initialized = false;
    private Object _voldata = null;

    public J3DVolumeModel(XjVolumeInfo xj_vol) {
        this.xj_vol = xj_vol;
        int pixelType = xj_vol.getPixelType();
        int bpp = xj_vol.getBitsPerVoxel();
        VrPreset vrpreset = null;
        if (pixelType != 2 && bpp == 8) {
            this.j_vol = new JVolume.LinearByte(xj_vol);
            try {
                vrpreset = new VrPreset(vr.class.getResourceAsStream("presets/GENERAL/vr_colorbyte.vrp"));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            this.j_vol = new JVolume.LinearShort(xj_vol);
        }
        this.j_vol.addPropertyChangeListener("IMAGE_LOADED", this);
        this.vr_context = new VrContext(this.j_vol);
        if (vrpreset != null) {
            this.vr_context.setPreset(vrpreset);
        }
        this.calcVox2RAS();
    }

    public J3DVolumeModel(XjVolumeInfo xj_vol, VrContext vr_context) {
        this.xj_vol = xj_vol;
        this.vr_context = vr_context;
        this.j_vol = vr_context.vol;
        this.j_vol.addPropertyChangeListener("IMAGE_LOADED", this);
        this.calcVox2RAS();
    }

    protected J3DVolumeModel(J3DVolumeModel vm) {
        vm.copyTo(this);
    }

    protected void copyTo(J3DVolumeModel vm) {
        vm._voldata = this._voldata;
        vm.j_vol = this.j_vol;
        vm.xj_vol = this.xj_vol;
        vm.aux_j_vols = this.aux_j_vols;
        vm.ht.putAll(this.ht);
        vm.vox2ras = (JnMatrix4d)this.vox2ras.clone();
        vm.ras2vox = (JnMatrix4d)this.ras2vox.clone();
        vm.initialized = this.initialized;
        vm.vr_context = (VrContext)this.vr_context.clone();
        vm.listeners.clear();
        vm.listeners.addAll(this.listeners);
        vm.user_data.putAll(this.user_data);
    }

    public static J3DVolumeModel createMultiChannelVolumeModel(XjMultiChannelVolumeInfo mvolInfo) {
        int[] channels = new int[mvolInfo.getNumChannels()];
        for (int i2 = 0; i2 < channels.length; ++i2) {
            channels[i2] = i2;
        }
        return J3DVolumeModel.createMultiChannelVolumeModel(mvolInfo, channels);
    }

    public static J3DVolumeModel createMultiChannelVolumeModel(XjMultiChannelVolumeInfo mvolInfo, int[] channels) {
        if (mvolInfo instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)mvolInfo;
            JDataLoader jdl = new JDataLoader(mvol);
            return jdl.loadMultiChannelVolumeModel(channels);
        }
        return null;
    }

    public void attachAuxiliaryVolumes(JVolume.LinearVolume[] vols) {
        for (int i2 = 0; i2 < vols.length; ++i2) {
            if (vols[i2].dx == this.j_vol.dx && vols[i2].dy == this.j_vol.dy && vols[i2].dz == this.j_vol.dz) continue;
            throw new RuntimeException("One or more volumes do not have same size dimensions");
        }
        this._voldata = null;
        this.aux_j_vols = vols;
    }

    public int getNumVolumes() {
        if (this.aux_j_vols != null) {
            return this.aux_j_vols.length + 1;
        }
        return 1;
    }

    public JVolume.LinearVolume getJVolume() {
        return this.j_vol;
    }

    public JVolume.LinearVolume getVolume(int idx) {
        if (idx == 0) {
            return this.j_vol;
        }
        return this.aux_j_vols[idx - 1];
    }

    public JVolume.LinearVolume[] getVolumes() {
        JVolume.LinearVolume[] _vols = new JVolume.LinearVolume[this.getNumVolumes()];
        _vols[0] = this.j_vol;
        for (int i2 = 1; i2 < _vols.length; ++i2) {
            _vols[i2] = this.aux_j_vols[i2 - 1];
        }
        return _vols;
    }

    public Object getVolumeData() {
        block4: {
            if (this._voldata != null) break block4;
            int nvols = this.getNumVolumes();
            if (this.j_vol instanceof JVolume.LinearShort) {
                short[][] data = new short[nvols][];
                this._voldata = data;
                data[0] = ((JVolume.LinearShort)this.j_vol).volume;
                for (int i2 = 1; i2 < data.length; ++i2) {
                    data[i2] = ((JVolume.LinearShort)this.aux_j_vols[i2 - 1]).volume;
                }
            } else {
                byte[][] data = new byte[nvols][];
                this._voldata = data;
                data[0] = ((JVolume.LinearByte)this.j_vol).volume;
                for (int i3 = 1; i3 < data.length; ++i3) {
                    data[i3] = ((JVolume.LinearByte)this.aux_j_vols[i3 - 1]).volume;
                }
            }
        }
        return this._voldata;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Object clone() {
        VrContext vrc_copy = (VrContext)this.vr_context.clone();
        J3DVolumeModel newjvm = new J3DVolumeModel(this.xj_vol, vrc_copy);
        return newjvm;
    }

    public XjVolumeModel dupvol() {
        VrContext vrc_copy = (VrContext)this.vr_context.clone();
        vrc_copy.vol = (JVolume.LinearShort)this.vr_context.vol.clone();
        J3DVolumeModel newjvm = new J3DVolumeModel(this.xj_vol, vrc_copy);
        return newjvm;
    }

    public void init() {
        try {
            String modality = this.j_vol.modality;
            InputStream is = null;
            is = modality.toUpperCase().equals("PT") ? VrPreset.class.getResourceAsStream("presets/ABDOMEN/pet.vrp") : VrPreset.class.getResourceAsStream("presets/GENERAL/vr_color.vrp");
            VrPreset preset = new VrPreset(is);
            this.init(preset);
        }
        catch (IOException ex) {
            System.err.println("J3DVolumeModel: Cannot open preset stream.");
        }
    }

    public void init(VrPreset preset) {
        this.vr_context.setPreset(preset);
        this.initialized = true;
        System.err.println("-- J3DVolumeModel: Created volume and setup VR preset.");
    }

    public void initMip() {
        this.vr_context.initMip();
    }

    public int getVolumeValue(double x2, double y2, double z2) {
        JVolume.LinearShort jls = (JVolume.LinearShort)this.j_vol;
        int ix = (int)x2;
        int iy = (int)y2;
        int iz = (int)z2;
        double fx = x2 - (double)ix;
        double fy = y2 - (double)iy;
        double fz = z2 - (double)iz;
        int dx = this.j_vol.dx;
        int dy = this.j_vol.dy;
        int dz = this.j_vol.dz;
        if (ix >= 0 && ix < dx - 1 && iy >= 0 && iy < dy - 1 && iz >= 0 && iz < dz - 1) {
            short[] d2 = jls.volume;
            int psize = dx * dy;
            int zoff0 = psize * iz;
            int zoff1 = zoff0 + psize;
            int yoff0 = dx * iy;
            int yoff1 = yoff0 + dx;
            short v0 = d2[zoff0 + yoff0 + ix];
            short v1 = d2[zoff0 + yoff0 + ix + 1];
            short v2 = d2[zoff0 + yoff1 + ix];
            short v3 = d2[zoff0 + yoff1 + ix + 1];
            short v4 = d2[zoff1 + yoff0 + ix];
            short v5 = d2[zoff1 + yoff0 + ix + 1];
            short v6 = d2[zoff1 + yoff1 + ix];
            short v7 = d2[zoff1 + yoff1 + ix + 1];
            int val = (int)J3DVolumeModel.trilineard(v0, v1, v2, v3, v4, v5, v6, v7, fx, fy, fz);
            return val;
        }
        return 0;
    }

    public final void resetBingrid() {
        this.vr_context.resetBingrid();
        this.notifyChangeListeners();
    }

    public final boolean bingridAnd(byte[] bgrid) {
        boolean ret = this.vr_context.bingridAnd(bgrid);
        this.notifyChangeListeners();
        return ret;
    }

    public final boolean bingridOr(byte[] bgrid) {
        boolean ret = this.vr_context.bingridOr(bgrid);
        this.notifyChangeListeners();
        return ret;
    }

    public final boolean bingridNot() {
        boolean ret = this.vr_context.bingridNot();
        this.notifyChangeListeners();
        return ret;
    }

    public void setPreset(VrPreset preset) {
        this.vr_context.setPreset(preset);
        this.notifyChangeListeners();
    }

    @Override
    public void voxelsChanged() {
        this.vr_context.reset();
        this.pcs.firePropertyChange("VOXELS_PROPERTY", null, this.j_vol);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("IMAGE_LOADED")) {
            int idx = (Integer)evt.getNewValue();
            if (this.initialized) {
                int[] zpos = new int[]{idx};
                this.vr_context.refreshVrContext(zpos, zpos.length);
            }
            this.pcs.firePropertyChange("VOLUME_SLICE", null, new int[]{idx});
        }
    }
}

