/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DDepthCapable;
import com.ge.med.jnu.geom.ParametricCurve3D;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.T3DComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;

public class PolyLine3DVc
extends XpVisualComponent
implements MouseInputListener,
PropertyChangeListener {
    private static final int NOT_SELECTED = -1;
    private static final int CURVE_SELECTED = -2;
    private ParametricCurve3D curve = null;
    private CPoint[] controlPoints = null;
    private int selectedPoint = -1;
    private int selectedPointPopup = -1;
    private boolean updateDirty = true;
    private boolean mouseDown = false;
    private boolean onCurve = false;
    private Cursor handCursor = new Cursor(12);
    private static final int pointSize = 6;
    private static final int pointRadius = 3;
    private static final int pointSelectRadius = 4;
    private JPopupMenu curvePopup = new JPopupMenu();
    private List adjustedControlList = null;
    private Point previousPoint = null;
    private String deleteControlPointStr = "Delete control Point";
    private String deleteCurveStr = "Delete curve";

    public PolyLine3DVc() {
        this.enableMouse();
        this.initPopUpMenu();
    }

    protected void initPopUpMenu() {
        JMenuItem delCp = new JMenuItem(this.deleteControlPointStr);
        this.curvePopup.add(delCp);
        JMenuItem delCurve = new JMenuItem(this.deleteCurveStr);
        this.curvePopup.add(delCurve);
        delCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PolyLine3DVc.this.deleteAllControlPoints();
            }
        });
        delCp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PolyLine3DVc.this.deleteControlPoint();
            }
        });
    }

    protected void enableMouse() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setCurve(ParametricCurve3D curve) {
        if (this.curve != curve) {
            if (this.curve != null) {
                this.curve.removePropertyChangeListener(this);
            }
            this.curve = curve;
            this.curve.addPropertyChangeListener("CURVE_PROPERTY", this);
            this.updateDirty = true;
        }
    }

    protected void update() {
        this.updateDirty = false;
        if (false) {
            return;
        }
        this.updateDirty = false;
        if (this.curve == null) {
            this.controlPoints = new CPoint[0];
            return;
        }
        if (this.curve.getControlPoints() != null) {
            List controlList = this.curve.getControlPoints();
            this.controlPoints = new CPoint[controlList.size()];
            CPoint rasPoint = new CPoint(2);
            for (int i2 = 0; i2 < controlList.size() && (double[])controlList.get(i2) != null; ++i2) {
                rasPoint.set((double[])controlList.get(i2));
                this.controlPoints[i2] = this.transform(rasPoint, (byte)1);
            }
        }
    }

    @Override
    public boolean contains(int x2, int y2) {
        if (this.mouseDown) {
            return true;
        }
        if (this.controlPoints != null) {
            for (int i2 = 0; i2 < this.controlPoints.length; ++i2) {
                if (this.controlPoints[i2] == null) {
                    XpLog.logger().warning("PolyLine3DVc: Null in contains while checking controlPoints[" + i2 + "]");
                    break;
                }
                if (!((double)x2 >= this.controlPoints[i2].x - 4.0) || !((double)x2 < this.controlPoints[i2].x + 4.0) || !((double)y2 >= this.controlPoints[i2].y - 4.0) || !((double)y2 < this.controlPoints[i2].y + 4.0)) continue;
                this.selectedPoint = i2;
                this.selectedPointPopup = i2;
                this.onCurve = false;
                return true;
            }
        }
        if (this.curve.getControlPoints() != null && this.curve.getControlPoints().size() > 1 && this.controlPoints != null) {
            int x1 = x2 - 2;
            int y1 = y2 - 2;
            int x22 = x2 + 2;
            int y22 = y2 + 2;
            CPoint prev = this.controlPoints[0];
            for (int i3 = 1; i3 < this.controlPoints.length; ++i3) {
                if (this.controlPoints[i3] == null) {
                    XpLog.logger().warning("PolyLine3DVc: Null in contains while checking controlPoints[" + i3 + "]");
                    break;
                }
                CPoint p2 = this.controlPoints[i3];
                if (XpGeomUtils.intersects(x1, y1, x22, y22, (int)prev.x, (int)prev.y, (int)p2.x, (int)p2.y)) {
                    this.onCurve = true;
                    this.selectedPoint = -1;
                    return true;
                }
                this.onCurve = false;
                prev = p2;
            }
        }
        this.selectedPoint = -1;
        this.onCurve = false;
        return false;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.curve.getControlPoints() != null) {
            this.update();
            if (this.controlPoints.length > 1) {
                g2.setColor(Color.yellow);
                CPoint p1 = this.controlPoints[0];
                for (int i2 = 1; i2 < this.controlPoints.length; ++i2) {
                    CPoint p2 = this.controlPoints[i2];
                    g2.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
                    p1 = p2;
                }
            }
            for (int i3 = 0; i3 < this.controlPoints.length; ++i3) {
                g2.setColor(Color.red);
                g2.fillRect((int)this.controlPoints[i3].x - 3, (int)this.controlPoints[i3].y - 3, 6, 6);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        boolean b3;
        int mod = e2.getModifiers();
        boolean b1 = 0 != (mod & 0x10);
        boolean b2 = 0 != (mod & 8);
        boolean bl = b3 = 0 != (mod & 4);
        if (this.mouseDown || !b1 && !b2 && !b3) {
            this.setCursor(this.handCursor);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.mouseDown = true;
        this.previousPoint = e2.getPoint();
        this.adjustedControlList = this.curve.getControlPoints();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.mouseDown = false;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        boolean b3;
        int mod = e2.getModifiers();
        boolean bl = b3 = 0 != (mod & 4);
        if (b3) {
            this.curvePopup.show(this, e2.getX(), e2.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        double[] tempRAS = null;
        int distX = 0;
        int distY = 0;
        T3DComponent t3dcomp = (T3DComponent)this.getParent();
        Point p2 = e2.getPoint();
        int width = t3dcomp.getWidth();
        int height = t3dcomp.getHeight();
        if (this.onCurve && this.selectedPoint == -1) {
            if (p2.x < 0 || p2.y < 0 || p2.x > width - 1 || p2.y > height - 1) {
                return;
            }
            distX = p2.x - this.previousPoint.x;
            distY = p2.y - this.previousPoint.y;
            CPoint points = new CPoint();
            for (int i2 = 0; i2 < this.controlPoints.length; ++i2) {
                points = this.controlPoints[i2];
                points.x += (double)distX * 1.0;
                points.y += (double)distY * 1.0;
                tempRAS = this.transform(points, (byte)2).generateArray();
                if (tempRAS == null) {
                    XpLog.logger().warning("PolyLine3DVc: BAD CURVE TRANSFORM");
                }
                this.adjustedControlList.set(i2, tempRAS);
            }
            this.previousPoint.y = p2.y;
            this.previousPoint.x = p2.x;
            this.curve.setControlPoints(this.adjustedControlList);
            this.repaint();
            return;
        }
        if (this.selectedPoint == -1) {
            return;
        }
        CPoint point = this.controlPoints[this.selectedPoint];
        point.x = p2.x;
        point.y = p2.y;
        if (p2.x < 0 || p2.y < 0 || p2.x > width - 1 || p2.y > height - 1) {
            return;
        }
        if (t3dcomp.getCapable(T3DDepthCapable.class.getCanonicalName()) != null) {
            T3DDepthCapable dc = (T3DDepthCapable)((Object)t3dcomp.getCapable(T3DDepthCapable.class.getCanonicalName()));
            tempRAS = dc.getRASCoords((int)point.x, (int)point.y, null);
        }
        if (tempRAS == null && (tempRAS = this.transform(point, (byte)2).generateArray()) == null) {
            XpLog.logger().warning("PolyLine3DVc: BAD POINT TRANSFORM");
        }
        this.adjustedControlList.set(this.selectedPoint, tempRAS);
        this.curve.setControlPoints(this.adjustedControlList);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    public void deleteControlPoint() {
        ArrayList tempControlPointsSrc = new ArrayList();
        tempControlPointsSrc = (ArrayList)this.curve.getControlPoints();
        ArrayList tempControlPointsDest = (ArrayList)tempControlPointsSrc.clone();
        tempControlPointsDest.remove(this.selectedPointPopup);
        this.curve.setControlPoints(tempControlPointsDest);
        this.update();
        this.repaint();
    }

    public void deleteAllControlPoints() {
        ArrayList emptyControlList = new ArrayList();
        this.curve.setControlPoints(emptyControlList);
        this.update();
        this.repaint();
    }

    public boolean checkCurveBound(double distx, double disty, double height, double width) {
        double x2 = 0.0;
        double y2 = 0.0;
        CPoint p2 = new CPoint();
        for (int i2 = 0; i2 < this.controlPoints.length; ++i2) {
            p2 = this.controlPoints[i2];
            x2 = p2.x + distx * 1.0;
            y2 = p2.y + disty * 1.0;
            if (!(x2 < 0.0 || y2 < 0.0 || x2 > width - 1.0) && !(y2 > height - 1.0)) continue;
            return false;
        }
        return true;
    }
}

