/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import java.util.Arrays;

public class RayVolume {
    private static final double EPSILON = (double)1.0E-4f;
    private static final int[][] OTHERDIM = new int[][]{{1, 2}, {0, 2}, {0, 1}};
    private int[] minB = new int[3];
    private int[] maxB = new int[3];

    public RayVolume(int dx, int dy, int dz) {
        this.minB[2] = 0;
        this.minB[1] = 0;
        this.minB[0] = 0;
        this.maxB[0] = dx;
        this.maxB[1] = dy;
        this.maxB[2] = dz;
    }

    private void scaleAdd(double[] v0, double s2, double[] v1, double[] res) {
        res[0] = v0[0] + s2 * v1[0];
        res[1] = v0[1] + s2 * v1[1];
        res[2] = v0[2] + s2 * v1[2];
    }

    public boolean intersect(double[] lookpt, double[] dir_x, double[] dir_y, double[] dir_z, int x0, int y0, int x1, int y1, int xskip, int yskip, int width, int height) {
        double[] rowpoint = new double[3];
        double[] currpoint = new double[3];
        double[] idir_z = new double[3];
        double[] tres = new double[2];
        idir_z[0] = Math.abs(dir_z[0]) > (double)1.0E-4f ? 1.0 / dir_z[0] : 0.0;
        idir_z[1] = Math.abs(dir_z[1]) > (double)1.0E-4f ? 1.0 / dir_z[1] : 0.0;
        idir_z[2] = Math.abs(dir_z[2]) > (double)1.0E-4f ? 1.0 / dir_z[2] : 0.0;
        for (int y2 = y0; y2 < y1; y2 += yskip) {
            this.scaleAdd(lookpt, (double)y2 - (double)height * 0.5, dir_y, rowpoint);
            for (int x2 = x0; x2 < x1; x2 += xskip) {
                this.scaleAdd(rowpoint, (double)x2 - (double)width * 0.5, dir_x, currpoint);
                this.ray_intersect(currpoint, dir_z, idir_z, tres);
            }
        }
        return true;
    }

    public int ray_intersect(double[] origin, double[] dir, double[] idir, double[] tres) {
        boolean[] hit = new boolean[]{false, false, false};
        double[][] Tminmax = new double[2][3];
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!(idir[i2] > 0.0)) continue;
            Tminmax[0][i2] = ((double)this.minB[i2] - origin[i2]) * idir[i2];
            Tminmax[1][i2] = ((double)this.maxB[i2] - origin[i2]) * idir[i2];
            hit[i2] = true;
        }
        tres[1] = 9999999.0;
        tres[0] = 9999999.0;
        int nhits = 0;
        block1: for (int i3 = 0; i3 < 3 && nhits < 2; ++i3) {
            if (!hit[i3]) continue;
            for (int j2 = 0; j2 < 2; ++j2) {
                int idx_dim0 = OTHERDIM[i3][0];
                int idx_dim1 = OTHERDIM[i3][1];
                double tc = Tminmax[j2][i3];
                double pt0 = origin[idx_dim0] + dir[idx_dim0] * tc;
                double pt1 = origin[idx_dim1] + dir[idx_dim1] * tc;
                if (!(pt0 >= (double)this.minB[idx_dim0]) || !(pt0 <= (double)this.maxB[idx_dim0]) || !(pt1 >= (double)this.minB[idx_dim1]) || !(pt1 <= (double)this.maxB[idx_dim1])) continue;
                tres[nhits++] = tc;
                if (nhits != 2) continue;
                if (!(tres[0] > tres[1])) continue block1;
                double tmp = tres[0];
                tres[0] = tres[1];
                tres[1] = tmp;
                continue block1;
            }
        }
        return nhits;
    }

    public int ray_intersect(float[] origin, float[] dir, float[] idir, ThreadData td, float[] tres) {
        boolean[] hit = td.hit;
        float[][] Tminmax = td.Tminmax;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!(idir[i2] > 0.0f)) continue;
            Tminmax[0][i2] = ((float)this.minB[i2] - origin[i2]) * idir[i2];
            Tminmax[1][i2] = ((float)this.maxB[i2] - origin[i2]) * idir[i2];
            hit[i2] = true;
        }
        tres[1] = 9999999.0f;
        tres[0] = 9999999.0f;
        int nhits = 0;
        block1: for (int i3 = 0; i3 < 3 && nhits < 2; ++i3) {
            if (!hit[i3]) continue;
            for (int j2 = 0; j2 < 2; ++j2) {
                int idx_dim0 = OTHERDIM[i3][0];
                int idx_dim1 = OTHERDIM[i3][1];
                float tc = Tminmax[j2][i3];
                float pt0 = origin[idx_dim0] + dir[idx_dim0] * tc;
                float pt1 = origin[idx_dim1] + dir[idx_dim1] * tc;
                if (!(pt0 >= (float)this.minB[idx_dim0]) || !(pt0 <= (float)this.maxB[idx_dim0]) || !(pt1 >= (float)this.minB[idx_dim1]) || !(pt1 <= (float)this.maxB[idx_dim1])) continue;
                tres[nhits++] = tc;
                if (nhits != 2) continue;
                if (!(tres[0] > tres[1])) continue block1;
                float tmp = tres[0];
                tres[0] = tres[1];
                tres[1] = tmp;
                continue block1;
            }
        }
        return nhits;
    }

    public static class ThreadData {
        public boolean[] hit = new boolean[]{false, false, false};
        public float[][] Tminmax = new float[2][3];

        public final void reset() {
            Arrays.fill(this.hit, false);
        }
    }
}

