/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.j3d.CustomCursor;
import com.ge.med.terra.jami.j3d.CustomIcon;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.PanMouseController;
import com.ge.med.terra.jami.j3d.T3DTrackball;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.WLMouseController;
import com.ge.med.terra.jami.j3d.ZoomMouseController;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class RetargetableMouseController
extends MouseInputAdapter
implements XpMouseController,
MouseWheelListener {
    static Logger logger = Logger.getLogger("com.ge.med.terra.jami");
    protected Map controllerMap_ = new HashMap();
    protected Map propertyMap_ = new HashMap();
    protected JComponent target_;
    private Map controllerReverseMap_ = new HashMap();
    private XpMouseController activeController_;
    private Cursor oldCursor_;
    public static final String CURSOR_PROPERTY = "Cursor";
    public static final String ICON_PROPERTY = "Icon";
    public static final String NAME_PROPERTY = "Name";
    public static final String SHORT_DESCRIPTION_PROPERTY = "ShortDescription";
    public static final Map TRACKBALL_PROPERTIES = new HashMap();
    public static final Map ZOOM_PROPERTIES = new HashMap();
    public static final Map PAN_PROPERTIES = new HashMap();
    public static final Map WL_PROPERTIES = new HashMap();
    public static final Map SELECT_PROPERTIES = new HashMap();
    long wheelPrevTime_ = 0L;
    static final int WHEEL_SENSITIVITY = 500;
    static final int FAST_WHEEL_SCROLL_AMOUNT = 3;
    boolean start = false;
    double depth = 0.0;
    double depthMin = 0.0;
    double depthMax = 0.0;
    static double stepsize;
    byte[] mask;
    static final byte[] MASK;

    public XpMouseController getMouseController(int binding) {
        return (XpMouseController)this.controllerMap_.get(new Integer(binding));
    }

    public Properties getMouseControllerProperties(int binding) {
        return (Properties)this.propertyMap_.get(this.getMouseController(binding));
    }

    public RetargetableMouseController() {
        this.addMouseController(new T3DTrackball(), 1024, TRACKBALL_PROPERTIES);
        this.addMouseController(new PanMouseController(), 4096, PAN_PROPERTIES);
        this.addMouseController(new ZoomMouseController(), 2048, ZOOM_PROPERTIES);
        this.addMouseController(new WLMouseController(), 1088, WL_PROPERTIES);
        this.addMouseController(new ZoomMouseController(), 4160, ZOOM_PROPERTIES);
    }

    public static void main(String[] args) {
    }

    @Override
    public void setTarget(JComponent jc) {
        this.target_ = jc;
        for (XpMouseController controller : this.controllerMap_.values()) {
            controller.setTarget(jc);
        }
    }

    public void addMouseController(XpMouseController controller, int binding, Map properties) {
        this.controllerMap_.put(new Integer(binding), controller);
        this.controllerReverseMap_.put(controller, new Integer(binding));
        if (properties != null) {
            Properties p2 = new Properties();
            Set s2 = properties.entrySet();
            for (Map.Entry me : s2) {
                if (!(me.getKey() instanceof String) || !(me.getValue() instanceof String)) continue;
                p2.setProperty((String)me.getKey(), (String)me.getValue());
            }
            this.propertyMap_.put(controller, p2);
        }
        if (this.target_ != null) {
            controller.setTarget(this.target_);
        }
    }

    public void removeMouseController(XpMouseController controller) {
        if (controller == null) {
            return;
        }
        Object o2 = this.controllerReverseMap_.get(controller);
        this.controllerReverseMap_.remove(controller);
        this.propertyMap_.remove(controller);
        if (o2 != null) {
            this.controllerMap_.remove(o2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (this.activeController_ == null) {
            return;
        }
        this.activeController_.mouseClicked(e2);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.activeController_ != null) {
            this.activeController_.mouseDragged(e2);
        }
    }

    private void debugModifier(int modval) {
        String val = "";
        if ((modval & 0x400) != 0) {
            val = val + " | BUTTON1_DOWN";
        }
        if ((modval & 0x800) != 0) {
            val = val + " | BUTTON2_DOWN";
        }
        if ((modval & 0x1000) != 0) {
            val = val + " | BUTTON3_DOWN";
        }
        if ((modval & 0x10) != 0) {
            val = val + " | BUTTON1";
        }
        if ((modval & 8) != 0) {
            val = val + " | BUTTON2";
        }
        if ((modval & 4) != 0) {
            val = val + " | BUTTON3";
        }
        if (((long)modval & 0x10L) != 0L) {
            val = val + " | MOUSE_EVENT";
        }
        if ((modval & 4) != 0) {
            val = val + " | META";
        }
        if ((modval & 0x100) != 0) {
            val = val + " | META_DOWN";
        }
        System.err.println("modifier = [" + modval + "] " + val);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        Cursor cursor;
        int modifier_ex = e2.getModifiersEx() & 0xFFFFFEFF;
        this.activeController_ = (XpMouseController)this.controllerMap_.get(new Integer(modifier_ex));
        if (this.activeController_ == null) {
            System.err.println("mouse controller not found!");
            return;
        }
        Map prop = (Map)this.propertyMap_.get(this.activeController_);
        if (prop != null && (cursor = (Cursor)prop.get(CURSOR_PROPERTY)) != null) {
            if (this.oldCursor_ == null) {
                this.oldCursor_ = e2.getComponent().getCursor();
            }
            e2.getComponent().setCursor(cursor);
        }
        this.activeController_.mousePressed(e2);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.activeController_ == null) {
            return;
        }
        this.activeController_.mouseReleased(e2);
        if (this.oldCursor_ != null) {
            e2.getComponent().setCursor(this.oldCursor_);
            this.oldCursor_ = null;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        logger.fine("wheel moved");
        if (e2.getScrollType() == 0) {
            int sign = e2.getWheelRotation() > 0 ? 1 : -1;
            long t2 = System.currentTimeMillis();
            int dz = t2 - this.wheelPrevTime_ > 500L ? 1 : 3;
            dz *= sign;
            this.wheelPrevTime_ = t2;
            if (this.target_ instanceof T3DCapable) {
                T3DRenderStyleCapable trsc;
                String s2;
                T3DCapable t3d = (T3DCapable)((Object)this.target_);
                if ((e2.getModifiers() & 2) != 0) {
                    t3d.setViewHeight(t3d.getViewHeight() * (1.0 + 0.05 * (double)dz));
                } else if (t3d instanceof T3DRenderStyleCapable && !"VOLUME".equals(s2 = (trsc = (T3DRenderStyleCapable)((Object)t3d)).getRenderStyle()) && t3d instanceof T3DViewport) {
                    XjVolumeInfo v2 = ((T3DViewport)t3d).getT3DComponent().getVolume();
                    double[] eye = t3d.getEyePoint(null);
                    double[] look = t3d.getLookPoint(null);
                    JnVector3d view = new JnVector3d(look);
                    view.sub(eye);
                    view.normalize();
                    double[] xv = v2.getXDirectionRAS(null);
                    double[] zv = v2.getZDirectionRAS(null);
                    double[] vv = xv;
                    double[] dArray = new double[]{0.0, 0.0, 1.0};
                    if (Math.abs(Math.abs(view.dot(dArray)) - 1.0) < 0.001) {
                        vv = zv;
                    }
                    view.scale((double)dz * Math.sqrt(vv[0] * vv[0] + vv[1] * vv[1] + vv[2] * vv[2]));
                    look[0] = look[0] + view.x;
                    look[1] = look[1] + view.y;
                    look[2] = look[2] + view.z;
                    if (GeomUtils.isInVolume(look, v2.getRASOfOrigin(null), xv, v2.getYDirectionRAS(null), zv, v2.getVolumeDimensions(null))) {
                        eye[0] = eye[0] + view.x;
                        eye[1] = eye[1] + view.y;
                        eye[2] = eye[2] + view.z;
                        t3d.setCamera(eye, look, t3d.getUp(null));
                    }
                }
            }
        }
    }

    private void doCut(T3DCapable t3d, int steps) {
        double[] view = new double[3];
        double[] look = t3d.getLookPoint(null);
        double[] eye = t3d.getEyePoint(null);
        view[0] = look[0] - eye[0];
        view[1] = look[1] - eye[1];
        view[2] = look[2] - eye[2];
        if (!this.start) {
            double[] ulc = new double[3];
            double[] xside = new double[3];
            double[] yside = new double[3];
            double[] zside = new double[3];
            t3d.getWorldBounds(ulc, xside, yside, zside);
            double t0 = (ulc[0] - look[0]) * view[0] + (ulc[1] - look[1]) * view[1] + (ulc[2] - look[2]) * view[2];
            double t1 = (ulc[0] + xside[0] - look[0]) * view[0] + (ulc[1] + xside[1] - look[1]) * view[1] + (ulc[2] + xside[2] - look[2]) * view[2];
            double t2 = (ulc[0] + yside[0] - look[0]) * view[0] + (ulc[1] + yside[1] - look[1]) * view[1] + (ulc[2] + yside[2] - look[2]) * view[2];
            double t3 = (ulc[0] + zside[0] - look[0]) * view[0] + (ulc[1] + zside[1] - look[1]) * view[1] + (ulc[2] + zside[2] - look[2]) * view[2];
            double t4 = (ulc[0] + xside[0] + yside[0] - look[0]) * view[0] + (ulc[1] + xside[1] + yside[1] - look[1]) * view[1] + (ulc[2] + xside[2] + yside[2] - look[2]) * view[2];
            double t5 = (ulc[0] + yside[0] + zside[0] - look[0]) * view[0] + (ulc[1] + yside[1] + zside[1] - look[1]) * view[1] + (ulc[2] + yside[2] + zside[2] - look[2]) * view[2];
            double t6 = (ulc[0] + zside[0] + xside[0] - look[0]) * view[0] + (ulc[1] + zside[1] + xside[1] - look[1]) * view[1] + (ulc[2] + zside[2] + xside[2] - look[2]) * view[2];
            double t7 = (ulc[0] + xside[0] + yside[0] + zside[0] - look[0]) * view[0] + (ulc[1] + xside[1] + yside[1] + zside[1] - look[1]) * view[1] + (ulc[2] + xside[2] + yside[2] + zside[2] - look[2]) * view[2];
            t0 = -t0;
            t1 = -t1;
            t2 = -t2;
            t3 = -t3;
            t4 = -t4;
            t5 = -t5;
            t6 = -t6;
            t7 = -t7;
            this.depthMin = t0;
            this.depthMax = t0;
            this.depthMin = Math.max(this.depthMin, t1);
            this.depthMax = Math.min(this.depthMax, t1);
            this.depthMin = Math.max(this.depthMin, t2);
            this.depthMax = Math.min(this.depthMax, t2);
            this.depthMin = Math.max(this.depthMin, t3);
            this.depthMax = Math.min(this.depthMax, t3);
            this.depthMin = Math.max(this.depthMin, t4);
            this.depthMax = Math.min(this.depthMax, t4);
            this.depthMin = Math.max(this.depthMin, t5);
            this.depthMax = Math.min(this.depthMax, t5);
            this.depthMin = Math.max(this.depthMin, t6);
            this.depthMax = Math.min(this.depthMax, t6);
            this.depthMin = Math.max(this.depthMin, t7);
            this.depthMax = Math.min(this.depthMax, t7);
            this.depth = this.depthMin;
            this.start = true;
        }
        double cut = stepsize * (double)steps;
        this.depth -= cut;
        System.out.println("Depth min =" + this.depthMin + ",depthmax = " + this.depthMax + ",depth=" + this.depth);
        if (this.depth < this.depthMax) {
            this.depth += cut;
            return;
        }
        if (this.depth > this.depthMin) {
            ((J3DVolumeModel)((T3DViewport)t3d).getVolumeModel()).resetBingrid();
            this.depth = this.depthMin;
            return;
        }
        XjVolumeInfo vol = ((T3DViewport)t3d).getT3DComponent().getVolume();
        int[] dims = vol.getVolumeDimensions(null);
        double[] xv = vol.getXDirectionRAS(null);
        double[] yv = vol.getYDirectionRAS(null);
        double[] zv = vol.getZDirectionRAS(null);
        double[] orig = vol.getRASOfOrigin(null);
        if (this.mask == null || this.mask.length != dims[0] * dims[1] * dims[2] >> 3) {
            this.mask = new byte[dims[0] * dims[1] * dims[2] >> 3];
            System.err.println("initializing mask");
        }
        Arrays.fill(this.mask, (byte)-1);
        double[] ras = new double[3];
        double delta = xv[0] * view[0] + xv[1] * view[1] + xv[2] * view[2];
        int count = 0;
        int off = 0;
        int pack = 0;
        System.out.println("Cut Start");
        for (int z2 = 0; z2 < dims[2]; ++z2) {
            ras[0] = look[0] - (orig[0] + (double)z2 * zv[0]);
            ras[1] = look[1] - (orig[1] + (double)z2 * zv[1]);
            ras[2] = look[2] - (orig[2] + (double)z2 * zv[2]);
            for (int y2 = 0; y2 < dims[1]; ++y2) {
                double projDepth = ras[0] * view[0] + ras[1] * view[1] + ras[2] * view[2];
                int x2 = 0;
                while (x2 < dims[0]) {
                    if (x2 == 0 && y2 == 0 && z2 == 0 || x2 == dims[2] - 1 && y2 == dims[1] - 1 && z2 == dims[2] - 1) {
                        System.err.println("proj depth = " + projDepth);
                    }
                    if (projDepth < this.depth) {
                        pack |= MASK[off & 7];
                    }
                    if (++count == 8) {
                        int n2 = off >> 3;
                        this.mask[n2] = (byte)(this.mask[n2] & pack);
                        pack = 0;
                        count = 0;
                    }
                    ++x2;
                    ++off;
                    projDepth -= delta;
                }
                ras[0] = ras[0] - yv[0];
                ras[1] = ras[1] - yv[1];
                ras[2] = ras[2] - yv[2];
            }
        }
        System.out.println("Cut End");
        J3DVolumeModel j3dvm = (J3DVolumeModel)((T3DViewport)t3d).getVolumeModel();
        j3dvm.resetBingrid();
        j3dvm.bingridAnd(this.mask);
    }

    static {
        TRACKBALL_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.ROTATION_3D_CURSOR);
        TRACKBALL_PROPERTIES.put(ICON_PROPERTY, CustomIcon.ROTATION3D_ICON);
        TRACKBALL_PROPERTIES.put(NAME_PROPERTY, "Track Ball");
        TRACKBALL_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Free 3D Rotate");
        ZOOM_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.ZOOM_CURSOR);
        ZOOM_PROPERTIES.put(ICON_PROPERTY, CustomIcon.ZOOM_ICON);
        ZOOM_PROPERTIES.put(NAME_PROPERTY, "Zoom");
        ZOOM_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Zoom In/Out");
        PAN_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.PAN_CURSOR);
        PAN_PROPERTIES.put(ICON_PROPERTY, CustomIcon.PAN_ICON);
        PAN_PROPERTIES.put(NAME_PROPERTY, "Pan/Roam");
        PAN_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Move Image");
        WL_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.WL_CURSOR);
        WL_PROPERTIES.put(ICON_PROPERTY, CustomIcon.WL_ICON);
        WL_PROPERTIES.put(NAME_PROPERTY, "Window/Level");
        WL_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "WindowLevel");
        SELECT_PROPERTIES.put(CURSOR_PROPERTY, Cursor.getDefaultCursor());
        SELECT_PROPERTIES.put(ICON_PROPERTY, CustomIcon.SELCET_ICON);
        SELECT_PROPERTIES.put(NAME_PROPERTY, "Select");
        SELECT_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Select Object");
        stepsize = 5.0;
        MASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    }
}

