/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.Capable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.Fusion3DCapable;
import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.T3DRenderedState;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjFragmentProgram;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.SegmentationCapable;
import com.ge.med.terra.jami.j3d.DownSampledVolume;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.T3DImageBlitter;
import com.ge.med.terra.jami.j3d.ViewResetAction;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.j3d.mprender.OnepassAlgorithm;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.render.XpOverlayFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public class T3DComponent
extends XpVisualComponent
implements T3DCapable,
Fusion3DCapable,
XpImageRenderAttributesOwner,
FrameOwner,
T3DRenderStyleCapable,
PropertyChangeListener,
XjChangeListener,
SegmentationCapable,
ColorMapCapable,
WindowLevelCapable,
T3DRenderedState {
    private static int t3dcomponent_id_cnt = 0;
    public static final String VOLUME_DOWNSAMPLEXY = "VOLUME_DOWNSAMPLEXY";
    public static final String VOLUME_DOWNSAMPLEZ = "VOLUME_DOWNSAMPLEZ";
    private T3DRenderEngine engine = null;
    private T3DImageBlitter renderer = null;
    private int t3dcomponent_id = t3dcomponent_id_cnt++;
    private int[] rgb_image = null;
    private short[] lum_image = null;
    private short[] outoverlay = null;
    private double winUpperLimit = Double.MAX_VALUE;
    private double winLowerLimit = -1.7976931348623157E308;
    private boolean startIRE = true;
    private volatile boolean ire = true;
    private volatile boolean renderFinal = true;
    private int[] _actColorMap = null;
    private int roiVcCnt = 0;
    private List<XjFragmentProgram> combiners = new ArrayList<XjFragmentProgram>();
    private boolean debug = false;
    private boolean dirtyT3D = true;
    private boolean t3dReady = false;
    private boolean renderStyleSwitch = false;
    private int volDownSampleXY = 1;
    private int volDownSampleZ = 1;
    private boolean ignoreRenderEngineEvents = false;
    private boolean isVolumeLoaded = false;
    private CameraState requestedCamera = new CameraState();
    private CameraState renderedCamera = new CameraState();
    private Object paintLock = new Object();
    private transient boolean changeDisplay = false;
    private transient boolean changeRegion = false;
    private boolean keeprunning = true;
    private Object lock = new Object();
    private Object ireDone = new Object();
    private Rectangle dirtyRegion = new Rectangle();
    private MultipassAlgorithm incrementalAlg = null;
    private MultipassAlgorithm[] mp_alg = new MultipassAlgorithm[16];
    private Object[] combiner_buffers = null;
    private boolean forceRender = false;
    private boolean doRefreshOnVisible = false;
    private CPoint ul = new CPoint(2);
    private CPoint ur = new CPoint(2);
    private CPoint br = new CPoint(2);
    private CTransform _disp2ras = new CTransform(CTransform.Identity);
    private CTransform _ras2disp = new CTransform(CTransform.Identity);
    private CTransform _vox2disp = new CTransform(CTransform.Identity);
    private CTransform _disp2vox = new CTransform(CTransform.Identity);
    private CTransform _ras2vox = new CTransform(CTransform.Identity);
    private CTransform _vox2ras = new CTransform(CTransform.Identity);

    public T3DComponent() {
        this(new J3DRenderEngine());
    }

    public T3DComponent(T3DRenderEngine engine) {
        this.engine = engine;
        this.init();
    }

    protected T3DImageBlitter createImageBlitter() {
        return new T3DImageBlitter();
    }

    private void init() {
        this.renderer = this.createImageBlitter();
        this.engine.addPropertyChangeListener(this);
        this.engine.addChangeListener(this);
        this.setInitialView(ViewResetAction.A_VECTOR.toArray());
        this.setInitialUp(ViewResetAction.A_UP_VECTOR.toArray());
        this.addMouseListener(XpAppContext.instance().getSelectionManager());
        this.set2DInterpolation(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    @Override
    public double[] getRenderedLookPoint(double[] renderedLookPoint) {
        if (renderedLookPoint == null) {
            renderedLookPoint = new double[3];
        }
        System.arraycopy(this.renderedCamera.lookPoint, 0, renderedLookPoint, 0, 3);
        return renderedLookPoint;
    }

    @Override
    public double[] getRenderedEyePoint(double[] renderedEyePoint) {
        if (renderedEyePoint == null) {
            renderedEyePoint = new double[3];
        }
        System.arraycopy(this.renderedCamera.eyePoint, 0, renderedEyePoint, 0, 3);
        return renderedEyePoint;
    }

    @Override
    public double[] getRenderedUp(double[] renderedUp) {
        if (renderedUp == null) {
            renderedUp = new double[3];
        }
        System.arraycopy(this.renderedCamera.upVector, 0, renderedUp, 0, 3);
        return renderedUp;
    }

    @Override
    public double getRenderedViewHeight() {
        return this.renderedCamera.viewHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderThread() {
        block15: while (this.keeprunning) {
            int passno;
            XjVolumeInfo vol;
            Object object = this.lock;
            synchronized (object) {
                while (!this.changeDisplay && !this.changeRegion) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            if (!this.keeprunning) break;
            if (this.rgb_image == null || this.lum_image == null) {
                this.changeDisplay = false;
                this.changeRegion = false;
                continue;
            }
            int w2 = this.getWidth();
            int h2 = this.getHeight();
            int nouts = this.getNumOutputLayers();
            int imgWidth = this.renderer.getOutputWidth();
            int imgHeight = this.renderer.getOutputHeight();
            int nOutputs = this.renderer.getNumOutputs();
            if (w2 != imgWidth || h2 != imgHeight || nouts != nOutputs) {
                this.resizeBuffers(w2, h2);
            }
            if ((vol = this.getVolume()) == null) {
                this.changeDisplay = false;
                this.changeRegion = false;
                this.repaint();
                continue;
            }
            if (this.changeDisplay) {
                this.engine.clearBuffers();
                this.changeDisplay = false;
                this.renderFinal = false;
                int nengineoutputs = this.engine.getNumOutputs();
                try {
                    this.syncCameraToEngine();
                    this.engine.initRender();
                    this.firePropertyChange("RENDER_START", null, this.engine);
                    if (this.ire) {
                        int remainingPassMask = (1 << nengineoutputs) - 1;
                        for (int layer = 0; layer < nengineoutputs; ++layer) {
                            this.mp_alg[layer] = this.engine.getMultipassAlgorithm(layer);
                        }
                        passno = 0;
                        while (true) {
                            boolean donerender = false;
                            boolean rendercancel = false;
                            for (int layer = 0; layer < nengineoutputs; ++layer) {
                                int layerBit;
                                if (nengineoutputs > 1) {
                                    this.renderer.restoreFromOutput(this.engine.getPixelBuffer(), layer);
                                }
                                if ((remainingPassMask & (layerBit = 1 << layer)) == 0) continue;
                                MultipassAlgorithm ma = this.mp_alg[layer];
                                int rempasses = ma.render(0, 0, w2, h2, layer, passno);
                                if (rempasses == 0) {
                                    remainingPassMask &= ~layerBit;
                                }
                                ma.fill(0, 0, w2, h2, layer, passno);
                                if (rempasses == -99999) {
                                    rendercancel = true;
                                    break;
                                }
                                this.sendToOutput(layer);
                                if (!this.changeDisplay && remainingPassMask != 0) continue;
                                donerender = true;
                            }
                            if (!rendercancel) {
                                if (w2 == this.getWidth() && h2 == this.getHeight()) {
                                    this.firePropertyChange("ALL_LAYERS_COMPLETE_PROPERTY", null, this.engine);
                                }
                                this.paintToScreen();
                                if (!donerender) {
                                    ++passno;
                                    continue;
                                }
                            }
                            break;
                        }
                    } else {
                        for (int layer = 0; layer < nengineoutputs; ++layer) {
                            this.engine.render(layer);
                            this.sendToOutput(layer);
                        }
                        this.paintToScreen();
                    }
                }
                catch (Exception ex1) {
                    this.handleRenderThreadException(ex1);
                }
                Object ex1 = this.ireDone;
                synchronized (ex1) {
                    this.renderFinal = true;
                    this.ireDone.notifyAll();
                }
                this.firePropertyChange("RENDER_FINISH", null, this.engine);
                continue;
            }
            this.changeRegion = false;
            try {
                Rectangle r2 = new Rectangle(this.dirtyRegion);
                IterativeRenderer irenderer = (IterativeRenderer)((Object)this.engine);
                if (this.incrementalAlg == null) {
                    this.incrementalAlg = new OnepassAlgorithm();
                    this.incrementalAlg.setT3DIRenderer(irenderer);
                }
                passno = 0;
                while (true) {
                    int rempasses = this.incrementalAlg.render(this.dirtyRegion.x, this.dirtyRegion.y, this.dirtyRegion.width, this.dirtyRegion.height, 0, passno);
                    this.incrementalAlg.fill(this.dirtyRegion.x, this.dirtyRegion.y, this.dirtyRegion.width, this.dirtyRegion.height, 0, passno);
                    this.sendToOutput(0);
                    this.paintToScreen();
                    if (rempasses <= 0) continue block15;
                    ++passno;
                }
            }
            catch (Exception ex1) {
                this.handleRenderThreadException(ex1);
            }
        }
        Object object = this.ireDone;
        synchronized (object) {
            this.renderFinal = true;
            this.ireDone.notifyAll();
        }
        XpLog.logger().fine("-- Goodbye T3DComponent thread.");
    }

    private void syncCameraToEngine() {
        this.engine.setCamera(this.requestedCamera.eyePoint, this.requestedCamera.lookPoint, this.requestedCamera.upVector);
        this.engine.setViewHeight(this.requestedCamera.viewHeight);
    }

    private void syncCameraFromEngine() {
        this.engine.getEyePoint(this.requestedCamera.eyePoint);
        this.engine.getLookPoint(this.requestedCamera.lookPoint);
        this.engine.getUp(this.requestedCamera.upVector);
        this.requestedCamera.viewHeight = this.engine.getViewHeight();
        this.engine.getLookPoint(this.renderedCamera.lookPoint);
        this.engine.getEyePoint(this.renderedCamera.eyePoint);
        this.engine.getUp(this.renderedCamera.upVector);
        this.renderedCamera.viewHeight = this.engine.getViewHeight();
    }

    protected void handleRenderThreadException(Exception ex) {
        ex.printStackTrace();
    }

    private void paintToScreen() {
        int ncombiners = this.combiners.size();
        if (ncombiners > 0 && this.combiner_buffers != null) {
            int width = this.engine.getBufferWidth();
            int height = this.engine.getBufferHeight();
            for (int i2 = 0; i2 < ncombiners; ++i2) {
                XjFragmentProgram f2 = this.combiners.get(i2);
                Object result = this.renderer.getPixelBuffer(i2);
                f2.execute(this.combiner_buffers, width, height, result);
            }
            this.renderer.refreshImage();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToOutput(int layerNo) {
        Object pbuffer = this.engine.getPixelBuffer();
        if (layerNo >= this.engine.getNumOutputs()) {
            return;
        }
        Object object = this.paintLock;
        synchronized (object) {
            this.engine.getLookPoint(this.renderedCamera.lookPoint);
            this.engine.getEyePoint(this.renderedCamera.eyePoint);
            this.engine.getUp(this.renderedCamera.upVector);
            this.renderedCamera.viewHeight = this.engine.getViewHeight();
            this.renderer.updateOverlay(this.outoverlay);
            int ncombiners = this.combiners.size();
            int nengineoutputs = this.engine.getNumOutputs();
            if (ncombiners > 0) {
                if (this.combiner_buffers == null || this.combiner_buffers.length != nengineoutputs) {
                    this.combiner_buffers = new Object[nengineoutputs];
                }
                int width = this.engine.getBufferWidth();
                int height = this.engine.getBufferHeight();
                int bufflen = width * height;
                Object cmb_buff = this.combiner_buffers[layerNo];
                if (pbuffer instanceof int[]) {
                    int[] ibuffer = (int[])pbuffer;
                    if (!(cmb_buff instanceof int[]) || ((int[])cmb_buff).length != ibuffer.length) {
                        cmb_buff = new int[bufflen];
                    }
                    System.arraycopy(ibuffer, 0, cmb_buff, 0, bufflen);
                } else {
                    short[] sbuffer = (short[])pbuffer;
                    if (!(cmb_buff instanceof short[]) || ((short[])cmb_buff).length != sbuffer.length) {
                        cmb_buff = new short[bufflen];
                    }
                    System.arraycopy(sbuffer, 0, cmb_buff, 0, bufflen);
                }
                this.combiner_buffers[layerNo] = cmb_buff;
            } else {
                this.combiner_buffers = null;
                this.renderer.sendToOutput(this.engine, pbuffer, layerNo);
                if (pbuffer instanceof short[] && layerNo == nengineoutputs - 1) {
                    this.setDirtyT3D();
                }
            }
        }
    }

    public void render() {
        this.refresh();
        this.waitForIRE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIRE() {
        Object object = this.ireDone;
        synchronized (object) {
            while (!this.renderFinal) {
                try {
                    this.ireDone.wait();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public int getNumOutputLayers() {
        int ncombiners = this.combiners.size();
        if (ncombiners > 0) {
            return ncombiners;
        }
        return this.engine.getNumOutputs();
    }

    public boolean isRenderFinal() {
        return !this.changeDisplay && this.renderFinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplay() {
        if (this.isShowing() || this.forceRender) {
            Object object = this.lock;
            synchronized (object) {
                this.changeDisplay = true;
                this.lock.notify();
            }
        } else {
            this.doRefreshOnVisible = true;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.doRefreshOnVisible && visible) {
            this.doRefreshOnVisible = false;
            this.refresh();
        }
    }

    public void shutdown() {
        this.keeprunning = false;
        this.engine.removePropertyChangeListener(this);
        this.engine.removeChangeListener(this);
        this.forceRender = true;
        this.updateDisplay();
        this.engine.shutdown();
        this.engine = null;
    }

    private void startRenderThread() {
        Thread rt = new Thread(){

            @Override
            public void run() {
                T3DComponent.this.renderThread();
            }
        };
        rt.setName("T3DComponent[" + this.t3dcomponent_id + "]_RenderThread");
        rt.setDaemon(true);
        rt.start();
        this.refresh();
    }

    @Override
    public Capable getCapable(String capableIFName) {
        Capable c2 = super.getCapable(capableIFName);
        if (c2 == null) {
            try {
                Class<?> cl = Class.forName(capableIFName);
                if (cl.isInstance(this)) {
                    c2 = this;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c2 == null) {
                c2 = this.engine.getCapable(capableIFName);
            }
        }
        return c2;
    }

    public BufferedImage getDisplayBuffer() {
        return this.renderer.getDisplayBuffer();
    }

    protected void updateSlice() {
        int owidth = this.getWidth();
        int oheight = this.getHeight();
        if (this.getFrame() == null && owidth > 0 && oheight > 0) {
            this.resizeBuffers(owidth, oheight);
        }
        XpImage frame = this.getFrame();
        XpSlice slice = frame.getSlice();
        double winWidth = owidth;
        double winHeight = oheight;
        double viewHeight = this.getRenderedViewHeight();
        double aratio = winWidth / winHeight;
        double viewWidth = viewHeight * aratio;
        int w2 = slice.width;
        int h2 = slice.height;
        double spx = viewWidth / (double)w2;
        double spy = viewHeight / (double)h2;
        double[] lookPoint = this.getRenderedLookPoint(null);
        double[] eyePoint = this.getRenderedEyePoint(null);
        double[] upVector = this.getRenderedUp(null);
        JnVector3d temp_v = new JnVector3d();
        JnVector3d u2 = new JnVector3d(upVector);
        JnVector3d v2 = new JnVector3d(lookPoint);
        temp_v.set(eyePoint);
        v2.sub(temp_v);
        JnVector3d.cross(v2, u2, temp_v);
        JnVector3d r2 = temp_v;
        r2.normalize();
        u2.normalize();
        this.ul.x = lookPoint[0] - (double)(w2 - 1) * 0.5 * r2.x * spx + (double)(h2 - 1) * 0.5 * u2.x * spy;
        this.ul.y = lookPoint[1] - (double)(w2 - 1) * 0.5 * r2.y * spx + (double)(h2 - 1) * 0.5 * u2.y * spy;
        this.ul.z = lookPoint[2] - (double)(w2 - 1) * 0.5 * r2.z * spx + (double)(h2 - 1) * 0.5 * u2.z * spy;
        this.ur.x = lookPoint[0] + (double)(w2 - 1) * 0.5 * r2.x * spx + (double)(h2 - 1) * 0.5 * u2.x * spy;
        this.ur.y = lookPoint[1] + (double)(w2 - 1) * 0.5 * r2.y * spx + (double)(h2 - 1) * 0.5 * u2.y * spy;
        this.ur.z = lookPoint[2] + (double)(w2 - 1) * 0.5 * r2.z * spx + (double)(h2 - 1) * 0.5 * u2.z * spy;
        this.br.x = lookPoint[0] + (double)(w2 - 1) * 0.5 * r2.x * spx - (double)(h2 - 1) * 0.5 * u2.x * spy;
        this.br.y = lookPoint[1] + (double)(w2 - 1) * 0.5 * r2.y * spx - (double)(h2 - 1) * 0.5 * u2.y * spy;
        this.br.z = lookPoint[2] + (double)(w2 - 1) * 0.5 * r2.z * spx - (double)(h2 - 1) * 0.5 * u2.z * spy;
        this.renderer.setSlice(this.ul, this.ur, this.br, spx, spy);
    }

    public int addFragmentProgram(XjFragmentProgram fp) {
        this.combiners.add(fp);
        return this.combiners.size();
    }

    public int removeFragmentProgram(XjFragmentProgram fp) {
        this.combiners.remove(fp);
        return this.combiners.size();
    }

    public int getNumFragmentPrograms() {
        return this.combiners.size();
    }

    public T3DRenderEngine getT3DRenderEngine() {
        return this.engine;
    }

    @Override
    public String[] getSupportedRenderStyles() {
        return this.engine.getSupportedRenderStyles();
    }

    public XjVolumeInfo getVolume() {
        return this.engine.getVolume();
    }

    public XjVolumeModel getVolumeModel() {
        return this.engine.getVolumeModel();
    }

    public void setVolumeModel(XjVolumeModel vm) {
        this.t3dReady = false;
        this.isVolumeLoaded = false;
        this.engine.setVolumeModel(vm);
        this.syncCameraFromEngine();
        this.isVolumeLoaded = true;
        this.initRenderer(this.getVolume());
        this.t3dReady = true;
    }

    public void setProperty(String propName, Object value) {
        this.engine.setProperty(propName, value);
        if (propName.equals(VOLUME_DOWNSAMPLEXY)) {
            this.volDownSampleXY = (Integer)value;
        } else if (propName.equals(VOLUME_DOWNSAMPLEZ)) {
            this.volDownSampleZ = (Integer)value;
        }
    }

    public Object getProperty(String propName) {
        return this.engine.getProperty(propName);
    }

    @Override
    public void setRenderStyle(String style) {
        String old_rstyle = this.getRenderStyle();
        this.engine.setRenderStyle(style);
        if (old_rstyle.equals("FUSED_REFORMAT")) {
            this.setSegmentationVisible(false);
        }
        if (style.equals("FUSED_REFORMAT")) {
            this.setSegmentationVisible(true);
        }
    }

    protected final void set2DInterpolation(Object rhint) {
        this.renderer.setInterpolationHint(rhint);
    }

    @Override
    public String getRenderStyle() {
        return this.engine.getRenderStyle();
    }

    public void setDownSampleFactorXY(int ds_factor) {
        this.volDownSampleXY = ds_factor;
    }

    public int getDownSampleFactorXY() {
        return this.volDownSampleXY;
    }

    public void setDownSampleFactorZ(int ds_factor) {
        this.volDownSampleZ = ds_factor;
    }

    public int getDownSampleFactorZ() {
        return this.volDownSampleZ;
    }

    protected final void setT3DReady(boolean ready) {
        this.t3dReady = ready;
    }

    public final boolean isT3DReady() {
        return this.t3dReady;
    }

    public void refresh() {
        if (!this.isT3DReady()) {
            return;
        }
        this.updateDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRegion(JnRectangle r2) {
        if (!this.isT3DReady()) {
            return;
        }
        if (this.isShowing()) {
            Rectangle output = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            int x2 = r2.x + r2.width - 1;
            int y2 = r2.y + r2.height - 1;
            if (output.contains(r2.x, r2.y) || output.contains(x2, y2)) {
                this.dirtyRegion.setBounds(r2.x, r2.y, r2.width, r2.height);
                if (r2.x < 0) {
                    this.dirtyRegion.x = 0;
                    this.dirtyRegion.width = r2.width + r2.x;
                }
                if (r2.y < 0) {
                    this.dirtyRegion.y = 0;
                    this.dirtyRegion.height = r2.height + r2.y;
                }
                Object object = this.lock;
                synchronized (object) {
                    this.changeRegion = true;
                    this.lock.notify();
                }
            }
        } else {
            this.doRefreshOnVisible = true;
        }
    }

    public void setVolume(XjVolumeInfo volume) {
        XjVolumeInfo volToLoad = volume;
        if (volume instanceof XjVolume && (this.volDownSampleXY > 1 || this.volDownSampleZ > 1)) {
            volToLoad = new ReducedVolume((XjVolume)volume, this.volDownSampleXY, this.volDownSampleZ);
        }
        this.loadVolume(volToLoad);
    }

    private void loadVolume(XjVolumeInfo volume) {
        this.t3dReady = false;
        this.isVolumeLoaded = false;
        this.engine.setVolume(volume);
        this.syncCameraFromEngine();
        this.isVolumeLoaded = true;
        this.setDirtyT3D();
        this.initRenderer(volume);
        this.t3dReady = true;
    }

    private void initRenderer(XjVolumeInfo volume) {
        if (volume != null) {
            XpImageRenderAttributes ira;
            String modality = "" + volume.getValue(8, 96);
            double rescaleSlope = XjVolumeUtils.calcVolumeRescaleSlope(volume);
            double rescaleIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(volume);
            if (modality.equals("PT")) {
                ira = this.renderer.getImageRenderAttributes();
                ira.setVideoInverted(true);
                double min = 0.0;
                double max = 32767.0 * rescaleSlope * 0.4;
                double ww = max - min;
                double wl = (max + min) * 0.5;
                ira.setWindowing(ww, wl);
                this.renderer.setImageRenderAttributes(ira);
            } else {
                ira = this.renderer.getImageRenderAttributes();
                double ww = XjVolumeUtils.calcVolumeDefWW(volume);
                double wl = XjVolumeUtils.calcVolumeDefWL(volume);
                ira.setWindowing(ww, wl);
                ira.setVideoInverted(false);
                this.renderer.setImageRenderAttributes(ira);
            }
            int nouts = this.renderer.getNumOutputs();
            if (nouts > 0) {
                for (int i2 = 0; i2 < nouts; ++i2) {
                    XjVolumeModel vm = this.engine.getVolumeModel(i2);
                    if (vm == null) continue;
                    double layerSlope = XjVolumeUtils.calcVolumeRescaleSlope(vm.getVolume());
                    double layerIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(vm.getVolume());
                    this.renderer.setRescaleLayer(layerSlope, layerIntercept, i2);
                }
                this.refresh();
            }
            this.renderStyleSwitch = true;
        }
        this.syncCameraFromEngine();
        if (this.isVisible()) {
            this.setDirtyT3D();
            this.renderer.clearOutputBuffers();
            this.refresh();
        }
    }

    protected final XpImage2DRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes ira) {
        this.renderer.setImageRenderAttributes(ira);
    }

    @Override
    public XpImageRenderAttributes getImageRenderAttributes() {
        if (this.renderer != null) {
            return this.renderer.getImageRenderAttributes();
        }
        return null;
    }

    public void setDirtyT3D() {
        this.dirtyT3D = true;
    }

    public boolean isDirtyT3D() {
        return this.dirtyT3D;
    }

    @Override
    public XpImage getFrame() {
        return this.getMedicalImage();
    }

    public XpMedicalImage getMedicalImage() {
        XpMedicalImage img = this.renderer.getMedicalImage(0);
        return img;
    }

    @Override
    public boolean contains(int x2, int y2) {
        return true;
    }

    private void updateTransforms() {
        JnVector3d r2 = new JnVector3d();
        JnVector3d u2 = new JnVector3d();
        JnVector3d v2 = new JnVector3d();
        JnVector3d xdir = new JnVector3d();
        JnVector3d ydir = new JnVector3d();
        JnVector3d zdir = new JnVector3d();
        XjVolumeInfo vinfo = this.getVolume();
        if (vinfo == null) {
            return;
        }
        double[] dir_x = vinfo.getXDirectionRAS(null);
        double[] dir_y = vinfo.getYDirectionRAS(null);
        double[] dir_z = vinfo.getZDirectionRAS(null);
        double ras_spx = JnVector3d.length(dir_x);
        double ras_spy = JnVector3d.length(dir_y);
        double ras_spz = JnVector3d.length(dir_z);
        this.engine.getTransform(1001, 1000, this._ras2vox.m);
        this._ras2vox.inverse(this._vox2ras);
        double[] look = this.getRenderedLookPoint(null);
        double[] eye = this.getRenderedEyePoint(null);
        double[] up = this.getRenderedUp(null);
        GeomUtils.calcDirectionVectors(look, eye, up, r2, u2, v2);
        double viewHeight = this.getRenderedViewHeight();
        int winWidth = this.engine.getBufferWidth();
        int winHeight = this.engine.getBufferHeight();
        if (winWidth <= 0) {
            winWidth = this.getWidth();
        }
        if (winHeight <= 0) {
            winHeight = this.getHeight();
        }
        double aratio = (double)winWidth / (double)winHeight;
        double viewWidth = viewHeight * aratio;
        double view_spx = viewWidth / (double)winWidth;
        double view_spy = viewHeight / (double)winHeight;
        double view_spz = XjVolumeUtils.getViewStepSize(this._ras2vox, v2, ras_spx, ras_spy, ras_spz);
        xdir.set(r2.x * view_spx, r2.y * view_spx, r2.z * view_spx);
        ydir.set(u2.x * view_spy, u2.y * view_spy, u2.z * view_spy);
        zdir.set(v2.x * view_spz, v2.y * view_spz, v2.z * view_spz);
        this._disp2ras.set(xdir.x, ydir.x, zdir.x, look[0] - xdir.x * (double)winWidth * 0.5 - ydir.x * (double)winHeight * 0.5, xdir.y, ydir.y, zdir.y, look[1] - xdir.y * (double)winWidth * 0.5 - ydir.y * (double)winHeight * 0.5, xdir.z, ydir.z, zdir.z, look[2] - xdir.z * (double)winWidth * 0.5 - ydir.z * (double)winHeight * 0.5, 0.0, 0.0, 0.0, 1.0);
        this._disp2ras.inverse(this._ras2disp);
        CTransform rmat = this._vox2ras.multiplyBy(this._ras2disp);
        System.arraycopy(rmat.m, 0, this._vox2disp.m, 0, 16);
        this._vox2disp.inverse(this._disp2vox);
    }

    @Override
    public final CTransform getTransform(byte in, byte out) {
        if (in == out) {
            return CTransform.Identity;
        }
        if (in == 0) {
            in = (byte)5;
        }
        if (out == 0) {
            out = (byte)5;
        }
        boolean lps2ras = false;
        boolean ras2lps = false;
        XpMedicalImage medimg = this.renderer.getMedicalImage(0);
        if (medimg == null) {
            return super.getTransform(in, out);
        }
        CTransform t2 = new CTransform();
        if (in == 4) {
            in = (byte)2;
            lps2ras = true;
        }
        if (out == 4) {
            out = (byte)2;
            ras2lps = true;
        }
        block0 : switch (in) {
            case 2: {
                switch (out) {
                    case 2: {
                        System.arraycopy(CTransform.Identity.m, 0, t2.m, 0, 16);
                        break;
                    }
                    case 1: {
                        System.arraycopy(this._ras2disp.m, 0, t2.m, 0, 16);
                        break;
                    }
                    case 5: {
                        System.arraycopy(this._ras2vox.m, 0, t2.m, 0, 16);
                    }
                }
                break;
            }
            case 1: {
                switch (out) {
                    case 2: {
                        System.arraycopy(this._disp2ras.m, 0, t2.m, 0, 16);
                        break;
                    }
                    case 1: {
                        System.arraycopy(CTransform.Identity.m, 0, t2.m, 0, 16);
                        break;
                    }
                    case 5: {
                        System.arraycopy(this._disp2vox.m, 0, t2.m, 0, 16);
                    }
                }
                break;
            }
            case 5: {
                switch (out) {
                    case 2: {
                        System.arraycopy(this._vox2ras.m, 0, t2.m, 0, 16);
                        break block0;
                    }
                    case 1: {
                        System.arraycopy(this._vox2disp.m, 0, t2.m, 0, 16);
                        break block0;
                    }
                    case 5: {
                        System.arraycopy(CTransform.Identity.m, 0, t2.m, 0, 16);
                    }
                }
            }
        }
        if (lps2ras) {
            CTransform lps2ras_tx = this.getRAS2LPS().inverse();
            t2 = lps2ras_tx.multiplyBy(t2);
        }
        if (ras2lps) {
            t2 = t2.multiplyBy(this.getRAS2LPS());
        }
        return t2;
    }

    protected void resizeBuffers(int width, int height) {
        int len = width * height;
        int noutputs = this.getNumOutputLayers();
        if (this.renderer.updateSize(this.engine, noutputs, width, height, !this.isShowing()) || this.rgb_image == null) {
            this.outoverlay = new short[len];
            this.rgb_image = new int[len];
            this.lum_image = new short[len];
        }
        this.engine.setOutput(this.rgb_image, this.lum_image, width, height);
        this.engine.setOverlay(this.outoverlay);
        this.setDirtyT3D();
    }

    public void setOverlayColorMap(int[] cmap) {
        this.renderer.setOverlayColorMap(cmap);
        this.setDirtyT3D();
    }

    public void setOverlayFilter(XpOverlayFilter filter) {
        if (this.renderer.updateOverlayFilter(filter)) {
            this.setDirtyT3D();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g2) {
        if (!this.t3dReady) {
            return;
        }
        if (this.getVolume() == null) {
            return;
        }
        this.updateTransforms();
        this.updateSlice();
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        if (this.startIRE) {
            this.startIRE = false;
            this.startRenderThread();
        }
        int imgWidth = this.renderer.getOutputWidth();
        int imgHeight = this.renderer.getOutputHeight();
        if (imgWidth != w2 || imgHeight != h2) {
            this.refresh();
            return;
        }
        boolean segVisible = this.isSegmentationVisible();
        if (this.dirtyT3D) {
            if (this.renderStyleSwitch) {
                Object pbuffer = this.engine.getPixelBuffer();
                if (pbuffer instanceof int[]) {
                    this.renderer.setMode(1);
                } else {
                    this.renderer.setMode(11);
                }
                this.renderStyleSwitch = false;
            }
            if (segVisible) {
                this.renderer.syncColorOverlay();
            }
            this.renderer.refreshImage();
            this.dirtyT3D = false;
        } else if (segVisible && this.renderer.getOverlayFilter() != null) {
            this.renderer.refreshImage();
        }
        Object object = this.paintLock;
        synchronized (object) {
            this.renderer.paint(g2, this);
        }
    }

    @Override
    public Component add(Component comp) {
        Component retcomp = super.add(comp);
        XpAppContext.instance().getSelectionManager().addComponent(comp);
        if (comp instanceof XpImageRoiVc) {
            XpImageRoiVc rvc = (XpImageRoiVc)comp;
            ++this.roiVcCnt;
            rvc.setRoiNumber(this.roiVcCnt);
        }
        return retcomp;
    }

    private static double diffvec(double[] v1, double[] v2) {
        return Math.abs(v1[0] - v2[0]) + Math.abs(v1[1] - v2[1]) + Math.abs(v1[2] - v2[2]);
    }

    @Override
    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.engine.getWorldBounds(ulc, xside, yside, zside);
    }

    @Override
    public void setLookPoint(double[] point) {
        double diffLook = T3DComponent.diffvec(point, this.requestedCamera.lookPoint);
        boolean cameraChanged = false;
        if (diffLook > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(point, 0, this.requestedCamera.lookPoint, 0, 3);
        }
        if (cameraChanged) {
            this.setDirtyT3D();
            this.refresh();
        }
    }

    @Override
    public double[] getLookPoint(double[] look_pt) {
        if (!this.isVolumeLoaded) {
            return this.engine.getLookPoint(look_pt);
        }
        if (look_pt == null) {
            look_pt = new double[3];
        }
        System.arraycopy(this.requestedCamera.lookPoint, 0, look_pt, 0, 3);
        return look_pt;
    }

    @Override
    public void setEyePoint(double[] point) {
        double diffEye = T3DComponent.diffvec(point, this.requestedCamera.eyePoint);
        boolean cameraChanged = false;
        if (diffEye > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(point, 0, this.requestedCamera.eyePoint, 0, 3);
        }
        if (cameraChanged) {
            this.setDirtyT3D();
            this.refresh();
        }
    }

    @Override
    public double[] getEyePoint(double[] eye_pt) {
        if (!this.isVolumeLoaded) {
            this.engine.getEyePoint(eye_pt);
        }
        if (eye_pt == null) {
            eye_pt = new double[3];
        }
        System.arraycopy(this.requestedCamera.eyePoint, 0, eye_pt, 0, 3);
        return eye_pt;
    }

    @Override
    public void setUp(double[] vec) {
        double diffUp = T3DComponent.diffvec(vec, this.requestedCamera.upVector);
        boolean cameraChanged = false;
        if (diffUp > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(vec, 0, this.requestedCamera.upVector, 0, 3);
        }
        if (cameraChanged) {
            this.setDirtyT3D();
            this.refresh();
        }
    }

    @Override
    public double[] getUp(double[] up_v) {
        if (!this.isVolumeLoaded) {
            return this.engine.getUp(up_v);
        }
        if (up_v == null) {
            up_v = new double[3];
        }
        System.arraycopy(this.requestedCamera.upVector, 0, up_v, 0, 3);
        return up_v;
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        double diffEye = T3DComponent.diffvec(eyepoint, this.requestedCamera.eyePoint);
        double diffLook = T3DComponent.diffvec(lookpoint, this.requestedCamera.lookPoint);
        double diffUp = T3DComponent.diffvec(up, this.requestedCamera.upVector);
        boolean cameraChanged = false;
        if (diffEye > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(eyepoint, 0, this.requestedCamera.eyePoint, 0, 3);
        }
        if (diffLook > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(lookpoint, 0, this.requestedCamera.lookPoint, 0, 3);
        }
        if (diffUp > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(up, 0, this.requestedCamera.upVector, 0, 3);
        }
        if (cameraChanged) {
            this.setDirtyT3D();
            this.refresh();
        }
    }

    @Override
    public void setViewHeight(double height) {
        boolean doUpdate = false;
        if (height != this.getViewHeight()) {
            this.requestedCamera.viewHeight = height;
            doUpdate = true;
        }
        if (doUpdate) {
            this.setDirtyT3D();
            this.refresh();
        }
    }

    @Override
    public double getViewHeight() {
        if (!this.isVolumeLoaded) {
            return this.engine.getViewHeight();
        }
        return this.engine.getViewHeight();
    }

    @Override
    public void setAspectRatio(double aspect) {
        this.engine.setAspectRatio(aspect);
    }

    @Override
    public double getAspectRatio() {
        return this.engine.getAspectRatio();
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        this.engine.setViewClip(clipOffsets);
    }

    @Override
    public double[] getViewClip(double[] view_clip) {
        return this.engine.getViewClip(view_clip);
    }

    @Override
    public void setPerspective(boolean b2) {
        this.engine.setPerspective(b2);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isPerspective() {
        return this.engine.isPerspective();
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.engine.addTaskMonitor(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.engine.removeTaskMonitor(tm);
    }

    public void dispose() {
        this.shutdown();
        this.waitForIRE();
        this.renderer = null;
    }

    public double[] getInitialUp() {
        return this.engine.getInitialUp();
    }

    public void setInitialUp(double[] initialUp) {
        this.engine.setInitialUp(initialUp);
    }

    public double[] getInitialView() {
        return this.engine.getInitialView();
    }

    public void setInitialView(double[] initialView) {
        this.engine.setInitialView(initialView);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (source instanceof T3DRenderEngine) {
            boolean doUpdate = false;
            if (propertyName.equalsIgnoreCase("perspective") || propertyName.equalsIgnoreCase("viewClip")) {
                doUpdate = true;
            } else if (propertyName.equalsIgnoreCase("renderStyle")) {
                doUpdate = true;
                this.renderStyleSwitch = true;
            } else if (propertyName.equalsIgnoreCase("OUTPUTBUFFER_PROPERTY")) {
                JnRectangle r2 = (JnRectangle)newValue;
                this.refreshRegion(r2);
            }
            if (doUpdate && !this.ignoreRenderEngineEvents) {
                this.setDirtyT3D();
                this.refresh();
            }
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void stateChanged(EventObject e2) {
        boolean refresh = true;
        if (e2.getSource() instanceof T3DRenderEngine && this.ignoreRenderEngineEvents) {
            refresh = false;
        }
        if (refresh) {
            this.refresh();
        }
    }

    public boolean isIre() {
        return this.ire;
    }

    public synchronized void setIre(boolean ire) {
        this.ire = ire;
    }

    @Override
    public void setSegmentationVisible(boolean segVisible) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        sc.setSegmentationVisible(segVisible);
        this.sync_overlay();
        this.refresh();
    }

    private void sync_overlay() {
        if (this.isSegmentationVisible()) {
            this.setOverlayColorMap(this.getSegmentationColorMap());
        } else {
            this.setOverlayColorMap(null);
        }
    }

    @Override
    public boolean isSegmentationVisible() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc != null) {
            ret = sc.isSegmentationVisible();
        }
        return ret;
    }

    @Override
    public void setSegmentationColorMap(int[] cmap) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        sc.setSegmentationColorMap(cmap);
        this.sync_overlay();
    }

    @Override
    public int[] getSegmentationColorMap() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        int[] ret = null;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.getSegmentationColorMap();
        return ret;
    }

    @Override
    public boolean applySegmentation(short[] labels, int offset) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.applySegmentation(labels, offset);
        this.refresh();
        return ret;
    }

    @Override
    public boolean applySegmentation(byte[] bgrid) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.applySegmentation(bgrid);
        this.refresh();
        return ret;
    }

    @Override
    public boolean intersect(byte[] bgrid) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.intersect(bgrid);
        this.refresh();
        return ret;
    }

    @Override
    public boolean union(byte[] bgrid) {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.union(bgrid);
        this.refresh();
        return ret;
    }

    @Override
    public boolean negation() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        boolean ret = false;
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        ret = sc.negation();
        this.refresh();
        return ret;
    }

    @Override
    public void clearSegmentation() {
        SegmentationCapable sc = (SegmentationCapable)((Object)this.engine.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (sc == null) {
            throw new UnsupportedOperationException("SegmentationCapable:: not supported");
        }
        sc.clearSegmentation();
        this.refresh();
    }

    @Override
    public int addVolumeLayer(XjVolumeInfo volInfo) {
        int nlayer = this.engine.addVolume(volInfo);
        this.renderer.clearIPA(nlayer);
        double rescaleSlope = XjVolumeUtils.calcVolumeRescaleSlope(volInfo);
        double rescaleIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(volInfo);
        this.renderer.setRescaleLayer(rescaleSlope, rescaleIntercept, nlayer);
        return nlayer;
    }

    @Override
    public int addVolumeLayer(XjVolumeModel volModel) {
        int nlayer = this.engine.addVolumeModel(volModel);
        this.renderer.clearIPA(nlayer);
        XjVolumeInfo volInfo = volModel.getVolume();
        double rescaleSlope = XjVolumeUtils.calcVolumeRescaleSlope(volInfo);
        double rescaleIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(volInfo);
        this.renderer.setRescaleLayer(rescaleSlope, rescaleIntercept, nlayer);
        return nlayer;
    }

    @Override
    public void setVolumeLayer(XjVolumeInfo volInfo, int layer) {
        if (layer == 0) {
            this.isVolumeLoaded = false;
        }
        this.engine.setVolume(volInfo, layer);
        if (layer == 0) {
            this.syncCameraFromEngine();
            this.isVolumeLoaded = true;
        }
        this.renderer.clearIPA(layer);
        double rescaleSlope = XjVolumeUtils.calcVolumeRescaleSlope(volInfo);
        double rescaleIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(volInfo);
        this.renderer.setRescaleLayer(rescaleSlope, rescaleIntercept, layer);
    }

    @Override
    public void setVolumeLayer(XjVolumeModel volModel, int layer) {
        if (layer == 0) {
            this.isVolumeLoaded = false;
        }
        this.engine.setVolumeModel(volModel, layer);
        if (layer == 0) {
            this.syncCameraFromEngine();
            this.isVolumeLoaded = true;
        }
        this.renderer.clearIPA(layer);
        XjVolumeInfo volInfo = volModel.getVolume();
        double rescaleSlope = XjVolumeUtils.calcVolumeRescaleSlope(volInfo);
        double rescaleIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(volInfo);
        this.renderer.setRescaleLayer(rescaleSlope, rescaleIntercept, layer);
    }

    @Override
    public XjVolumeInfo getVolume(int layerNo) {
        XjVolumeModel vm = this.engine.getVolumeModel(layerNo);
        if (vm != null) {
            return vm.getVolume();
        }
        return null;
    }

    @Override
    public XjVolumeModel getVolumeModel(int layerNo) {
        XjVolumeModel vm = this.engine.getVolumeModel(layerNo);
        return vm;
    }

    @Override
    public int removeVolumeLayer(int layer) {
        this.renderer.clearIPA(layer);
        return this.engine.removeVolumeModel(layer);
    }

    @Override
    public void selectVolumeLayer(int layer) {
        int oldVal = this.renderer.getImageLayer();
        this.renderer.selectImageLayer(layer);
        this.firePropertyChange("VOLUME_LAYER_PROPERTY", oldVal, this.renderer.getImageLayer());
    }

    @Override
    public int getVolumeLayer() {
        return this.renderer.getImageLayer();
    }

    @Override
    public int getNumVolumeLayers() {
        return this.engine.getNumVolumes();
    }

    @Override
    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        this.renderer.setPixelCombiner(fpc);
    }

    @Override
    public XjFusionPixelCombiner getPixelCombiner() {
        return this.renderer.getPixelCombiner();
    }

    public void setColorMap(int layer, int[] cMap) {
        if (layer == 0) {
            XpViewport.JamiIndexColorModel colorModel = null;
            if (cMap != null) {
                colorModel = new XpViewport.JamiIndexColorModel(cMap);
            }
            this._actColorMap = cMap;
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            kir.setColormap(colorModel);
            this.setImageRenderAttributes(kir);
            this.renderer.refreshImage();
        } else {
            this.setImageLayerColorMap(layer, cMap);
        }
        this.firePropertyChange("COLOR_MAP", null, cMap);
    }

    @Override
    public void setColorMap(int[] cMap) {
        int layer = this.renderer.getImageLayer();
        this.setColorMap(layer, cMap);
    }

    @Override
    public int[] getColorMap() {
        int layer = this.renderer.getImageLayer();
        List l2 = this.renderer.getImageLayers();
        if (layer == 0 || l2 == null) {
            return this._actColorMap;
        }
        XpImageLayer il = (XpImageLayer)l2.get(layer - 1);
        return il.getColorMapTable();
    }

    protected void setImageLayerColorMap(int layer, int[] cmap) {
        this.renderer.setColorMap(layer, cmap);
    }

    protected void setImageLayerWindowing(int layer, double ww, double wl) {
        this.renderer.setWindowing(layer, ww, wl);
    }

    protected void setImageLayerVideoInverted(int layer, boolean ivvideo) {
        this.renderer.setInverseVideo(layer, ivvideo);
    }

    protected void resetImageLayerWindowing(int layer) {
        this.renderer.resetWindowing(layer);
    }

    public synchronized void setWindowing(int layer, double width, double level) {
        if (width < 0.0) {
            return;
        }
        double hw = width * 0.5;
        double min = level - hw;
        double max = level + hw;
        if (min < this.winLowerLimit) {
            min = this.winLowerLimit;
        } else if (min > this.winUpperLimit) {
            min = this.winUpperLimit;
        }
        if (max > this.winUpperLimit) {
            max = this.winUpperLimit;
        } else if (max < this.winLowerLimit) {
            max = this.winLowerLimit;
        }
        width = max - min;
        level = (max + min) * 0.5;
        double oldMin = 0.0;
        double oldMax = 0.0;
        if (layer == 0) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            oldMin = ira.getWindowMin();
            oldMax = ira.getWindowMax();
            ira.setWindowing(width, level);
            this.setImageRenderAttributes(ira);
        } else {
            oldMin = this.getWinMin();
            oldMax = this.getWinMax();
            this.setImageLayerWindowing(layer, width, level);
        }
        if (min != oldMin) {
            this.firePropertyChange("winMin", oldMin, min);
        }
        if (max != oldMax) {
            this.firePropertyChange("winMax", oldMax, max);
        }
    }

    public synchronized void setWindowing(double width, double level) {
        int layer = this.renderer.getImageLayer();
        this.setWindowing(layer, width, level);
    }

    @Override
    public void setWinMinMax(double min, double max) {
        double ww = max - min;
        double wl = (max + min) * 0.5;
        this.setWindowing(ww, wl);
    }

    @Override
    public double getWinMin() {
        int layer = this.renderer.getImageLayer();
        List l2 = this.renderer.getImageLayers();
        if (layer == 0) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            return kir.getWindowMin();
        }
        if (l2 == null) {
            XpImagePixelAttributes ipa = this.renderer.getIPA(layer);
            return ipa.getWindowMin();
        }
        XpImageLayer il = (XpImageLayer)l2.get(layer - 1);
        return il.getWindowMin();
    }

    @Override
    public final void setWinMin(double min) {
        double winMax = this.getWinMax();
        this.setWinMinMax(min, winMax);
    }

    @Override
    public double getWinMax() {
        int layer = this.renderer.getImageLayer();
        List l2 = this.renderer.getImageLayers();
        if (layer == 0) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            return kir.getWindowMax();
        }
        if (l2 == null) {
            XpImagePixelAttributes ipa = this.renderer.getIPA(layer);
            return ipa.getWindowMax();
        }
        XpImageLayer il = (XpImageLayer)l2.get(layer - 1);
        return il.getWindowMax();
    }

    @Override
    public final void setWinMax(double max) {
        double winMin = this.getWinMin();
        this.setWinMinMax(winMin, max);
    }

    @Override
    public void resetWindowing() {
        int layer = this.renderer.getImageLayer();
        boolean arp = this.isAutoRepaint();
        if (layer == 0) {
            this.setAutoRepaint(false);
            XpImage img = this.getFrame();
            if (img != null) {
                double ww = img.getDefaultWindowWidth();
                double wl = img.getDefaultWindowLevel();
                double min = wl - ww / 2.0;
                double max = wl + ww / 2.0;
                this.setWinMinMax(min, max);
                this.setVideoInverted(false);
            }
        } else {
            this.resetImageLayerWindowing(layer);
        }
        this.setAutoRepaint(arp);
    }

    @Override
    public final void setWinUpperLimit(double wuLimit) {
        if (wuLimit >= this.winLowerLimit) {
            this.winUpperLimit = wuLimit;
            double max = this.getWinMax();
            if (max > this.winUpperLimit) {
                this.setWinMax(this.winUpperLimit);
            }
        }
    }

    @Override
    public final double getWinUpperLimit() {
        return this.winUpperLimit;
    }

    @Override
    public final void setWinLowerLimit(double wlLimit) {
        if (wlLimit <= this.winUpperLimit) {
            this.winLowerLimit = wlLimit;
            double min = this.getWinMin();
            if (min < this.winLowerLimit) {
                this.setWinMin(this.winLowerLimit);
            }
        }
    }

    @Override
    public final double getWinLowerLimit() {
        return this.winLowerLimit;
    }

    public void setVideoInverted(int layer, boolean inverted) {
        boolean old_ivvideo = this.isVideoInverted();
        if (old_ivvideo != inverted) {
            if (layer == 0) {
                XpImageRenderAttributes kir = this.getImageRenderAttributes();
                kir.setVideoInverted(inverted);
                this.setImageRenderAttributes(kir);
            } else {
                this.setImageLayerVideoInverted(layer, inverted);
            }
            this.firePropertyChange("videoInverted", old_ivvideo, inverted);
        }
    }

    @Override
    public void setVideoInverted(boolean inverted) {
        int layer = this.renderer.getImageLayer();
        this.setVideoInverted(layer, inverted);
    }

    @Override
    public boolean isVideoInverted() {
        int layer = this.renderer.getImageLayer();
        List l2 = this.renderer.getImageLayers();
        boolean ivvideo = false;
        if (layer == 0) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            ivvideo = kir.isVideoInverted();
        } else if (l2 == null) {
            XpImagePixelAttributes ipa = this.renderer.getIPA(layer);
            ivvideo = ipa.isVideoInverted();
        } else {
            XpImageLayer il = (XpImageLayer)l2.get(layer - 1);
            ivvideo = il.isVideoInverted();
        }
        return ivvideo;
    }

    @Override
    public double[] getRange() {
        double[] range = new double[]{0.0, 1200.0};
        return range;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.engine.setBackground(null == bg ? -16777216 : bg.getRGB(), -16777216);
    }

    public void setIgnoreRenderEngineEvents(boolean ignore) {
        this.ignoreRenderEngineEvents = ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRenderContents() {
        this.forceRender = true;
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        if (this.startIRE) {
            this.resizeBuffers(w2, h2);
            this.startIRE = false;
            this.startRenderThread();
        }
        final Object lockRender = new Object();
        PropertyChangeListener finishRender = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object object = lockRender;
                synchronized (object) {
                    lockRender.notifyAll();
                }
            }
        };
        this.addPropertyChangeListener("RENDER_FINISH", finishRender);
        Object object = lockRender;
        synchronized (object) {
            this.updateDisplay();
            try {
                lockRender.wait();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        this.removePropertyChangeListener("RENDER_FINISH", finishRender);
        this.forceRender = false;
    }

    private static class CameraState {
        public double[] lookPoint = new double[3];
        public double[] eyePoint = new double[3];
        public double[] upVector = new double[3];
        public double viewHeight = 1.0;

        private CameraState() {
        }

        public void set(double[] lookPt, double[] eyePt, double[] up, double view_height) {
            this.viewHeight = view_height;
            System.arraycopy(lookPt, 0, this.lookPoint, 0, 3);
            System.arraycopy(eyePt, 0, this.eyePoint, 0, 3);
            System.arraycopy(up, 0, this.upVector, 0, 3);
        }

        public void set(CameraState cs) {
            this.set(cs.lookPoint, cs.eyePoint, cs.upVector, cs.viewHeight);
        }
    }

    private static class ReducedVolume
    implements XjVolume,
    DownSampledVolume {
        private XjVolume proxy = null;
        private int volDownSampleXY = 1;
        private int volDownSampleZ = 1;
        private int[] orig_dims = new int[3];
        private int[] dims = new int[3];
        private double[] xdir = new double[3];
        private double[] ydir = new double[3];
        private double[] zdir = new double[3];

        public ReducedVolume(XjVolume proxy, int volDownSampleXY, int volDownSampleZ) {
            this.proxy = proxy;
            this.volDownSampleXY = volDownSampleXY;
            this.volDownSampleZ = volDownSampleZ;
            proxy.getVolumeDimensions(this.orig_dims);
            proxy.getXDirectionRAS(this.xdir);
            proxy.getYDirectionRAS(this.ydir);
            proxy.getZDirectionRAS(this.zdir);
            this.dims[0] = this.orig_dims[0] / volDownSampleXY;
            this.dims[1] = this.orig_dims[1] / volDownSampleXY;
            this.dims[2] = this.orig_dims[2] / volDownSampleZ;
            this.vscale(this.xdir, volDownSampleXY);
            this.vscale(this.ydir, volDownSampleXY);
            this.vscale(this.zdir, volDownSampleZ);
        }

        private void vscale(double[] v2, int s2) {
            v2[0] = v2[0] * (double)s2;
            v2[1] = v2[1] * (double)s2;
            v2[2] = v2[2] * (double)s2;
        }

        @Override
        public long getVSliceOffset(int arg0) {
            return this.proxy.getVSliceOffset(arg0);
        }

        @Override
        public String getVSlicePath(int arg0) {
            return this.proxy.getVSlicePath(arg0);
        }

        @Override
        public boolean isVolumeLittleEndian() {
            return this.proxy.isVolumeLittleEndian();
        }

        @Override
        public int getBitsPerVoxel() {
            return this.proxy.getBitsPerVoxel();
        }

        @Override
        public int getPixelType() {
            return this.proxy.getPixelType();
        }

        @Override
        public Object getVSliceValue(int arg0, int arg1, int arg2) {
            return this.proxy.getVSliceValue(arg0, arg1, arg2);
        }

        @Override
        public String getRelatedComposite() {
            return this.proxy.getRelatedComposite();
        }

        @Override
        public Object getValue(int arg0, int arg1) {
            return this.proxy.getValue(arg0, arg1);
        }

        @Override
        public int getValues(XjTagValue[] arg0) {
            return this.proxy.getValues(arg0);
        }

        @Override
        public int[] getVolumeDimensions(int[] arg0) {
            if (arg0 == null) {
                arg0 = new int[3];
            }
            System.arraycopy(this.dims, 0, arg0, 0, this.dims.length);
            return arg0;
        }

        @Override
        public double[] getRASOfOrigin(double[] arg0) {
            return this.proxy.getRASOfOrigin(arg0);
        }

        @Override
        public double[] getXDirectionRAS(double[] arg0) {
            if (arg0 == null) {
                arg0 = new double[3];
            }
            System.arraycopy(this.xdir, 0, arg0, 0, this.xdir.length);
            return arg0;
        }

        @Override
        public double[] getYDirectionRAS(double[] arg0) {
            if (arg0 == null) {
                arg0 = new double[3];
            }
            System.arraycopy(this.ydir, 0, arg0, 0, this.ydir.length);
            return arg0;
        }

        @Override
        public double[] getZDirectionRAS(double[] arg0) {
            if (arg0 == null) {
                arg0 = new double[3];
            }
            System.arraycopy(this.zdir, 0, arg0, 0, this.zdir.length);
            return arg0;
        }

        @Override
        public int getDownSampleXY() {
            return this.volDownSampleXY;
        }

        @Override
        public int getDownSampleZ() {
            return this.volDownSampleZ;
        }

        @Override
        public int[] getOriginalDimensions(int[] dims) {
            if (dims == null) {
                dims = new int[3];
            }
            System.arraycopy(this.orig_dims, 0, dims, 0, this.orig_dims.length);
            return dims;
        }
    }
}

