/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnQuaternion;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class T3DTrackball
extends MouseInputAdapter
implements XpMouseController,
PropertyChangeListener {
    private static double toPointX_;
    private static double toPointY_;
    protected JnVector3d lookPoint_ = new JnVector3d(0.0, 0.0, 0.0);
    protected JnVector3d eyePoint_ = new JnVector3d(0.0, 0.0, -1.0);
    protected JnVector3d upVector_ = new JnVector3d(0.0, 1.0, 0.0);
    private T3DCapable t3dCapable_;
    private JComponent target;
    protected MouseEvent ePrev_;
    protected double[] ulc_ = new double[3];
    protected double[] xside_ = new double[3];
    protected double[] yside_ = new double[3];
    protected double[] zside_ = new double[3];
    int prevPrevX_;
    int prevPrevY_;
    int prevX_;
    int prevY_;
    Thread spinner_;
    private boolean start_;
    private Sphere sphere_;
    private static final int THRESH = 16;
    protected double volumeSize_ = 0.0;
    private static boolean debug;
    JnQuaternion lastDelta_;
    private Cursor3DModel cursor_;
    double radius_;
    JnQuaternion prevDelta_;
    Point prePrev_;
    private boolean inertia_ = false;
    protected int prePreX;
    protected int prePreY;
    protected boolean driving_;
    static final double EPS = 1.0E-6;

    @Override
    public void mousePressed(MouseEvent event) {
        this.prevX_ = event.getX();
        this.prevY_ = event.getY();
        this.prevPrevX_ = this.prevX_;
        this.prevPrevY_ = this.prevY_;
        this.pauseSpinner();
        this.driving_ = true;
        if (this.t3dCapable_ == null) {
            System.err.println("t3d capable null!");
            return;
        }
        this.ePrev_ = event;
        this.computeRadius();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        int x2 = e2.getX();
        int y2 = e2.getY();
        if (this.inertia_) {
            int sqDist = (x2 - this.prevPrevX_) * (x2 - this.prevPrevX_) + (y2 - this.prevPrevY_) * (y2 - this.prevPrevY_);
            if (sqDist <= 16) {
                return;
            }
            int w2 = e2.getComponent().getWidth();
            int h2 = e2.getComponent().getHeight();
            double t2 = Math.min(Math.sqrt((double)sqDist / (double)(w2 * w2 + h2 * h2)) * 10.0, 1.0);
            this.lastDelta_ = T3DTrackball.SLERP(new JnQuaternion(0.0, 0.0, 0.0, 1.0), this.lastDelta_, 0.2 + (1.0 - t2) * 0.8);
            this.startSpinner();
        }
        this.driving_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSpinner() {
        if (this.spinner_ == null) {
            this.spinner_ = new Spinner();
            this.spinner_.start();
        }
        this.start_ = true;
        T3DTrackball t3DTrackball = this;
        synchronized (t3DTrackball) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseSpinner() {
        if (this.spinner_ == null) {
            return;
        }
        this.start_ = false;
        T3DTrackball t3DTrackball = this;
        synchronized (t3DTrackball) {
            this.notifyAll();
        }
    }

    @Override
    public void setTarget(JComponent vc) {
        if (this.target instanceof T3DCapable) {
            ((T3DCapable)((Object)this.target)).removePropertyChangeListener(this);
        }
        this.target = vc;
        if (vc instanceof T3DCapable) {
            this.t3dCapable_ = (T3DCapable)((Object)vc);
            this.lookPoint_.set(this.t3dCapable_.getLookPoint(null));
            this.eyePoint_.set(this.t3dCapable_.getEyePoint(null));
            this.upVector_.set(this.t3dCapable_.getUp(null));
            this.t3dCapable_.addPropertyChangeListener(this);
        } else {
            this.t3dCapable_ = null;
        }
        if (debug && vc instanceof T3DViewport) {
            this.sphere_ = new Sphere();
            ((T3DViewport)vc).getT3DComponent().add(this.sphere_);
        }
    }

    public void setCursor3D(Cursor3DModel cursor) {
        this.cursor_ = cursor;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        JnVector3d cursorLPS;
        CPoint cursorRAS;
        Point ptPrev;
        Point ptPos;
        JnQuaternion q2;
        T3DRenderStyleCapable rsc;
        if (this.t3dCapable_ == null) {
            return;
        }
        Component comp = event.getComponent();
        int width = comp.getWidth();
        int height = comp.getHeight();
        Point center = new Point(width / 2, height / 2);
        boolean isFullBody = false;
        if (this.t3dCapable_ instanceof T3DRenderStyleCapable && (rsc = (T3DRenderStyleCapable)((Object)this.t3dCapable_)).getRenderStyle().equals("VOLUME")) {
            isFullBody = true;
        }
        if (this.cursor_ != null && !isFullBody && this.target != null) {
            CPoint pt = this.cursor_.getPoint(null);
            double[] disp = GeomUtils.RAStoDisplay(pt.generateArray(), this.t3dCapable_.getEyePoint(null), this.t3dCapable_.getLookPoint(null), this.t3dCapable_.getUp(null), this.t3dCapable_.getViewHeight(), this.target.getWidth(), this.target.getHeight(), new double[3]);
            center.setLocation((int)disp[0], (int)disp[1]);
        }
        if ((q2 = T3DTrackball.simpleTrackBall(center, ptPos = event.getPoint(), ptPrev = this.ePrev_.getPoint(), this.radius_)) == null) {
            return;
        }
        this.lastDelta_ = this.prevDelta_;
        this.prevDelta_ = q2;
        JnMatrix3d mRot = q2.build3dRotationMatrix();
        JnVector3d zv = new JnVector3d();
        zv.sub(this.lookPoint_, this.eyePoint_);
        double dist = zv.length();
        zv.normalize();
        zv.x = -zv.x;
        zv.y = -zv.y;
        JnVector3d yv = new JnVector3d();
        yv.set(this.upVector_);
        yv.normalize();
        yv.z = -yv.z;
        JnVector3d xv = JnVector3d.cross(yv, zv);
        JnMatrix3d mPrev = new JnMatrix3d(new double[]{xv.x, yv.x, zv.x, xv.y, yv.y, zv.y, xv.z, yv.z, zv.z});
        mRot.mul(mPrev);
        double xshift = 0.0;
        double yshift = 0.0;
        if (this.cursor_ != null && !isFullBody) {
            JnVector3d lookLPS = new JnVector3d(-this.lookPoint_.x, -this.lookPoint_.y, this.lookPoint_.z);
            cursorRAS = this.cursor_.getPoint(null);
            cursorLPS = new JnVector3d(-cursorRAS.x, -cursorRAS.y, cursorRAS.z);
            JnVector3d shiftLPS = new JnVector3d();
            shiftLPS.sub(lookLPS, cursorLPS);
            xshift = xv.dot(shiftLPS);
            yshift = yv.dot(shiftLPS);
        }
        this.upVector_.set(mRot.m01, mRot.m11, -mRot.m21);
        JnVector3d viewVector = new JnVector3d(-mRot.m02, -mRot.m12, mRot.m22);
        if (this.cursor_ != null && (xshift != 0.0 || yshift != 0.0)) {
            cursorRAS = this.cursor_.getPoint(null);
            cursorLPS = new JnVector3d(-cursorRAS.x, -cursorRAS.y, cursorRAS.z);
            JnVector3d newXv = new JnVector3d(mRot.m00, mRot.m10, mRot.m20);
            JnVector3d newYv = new JnVector3d(mRot.m01, mRot.m11, mRot.m21);
            cursorLPS.scaleAdd(xshift, newXv);
            cursorLPS.scaleAdd(yshift, newYv);
            this.lookPoint_.set(-cursorLPS.x, -cursorLPS.y, cursorLPS.z);
        }
        this.eyePoint_.set(this.lookPoint_);
        this.eyePoint_.scaleAdd(-dist, viewVector);
        this.t3dCapable_.setCamera(this.eyePoint_.generateArray(), this.lookPoint_.generateArray(), this.upVector_.generateArray());
        this.ePrev_ = event;
        this.prevPrevX_ = this.prevX_;
        this.prevPrevY_ = this.prevY_;
        this.prevX_ = event.getX();
        this.prevY_ = event.getY();
    }

    public void setInertiaEnabled(boolean inertia) {
        this.inertia_ = inertia;
    }

    private static final JnQuaternion simpleTrackBall(Point ptCenter, Point ptPos, Point ptPrev, double dRadius) {
        double len;
        Point vTo = new Point(ptCenter.x - ptPrev.x, ptCenter.y - ptPrev.y);
        Point vFrom = new Point(ptCenter.x - ptPos.x, ptCenter.y - ptPos.y);
        JnVector3d vSphereFrom = new JnVector3d();
        JnVector3d vSphereTo = new JnVector3d();
        double dSqLen = 0.0;
        vSphereFrom.x = (double)vFrom.x / dRadius;
        vSphereFrom.y = (double)vFrom.y / dRadius;
        dSqLen = vSphereFrom.x * vSphereFrom.x + vSphereFrom.y * vSphereFrom.y;
        if (dSqLen > 1.0) {
            len = Math.sqrt(dSqLen);
            vSphereFrom.x /= len;
            vSphereFrom.y /= len;
            vSphereFrom.z = 0.0;
        } else {
            vSphereFrom.z = Math.sqrt(1.0 - dSqLen);
        }
        vSphereTo.x = (double)vTo.x / dRadius;
        vSphereTo.y = (double)vTo.y / dRadius;
        dSqLen = vSphereTo.x * vSphereTo.x + vSphereTo.y * vSphereTo.y;
        if (dSqLen > 1.0) {
            len = Math.sqrt(dSqLen);
            vSphereTo.x /= len;
            vSphereTo.y /= len;
            vSphereTo.z = 0.0;
        } else {
            vSphereTo.z = Math.sqrt(1.0 - dSqLen);
        }
        toPointX_ = -vSphereTo.x * dRadius;
        toPointY_ = -vSphereTo.y * dRadius;
        JnQuaternion q2 = T3DTrackball.twoVectorsToQuaternion(vSphereFrom, vSphereTo);
        return q2;
    }

    public static final JnQuaternion twoVectorsToQuaternion(JnVector3d vFrom, JnVector3d vTo) {
        double e2 = vFrom.dot(vTo);
        JnVector3d cross = JnVector3d.cross(vFrom, vTo);
        JnQuaternion q2 = new JnQuaternion();
        double vc = 1.0 / Math.sqrt(2.0 * (1.0 + e2));
        cross.scale(vc);
        q2.x = cross.x;
        q2.y = cross.y;
        q2.z = cross.z;
        q2.w = Math.sqrt(2.0 * (1.0 + e2)) * 0.5;
        return q2;
    }

    protected T3DCapable getT3DCapable() {
        return this.t3dCapable_;
    }

    protected JComponent getTarget() {
        return this.target;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.driving_) {
            return;
        }
        if ("eyePoint".equals(evt.getPropertyName())) {
            this.eyePoint_.set((double[])evt.getNewValue());
        } else if ("lookPoint".equals(evt.getPropertyName())) {
            this.lookPoint_.set((double[])evt.getNewValue());
        } else if ("up".equals(evt.getPropertyName())) {
            this.upVector_.set((double[])evt.getNewValue());
        } else if ("viewHeight".equals(evt.getPropertyName())) {
            this.computeRadius();
            if (this.sphere_ != null) {
                this.sphere_.repaint();
            }
        }
    }

    private void computeRadius() {
        this.t3dCapable_.getWorldBounds(this.ulc_, this.xside_, this.yside_, this.zside_);
        JnVector3d xv = new JnVector3d(this.xside_);
        JnVector3d yv = new JnVector3d(this.yside_);
        JnVector3d zv = new JnVector3d(this.zside_);
        this.volumeSize_ = Math.sqrt(xv.lengthSquared() + yv.lengthSquared() + zv.lengthSquared()) * 0.8;
        double vh = this.t3dCapable_.getViewHeight();
        if (vh == 0.0) {
            return;
        }
        double asp = this.t3dCapable_.getAspectRatio();
        if (asp > 1.0) {
            vh *= asp;
        }
        if (this.target != null) {
            this.radius_ = Math.min(this.volumeSize_ / vh * (double)this.target.getHeight() * 0.5, (double)this.target.getHeight() * 0.5);
        }
    }

    static final JnQuaternion SLERP(JnQuaternion p2, JnQuaternion q2, double t2) {
        JnQuaternion result = new JnQuaternion();
        double cosom = p2.x * q2.x + p2.y * q2.y + p2.z * q2.z + p2.w * q2.w;
        if (1.0 + cosom > 1.0E-6) {
            double sclq;
            double sclp;
            if (1.0 - cosom > 1.0E-6) {
                double omega = Math.acos(cosom);
                double sinom = Math.sin(omega);
                sclp = Math.sin((1.0 - t2) * omega) / sinom;
                sclq = Math.sin(t2 * omega) / sinom;
            } else {
                sclp = 1.0 - t2;
                sclq = t2;
            }
            result.x = sclp * p2.x + sclq * q2.x;
            result.y = sclp * p2.y + sclq * q2.y;
            result.z = sclp * p2.z + sclq * q2.z;
            result.w = sclp * p2.w + sclq * q2.w;
        } else {
            result.x = -p2.y;
            result.y = p2.x;
            result.z = -p2.w;
            result.w = p2.z;
            double sclp = Math.sin((1.0 - t2) * Math.PI * 0.5);
            double sclq = Math.sin(t2 * Math.PI * 0.5);
            result.x = sclp * p2.x + sclq * result.x;
            result.y = sclp * p2.y + sclq * result.y;
            result.z = sclp * p2.z + sclq * result.z;
        }
        return result;
    }

    static {
        debug = false;
    }

    private class Sphere
    extends XpVisualComponent {
        private Sphere() {
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            g2.setColor(Color.WHITE);
            Graphics2D g2d = (Graphics2D)g2;
            g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
            g2d.draw(new Ellipse2D.Double(-T3DTrackball.this.radius_, -T3DTrackball.this.radius_, T3DTrackball.this.radius_ * 2.0, T3DTrackball.this.radius_ * 2.0));
            g2d.translate(toPointX_, toPointY_);
            g2d.draw(new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0));
        }
    }

    private class Spinner
    extends Thread {
        private Spinner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                T3DTrackball t3DTrackball = T3DTrackball.this;
                synchronized (t3DTrackball) {
                    if (!T3DTrackball.this.start_) {
                        try {
                            T3DTrackball.this.wait();
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                if (!T3DTrackball.this.start_) continue;
                JnMatrix3d mRot = T3DTrackball.this.lastDelta_.build3dRotationMatrix();
                JnVector3d zv = new JnVector3d();
                zv.sub(T3DTrackball.this.lookPoint_, T3DTrackball.this.eyePoint_);
                double dist = zv.length();
                zv.normalize();
                zv.x = -zv.x;
                zv.y = -zv.y;
                JnVector3d yv = new JnVector3d();
                yv.set(T3DTrackball.this.upVector_);
                yv.normalize();
                yv.z = -yv.z;
                JnVector3d xv = JnVector3d.cross(yv, zv);
                JnMatrix3d mPrev = new JnMatrix3d(new double[]{xv.x, yv.x, zv.x, xv.y, yv.y, zv.y, xv.z, yv.z, zv.z});
                mRot.mul(mPrev);
                if (T3DTrackball.this.cursor_ != null) {
                    T3DTrackball.this.lookPoint_.set(T3DTrackball.this.cursor_.getPoint(null));
                }
                T3DTrackball.this.upVector_.set(mRot.m01, mRot.m11, -mRot.m21);
                T3DTrackball.this.eyePoint_.set(T3DTrackball.this.lookPoint_);
                T3DTrackball.this.eyePoint_.scaleAdd(-dist, new JnVector3d(-mRot.m02, -mRot.m12, mRot.m22));
                T3DTrackball.this.t3dCapable_.setCamera(T3DTrackball.this.eyePoint_.generateArray(), T3DTrackball.this.lookPoint_.generateArray(), T3DTrackball.this.upVector_.generateArray());
                T3DTrackball.this.t3dCapable_.repaint();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

