/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.StdAnno.ApStyle;
import com.ge.med.idc.ActiveAnnotationCapable;
import com.ge.med.idc.Capable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreationListener;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.OffScreenCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.T3DStateCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjFragmentProgram;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpStackLayout;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpApdAnnotation;
import com.ge.med.terra.jami.annotation.XpApdAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpRASAnnotation;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.DefaultT3DMouseController;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DSerializer;
import com.ge.med.terra.jami.j3d.remote.RmClient3DEngine;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.roi.j3d.Roi3DStatImage;
import com.ge.med.terra.jami.roi.j3d.T3DStatImage;
import com.ge.med.terra.jami.roi.j3d.Xp3DRoiVc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public class T3DViewport
extends XpViewport
implements T3DCapable,
FrameOwner,
XpImageRenderAttributesOwner,
WindowLevelCapable,
ColorMapCapable,
ROICapable,
UserAnnoCapable,
OffScreenCapable,
T3DRenderStyleCapable,
T3DStateCapable,
ActiveAnnotationCapable,
AnnotCapable,
Selectable,
ComponentCreationListener {
    T3DSerializer serializer = null;
    private T3DComponent tc = null;
    private XpMouseController mc = null;
    private XpDicomObject dobj = null;
    private XpAnnotationGenerator ag = null;
    private XpAnnotationVc annotVc = new XpAnnotationVc();
    private Map rois = new HashMap();
    private Map uannos = new HashMap();
    private List roilist = new ArrayList();
    private List uannolist = new ArrayList();
    private ComponentCreator componentCreator = null;
    private Cursor oldCursor = null;
    public static final ImageIcon CROSS_ICON = new ImageIcon(XpSingularPort.class.getResource("measureCursor.gif"));
    public static final Cursor MEASUREMENT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(CROSS_ICON.getImage(), new Point(CROSS_ICON.getIconWidth() / 2, CROSS_ICON.getIconHeight() / 2), "Measurement");
    private PropertyChangeListener propChangeRouter = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            T3DViewport.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    };
    private Properties annotationGeneratorProps;
    private MouseListener selectionListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e2) {
            T3DViewport.this.firePropertyChange("COMPONENT_SELECTED", false, true);
        }
    };
    private boolean selected_ = false;

    public static JFrame showVolume(XjVolumeInfo volinfo) {
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        T3DViewport vp = new T3DViewport();
        vp.setPreferredSize(new Dimension(512, 512));
        f2.setContentPane(vp);
        f2.pack();
        f2.setVisible(true);
        vp.setVolume(volinfo);
        return f2;
    }

    public T3DViewport() {
        this(new T3DComponent());
    }

    public T3DViewport(T3DComponent tc) {
        this.setT3DComponent(tc);
        this.initViewport();
    }

    public T3DViewport(T3DRenderEngine engine) {
        T3DComponent tc = new T3DComponent(engine);
        this.setT3DComponent(tc);
        this.initViewport();
    }

    public T3DViewport(RmRenderSession serverSession, String remoteRenderEngineClass) {
        RmClient3DEngine client_re = new RmClient3DEngine(serverSession, remoteRenderEngineClass);
        T3DComponent tc = new T3DComponent(client_re);
        this.setT3DComponent(tc);
        this.initViewport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        T3DViewport vp;
        try {
            vp = (T3DViewport)this.getClass().newInstance();
        }
        catch (InstantiationException e2) {
            vp = new T3DViewport();
        }
        catch (IllegalAccessException e3) {
            vp = new T3DViewport();
        }
        vp.setAnnotationGenerator(this.getAnnotationGenerator().getClass(), this.annotationGeneratorProps);
        vp.setVolumeModel(this.getVolumeModel());
        int volumeLayers = this.tc.getNumVolumeLayers();
        T3DComponent vpT3Dcomp = vp.getT3DComponent();
        for (int i2 = 1; i2 < volumeLayers; ++i2) {
            vpT3Dcomp.addVolumeLayer(this.tc.getVolumeModel(i2));
        }
        vp.getT3DComponent().setPixelCombiner(this.tc.getPixelCombiner());
        int layer = this.tc.getVolumeLayer();
        for (int i3 = 0; i3 < volumeLayers; ++i3) {
            this.tc.selectVolumeLayer(i3);
            vpT3Dcomp.selectVolumeLayer(i3);
            vpT3Dcomp.setWinMinMax(this.tc.getWinMin(), this.tc.getWinMax());
            vpT3Dcomp.setVideoInverted(this.tc.isVideoInverted());
            int[] colorMap = this.tc.getColorMap();
            if (colorMap == null) continue;
            vpT3Dcomp.setColorMap(colorMap);
        }
        this.tc.selectVolumeLayer(layer);
        vpT3Dcomp.selectVolumeLayer(layer);
        vp.setT3DState(this.getT3DState());
        vp.setViewHeight(this.getViewHeight());
        vp.setSize(this.getSize());
        vp.setPreferredSize(this.getPreferredSize());
        vp.getT3DComponent().setSize(this.getT3DComponent().getSize());
        vp.forceRenderContents();
        T3DComponent tc = this.getT3DComponent();
        for (int i4 = 0; i4 < tc.getComponentCount(); ++i4) {
            Component c2 = tc.getComponent(i4);
            if (c2 instanceof Xp3DRoiVc) {
                Xp3DRoiVc roivc = (Xp3DRoiVc)c2;
                RoiActor ra = roivc.getRoiActor();
                if (!(ra instanceof XpStatisticsRoi)) continue;
                XpStatisticsRoi sr = (XpStatisticsRoi)ra;
                RoiActor newroi = (RoiActor)sr.clone();
                T3DStatImage origImg = (T3DStatImage)sr.getImage();
                T3DStatImage tsi = new T3DStatImage(vp, newroi, origImg.getReferenceSlice());
                Xp3DRoiVc newroivc = null;
                try {
                    Constructor<?> construct = c2.getClass().getConstructor(RoiActor.class, Boolean.TYPE, Boolean.TYPE);
                    newroivc = (Xp3DRoiVc)construct.newInstance(newroi, roivc.isViewLock(), true);
                }
                catch (SecurityException e4) {
                    e4.printStackTrace();
                }
                catch (NoSuchMethodException e5) {
                    e5.printStackTrace();
                }
                catch (IllegalArgumentException e6) {
                    e6.printStackTrace();
                }
                catch (InstantiationException e7) {
                    e7.printStackTrace();
                }
                catch (IllegalAccessException e8) {
                    e8.printStackTrace();
                }
                catch (InvocationTargetException e9) {
                    e9.printStackTrace();
                }
                finally {
                    if (newroivc == null) {
                        newroivc = new Xp3DRoiVc(newroi, roivc.isViewLock(), true);
                    }
                }
                newroi.setImage(tsi);
                vp.getT3DComponent().add(newroivc);
                newroi.setSelected(false);
                continue;
            }
            if (c2 instanceof XpUserAnnotationVc) {
                XpUserAnnotationVc userAnnoVc = (XpUserAnnotationVc)c2;
                XpUserAnnotationModel userAnnotationModel = userAnnoVc.getUserAnnotationModel();
                XpUserAnnotationModel new_model = (XpUserAnnotationModel)userAnnotationModel.clone();
                vp.add(new_model);
                new_model.setSelected(false);
                continue;
            }
            try {
                Method m2 = c2.getClass().getMethod("clone", new Class[0]);
                int mod = m2.getModifiers();
                if (!Modifier.isPublic(mod)) continue;
                Component clone_c = (Component)m2.invoke((Object)c2, new Object[0]);
                vp.getT3DComponent().add(clone_c);
                continue;
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e1) {
                continue;
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
        vp.invalidate();
        vp.validate();
        return vp;
    }

    public BufferedImage exportImage(int width, int height) {
        T3DViewport clonevp = (T3DViewport)this.clone();
        BufferedImage bimg = new BufferedImage(width, height, 1);
        clonevp.setPreferredSize(new Dimension(width, height));
        JFrame jf = new JFrame("offscreen");
        jf.setContentPane(clonevp);
        jf.pack();
        clonevp.getT3DComponent().forceRenderContents();
        clonevp.refreshContents();
        Graphics g2 = bimg.getGraphics();
        clonevp.paint(g2);
        clonevp.dispose();
        jf.dispose();
        return bimg;
    }

    public void forceRenderContents() {
        this.tc.forceRenderContents();
    }

    private void initViewport() {
        this.setAnnotationGenerator(T3DAnnotationGenerator.class, null);
        this.setBackground(Color.black);
        this.setLayout(new XpStackLayout());
        this.add(this.tc);
        this.tc.add((Component)this.annotVc, 0);
        DefaultT3DMouseController rmc = new DefaultT3DMouseController();
        this.setMouseController(rmc);
        this.addMouseWheelListener(rmc);
        this.serializer = new T3DSerializer(this);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.tc != null) {
            this.tc.setBackground(bg);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setMouseController(null);
        if (this.ag != null) {
            this.ag.reset();
        }
        this.dobj = null;
        this.ag = null;
        if (this.tc != null) {
            this.disableMouseController();
            this.remove(this.tc);
            this.tc.dispose();
            this.tc.remove(this.annotVc);
            this.tc.removeMouseListener(this.selectionListener);
            this.tc.removePropertyChangeListener(this.propChangeRouter);
            this.tc = null;
            this.annotVc = null;
        }
    }

    @Override
    public final void setRenderStyle(String style) {
        this.tc.setRenderStyle(style);
    }

    @Override
    public final String getRenderStyle() {
        return this.tc.getRenderStyle();
    }

    private void setT3DComponent(T3DComponent tc) {
        if (this.tc != null) {
            this.tc.removeMouseListener(this.selectionListener);
            this.tc.removePropertyChangeListener(this.propChangeRouter);
        }
        this.tc = tc;
        tc.addPropertyChangeListener(this.propChangeRouter);
    }

    @Override
    public Capable getCapable(String capableIFName) {
        Capable c2 = super.getCapable(capableIFName);
        if (c2 == null && this.tc != null) {
            c2 = this.tc.getCapable(capableIFName);
        }
        return c2;
    }

    @Override
    public final void setAnnotationGenerator(Class agClass, Properties props) {
        try {
            this.ag = (XpAnnotationGenerator)agClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.ag != null) {
                this.annotationGeneratorProps = props;
                this.ag.setProperties(props);
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    @Override
    public final XpAnnotationGenerator getAnnotationGenerator() {
        return this.ag;
    }

    private void cleanup() {
        this.ag.reset();
    }

    public void setVolume(XjVolumeInfo volume) {
        this.cleanup();
        if (volume == null) {
            this.dobj = null;
            this.tc.setVolume(null);
            this.init();
            return;
        }
        this.dobj = new DicomSource(volume);
        this.init();
        this.tc.setVolume(volume);
        this.repaint();
    }

    public XpDicomObject getDicomSource() {
        return this.dobj;
    }

    private void init() {
        if (this.dobj != null) {
            XpAnnotationModel annotModel = null;
            if (this.ag instanceof XpApdAnnotationGenerator) {
                XpApdAnnotationGenerator apd_ag = (XpApdAnnotationGenerator)this.ag;
                annotModel = apd_ag.getAnnotation(this.dobj);
            } else {
                annotModel = this.ag.getAnnotation(this.tc.getMedicalImage(), this.dobj);
            }
            this.annotVc.setAnnotationModel(annotModel);
            XpImageRenderAttributes ira = this.tc.getImageRenderAttributes();
            double wl = 600.0;
            double ww = 1200.0;
            ira.setWindowing(ww, wl);
            this.tc.setImageRenderAttributes(ira);
        } else {
            this.annotVc.setAnnotationModel(null);
        }
    }

    public void setProperty(String propName, Object value) {
        this.tc.setProperty(propName, value);
        this.repaint();
    }

    public Object getProperty(String propName) {
        return this.tc.getProperty(propName);
    }

    @Override
    public final XpImage getFrame() {
        return this.tc.getFrame();
    }

    public final T3DComponent getT3DComponent() {
        return this.tc;
    }

    public final XpAnnotationVc getAnnotationVc() {
        return this.annotVc;
    }

    @Override
    public XpMedicalImage[] getImages() {
        XpMedicalImage[] imgs = new XpMedicalImage[]{this.tc.getMedicalImage()};
        return imgs;
    }

    @Override
    public void refreshContents() {
        this.tc.refresh();
    }

    @Override
    public XpImage getImageAt(int idx) {
        return this.tc.getFrame();
    }

    @Override
    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.tc.getWorldBounds(ulc, xside, yside, zside);
    }

    @Override
    public void setLookPoint(double[] point) {
        this.tc.setLookPoint(point);
    }

    @Override
    public double[] getLookPoint(double[] look_pt) {
        return this.tc.getLookPoint(look_pt);
    }

    @Override
    public void setEyePoint(double[] point) {
        this.tc.setEyePoint(point);
    }

    @Override
    public double[] getEyePoint(double[] eye_pt) {
        return this.tc.getEyePoint(eye_pt);
    }

    @Override
    public void setUp(double[] vec) {
        this.tc.setUp(vec);
    }

    @Override
    public double[] getUp(double[] up_v) {
        return this.tc.getUp(up_v);
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.tc.setCamera(eyepoint, lookpoint, up);
    }

    @Override
    public void setViewHeight(double height) {
        this.tc.setViewHeight(height);
    }

    @Override
    public double getViewHeight() {
        return this.tc.getViewHeight();
    }

    @Override
    public void setAspectRatio(double aspect) {
        this.tc.setAspectRatio(aspect);
    }

    @Override
    public double getAspectRatio() {
        return this.tc.getAspectRatio();
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        this.tc.setViewClip(clipOffsets);
    }

    @Override
    public double[] getViewClip(double[] view_clip) {
        return this.tc.getViewClip(view_clip);
    }

    @Override
    public void setPerspective(boolean b2) {
        this.tc.setPerspective(b2);
    }

    @Override
    public boolean isPerspective() {
        return this.tc.isPerspective();
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.tc.setImageRenderAttributes(attr);
    }

    @Override
    public XpImageRenderAttributes getImageRenderAttributes() {
        return this.tc.getImageRenderAttributes();
    }

    public synchronized void setWindowing(double width, double level) {
        this.tc.setWindowing(width, level);
        this.auto_repaint();
    }

    @Override
    public void setWinMinMax(double min, double max) {
        this.tc.setWinMinMax(min, max);
    }

    @Override
    public double getWinMin() {
        return this.tc.getWinMin();
    }

    @Override
    public final void setWinMin(double min) {
        this.tc.setWinMin(min);
    }

    @Override
    public double getWinMax() {
        return this.tc.getWinMax();
    }

    @Override
    public final void setWinMax(double max) {
        this.tc.setWinMax(max);
    }

    @Override
    public void resetWindowing() {
        this.tc.resetWindowing();
        this.auto_repaint();
    }

    @Override
    public final void setWinUpperLimit(double wuLimit) {
        this.tc.setWinUpperLimit(wuLimit);
    }

    @Override
    public final double getWinUpperLimit() {
        return this.tc.getWinUpperLimit();
    }

    @Override
    public final void setWinLowerLimit(double wlLimit) {
        this.tc.setWinLowerLimit(wlLimit);
    }

    @Override
    public final double getWinLowerLimit() {
        return this.tc.getWinLowerLimit();
    }

    @Override
    public void setVideoInverted(boolean inverted) {
        this.tc.setVideoInverted(inverted);
        this.auto_repaint();
    }

    @Override
    public boolean isVideoInverted() {
        return this.tc.isVideoInverted();
    }

    @Override
    public double[] getRange() {
        return this.tc.getRange();
    }

    protected Component addComponent(Component c2) {
        RoiActor ra;
        Component retcomp = this.tc.add(c2);
        this.invalidate();
        this.validate();
        this.repaint();
        if (c2 instanceof XpImageRoiVc && (ra = ((XpImageRoiVc)c2).getRoiActor()) != null) {
            this.firePropertyChange("ROI_ADDED", null, ra, this);
        }
        return retcomp;
    }

    protected void removeComponent(Component c2) {
        RoiActor ra;
        this.tc.remove(c2);
        this.invalidate();
        this.validate();
        this.repaint();
        if (c2 instanceof XpImageRoiVc && (ra = ((XpImageRoiVc)c2).getRoiActor()) != null) {
            this.firePropertyChange("ROI_REMOVED", null, ra, this);
        }
    }

    @Override
    public void add(RoiActor ra) {
        XpImageRoiVc rvc = (XpImageRoiVc)this.rois.get(ra);
        if (rvc == null) {
            rvc = new Xp3DRoiVc(ra);
            this.roilist.add(ra);
            this.rois.put(ra, rvc);
            ra.setImage(new T3DStatImage(this, ra));
            this.addComponent(rvc);
        }
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof XpImageRoiVc) {
            XpImageRoiVc roi3d = (XpImageRoiVc)comp;
            RoiActor ra = roi3d.getRoiActor();
            this.roilist.add(ra);
            this.rois.put(ra, roi3d);
            if (!(ra.getImage() instanceof Roi3DStatImage)) {
                ra.setImage(new T3DStatImage(this, ra));
            }
            return this.addComponent(comp);
        }
        return super.add(comp);
    }

    @Override
    public void remove(Component comp) {
        if (comp instanceof XpImageRoiVc) {
            XpImageRoiVc roi3d = (XpImageRoiVc)comp;
            RoiActor ra = roi3d.getRoiActor();
            this.roilist.remove(ra);
            this.rois.remove(ra);
            ra.setImage(null);
            this.removeComponent(comp);
        }
        super.remove(comp);
    }

    @Override
    public List getRois() {
        return this.roilist;
    }

    @Override
    public boolean remove(RoiActor ra) {
        XpImageRoiVc rvc = (XpImageRoiVc)this.rois.get(ra);
        if (rvc != null) {
            this.roilist.remove(ra);
            this.rois.remove(ra);
            ra.setImage(null);
            this.removeComponent(rvc);
            return true;
        }
        return false;
    }

    @Override
    public RoiActor getRoi() {
        int len = this.roilist.size();
        if (len > 0) {
            return (RoiActor)this.roilist.get(len - 1);
        }
        return null;
    }

    @Override
    public void setComponentCreator(ComponentCreator rc) {
        if (this.componentCreator != null) {
            this.getT3DComponent().setCursor(this.oldCursor);
            this.componentCreator.removeViewport(this, this.getT3DComponent());
            this.componentCreator.removeComponentCreationListener(this);
            this.componentCreator = null;
        }
        this.componentCreator = rc;
        if (rc != null) {
            rc.addViewport(this, this.getT3DComponent());
            rc.addComponentCreationListener(this);
            this.oldCursor = this.getT3DComponent().getCursor();
            this.disableMouseController();
            this.getT3DComponent().setCursor(MEASUREMENT_CURSOR);
        } else {
            this.enableMouseController();
        }
    }

    @Override
    public ComponentCreator getComponentCreator() {
        return this.componentCreator;
    }

    @Override
    public void add(XpUserAnnotationModel m2) {
        XpUserAnnotationVc uvc = (XpUserAnnotationVc)this.uannos.get(m2);
        if (uvc == null) {
            uvc = new XpUserAnnotationVc(m2);
            this.uannolist.add(m2);
            this.uannos.put(m2, uvc);
            this.addComponent(uvc);
        }
    }

    @Override
    public boolean remove(XpUserAnnotationModel m2) {
        XpUserAnnotationVc uvc = (XpUserAnnotationVc)this.uannos.get(m2);
        if (uvc != null) {
            this.uannolist.remove(m2);
            this.uannos.remove(m2);
            this.removeComponent(uvc);
            return true;
        }
        return false;
    }

    @Override
    public List getUserAnnos() {
        return this.uannolist;
    }

    public XjVolumeModel getVolumeModel() {
        return this.tc.getVolumeModel();
    }

    public XjVolumeInfo getVolume() {
        return this.tc.getVolume();
    }

    public void setOverlayColorMap(int[] cmap) {
        this.tc.setOverlayColorMap(cmap);
    }

    public void setVolumeModel(XjVolumeModel vm) {
        this.cleanup();
        if (vm instanceof XpDicomObject) {
            this.dobj = (XpDicomObject)((Object)vm);
        } else if (vm == null) {
            this.dobj = null;
        }
        this.init();
        this.tc.setVolumeModel(vm);
        this.repaint();
    }

    public final XpMouseController getMouseController() {
        return this.mc;
    }

    public void disableMouseController() {
        if (this.mc != null) {
            this.mc.setTarget(null);
            this.tc.removeMouseListener(this.mc);
            this.tc.removeMouseMotionListener(this.mc);
            if (this.mc instanceof PropertyChangeListener) {
                this.tc.removePropertyChangeListener((PropertyChangeListener)((Object)this.mc));
            }
            if (this.mc instanceof MouseWheelListener) {
                this.removeMouseWheelListener((MouseWheelListener)((Object)this.mc));
            }
        }
    }

    public void enableMouseController() {
        if (this.mc != null) {
            this.mc.setTarget(this);
            this.tc.addMouseListener(this.mc);
            this.tc.addMouseMotionListener(this.mc);
            if (this.mc instanceof MouseWheelListener) {
                this.addMouseWheelListener((MouseWheelListener)((Object)this.mc));
            }
        }
        this.tc.removeMouseListener(this.selectionListener);
        this.tc.addMouseListener(this.selectionListener);
    }

    protected MouseListener getSelectionListener() {
        return this.selectionListener;
    }

    public final void setMouseController(XpMouseController mc) {
        if (mc != this.mc) {
            this.disableMouseController();
            this.mc = mc;
            this.enableMouseController();
            if (mc != null) {
                mc.setTarget(this);
            }
        }
        this.tc.removeMouseListener(this.selectionListener);
        this.tc.addMouseListener(this.selectionListener);
    }

    @Override
    public final BufferedImage getImage(BufferedImage img, String options) {
        BufferedImage bi = img;
        if (bi == null) {
            Dimension d2 = this.getSize();
            bi = new BufferedImage(d2.width, d2.height, 2);
        }
        if (options != null) {
            String[] toks = options.split("=\\s");
            int i2 = 0;
            while (i2 < toks.length) {
                if (toks[i2].equals("annotation")) {
                    if (toks[i2 + 1].equals("off")) {
                        this.annotVc.setVisible(false);
                        i2 += 2;
                        continue;
                    }
                    ++i2;
                    continue;
                }
                if (toks[i2].equals("graphics")) {
                    ++i2;
                    continue;
                }
                ++i2;
            }
        }
        int type = bi.getType();
        switch (type) {
            case 2: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                XpBufferedImage xbi = (XpBufferedImage)this.getFrame();
                BufferedImage bimg = (BufferedImage)xbi.getPixelData();
                if (bimg.getWidth() != bi.getWidth() || bimg.getHeight() != bi.getHeight() || bimg.getType() != 11) break;
                short[] sdata = ((DataBufferUShort)bimg.getRaster().getDataBuffer()).getData();
                short[] ddata = ((DataBufferUShort)bi.getRaster().getDataBuffer()).getData();
                System.arraycopy(sdata, 0, ddata, 0, sdata.length);
            }
        }
        return bi;
    }

    @Override
    public String[] getSupportedRenderStyles() {
        return this.tc.getSupportedRenderStyles();
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.tc.addTaskMonitor(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.tc.removeTaskMonitor(tm);
    }

    @Override
    public InputStream getT3DState() {
        return this.serializer.getT3DState();
    }

    @Override
    public void setT3DState(InputStream t3dStateStream) {
        this.serializer.setT3DState(t3dStateStream);
        this.firePropertyChange("t3dstate", null, null);
    }

    @Override
    public Border getBorder() {
        if (this.tc != null) {
            return this.tc.getBorder();
        }
        return super.getBorder();
    }

    @Override
    public void setBorder(Border b2) {
        if (this.tc != null) {
            this.tc.setBorder(b2);
        } else {
            super.setBorder(b2);
        }
    }

    public double[] getInitialUp() {
        return this.tc.getInitialUp();
    }

    public void setInitialUp(double[] initialUp) {
        this.tc.setInitialUp(initialUp);
    }

    public double[] getInitialView() {
        return this.tc.getInitialView();
    }

    public void setInitialView(double[] initialView) {
        this.tc.setInitialView(initialView);
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
        super.setAutoRepaint(autoRepaint);
        if (this.tc != null) {
            this.tc.setAutoRepaint(autoRepaint);
        }
    }

    @Override
    public String[] getAnnotationSegments() {
        return this.getAnnotationVc().getAnnotationSegments();
    }

    @Override
    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil) {
        this.getAnnotationVc().setActiveAnnotationListener(annotSegment, mil);
    }

    @Override
    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil, String tooltip) {
        this.getAnnotationVc().setActiveAnnotationListener(annotSegment, mil, tooltip);
    }

    @Override
    public void clearActiveAnnotationListener(String annotSegment) {
        this.getAnnotationVc().clearActiveAnnotationListener(annotSegment);
    }

    @Override
    public void clearActiveAnnotationListeners() {
        this.getAnnotationVc().clearActiveAnnotationListeners();
    }

    @Override
    protected void applyAnnotationLanguage(String lang) {
        super.applyAnnotationLanguage(lang);
        XpAnnotationGenerator ag2 = this.getAnnotationGenerator();
        if (ag2 instanceof XpApdAnnotationGenerator) {
            XpApdAnnotationGenerator generator = (XpApdAnnotationGenerator)ag2;
            generator.setLanguage(lang);
        }
    }

    @Override
    public String[] getAnnotationGroups() {
        XpAnnotationModel am2 = this.annotVc.getAnnotationModel();
        if (am2 != null) {
            return am2.getAnnotationGroups();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems() {
        XpAnnotationModel am2 = this.annotVc.getAnnotationModel();
        if (am2 != null) {
            return am2.getAnnotationItems();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems(String agName) {
        XpAnnotationModel am2 = this.annotVc.getAnnotationModel();
        if (am2 != null) {
            return am2.getAnnotationItems(agName);
        }
        return null;
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
        XpAnnotationModel am2 = this.annotVc.getAnnotationModel();
        if (am2 != null) {
            am2.setAnnotationGroup(agName, activate);
        }
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
        XpAnnotationModel am2 = this.annotVc.getAnnotationModel();
        if (am2 != null) {
            am2.setAnnotationItems(annoItems, activate);
        }
    }

    @Override
    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        XpAnnotationModel am2 = this.annotVc.getAnnotationModel();
        if (am2 != null) {
            am2.queryAnnotationItems(annoItems, queryRes);
        }
    }

    @Override
    public boolean queryAnnotationItem(String aiName) {
        XpAnnotationModel am2 = this.annotVc.getAnnotationModel();
        if (am2 != null) {
            return am2.queryAnnotationItem(aiName);
        }
        return false;
    }

    @Override
    public void setAnnotationVisible(boolean annotVisible) {
        this.annotVc.setVisible(annotVisible);
    }

    @Override
    public boolean isAnnotationVisible() {
        return this.annotVc.isVisible();
    }

    @Override
    public void setAnnotationColor(Color c2) {
        this.annotVc.setForeground(c2);
    }

    @Override
    public Color getAnnotationColor() {
        return this.annotVc.getForeground();
    }

    @Override
    public void setColorMap(int[] cMap) {
        this.tc.setColorMap(cMap);
    }

    @Override
    public int[] getColorMap() {
        return this.tc.getColorMap();
    }

    public int addFragmentProgram(XjFragmentProgram fp) {
        return this.tc.addFragmentProgram(fp);
    }

    public int removeFragmentProgram(XjFragmentProgram fp) {
        return this.tc.removeFragmentProgram(fp);
    }

    public int getNumFragmentPrograms() {
        return this.tc.getNumFragmentPrograms();
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelected(boolean selection) {
        boolean old = this.selected_;
        this.selected_ = selection;
    }

    @Override
    public void componentAddedNotification(ComponentCapable cc) {
    }

    @Override
    public void componentCreationNotification(ComponentCapable cc) {
        if (this.componentCreator != null) {
            this.componentCreator.removeViewport(this, this.getT3DComponent());
            this.componentCreator.removeComponentCreationListener(this);
            this.componentCreator = null;
        }
        this.getT3DComponent().setCursor(this.oldCursor);
        this.enableMouseController();
        List roiList = this.getRois();
        int numberOfRois = roiList.size();
        for (int i2 = 0; i2 < numberOfRois; ++i2) {
            RoiActor ra;
            Xp3DRoiVc vc = (Xp3DRoiVc)this.rois.get(roiList.get(i2));
            if (vc == null || !vc.isVisible() || (ra = vc.getRoiActor()) == null || !ra.isSelected()) continue;
            vc.requestFocus();
        }
    }

    protected Map getRoiMap() {
        return this.rois;
    }

    protected Map getUserAnnotationMap() {
        return this.uannos;
    }

    protected List getRoiList() {
        return this.roilist;
    }

    protected List getUserAnnotationList() {
        return this.uannolist;
    }

    public static class T3DAnnotationGenerator
    extends XpApdAnnotationGenerator {
        private Vector amvector = new Vector();

        @Override
        public XpApdAnnotation createApdAnnotation(XpDicomObject dobj, ApStyle aps) {
            T3DAnnotation annot = new T3DAnnotation(dobj, aps);
            this.amvector.add(annot);
            return annot;
        }

        @Override
        public void reset() {
            int len = this.amvector.size();
            for (int i2 = 0; i2 < len; ++i2) {
                T3DAnnotation annot = (T3DAnnotation)this.amvector.get(i2);
                annot.dispose();
            }
            this.amvector.clear();
            super.reset();
        }
    }

    private static class T3DAnnotation
    extends XpApdAnnotation {
        public T3DAnnotation(XpDicomObject mi, ApStyle apStyle) {
            super(mi, apStyle);
        }

        @Override
        public XpAnnotationConfig getAnnotationConfig(Class apStyleClass) {
            XpDicomElement modElement = new XpDicomElement(8, 96);
            XpDicomObject mi = this.getDicomObject();
            int result = mi.getValue(modElement);
            String modality = (String)modElement.value;
            if (modality.equals("PT")) {
                return new XpMRCTApdAnnotationConfig.PETFull();
            }
            return new T3DAnnotConfig();
        }
    }

    public static class T3DAnnotConfig
    extends XpMRCTApdAnnotationConfig {
        private Dimension size = new Dimension();
        private XpRASAnnotation rasAnno = new XpRASAnnotation();
        private double[] up = new double[3];
        private double[] lookpt = new double[3];
        private double[] eyept = new double[3];
        private CPoint[] cornerPts = new CPoint[3];
        private JnVector3d u = new JnVector3d();
        private JnVector3d r = new JnVector3d();
        private JnVector3d v = new JnVector3d();

        public T3DAnnotConfig() {
            for (int i2 = 0; i2 < this.cornerPts.length; ++i2) {
                this.cornerPts[i2] = new CPoint(2);
            }
        }

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am2 = avc.getAnnotationModel();
            T3DComponent tc = (T3DComponent)jc;
            if (am2 == null) {
                return;
            }
            this.setT3DRASCorners(avc, tc);
            this.setRenderAttributes(avc, tc);
            this.setROIInfo(avc, tc);
        }

        private void calc_cam(double[] eyepoint, double[] lookpoint, double[] up) {
            this.v.set(lookpoint[0] - eyepoint[0], lookpoint[1] - eyepoint[1], lookpoint[2] - eyepoint[2]);
            this.v.normalize();
            this.u.set(-up[0], -up[1], -up[2]);
            this.u.normalize();
            JnVector3d.cross(this.u, this.v, this.r);
            this.r.normalize();
            JnVector3d.cross(this.v, this.r, this.u);
            this.u.normalize();
        }

        private void setT3DRASCorners(XpAnnotationVc avc, T3DComponent tc) {
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            String rasSouth = null;
            String rasNorth = null;
            String rasEast = null;
            String rasWest = null;
            tc.getSize(this.size);
            int w2 = this.size.width;
            int h2 = this.size.height;
            int hw = w2 >> 1;
            int hh = h2 >> 1;
            double viewHeight = tc.getViewHeight();
            double aspectRatio = tc.getAspectRatio();
            double viewWidth = viewHeight * aspectRatio;
            double spX = viewWidth / (double)w2;
            double spY = viewHeight / (double)h2;
            tc.getEyePoint(this.eyept);
            tc.getLookPoint(this.lookpt);
            tc.getUp(this.up);
            double len = Math.sqrt(this.up[0] * this.up[0] + this.up[1] * this.up[1] + this.up[2] * this.up[2]);
            this.up[0] = this.up[0] / len;
            this.up[1] = this.up[1] / len;
            this.up[2] = this.up[2] / len;
            this.calc_cam(this.eyept, this.lookpt, this.up);
            this.cornerPts[0].x = this.lookpt[0] + this.up[0] * spY * (double)hh - this.r.x * spX * (double)hw;
            this.cornerPts[0].y = this.lookpt[1] + this.up[1] * spY * (double)hh - this.r.y * spX * (double)hw;
            this.cornerPts[0].z = this.lookpt[2] + this.up[2] * spY * (double)hh - this.r.z * spX * (double)hw;
            this.cornerPts[1].x = this.lookpt[0] + this.up[0] * spY * (double)hh + this.r.x * spX * (double)hw;
            this.cornerPts[1].y = this.lookpt[1] + this.up[1] * spY * (double)hh + this.r.y * spX * (double)hw;
            this.cornerPts[1].z = this.lookpt[2] + this.up[2] * spY * (double)hh + this.r.z * spX * (double)hw;
            this.cornerPts[2].x = this.lookpt[0] - this.up[0] * spY * (double)hh + this.r.x * spX * (double)hw;
            this.cornerPts[2].y = this.lookpt[1] - this.up[1] * spY * (double)hh + this.r.y * spX * (double)hw;
            this.cornerPts[2].z = this.lookpt[2] - this.up[2] * spY * (double)hh + this.r.z * spX * (double)hw;
            this.rasAnno.set(this.cornerPts[0], this.cornerPts[1], this.cornerPts[2]);
            rasNorth = this.rasAnno.getNorth();
            rasSouth = this.rasAnno.getSouth();
            rasEast = this.rasAnno.getEast();
            rasWest = this.rasAnno.getWest();
            am2.setProperty("rasSouth", rasSouth);
            am2.setProperty("rasNorth", rasNorth);
            am2.setProperty("rasEast", rasEast);
            am2.setProperty("rasWest", rasWest);
        }
    }

    private class DicomSource
    implements XpDicomObject {
        private XjDicomObject dobj = null;
        private double[] clip = new double[2];
        private double curr_thickness = -1.0;

        public DicomSource(XjDicomObject dobj) {
            this.dobj = dobj;
        }

        @Override
        public int getValues(XpDicomElement[] values) {
            int notLoaded = 0;
            for (int i2 = 0; i2 < values.length; ++i2) {
                int result = this.getValue(values[i2]);
                if (result != 1) continue;
                ++notLoaded;
            }
            return notLoaded;
        }

        @Override
        public int getValue(XpDicomElement value) {
            if (value.group == 24 && value.element == 80) {
                XpAnnotationModel am2;
                T3DViewport.this.getViewClip(this.clip);
                double thickness = Math.abs(this.clip[0]) + Math.abs(this.clip[1]);
                if (thickness > 0.0) {
                    value.value = "" + thickness;
                } else {
                    Object val = this.dobj.getValue(value.group, value.element);
                    thickness = Double.parseDouble("" + val);
                    if (val != null) {
                        value.value = val;
                    }
                }
                if (this.curr_thickness != thickness && (am2 = T3DViewport.this.annotVc.getAnnotationModel()) instanceof XpApdAnnotation) {
                    ((XpApdAnnotation)am2).getApStyle().reset();
                }
                this.curr_thickness = thickness;
                return 0;
            }
            Object val = this.dobj.getValue(value.group, value.element);
            if (val != null) {
                value.value = val;
                return 0;
            }
            return 1;
        }
    }
}

