/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.ViewResetActionBase;
import java.util.HashMap;
import java.util.Map;

public class ViewResetAction
extends ViewResetActionBase {
    private T3DCapable engine_;
    private Cursor3DModel cursor_;
    private JnVector3d viewVector;
    private JnVector3d upVector;
    private static Map viewVectorTable;
    public static final JnVector3d S_VECTOR;
    public static final JnVector3d I_VECTOR;
    public static final JnVector3d A_VECTOR;
    public static final JnVector3d P_VECTOR;
    public static final JnVector3d L_VECTOR;
    public static final JnVector3d R_VECTOR;
    private static Map upVectorTable;
    public static final JnVector3d S_UP_VECTOR;
    public static final JnVector3d I_UP_VECTOR;
    public static final JnVector3d A_UP_VECTOR;
    public static final JnVector3d P_UP_VECTOR;
    public static final JnVector3d L_UP_VECTOR;
    public static final JnVector3d R_UP_VECTOR;
    private JnMatrix4d tiltMat = new JnMatrix4d();

    public ViewResetAction() {
        this("I");
    }

    public ViewResetAction(T3DCapable engine, String orientation, Cursor3DModel cursor) {
        super(orientation);
        this.engine_ = engine;
        this.viewVector = (JnVector3d)viewVectorTable.get(orientation.substring(0, 1).toUpperCase());
        this.upVector = (JnVector3d)upVectorTable.get(orientation.substring(0, 1).toUpperCase());
        this.tiltMat.setIdentity();
    }

    public ViewResetAction(String string) {
        this(null, string, null);
    }

    public void setCursor(Cursor3DModel c2) {
        this.cursor_ = c2;
    }

    public Cursor3DModel getCursor() {
        return this.cursor_;
    }

    public void setTiltMatrix(JnMatrix4d tiltMat) {
        this.tiltMat.set(tiltMat);
    }

    @Override
    protected void performAction() {
        if (this.engine_ == null) {
            return;
        }
        double[] look = this.cursor_ == null ? this.engine_.getLookPoint(null) : this.cursor_.getPoint(null).generateArray();
        JnVector3d tiltedViewVector = new JnVector3d();
        JnVector3d tiltedUpVector = new JnVector3d();
        this.tiltMat.transform(this.viewVector, tiltedViewVector);
        this.tiltMat.transform(this.upVector, tiltedUpVector);
        JnVector3d eyev = new JnVector3d(look);
        eyev.sub(tiltedViewVector);
        this.engine_.setCamera(eyev.generateArray(), look, tiltedUpVector.generateArray());
    }

    public void setTarget(T3DCapable eng) {
        this.engine_ = eng;
    }

    public T3DCapable getTarget() {
        return this.engine_;
    }

    public static void setView(T3DCapable t3dcapable, String orientation, double[] center) {
        JnVector3d viewV = (JnVector3d)viewVectorTable.get(orientation.substring(0, 1).toUpperCase());
        JnVector3d upV = (JnVector3d)upVectorTable.get(orientation.substring(0, 1).toUpperCase());
        JnVector3d eyev = new JnVector3d(center);
        eyev.sub(viewV);
        t3dcapable.setCamera(eyev.generateArray(), center, upV.generateArray());
    }

    static {
        S_VECTOR = new JnVector3d(0.0, 0.0, -1.0);
        I_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        A_VECTOR = new JnVector3d(0.0, -1.0, 0.0);
        P_VECTOR = new JnVector3d(0.0, 1.0, 0.0);
        L_VECTOR = new JnVector3d(1.0, 0.0, 0.0);
        R_VECTOR = new JnVector3d(-1.0, 0.0, 0.0);
        S_UP_VECTOR = new JnVector3d(0.0, -1.0, 0.0);
        I_UP_VECTOR = new JnVector3d(0.0, 1.0, 0.0);
        A_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        P_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        L_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        R_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        viewVectorTable = new HashMap(6);
        viewVectorTable.put("S", S_VECTOR);
        viewVectorTable.put("I", I_VECTOR);
        viewVectorTable.put("A", A_VECTOR);
        viewVectorTable.put("P", P_VECTOR);
        viewVectorTable.put("L", L_VECTOR);
        viewVectorTable.put("R", R_VECTOR);
        upVectorTable = new HashMap(6);
        upVectorTable.put("S", S_UP_VECTOR);
        upVectorTable.put("I", I_UP_VECTOR);
        upVectorTable.put("A", A_UP_VECTOR);
        upVectorTable.put("P", P_UP_VECTOR);
        upVectorTable.put("L", L_UP_VECTOR);
        upVectorTable.put("R", R_UP_VECTOR);
    }
}

