/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.PathIterator3D;
import com.ge.med.jnu.geom.Rectangle3D;
import com.ge.med.jnu.geom.Shape3D;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VolumeProjectionPlane
extends XpVisualComponent
implements ChangeListener {
    private static final Color BOX_COLOR = new Color(200, 200, 200);
    private static final Stroke BOX_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{8.0f, 2.0f}, 0.0f);
    private Shape3D volumeBox_;
    private T3DCapable engine_;

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.engine_ == null) {
            return;
        }
        double[] ulc = new double[3];
        double[] xside = new double[3];
        double[] yside = new double[3];
        double[] zside = new double[3];
        this.engine_.getWorldBounds(ulc, xside, yside, zside);
        JnVector3d xv = new JnVector3d(xside);
        JnVector3d yv = new JnVector3d(yside);
        JnVector3d zv = new JnVector3d(zside);
        double ww = xv.length();
        double hh = yv.length();
        double dd = zv.length();
        xv.normalize();
        yv.normalize();
        zv.normalize();
        JnMatrix3d rotation = new JnMatrix3d(new double[]{xv.x, yv.x, zv.x, xv.y, yv.y, zv.y, xv.z, yv.z, zv.z});
        this.volumeBox_ = new Rectangle3D(0.0, 0.0, 0.0, ww, hh, dd);
        JnVector3d origv = new JnVector3d(ulc);
        JnVector3d center = new JnVector3d(this.engine_.getLookPoint(null));
        center.sub(origv);
        JnVector3d eyev = new JnVector3d(this.engine_.getEyePoint(null));
        JnVector3d lookv = new JnVector3d(this.engine_.getLookPoint(null));
        JnVector3d viewv = new JnVector3d(lookv.generateArray());
        viewv.sub(eyev);
        JnVector3d vx = JnVector3d.cross(viewv.generateArray(), this.engine_.getUp(null));
        vx.normalize();
        JnVector3d vy = new JnVector3d(this.engine_.getUp(null));
        vy.scale(-1.0);
        rotation.transpose();
        rotation.transform(vx);
        rotation.transform(vy);
        rotation.transform(center);
        double halfhVolume = this.engine_.getViewHeight() / 2.0;
        double halfwVolume = (double)this.getWidth() * halfhVolume / (double)this.getHeight();
        int halfw = this.getWidth() / 2;
        int halfh = this.getHeight() / 2;
        JnVector3d ul = new JnVector3d(center.x - vx.x * halfwVolume - vy.x * halfhVolume, center.y - vx.y * halfwVolume - vy.y * halfhVolume, center.z - vx.z * halfwVolume - vy.z * halfhVolume);
        JnVector3d ur = new JnVector3d(center.x + vx.x * halfwVolume - vy.x * halfhVolume, center.y + vx.y * halfwVolume - vy.y * halfhVolume, center.z + vx.z * halfwVolume - vy.z * halfhVolume);
        JnVector3d bl = new JnVector3d(center.x - vx.x * halfwVolume + vy.x * halfhVolume, center.y - vx.y * halfwVolume + vy.y * halfhVolume, center.z - vx.z * halfwVolume + vy.z * halfhVolume);
        PathIterator3D pathIt = this.volumeBox_.getIntersection(ul, ur, bl);
        GeneralPath path2d = new GeneralPath();
        while (!pathIt.isDone()) {
            JnVector3d pt = new JnVector3d();
            int type = pathIt.currentSegment(pt);
            pt.scaleAdd(-1.0, center);
            double xOff = pt.dot(vx) / (this.engine_.getViewHeight() / (double)this.getHeight());
            double yOff = pt.dot(vy) / (this.engine_.getViewHeight() / (double)this.getHeight());
            if (type == 0) {
                path2d.moveTo((float)((double)halfw + xOff), (float)((double)halfh + yOff));
            } else {
                path2d.lineTo((float)((double)halfw + xOff), (float)((double)halfh + yOff));
            }
            pathIt.next();
        }
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(BOX_COLOR);
        g2d.setStroke(BOX_STROKE);
        g2d.draw(path2d);
    }

    @Override
    public boolean contains(int x2, int y2) {
        return false;
    }

    public VolumeProjectionPlane(T3DCapable engine) {
        this.engine_ = engine;
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
    }
}

