/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.terra.jami.j3d.VoxelCombiner;

public class LinearVoxelCombiner
implements VoxelCombiner {
    static final short BACKGROUNDVALUE = -2000;
    private short[] clipping = new short[]{0, 4096};
    private double[] weights = new double[]{1.0};
    private int numinputs = 1;
    private double rSlope = 1.0;
    private double rIntercept = 0.0;

    public LinearVoxelCombiner(double rescaleSlope, double rescaleIntercept) {
        this.rIntercept = rescaleIntercept;
        this.rSlope = rescaleSlope;
    }

    @Override
    public void setNumberOfThreads(int numThreads) {
    }

    @Override
    public double getRescaleSlope() {
        return this.rSlope;
    }

    @Override
    public double getRescaleIntercept() {
        return this.rIntercept;
    }

    @Override
    public void setData(Object data) {
        Params p2 = (Params)data;
        this.weights = p2.weights;
        this.clipping = p2.clipping;
        this.numinputs = p2.weights.length;
    }

    @Override
    public void combine(int threadNo, short[] resultBuffer, short[][] srcBuffer, int srcOffset, int destOffset, int skipSrc, int skipDest, int num) {
        for (int i2 = 0; i2 < num; ++i2) {
            int srcI = i2 * skipSrc + srcOffset;
            int destI = i2 * skipDest + destOffset;
            double sum = 0.0;
            for (int v2 = this.numinputs - 1; v2 >= 0; --v2) {
                short value = srcBuffer[v2][srcI];
                if (value <= -2000) {
                    sum = -2000.0;
                    break;
                }
                sum += (double)value * this.weights[v2];
            }
            if (sum == -2000.0) {
                resultBuffer[destI] = -2000;
                continue;
            }
            short val = (short)(sum + 0.5);
            if (val < this.clipping[0]) {
                val = this.clipping[0];
            } else if (val > this.clipping[1]) {
                val = this.clipping[1];
            }
            resultBuffer[destI] = val;
        }
    }

    public static class Params {
        public double[] weights = null;
        public short[] clipping = null;
    }
}

