/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.j3d.mpr.thickmpr;
import com.ge.med.terra.jami.render.Bicubic;
import com.ge.med.terra.jami.render.Bilinear;
import java.util.Arrays;

public class majoraxisThickmpr
extends thickmpr {
    private static final int NCPUS = ParallelTaskManager.getNumCPU();
    private JnAffineTransform at = new JnAffineTransform();
    private JnAffineTransform inv_at = new JnAffineTransform();
    private short[] outbuff = null;
    private int[] avgbuff = null;
    private double[] img2display = new double[6];
    private double[] display2img = new double[6];
    private int viewdir = 0;
    private int slice_start = 0;
    private int slice_end = 0;
    private int slice_center = 0;
    private Bicubic bicubic = new Bicubic();
    private Bilinear bilinear = new Bilinear();
    private XpGeomUtils gu = new XpGeomUtils();
    private short[][] temp_yz = new short[NCPUS][];

    @Override
    public void setView(double[] lookpt, double[] xstep, double[] ystep, double[] zstep, double nsteps, int w2, int h2, int dx, int dy, int dz, int interpolation, int nocontentPix) {
        super.setView(lookpt, xstep, ystep, zstep, nsteps, w2, h2, dx, dy, dz, interpolation, nocontentPix);
        int len = w2 * h2;
        if (this.outbuff == null || this.outbuff.length < len) {
            this.outbuff = new short[len];
            this.avgbuff = new int[len];
        }
        double half_nsteps = nsteps * 0.5;
        double[] dotvec = new double[]{Math.abs(JnVector3d.dot(zstep, new double[]{1.0, 0.0, 0.0})), Math.abs(JnVector3d.dot(zstep, new double[]{0.0, 1.0, 0.0})), Math.abs(JnVector3d.dot(zstep, new double[]{0.0, 0.0, 1.0}))};
        this.viewdir = dotvec[0] > dotvec[1] ? 0 : 1;
        this.viewdir = dotvec[2] > dotvec[this.viewdir] ? 2 : this.viewdir;
        double x_ul = majoraxisThickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx) - half_nsteps * zstep[0];
        double y_ul = majoraxisThickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy) - half_nsteps * zstep[1];
        double z_ul = majoraxisThickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz) - half_nsteps * zstep[2];
        double x1_ul = majoraxisThickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx) + half_nsteps * zstep[0];
        double y1_ul = majoraxisThickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy) + half_nsteps * zstep[1];
        double z1_ul = majoraxisThickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz) + half_nsteps * zstep[2];
        int nslices = 0;
        switch (this.viewdir) {
            case 0: {
                this.at.setTransform(xstep[1], xstep[2], ystep[1], ystep[2], y_ul, z_ul);
                double xx0 = Math.min(x_ul, x1_ul);
                double xx1 = Math.max(x_ul, x1_ul);
                this.slice_start = (int)Math.ceil(xx0);
                this.slice_center = (int)((xx1 + xx0) * 0.5);
                this.slice_end = (int)xx1;
                nslices = dx;
                break;
            }
            case 1: {
                this.at.setTransform(xstep[0], xstep[2], ystep[0], ystep[2], x_ul, z_ul);
                double yy0 = Math.min(y_ul, y1_ul);
                double yy1 = Math.max(y_ul, y1_ul);
                this.slice_start = (int)Math.ceil(yy0);
                this.slice_center = (int)((yy1 + yy0) * 0.5);
                this.slice_end = (int)yy1;
                nslices = dy;
                break;
            }
            case 2: {
                this.at.setTransform(xstep[0], xstep[1], ystep[0], ystep[1], x_ul, y_ul);
                double zz0 = Math.min(z_ul, z1_ul);
                double zz1 = Math.max(z_ul, z1_ul);
                this.slice_start = (int)Math.ceil(zz0);
                this.slice_center = (int)((zz1 + zz0) * 0.5);
                this.slice_end = (int)zz1;
                nslices = dz;
            }
        }
        if (this.slice_start > this.slice_end) {
            int temp = this.slice_start;
            this.slice_start = this.slice_end;
            this.slice_end = temp;
        }
        if (this.slice_start < 0 && this.slice_end < 0 || this.slice_start >= nslices && this.slice_end >= nslices) {
            this.slice_start = 88888;
            this.slice_end = -88888;
        } else {
            this.slice_start = Math.min(Math.max(0, this.slice_start), nslices - 1);
            this.slice_end = Math.min(Math.max(0, this.slice_end), nslices - 1);
        }
        this.at.getMatrix(this.display2img);
        this.gu.calcInverse(this.at, this.inv_at);
        this.inv_at.getMatrix(this.img2display);
        Arrays.fill(this.outbuff, (short)nocontentPix);
        int yzlen = dy * dz;
        for (int i2 = 0; i2 < this.temp_yz.length; ++i2) {
            if (this.temp_yz[i2] != null && this.temp_yz[i2].length == yzlen) continue;
            this.temp_yz[i2] = new short[yzlen];
        }
    }

    public int getSliceStart() {
        return this.slice_start;
    }

    public int getSliceEnd() {
        return this.slice_end;
    }

    public int getSliceCenter() {
        return this.slice_center;
    }

    public double[] getImage2Display() {
        return this.img2display;
    }

    public double[] getDisplay2Image() {
        return this.display2img;
    }

    public int getViewDir() {
        return this.viewdir;
    }

    public int getDepthStep(int x2, int y2) {
        int width = this.getWidth();
        int height = this.getHeight();
        double nsteps = this.getNumSteps();
        short[] depth_buffer = this.getDepthBuffer();
        if (x2 >= 0 && x2 < width && y2 >= 0 && y2 < height) {
            if (nsteps < 1.5) {
                return 0;
            }
            return depth_buffer[y2 * width + x2];
        }
        return 8192;
    }

    public double[] getVolumeCoords(int x2, int y2, double[] volCoords) {
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int width = this.getWidth();
        int height = this.getHeight();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int depth_step = this.getDepthStep(x2, y2);
        if (depth_step == 8192) {
            return null;
        }
        if (volCoords == null) {
            volCoords = new double[3];
        }
        double X = majoraxisThickmpr.getViewStartCoord(0, width, height, lookpt, xstep, ystep, dx) + (double)x2 * xstep[0] + (double)y2 * ystep[0] + zstep[0] * (double)depth_step;
        double Y = majoraxisThickmpr.getViewStartCoord(1, width, height, lookpt, xstep, ystep, dy) + (double)x2 * xstep[1] + (double)y2 * ystep[1] + zstep[1] * (double)depth_step;
        double Z = majoraxisThickmpr.getViewStartCoord(2, width, height, lookpt, xstep, ystep, dz) + (double)x2 * xstep[2] + (double)y2 * ystep[2] + zstep[2] * (double)depth_step;
        volCoords[0] = X;
        volCoords[1] = Y;
        volCoords[2] = Z;
        return volCoords;
    }

    protected static void copyraster(short[] src, short[] dest, short[] depth_buffer, int depthVal, int w2, int h2, int x0, int y0, int x1, int y1, int xstep, int ystep) {
        y1 = Math.min(y1, h2);
        x1 = Math.min(x1, w2);
        short dval = (short)depthVal;
        for (int y2 = y0; y2 < y1; y2 += ystep) {
            int offset = y2 * w2;
            for (int x2 = x0; x2 < x1; x2 += xstep) {
                int idx = offset + x2;
                dest[idx] = src[idx];
                depth_buffer[idx] = dval;
            }
        }
    }

    protected static void fillraster(int[] accumbuff, short[] depth_buffer, int depthVal, int w2, int h2, int x0, int y0, int x1, int y1, int xstep, int ystep, int val) {
        y1 = Math.min(y1, h2);
        x1 = Math.min(x1, w2);
        short dval = (short)depthVal;
        for (int y2 = y0; y2 < y1; y2 += ystep) {
            int offset = y2 * w2;
            for (int x2 = x0; x2 < x1; x2 += xstep) {
                int idx = offset + x2;
                accumbuff[idx] = val;
                depth_buffer[idx] = dval;
            }
        }
    }

    protected static void scaleraster(short[] buff, int[] accumbuff, int w2, int h2, int x0, int y0, int x1, int y1, int xstep, int ystep, double scale) {
        y1 = Math.min(y1, h2);
        x1 = Math.min(x1, w2);
        for (int y2 = y0; y2 < y1; y2 += ystep) {
            int offset = y2 * w2;
            for (int x2 = x0; x2 < x1; x2 += xstep) {
                int idx = offset + x2;
                buff[idx] = (short)((double)accumbuff[idx] * scale);
            }
        }
    }

    protected static void avgraster(short[] buff, int[] accumbuff, int w2, int h2, int x0, int y0, int x1, int y1, int xstep, int ystep) {
        y1 = Math.min(y1, h2);
        x1 = Math.min(x1, w2);
        for (int y2 = y0; y2 < y1; y2 += ystep) {
            int offset = y2 * w2;
            for (int x2 = x0; x2 < x1; x2 += xstep) {
                int idx;
                int n2 = idx = offset + x2;
                accumbuff[n2] = accumbuff[n2] + buff[idx];
            }
        }
    }

    protected static void mipraster(short[] buff, short[] accumbuff, short[] depth_buffer, int depthVal, int w2, int h2, int x0, int y0, int x1, int y1, int xstep, int ystep) {
        y1 = Math.min(y1, h2);
        x1 = Math.min(x1, w2);
        short dval = (short)depthVal;
        for (int y2 = y0; y2 < y1; y2 += ystep) {
            int offset = y2 * w2;
            for (int x2 = x0; x2 < x1; x2 += xstep) {
                int idx = offset + x2;
                if (buff[idx] <= accumbuff[idx]) continue;
                accumbuff[idx] = buff[idx];
                depth_buffer[idx] = dval;
            }
        }
    }

    protected static void minipraster(short[] buff, short[] accumbuff, short[] depth_buffer, int depthVal, int w2, int h2, int x0, int y0, int x1, int y1, int xstep, int ystep) {
        y1 = Math.min(y1, h2);
        x1 = Math.min(x1, w2);
        short dval = (short)depthVal;
        for (int y2 = y0; y2 < y1; y2 += ystep) {
            int offset = y2 * w2;
            for (int x2 = x0; x2 < x1; x2 += xstep) {
                int idx = offset + x2;
                if (buff[idx] >= accumbuff[idx]) continue;
                accumbuff[idx] = buff[idx];
                depth_buffer[idx] = dval;
            }
        }
    }

    protected static void fillYZ_plane(short[] vol, int vol_offset, int dx, int dy, int dz, short[] tbuff, int xslice) {
        int pgsize = dx * dy;
        for (int z2 = 0; z2 < dz; ++z2) {
            int buffoffset = z2 * dy;
            int offset = vol_offset + z2 * pgsize;
            for (int y2 = 0; y2 < dy; ++y2) {
                int idx = offset + y2 * dx + xslice;
                tbuff[buffoffset + y2] = vol[idx];
            }
        }
    }

    private void bicubic_mip(int worker_id, int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int yzplane = worker_id;
        short[] depthBuff = this.getDepthBuffer();
        switch (this.viewdir) {
            case 0: {
                for (int i2 = this.slice_start; i2 <= this.slice_end; ++i2) {
                    majoraxisThickmpr.fillYZ_plane(vol, vol_offset, dx, dy, dz, this.temp_yz[yzplane], i2);
                    this.bicubic.shortToshort(this.img2display, this.display2img, this.temp_yz[yzplane], 0, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i2 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.mipraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 1: {
                for (int i3 = this.slice_start; i3 <= this.slice_end; ++i3) {
                    int xzoffset = vol_offset + i3 * dx;
                    this.bicubic.shortToshortXZ(this.img2display, this.display2img, vol, xzoffset, dx, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i3 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.mipraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 2: {
                for (int i4 = this.slice_start; i4 <= this.slice_end; ++i4) {
                    this.bicubic.shortToshort(this.img2display, this.display2img, vol, vol_offset + i4 * dx * dy, dx, dy, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i4 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.mipraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
        }
    }

    private void bicubic_minip(int worker_id, int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int yzplane = worker_id;
        short[] depthBuff = this.getDepthBuffer();
        switch (this.viewdir) {
            case 0: {
                for (int i2 = this.slice_start; i2 <= this.slice_end; ++i2) {
                    majoraxisThickmpr.fillYZ_plane(vol, vol_offset, dx, dy, dz, this.temp_yz[yzplane], i2);
                    this.bicubic.shortToshort(this.img2display, this.display2img, this.temp_yz[yzplane], 0, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i2 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.minipraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 1: {
                for (int i3 = this.slice_start; i3 <= this.slice_end; ++i3) {
                    int xzoffset = vol_offset + i3 * dx;
                    this.bicubic.shortToshortXZ(this.img2display, this.display2img, vol, xzoffset, dx, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i3 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.minipraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 2: {
                for (int i4 = this.slice_start; i4 <= this.slice_end; ++i4) {
                    this.bicubic.shortToshort(this.img2display, this.display2img, vol, vol_offset + i4 * dx * dy, dx, dy, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i4 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.minipraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
        }
    }

    private void bicubic_average(int worker_id, int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int yzplane = worker_id;
        short[] depthBuff = this.getDepthBuffer();
        majoraxisThickmpr.fillraster(this.avgbuff, depthBuff, 0, w2, h2, x0, y0, x1, y1, xskip, yskip, 0);
        switch (this.viewdir) {
            case 0: {
                for (int i2 = this.slice_start; i2 <= this.slice_end; ++i2) {
                    majoraxisThickmpr.fillYZ_plane(vol, vol_offset, dx, dy, dz, this.temp_yz[yzplane], i2);
                    this.bicubic.shortToshort(this.img2display, this.display2img, this.temp_yz[yzplane], 0, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    majoraxisThickmpr.avgraster(this.outbuff, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 1: {
                for (int i3 = this.slice_start; i3 <= this.slice_end; ++i3) {
                    int xzoffset = vol_offset + i3 * dx;
                    this.bicubic.shortToshortXZ(this.img2display, this.display2img, vol, xzoffset, dx, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    majoraxisThickmpr.avgraster(this.outbuff, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 2: {
                for (int i4 = this.slice_start; i4 <= this.slice_end; ++i4) {
                    this.bicubic.shortToshort(this.img2display, this.display2img, vol, vol_offset + i4 * dx * dy, dx, dy, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    majoraxisThickmpr.avgraster(this.outbuff, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
        }
        majoraxisThickmpr.scaleraster(img, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip, 1.0 / (double)(this.slice_end - this.slice_start + 1));
    }

    private void bilinear_mip(int worker_id, int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int yzplane = worker_id;
        short[] depthBuff = this.getDepthBuffer();
        switch (this.viewdir) {
            case 0: {
                for (int i2 = this.slice_start; i2 <= this.slice_end; ++i2) {
                    majoraxisThickmpr.fillYZ_plane(vol, vol_offset, dx, dy, dz, this.temp_yz[yzplane], i2);
                    this.bilinear.shortToshort(this.img2display, this.display2img, this.temp_yz[yzplane], 0, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i2 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.mipraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 1: {
                for (int i3 = this.slice_start; i3 <= this.slice_end; ++i3) {
                    int xzoffset = vol_offset + i3 * dx;
                    this.bilinear.shortToshortXZ(this.img2display, this.display2img, vol, xzoffset, dx, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i3 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.mipraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 2: {
                for (int i4 = this.slice_start; i4 <= this.slice_end; ++i4) {
                    this.bilinear.shortToshort(this.img2display, this.display2img, vol, vol_offset + i4 * dx * dy, dx, dy, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i4 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.mipraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
        }
    }

    private void bilinear_minip(int worker_id, int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int yzplane = worker_id;
        short[] depthBuff = this.getDepthBuffer();
        switch (this.viewdir) {
            case 0: {
                for (int i2 = this.slice_start; i2 <= this.slice_end; ++i2) {
                    majoraxisThickmpr.fillYZ_plane(vol, vol_offset, dx, dy, dz, this.temp_yz[yzplane], i2);
                    this.bilinear.shortToshort(this.img2display, this.display2img, this.temp_yz[yzplane], 0, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i2 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.minipraster(this.outbuff, img, depthBuff, i2 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 1: {
                for (int i3 = this.slice_start; i3 <= this.slice_end; ++i3) {
                    int xzoffset = vol_offset + i3 * dx;
                    this.bilinear.shortToshortXZ(this.img2display, this.display2img, vol, xzoffset, dx, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i3 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.minipraster(this.outbuff, img, depthBuff, i3 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 2: {
                for (int i4 = this.slice_start; i4 <= this.slice_end; ++i4) {
                    this.bilinear.shortToshort(this.img2display, this.display2img, vol, vol_offset + i4 * dx * dy, dx, dy, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    if (i4 == this.slice_start) {
                        majoraxisThickmpr.copyraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                        continue;
                    }
                    majoraxisThickmpr.minipraster(this.outbuff, img, depthBuff, i4 - this.slice_center, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
        }
    }

    private void bilinear_average(int worker_id, int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int yzplane = worker_id;
        short[] depthBuff = this.getDepthBuffer();
        majoraxisThickmpr.fillraster(this.avgbuff, depthBuff, 0, w2, h2, x0, y0, x1, y1, xskip, yskip, 0);
        switch (this.viewdir) {
            case 0: {
                for (int i2 = this.slice_start; i2 <= this.slice_end; ++i2) {
                    majoraxisThickmpr.fillYZ_plane(vol, vol_offset, dx, dy, dz, this.temp_yz[yzplane], i2);
                    this.bilinear.shortToshort(this.img2display, this.display2img, this.temp_yz[yzplane], 0, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    majoraxisThickmpr.avgraster(this.outbuff, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 1: {
                for (int i3 = this.slice_start; i3 <= this.slice_end; ++i3) {
                    int xzoffset = vol_offset + i3 * dx;
                    this.bilinear.shortToshortXZ(this.img2display, this.display2img, vol, xzoffset, dx, dy, dz, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    majoraxisThickmpr.avgraster(this.outbuff, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
            case 2: {
                for (int i4 = this.slice_start; i4 <= this.slice_end; ++i4) {
                    this.bilinear.shortToshort(this.img2display, this.display2img, vol, vol_offset + i4 * dx * dy, dx, dy, this.outbuff, w2, h2, x0, y0, x1 - x0, y1 - y0, xskip, yskip);
                    majoraxisThickmpr.avgraster(this.outbuff, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip);
                }
                break;
            }
        }
        majoraxisThickmpr.scaleraster(img, this.avgbuff, w2, h2, x0, y0, x1, y1, xskip, yskip, 1.0 / (double)(this.slice_end - this.slice_start + 1));
    }

    public void ma_mip(int worker_id, int x0, int y0, int width, int height, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        boolean majorAxisMode = this.isMajorAxisView();
        int interpolation = this.getInterpolation();
        int x1 = Math.min(x0 + width, w2);
        int y1 = Math.min(y0 + height, h2);
        if (majorAxisMode) {
            if (interpolation == 2) {
                this.bicubic_mip(worker_id, x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w2, h2);
            } else {
                this.bilinear_mip(worker_id, x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w2, h2);
            }
        } else {
            this.thick_mip(x0, y0, width, height, xskip, yskip, vol, null, vol_offset, img, null, w2, h2);
        }
    }

    public void ma_minip(int worker_id, int x0, int y0, int width, int height, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        boolean majorAxisMode = this.isMajorAxisView();
        int interpolation = this.getInterpolation();
        int x1 = Math.min(x0 + width, w2);
        int y1 = Math.min(y0 + height, h2);
        if (majorAxisMode) {
            if (interpolation == 2) {
                this.bicubic_minip(worker_id, x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w2, h2);
            } else {
                this.bilinear_minip(worker_id, x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w2, h2);
            }
        } else {
            this.thick_minip(x0, y0, width, height, xskip, yskip, vol, null, vol_offset, img, null, w2, h2);
        }
    }

    public void ma_avg(int worker_id, int x0, int y0, int width, int height, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        boolean majorAxisMode = this.isMajorAxisView();
        int interpolation = this.getInterpolation();
        int x1 = Math.min(x0 + width, w2);
        int y1 = Math.min(y0 + height, h2);
        if (majorAxisMode) {
            if (interpolation == 2) {
                this.bicubic_average(worker_id, x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w2, h2);
            } else {
                this.bilinear_average(worker_id, x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w2, h2);
            }
        } else {
            this.thick_avg(x0, y0, width, height, xskip, yskip, vol, null, vol_offset, img, null, w2, h2);
        }
    }

    protected short[] getOutBuff() {
        return this.outbuff;
    }

    protected int[] getAvgBuff() {
        return this.avgbuff;
    }

    protected short[][] getTempYZ() {
        return this.temp_yz;
    }
}

