/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.RayBox;
import com.ge.med.terra.jami.j3d.mpr.mpr;
import java.util.Arrays;

public class thickmpr
extends mpr {
    private RayBox rb = new RayBox();
    private JnVector3d delta_x = new JnVector3d();
    private JnVector3d delta_y = new JnVector3d();
    private JnVector3d rowPt = new JnVector3d();
    private JnVector3d startPt = new JnVector3d();
    private int ystart = 0;
    private int yend = 0;
    private int[] xstart_arr = null;
    private int[] xend_arr = null;
    private short[] t0_raster = null;
    private short[] t1_raster = null;
    private short[] depth_buffer = null;
    private static final int AVG_EDGE = 0;
    private static final int MIP_EDGE = 1;
    private static final int MINIP_EDGE = 2;

    @Override
    public void setView(double[] lookpt, double[] xstep, double[] ystep, double[] zstep, double nsteps, int w2, int h2, int dx, int dy, int dz, int interpolation, int nocontentPix) {
        super.setView(lookpt, xstep, ystep, zstep, nsteps, w2, h2, dx, dy, dz, interpolation, nocontentPix);
        if (nsteps >= 1.5) {
            boolean majorAxisMode;
            int len = w2 * h2;
            if (this.xstart_arr == null || this.xstart_arr.length < h2) {
                this.xstart_arr = new int[h2];
                this.xend_arr = new int[h2];
            }
            if (this.t0_raster == null || this.t0_raster.length < len) {
                this.t0_raster = new short[w2 * h2];
                this.t1_raster = new short[w2 * h2];
            }
            int xy_scooch = (majorAxisMode = this.isMajorAxisView()) ? 1 : 2;
            Arrays.fill(this.t0_raster, (short)-32766);
            Arrays.fill(this.t1_raster, (short)-32766);
            Arrays.fill(this.xstart_arr, 9999);
            Arrays.fill(this.xend_arr, -9999);
            this.ystart = 9999;
            this.yend = -9999;
            JnVector3d minb = new JnVector3d();
            JnVector3d maxb = new JnVector3d();
            minb.set(0.0, 0.0, 0.0);
            maxb.set(dx - xy_scooch, dy - xy_scooch, (double)dz - 0.5);
            this.delta_x.set(xstep);
            this.delta_y.set(ystep);
            double sX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
            double sY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
            double sZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
            this.rowPt.set(sX, sY, sZ);
            int[] tidx = new int[2];
            double i_nsteps = Math.ceil(nsteps);
            double half_nsteps = (i_nsteps - 1.0) * 0.5;
            for (int i2 = 0; i2 < h2; ++i2) {
                int yoffset = i2 * w2;
                double z2 = -half_nsteps;
                int zidx = 0;
                while ((double)zidx < i_nsteps) {
                    double startX = this.rowPt.x + z2 * zstep[0];
                    double startY = this.rowPt.y + z2 * zstep[1];
                    double startZ = this.rowPt.z + z2 * zstep[2];
                    this.startPt.set(startX, startY, startZ);
                    boolean hit = this.rb.hitScanLine(minb, maxb, this.startPt, this.delta_x, w2, tidx);
                    int t0 = tidx[0];
                    int t1 = tidx[1];
                    if (hit && t0 < t1) {
                        int ridx0 = yoffset + t0;
                        int ridx1 = yoffset + t1;
                        Arrays.fill(this.t1_raster, ridx0, ridx1, (short)z2);
                        for (int ii = ridx0; ii <= ridx1; ++ii) {
                            if (this.t0_raster[ii] >= -30000) continue;
                            this.t0_raster[ii] = (short)z2;
                        }
                        if (this.yend < i2) {
                            this.yend = i2;
                        }
                        if (this.ystart > i2) {
                            this.ystart = i2;
                        }
                        if (t0 < this.xstart_arr[i2]) {
                            this.xstart_arr[i2] = t0;
                        }
                        if (t1 > this.xend_arr[i2]) {
                            this.xend_arr[i2] = t1;
                        }
                    }
                    ++zidx;
                    z2 += 1.0;
                }
                this.rowPt.add(this.delta_y);
            }
        }
    }

    protected int[] getXStartArray() {
        return this.xstart_arr;
    }

    protected int[] getXEndArray() {
        return this.xend_arr;
    }

    protected short[] getT0Raster() {
        return this.t0_raster;
    }

    protected short[] getT1Raster() {
        return this.t1_raster;
    }

    public void setDepthBuffer(short[] dbuffer) {
        this.depth_buffer = dbuffer;
    }

    public short[] getDepthBuffer() {
        return this.depth_buffer;
    }

    public int castray_thickmip_tl(int x0, int y0, short[] vol, byte[] seggrid, int vol_offset, int w2, int h2) {
        if (seggrid != null) {
            return this.cray_thickmip_tl(x0, y0, vol, seggrid, vol_offset, w2, h2);
        }
        return this.cray_thickmip_tl(x0, y0, vol, vol_offset, w2, h2);
    }

    private int cray_thickmip_tl(int x0, int y0, short[] vol, int vol_offset, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        if (y0 > this.yend - 1) {
            return nocontentPixel;
        }
        if (y0 < this.ystart + 1) {
            return nocontentPixel;
        }
        if (x0 < this.xstart_arr[y0] + 1) {
            return nocontentPixel;
        }
        if (x0 > this.xend_arr[y0] - 1) {
            return nocontentPixel;
        }
        int mval = nocontentPixel;
        short khit = 8192;
        int width = this.getWidth();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int izstep_stride_x = (int)(zstep[0] * 32768.0);
        int izstep_stride_y = (int)(zstep[1] * 32768.0);
        int izstep_stride_z = (int)(zstep[2] * 32768.0);
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx) + (double)x0 * xstep[0] + (double)y0 * ystep[0];
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy) + (double)x0 * xstep[1] + (double)y0 * ystep[1];
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz) + (double)x0 * xstep[2] + (double)y0 * ystep[2];
            int rix = (int)(startX * 32768.0);
            int riy = (int)(startY * 32768.0);
            int riz = (int)(startZ * 32768.0);
            int yoffset = y0 * w2;
            short t0 = this.t0_raster[yoffset + x0];
            short t1 = this.t1_raster[yoffset + x0];
            int jix = rix + t0 * izstep_x;
            int jiy = riy + t0 * izstep_y;
            int jiz = riz + t0 * izstep_z;
            for (short k2 = t0; k2 <= t1; ++k2) {
                iz = jiz >> 15;
                int poffset0 = vol_offset + iz * psize;
                iy = jiy >> 15;
                int roffset0 = iy * dx;
                ix = jix >> 15;
                short voxel0 = vol[poffset0 + roffset0 + ix];
                short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                int frac0_x = jix & Short.MAX_VALUE;
                int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                int roffset1 = roffset0 + dx;
                short voxel2 = vol[poffset0 + roffset1 + ix];
                short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                int frac0_y = jiy & Short.MAX_VALUE;
                int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                int poffset1 = poffset0 + psize;
                short voxel4 = vol[poffset1 + roffset0 + ix];
                short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                short voxel6 = vol[poffset1 + roffset1 + ix];
                short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                int frac0_z = jiz & Short.MAX_VALUE;
                int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                if (voxel > mval) {
                    mval = voxel;
                    khit = k2;
                }
                jix += izstep_stride_x;
                jiy += izstep_stride_y;
                jiz += izstep_stride_z;
            }
            this.depth_buffer[y0 * width + x0] = khit;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("cray_thickmip_tl[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "] x0=" + x0 + " y0=" + y0);
        }
        return mval;
    }

    private int cray_thickmip_tl(int x0, int y0, short[] vol, byte[] seggrid, int vol_offset, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        if (y0 > this.yend - 1) {
            return nocontentPixel;
        }
        if (y0 < this.ystart + 1) {
            return nocontentPixel;
        }
        if (x0 < this.xstart_arr[y0] + 1) {
            return nocontentPixel;
        }
        if (x0 > this.xend_arr[y0] - 1) {
            return nocontentPixel;
        }
        int mval = nocontentPixel;
        short khit = 8192;
        int width = this.getWidth();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int izstep_stride_x = (int)(zstep[0] * 32768.0);
        int izstep_stride_y = (int)(zstep[1] * 32768.0);
        int izstep_stride_z = (int)(zstep[2] * 32768.0);
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx) + (double)x0 * xstep[0] + (double)y0 * ystep[0];
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy) + (double)x0 * xstep[1] + (double)y0 * ystep[1];
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz) + (double)x0 * xstep[2] + (double)y0 * ystep[2];
            int rix = (int)(startX * 32768.0);
            int riy = (int)(startY * 32768.0);
            int riz = (int)(startZ * 32768.0);
            int yoffset = y0 * w2;
            short t0 = this.t0_raster[yoffset + x0];
            short t1 = this.t1_raster[yoffset + x0];
            int jix = rix + t0 * izstep_x;
            int jiy = riy + t0 * izstep_y;
            int jiz = riz + t0 * izstep_z;
            for (short k2 = t0; k2 <= t1; ++k2) {
                short voxel7;
                short voxel6;
                int voxel_z1_x2;
                short voxel5;
                short voxel4;
                int voxel_z1_x1;
                int voxel_z1;
                short voxel3;
                short voxel2;
                int voxel_z0_x2;
                short voxel1;
                short voxel0;
                int voxel_z0_x1;
                int voxel_z0;
                int voxel;
                int frac0_x = jix & Short.MAX_VALUE;
                int frac0_y = jiy & Short.MAX_VALUE;
                int frac0_z = jiz & Short.MAX_VALUE;
                ix = jix >> 15;
                iy = jiy >> 15;
                iz = jiz >> 15;
                int bpoffset = iz * psize;
                int poffset0 = vol_offset + bpoffset;
                int roffset0 = iy * dx;
                int roffset1 = roffset0 + dx;
                int poffset1 = poffset0 + psize;
                int vidx = bpoffset + roffset0 + ix;
                int bidx = vidx >> 3;
                int bmod = vidx % 8;
                if ((seggrid[bidx] & 1 << bmod) != 0 && (voxel = (voxel_z0 = (voxel_z0_x1 = (voxel0 = vol[poffset0 + roffset0 + ix]) + (((voxel1 = vol[poffset0 + roffset0 + ix + 1]) - voxel0) * frac0_x >> 15)) + (((voxel_z0_x2 = (voxel2 = vol[poffset0 + roffset1 + ix]) + (((voxel3 = vol[poffset0 + roffset1 + ix + 1]) - voxel2) * frac0_x >> 15)) - voxel_z0_x1) * frac0_y >> 15)) + (((voxel_z1 = (voxel_z1_x1 = (voxel4 = vol[poffset1 + roffset0 + ix]) + (((voxel5 = vol[poffset1 + roffset0 + ix + 1]) - voxel4) * frac0_x >> 15)) + (((voxel_z1_x2 = (voxel6 = vol[poffset1 + roffset1 + ix]) + (((voxel7 = vol[poffset1 + roffset1 + ix + 1]) - voxel6) * frac0_x >> 15)) - voxel_z1_x1) * frac0_y >> 15)) - voxel_z0) * frac0_z >> 15)) > mval) {
                    mval = voxel;
                    khit = k2;
                }
                jix += izstep_stride_x;
                jiy += izstep_stride_y;
                jiz += izstep_stride_z;
            }
            this.depth_buffer[y0 * width + x0] = khit;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("cray_thickmip_tl[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "] x0=" + x0 + " y0=" + y0);
        }
        return mval;
    }

    private static int startval(int val, int vstart, int modval) {
        int v2;
        for (v2 = val; v2 < vstart + 1; v2 += modval) {
        }
        return v2;
    }

    private void castrays_thickmip_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, byte[] seggrid, int vol_offset, short[] img, int w2, int h2) {
        if (seggrid != null) {
            this.thickmip_tl(x0, y0, x1, y1, xskip, yskip, vol, seggrid, vol_offset, img, w2, h2);
        } else {
            this.thickmip_tl(x0, y0, x1, y1, xskip, yskip, vol, vol_offset, img, w2, h2);
        }
    }

    public void thickmip_pixel_tl(int x0, int y0, short[] vol, int vol_offset, short[] imgval, short[] depthval, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
            double sample_x = startX + xstep[0] * (double)x0 + ystep[0] * (double)y0;
            double sample_y = startY + xstep[1] * (double)x0 + ystep[1] * (double)y0;
            double sample_z = startZ + xstep[2] * (double)x0 + ystep[2] * (double)y0;
            int six = (int)(sample_x * 32768.0);
            int siy = (int)(sample_y * 32768.0);
            int siz = (int)(sample_z * 32768.0);
            int yoffset = y0 * w2;
            short t0 = this.t0_raster[yoffset + x0];
            short t1 = this.t1_raster[yoffset + x0];
            int mval = nocontentPixel;
            int jix = six + t0 * izstep_x;
            int jiy = siy + t0 * izstep_y;
            int jiz = siz + t0 * izstep_z;
            short khit = 8192;
            for (short k2 = t0; k2 <= t1; ++k2) {
                iz = jiz >> 15;
                int poffset0 = vol_offset + iz * psize;
                iy = jiy >> 15;
                int roffset0 = iy * dx;
                ix = jix >> 15;
                short voxel0 = vol[poffset0 + roffset0 + ix];
                short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                int frac0_x = jix & Short.MAX_VALUE;
                int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                int roffset1 = roffset0 + dx;
                short voxel2 = vol[poffset0 + roffset1 + ix];
                short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                int frac0_y = jiy & Short.MAX_VALUE;
                int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                int poffset1 = poffset0 + psize;
                short voxel4 = vol[poffset1 + roffset0 + ix];
                short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                short voxel6 = vol[poffset1 + roffset1 + ix];
                short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                int frac0_z = jiz & Short.MAX_VALUE;
                int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                if (voxel > mval) {
                    mval = voxel;
                    khit = k2;
                }
                jix += izstep_x;
                jiy += izstep_y;
                jiz += izstep_z;
            }
            imgval[0] = (short)mval;
            depthval[0] = khit;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("castrays_thickmip[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    private void thickmip_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int izstep_stride_x = (int)(zstep[0] * 32768.0);
        int izstep_stride_y = (int)(zstep[1] * 32768.0);
        int izstep_stride_z = (int)(zstep[2] * 32768.0);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int psize = dx * dy;
        int ybegin = thickmpr.startval(y0, this.ystart, yskip);
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            int i2;
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (i2 = ybegin; i2 < this.yend; i2 += yskip) {
                int yoffset = i2 * w2;
                int xstart = thickmpr.startval(x0, this.xstart_arr[i2], xskip);
                int xend = this.xend_arr[i2];
                ylast = i2;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (int j2 = xstart; j2 < xend; j2 += xskip) {
                    short t0 = this.t0_raster[yoffset + j2];
                    short t1 = this.t1_raster[yoffset + j2];
                    int mval = nocontentPixel;
                    int jix = six + t0 * izstep_x;
                    int jiy = siy + t0 * izstep_y;
                    int jiz = siz + t0 * izstep_z;
                    short khit = 8192;
                    for (short k2 = t0; k2 <= t1; ++k2) {
                        iz = jiz >> 15;
                        int poffset0 = vol_offset + iz * psize;
                        iy = jiy >> 15;
                        int roffset0 = iy * dx;
                        ix = jix >> 15;
                        short voxel0 = vol[poffset0 + roffset0 + ix];
                        short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                        int frac0_x = jix & Short.MAX_VALUE;
                        int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                        int roffset1 = roffset0 + dx;
                        short voxel2 = vol[poffset0 + roffset1 + ix];
                        short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                        int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                        int frac0_y = jiy & Short.MAX_VALUE;
                        int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                        int poffset1 = poffset0 + psize;
                        short voxel4 = vol[poffset1 + roffset0 + ix];
                        short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                        int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                        short voxel6 = vol[poffset1 + roffset1 + ix];
                        short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                        int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                        int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                        int frac0_z = jiz & Short.MAX_VALUE;
                        int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                        if (voxel > mval) {
                            mval = voxel;
                            khit = k2;
                        }
                        jix += izstep_stride_x;
                        jiy += izstep_stride_y;
                        jiz += izstep_stride_z;
                    }
                    img[yoffset + j2] = (short)mval;
                    this.depth_buffer[yoffset + j2] = khit;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j2;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(vol, vol_offset, img, i2, w2, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, zstep, 1);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                for (i2 = ylast + yskip; i2 < h2 && (npix = this.fillLine(vol, vol_offset, img, i2, w2, x0, w2 - 1, xskip, startX, startY, startZ, xstep, ystep, zstep, 1)) > 0; i2 += yskip) {
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("castrays_thickmip[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    private void thickmip_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, byte[] seggrid, int vol_offset, short[] img, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int izstep_stride_x = (int)(zstep[0] * 32768.0);
        int izstep_stride_y = (int)(zstep[1] * 32768.0);
        int izstep_stride_z = (int)(zstep[2] * 32768.0);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            int i2;
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
            int ybegin = thickmpr.startval(y0, this.ystart, yskip);
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (i2 = ybegin; i2 < this.yend; i2 += yskip) {
                int yoffset = i2 * w2;
                int xstart = thickmpr.startval(x0, this.xstart_arr[i2], xskip);
                int xend = this.xend_arr[i2];
                ylast = i2;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (int j2 = xstart; j2 < xend; j2 += xskip) {
                    short t0 = this.t0_raster[yoffset + j2];
                    short t1 = this.t1_raster[yoffset + j2];
                    int mval = nocontentPixel;
                    int jix = six + t0 * izstep_x;
                    int jiy = siy + t0 * izstep_y;
                    int jiz = siz + t0 * izstep_z;
                    short khit = 8192;
                    for (short k2 = t0; k2 <= t1; ++k2) {
                        short voxel7;
                        short voxel6;
                        int voxel_z1_x2;
                        short voxel5;
                        short voxel4;
                        int voxel_z1_x1;
                        int voxel_z1;
                        short voxel3;
                        short voxel2;
                        int voxel_z0_x2;
                        short voxel1;
                        short voxel0;
                        int voxel_z0_x1;
                        int voxel_z0;
                        int voxel;
                        int frac0_x = jix & Short.MAX_VALUE;
                        int frac0_y = jiy & Short.MAX_VALUE;
                        int frac0_z = jiz & Short.MAX_VALUE;
                        ix = jix >> 15;
                        iy = jiy >> 15;
                        iz = jiz >> 15;
                        int bpoffset = iz * psize;
                        int poffset0 = vol_offset + bpoffset;
                        int roffset0 = iy * dx;
                        int roffset1 = roffset0 + dx;
                        int poffset1 = poffset0 + psize;
                        int vidx = bpoffset + roffset0 + ix;
                        int bidx = vidx >> 3;
                        int bmod = vidx % 8;
                        if ((seggrid[bidx] & 1 << bmod) != 0 && (voxel = (voxel_z0 = (voxel_z0_x1 = (voxel0 = vol[vidx]) + (((voxel1 = vol[vidx + 1]) - voxel0) * frac0_x >> 15)) + (((voxel_z0_x2 = (voxel2 = vol[poffset0 + roffset1 + ix]) + (((voxel3 = vol[poffset0 + roffset1 + ix + 1]) - voxel2) * frac0_x >> 15)) - voxel_z0_x1) * frac0_y >> 15)) + (((voxel_z1 = (voxel_z1_x1 = (voxel4 = vol[poffset1 + roffset0 + ix]) + (((voxel5 = vol[poffset1 + roffset0 + ix + 1]) - voxel4) * frac0_x >> 15)) + (((voxel_z1_x2 = (voxel6 = vol[poffset1 + roffset1 + ix]) + (((voxel7 = vol[poffset1 + roffset1 + ix + 1]) - voxel6) * frac0_x >> 15)) - voxel_z1_x1) * frac0_y >> 15)) - voxel_z0) * frac0_z >> 15)) > mval) {
                            mval = voxel;
                            khit = k2;
                        }
                        jix += izstep_stride_x;
                        jiy += izstep_stride_y;
                        jiz += izstep_stride_z;
                    }
                    img[yoffset + j2] = (short)mval;
                    this.depth_buffer[yoffset + j2] = khit;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j2;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(vol, vol_offset, img, i2, w2, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, zstep, 1);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                for (i2 = ylast + yskip; i2 < h2 && (npix = this.fillLine(vol, vol_offset, img, i2, w2, x0, w2 - 1, xskip, startX, startY, startZ, xstep, ystep, zstep, 1)) > 0; i2 += yskip) {
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("castrays_thickmip_seggrid[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    public int castray_thickminip_tl(int x0, int y0, short[] vol, int vol_offset, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        if (y0 > this.yend - 1) {
            return nocontentPixel;
        }
        if (y0 < this.ystart + 1) {
            return nocontentPixel;
        }
        if (x0 < this.xstart_arr[y0] + 1) {
            return nocontentPixel;
        }
        if (x0 > this.xend_arr[y0] - 1) {
            return nocontentPixel;
        }
        int mval = 9999;
        short khit = 8192;
        int width = this.getWidth();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx) + (double)x0 * xstep[0] + (double)y0 * ystep[0];
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy) + (double)x0 * xstep[1] + (double)y0 * ystep[1];
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz) + (double)x0 * xstep[2] + (double)y0 * ystep[2];
            int rix = (int)(startX * 32768.0);
            int riy = (int)(startY * 32768.0);
            int riz = (int)(startZ * 32768.0);
            int yoffset = y0 * w2;
            short t0 = this.t0_raster[yoffset + x0];
            short t1 = this.t1_raster[yoffset + x0];
            int T = t1 - t0;
            if (T > 0) {
                int jix = rix + t0 * izstep_x;
                int jiy = riy + t0 * izstep_y;
                int jiz = riz + t0 * izstep_z;
                for (short k2 = t0; k2 <= t1; ++k2) {
                    iz = jiz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    iy = jiy >> 15;
                    int roffset0 = iy * dx;
                    ix = jix >> 15;
                    short voxel0 = vol[poffset0 + roffset0 + ix];
                    short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                    int frac0_x = jix & Short.MAX_VALUE;
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int roffset1 = roffset0 + dx;
                    short voxel2 = vol[poffset0 + roffset1 + ix];
                    short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int frac0_y = jiy & Short.MAX_VALUE;
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int poffset1 = poffset0 + psize;
                    short voxel4 = vol[poffset1 + roffset0 + ix];
                    short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    short voxel6 = vol[poffset1 + roffset1 + ix];
                    short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int frac0_z = jiz & Short.MAX_VALUE;
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    if (voxel < mval) {
                        mval = voxel;
                        khit = k2;
                    }
                    jix += izstep_x;
                    jiy += izstep_y;
                    jiz += izstep_z;
                }
                this.depth_buffer[y0 * width + x0] = khit;
            } else {
                mval = nocontentPixel;
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("thickminip_castray[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "] x0=" + x0 + " y0=" + y0);
        }
        return mval;
    }

    public void thickminip_pixel_tl(int x0, int y0, short[] vol, int vol_offset, short[] imgval, short[] depthval, int w2, int h2) {
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
            double sample_x = startX + xstep[0] * (double)x0 + ystep[0] * (double)y0;
            double sample_y = startY + xstep[1] * (double)x0 + ystep[1] * (double)y0;
            double sample_z = startZ + xstep[2] * (double)x0 + ystep[2] * (double)y0;
            int six = (int)(sample_x * 32768.0);
            int siy = (int)(sample_y * 32768.0);
            int siz = (int)(sample_z * 32768.0);
            int yoffset = y0 * w2;
            short t0 = this.t0_raster[yoffset + x0];
            short t1 = this.t1_raster[yoffset + x0];
            int mval = 9999;
            int jix = six + t0 * izstep_x;
            int jiy = siy + t0 * izstep_y;
            int jiz = siz + t0 * izstep_z;
            short khit = 8192;
            for (short k2 = t0; k2 <= t1; ++k2) {
                iz = jiz >> 15;
                int poffset0 = vol_offset + iz * psize;
                iy = jiy >> 15;
                int roffset0 = iy * dx;
                ix = jix >> 15;
                short voxel0 = vol[poffset0 + roffset0 + ix];
                short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                int frac0_x = jix & Short.MAX_VALUE;
                int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                int roffset1 = roffset0 + dx;
                short voxel2 = vol[poffset0 + roffset1 + ix];
                short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                int frac0_y = jiy & Short.MAX_VALUE;
                int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                int poffset1 = poffset0 + psize;
                short voxel4 = vol[poffset1 + roffset0 + ix];
                short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                short voxel6 = vol[poffset1 + roffset1 + ix];
                short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                int frac0_z = jiz & Short.MAX_VALUE;
                int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                if (voxel < mval) {
                    mval = voxel;
                    khit = k2;
                }
                jix += izstep_x;
                jiy += izstep_y;
                jiz += izstep_z;
            }
            imgval[0] = (short)mval;
            depthval[0] = khit;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("castrays_thickminip[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    private void castrays_thickminip_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            int i2;
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
            int ybegin = thickmpr.startval(y0, this.ystart, yskip);
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (i2 = ybegin; i2 < this.yend; i2 += yskip) {
                int yoffset = i2 * w2;
                int xstart = thickmpr.startval(x0, this.xstart_arr[i2], xskip);
                int xend = this.xend_arr[i2];
                ylast = i2;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (int j2 = xstart; j2 < xend; j2 += xskip) {
                    short t0 = this.t0_raster[yoffset + j2];
                    short t1 = this.t1_raster[yoffset + j2];
                    int mval = 9999;
                    int T = t1 - t0;
                    short khit = 8192;
                    if (T > 0) {
                        int jix = six + t0 * izstep_x;
                        int jiy = siy + t0 * izstep_y;
                        int jiz = siz + t0 * izstep_z;
                        for (short k2 = t0; k2 <= t1; ++k2) {
                            iz = jiz >> 15;
                            int poffset0 = vol_offset + iz * psize;
                            iy = jiy >> 15;
                            int roffset0 = iy * dx;
                            ix = jix >> 15;
                            short voxel0 = vol[poffset0 + roffset0 + ix];
                            short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                            int frac0_x = jix & Short.MAX_VALUE;
                            int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                            int roffset1 = roffset0 + dx;
                            short voxel2 = vol[poffset0 + roffset1 + ix];
                            short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                            int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                            int frac0_y = jiy & Short.MAX_VALUE;
                            int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                            int poffset1 = poffset0 + psize;
                            short voxel4 = vol[poffset1 + roffset0 + ix];
                            short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                            int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                            short voxel6 = vol[poffset1 + roffset1 + ix];
                            short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                            int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                            int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                            int frac0_z = jiz & Short.MAX_VALUE;
                            int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                            if (voxel < mval) {
                                mval = voxel;
                                khit = k2;
                            }
                            jix += izstep_x;
                            jiy += izstep_y;
                            jiz += izstep_z;
                        }
                    } else {
                        mval = nocontentPixel;
                    }
                    img[yoffset + j2] = (short)mval;
                    this.depth_buffer[yoffset + j2] = khit;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j2;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(vol, vol_offset, img, i2, w2, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, zstep, 2);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                for (i2 = ylast + yskip; i2 < h2 && (npix = this.fillLine(vol, vol_offset, img, i2, w2, x0, w2 - 1, xskip, startX, startY, startZ, xstep, ystep, zstep, 2)) > 0; i2 += yskip) {
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("castrays_thickminip[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    public int castray_thickavg_tl(int x0, int y0, short[] vol, int vol_offset, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        if (y0 > this.yend - 1) {
            return nocontentPixel;
        }
        if (y0 < this.ystart + 1) {
            return nocontentPixel;
        }
        if (x0 < this.xstart_arr[y0] + 1) {
            return nocontentPixel;
        }
        if (x0 > this.xend_arr[y0] - 1) {
            return nocontentPixel;
        }
        int width = this.getWidth();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int psize = dx * dy;
        int mval = 0;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx) + (double)x0 * xstep[0] + (double)y0 * ystep[0];
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy) + (double)x0 * xstep[1] + (double)y0 * ystep[1];
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz) + (double)x0 * xstep[2] + (double)y0 * ystep[2];
            int rix = (int)(startX * 32768.0);
            int riy = (int)(startY * 32768.0);
            int riz = (int)(startZ * 32768.0);
            int yoffset = y0 * w2;
            int t0 = this.t0_raster[yoffset + x0];
            short t1 = this.t1_raster[yoffset + x0];
            int T = t1 - t0 + 1;
            if (T > 0) {
                double AVG_SCALE = 1.0 / (double)T;
                int jix = rix + t0 * izstep_x;
                int jiy = riy + t0 * izstep_y;
                int jiz = riz + t0 * izstep_z;
                for (int k2 = t0; k2 <= t1; ++k2) {
                    int frac0_x = jix & Short.MAX_VALUE;
                    int frac0_y = jiy & Short.MAX_VALUE;
                    int frac0_z = jiz & Short.MAX_VALUE;
                    ix = jix >> 15;
                    iy = jiy >> 15;
                    iz = jiz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int roffset1 = roffset0 + dx;
                    int poffset1 = poffset0 + psize;
                    short voxel0 = vol[poffset0 + roffset0 + ix];
                    short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                    short voxel2 = vol[poffset0 + roffset1 + ix];
                    short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                    short voxel4 = vol[poffset1 + roffset0 + ix];
                    short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                    short voxel6 = vol[poffset1 + roffset1 + ix];
                    short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    mval += voxel;
                    jix += izstep_x;
                    jiy += izstep_y;
                    jiz += izstep_z;
                }
                this.depth_buffer[y0 * width + x0] = 0;
                mval = (int)((double)mval * AVG_SCALE);
            } else {
                mval = nocontentPixel;
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("thickavg_castray[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "] x0=" + x0 + " y0=" + y0);
        }
        return mval;
    }

    private void castrays_thickavg_tl(int x0, int y0, int x1, int y1, int xskip, int yskip, short[] vol, int vol_offset, short[] img, int w2, int h2) {
        int nocontentPixel = this.getNoContentPixel();
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        try {
            int i2;
            double startX = thickmpr.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
            double startY = thickmpr.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
            double startZ = thickmpr.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
            int ybegin = thickmpr.startval(y0, this.ystart, yskip);
            int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
            int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
            int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
            int ylast = ybegin;
            for (i2 = ybegin; i2 < this.yend; i2 += yskip) {
                int yoffset = i2 * w2;
                int xstart = thickmpr.startval(x0, this.xstart_arr[i2], xskip);
                int xend = this.xend_arr[i2];
                ylast = i2;
                int six = rix + ixstep_x * xstart;
                int siy = riy + ixstep_y * xstart;
                int siz = riz + ixstep_z * xstart;
                int xlast = xstart;
                for (int j2 = xstart; j2 < xend; j2 += xskip) {
                    int t0 = this.t0_raster[yoffset + j2];
                    short t1 = this.t1_raster[yoffset + j2];
                    int mval = 0;
                    int T = t1 - t0 + 1;
                    if (T > 0) {
                        double AVG_SCALE = 1.0 / (double)T;
                        int jix = six + t0 * izstep_x;
                        int jiy = siy + t0 * izstep_y;
                        int jiz = siz + t0 * izstep_z;
                        for (int k2 = t0; k2 <= t1; ++k2) {
                            int frac0_x = jix & Short.MAX_VALUE;
                            int frac0_y = jiy & Short.MAX_VALUE;
                            int frac0_z = jiz & Short.MAX_VALUE;
                            ix = jix >> 15;
                            iy = jiy >> 15;
                            iz = jiz >> 15;
                            int poffset0 = vol_offset + iz * psize;
                            int roffset0 = iy * dx;
                            int roffset1 = roffset0 + dx;
                            int poffset1 = poffset0 + psize;
                            short voxel0 = vol[poffset0 + roffset0 + ix];
                            short voxel1 = vol[poffset0 + roffset0 + ix + 1];
                            short voxel2 = vol[poffset0 + roffset1 + ix];
                            short voxel3 = vol[poffset0 + roffset1 + ix + 1];
                            short voxel4 = vol[poffset1 + roffset0 + ix];
                            short voxel5 = vol[poffset1 + roffset0 + ix + 1];
                            short voxel6 = vol[poffset1 + roffset1 + ix];
                            short voxel7 = vol[poffset1 + roffset1 + ix + 1];
                            int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                            int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                            int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                            int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                            int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                            int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                            int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                            mval += voxel;
                            jix += izstep_x;
                            jiy += izstep_y;
                            jiz += izstep_z;
                        }
                        mval = (int)((double)mval * AVG_SCALE);
                    } else {
                        mval = nocontentPixel;
                    }
                    img[yoffset + j2] = (short)mval;
                    this.depth_buffer[yoffset + j2] = 0;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                    xlast = j2;
                }
                if (this.isMajorAxisView()) {
                    this.fillLineEdges(vol, vol_offset, img, i2, w2, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, zstep, 0);
                }
                rix += yskip_x;
                riy += yskip_y;
                riz += yskip_z;
            }
            if (this.isMajorAxisView()) {
                int npix;
                for (i2 = ylast + yskip; i2 < h2 && (npix = this.fillLine(vol, vol_offset, img, i2, w2, x0, w2 - 1, xskip, startX, startY, startZ, xstep, ystep, zstep, 0)) > 0; i2 += yskip) {
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("castrays_thickavg[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
            aie.printStackTrace();
        }
    }

    public void thick_mip(int x0, int y0, int ww, int hh, int xskip, int yskip, short[] vol, byte[] bingrid, int vol_offset, short[] img, short[] outoverlay, int w2, int h2) {
        double nsteps = this.getNumSteps();
        if (nsteps < 1.5) {
            this.mpr_tl(x0, y0, ww, hh, xskip, yskip, vol, bingrid, vol_offset, img, outoverlay, w2, h2);
        } else {
            this.castrays_thickmip_tl(x0, y0, x0 + ww, y0 + hh, xskip, yskip, vol, bingrid, vol_offset, img, w2, h2);
        }
    }

    public void thick_minip(int x0, int y0, int width, int height, int xskip, int yskip, short[] vol, byte[] bingrid, int vol_offset, short[] img, short[] outoverlay, int w2, int h2) {
        double nsteps = this.getNumSteps();
        if (nsteps < 1.5) {
            this.mpr_tl(x0, y0, width, height, xskip, yskip, vol, bingrid, vol_offset, img, outoverlay, w2, h2);
        } else {
            this.castrays_thickminip_tl(x0, y0, x0 + width, y0 + height, xskip, yskip, vol, vol_offset, img, w2, h2);
        }
    }

    public void thick_avg(int x0, int y0, int width, int height, int xskip, int yskip, short[] vol, byte[] bingrid, int vol_offset, short[] img, short[] outoverlay, int w2, int h2) {
        double nsteps = this.getNumSteps();
        if (nsteps < 1.5) {
            this.mpr_tl(x0, y0, width, height, xskip, yskip, vol, bingrid, vol_offset, img, outoverlay, w2, h2);
        } else {
            this.castrays_thickavg_tl(x0, y0, x0 + width, y0 + height, xskip, yskip, vol, vol_offset, img, w2, h2);
        }
    }

    private int fillLineEdges(short[] vol, int vol_offset, short[] outimg, int y2, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep, double[] zstep, int EDGE_MODE) {
        int vval;
        double p2;
        double p1;
        double p0;
        double p03;
        double p02;
        double p01;
        double p00;
        int voffset;
        double fz;
        double fy;
        double fx;
        int iz;
        int iy;
        int ix;
        int v7;
        int v6;
        int v5;
        int v4;
        int v3;
        int v2;
        int v1;
        int v0;
        double siz;
        double siy;
        double six;
        int k2;
        int ksteps;
        int mval;
        int j2;
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int noContent = this.getNoContentPixel();
        int psize = dimx * dimy;
        int npixels = 0;
        double rix = sx + ystep[0] * (double)y2;
        double riy = sy + ystep[1] * (double)y2;
        double riz = sz + ystep[2] * (double)y2;
        int yoffset = y2 * width;
        double numSteps = this.getNumSteps();
        double i_nsteps = Math.ceil(numSteps);
        double half_nsteps = (i_nsteps - 1.0) * 0.5;
        for (j2 = x0 - xskip; j2 >= 0; j2 -= xskip) {
            mval = 0;
            if (EDGE_MODE == 1) {
                mval = Integer.MIN_VALUE;
            } else if (EDGE_MODE == 2) {
                mval = Integer.MAX_VALUE;
            }
            ksteps = 0;
            k2 = 0;
            while ((double)k2 < i_nsteps) {
                six = rix + xstep[0] * (double)j2 + zstep[0] * ((double)k2 - half_nsteps);
                siy = riy + xstep[1] * (double)j2 + zstep[1] * ((double)k2 - half_nsteps);
                siz = riz + xstep[2] * (double)j2 + zstep[2] * ((double)k2 - half_nsteps);
                v0 = noContent;
                v1 = noContent;
                v2 = noContent;
                v3 = noContent;
                v4 = noContent;
                v5 = noContent;
                v6 = noContent;
                v7 = noContent;
                ix = (int)six;
                iy = (int)siy;
                iz = (int)siz;
                fx = six - (double)ix;
                fy = siy - (double)iy;
                fz = siz - (double)iz;
                voffset = vol_offset + psize * iz + iy * dimx + ix;
                if (ix >= 0 && ix < dimx && iy >= 0 && iy < dimy && iz >= 0 && iz < dimz) {
                    v0 = vol[voffset];
                    if (ix < dimx - 1) {
                        v1 = vol[voffset + 1];
                    }
                    if (iy < dimy - 1) {
                        v2 = vol[voffset + dimx];
                    }
                    if (ix < dimx - 1 && iy < dimy - 1) {
                        v3 = vol[voffset + dimx + 1];
                    }
                    if (iz < dimz - 1) {
                        v4 = vol[voffset + psize];
                        if (ix < dimx - 1) {
                            v5 = vol[voffset + psize + 1];
                        }
                        if (iy < dimy - 1) {
                            v6 = vol[voffset + psize + dimx];
                        }
                        if (ix < dimx - 1 && iy < dimy - 1) {
                            v7 = vol[voffset + psize + dimx + 1];
                        }
                    }
                    if (six < 0.0) {
                        v1 = noContent;
                        v3 = noContent;
                        v5 = noContent;
                        v7 = noContent;
                        fx = -fx;
                    }
                    if (siy < 0.0) {
                        v2 = noContent;
                        v3 = noContent;
                        v6 = noContent;
                        v7 = noContent;
                        fy = -fy;
                    }
                    if (siz < 0.0) {
                        v4 = noContent;
                        v5 = noContent;
                        v6 = noContent;
                        v7 = noContent;
                        fz = -fz;
                    }
                    p00 = (double)v0 + (double)(v1 - v0) * fx;
                    p01 = (double)v2 + (double)(v3 - v2) * fx;
                    p02 = (double)v4 + (double)(v5 - v4) * fx;
                    p03 = (double)v6 + (double)(v7 - v6) * fx;
                    p0 = p00 + (p01 - p00) * fy;
                    p1 = p02 + (p03 - p02) * fy;
                    p2 = p0 + (p1 - p0) * fz;
                    vval = (int)p2;
                    if (EDGE_MODE == 1) {
                        if (vval > mval) {
                            mval = vval;
                        }
                    } else if (EDGE_MODE == 2) {
                        if (vval < mval) {
                            mval = vval;
                        }
                    } else {
                        mval += vval;
                    }
                    ++ksteps;
                }
                ++k2;
            }
            if (ksteps <= 0) continue;
            if (EDGE_MODE == 0) {
                mval = (int)((double)mval * 1.0 / (double)ksteps);
            }
            outimg[yoffset + j2] = (short)mval;
            ++npixels;
        }
        for (j2 = x1 + xskip; j2 < width; j2 += xskip) {
            mval = 0;
            if (EDGE_MODE == 1) {
                mval = Integer.MIN_VALUE;
            } else if (EDGE_MODE == 2) {
                mval = Integer.MAX_VALUE;
            }
            ksteps = 0;
            k2 = 0;
            while ((double)k2 < i_nsteps) {
                six = rix + xstep[0] * (double)j2 + zstep[0] * ((double)k2 - half_nsteps);
                siy = riy + xstep[1] * (double)j2 + zstep[1] * ((double)k2 - half_nsteps);
                siz = riz + xstep[2] * (double)j2 + zstep[2] * ((double)k2 - half_nsteps);
                v0 = noContent;
                v1 = noContent;
                v2 = noContent;
                v3 = noContent;
                v4 = noContent;
                v5 = noContent;
                v6 = noContent;
                v7 = noContent;
                ix = (int)six;
                iy = (int)siy;
                iz = (int)siz;
                fx = six - (double)ix;
                fy = siy - (double)iy;
                fz = siz - (double)iz;
                voffset = vol_offset + psize * iz + iy * dimx + ix;
                if (ix >= 0 && ix < dimx && iy >= 0 && iy < dimy && iz >= 0 && iz < dimz) {
                    v0 = vol[voffset];
                    if (ix < dimx - 1) {
                        v1 = vol[voffset + 1];
                    }
                    if (iy < dimy - 1) {
                        v2 = vol[voffset + dimx];
                    }
                    if (ix < dimx - 1 && iy < dimy - 1) {
                        v3 = vol[voffset + dimx + 1];
                    }
                    if (iz < dimz - 1) {
                        v4 = vol[voffset + psize];
                        if (ix < dimx - 1) {
                            v5 = vol[voffset + psize + 1];
                        }
                        if (iy < dimy - 1) {
                            v6 = vol[voffset + psize + dimx];
                        }
                        if (ix < dimx - 1 && iy < dimy - 1) {
                            v7 = vol[voffset + psize + dimx + 1];
                        }
                    }
                    if (six < 0.0) {
                        v1 = noContent;
                        v3 = noContent;
                        v5 = noContent;
                        v7 = noContent;
                        fx = -fx;
                    }
                    if (siy < 0.0) {
                        v2 = noContent;
                        v3 = noContent;
                        v6 = noContent;
                        v7 = noContent;
                        fy = -fy;
                    }
                    if (siz < 0.0) {
                        v4 = noContent;
                        v5 = noContent;
                        v6 = noContent;
                        v7 = noContent;
                        fz = -fz;
                    }
                    p00 = (double)v0 + (double)(v1 - v0) * fx;
                    p01 = (double)v2 + (double)(v3 - v2) * fx;
                    p02 = (double)v4 + (double)(v5 - v4) * fx;
                    p03 = (double)v6 + (double)(v7 - v6) * fx;
                    p0 = p00 + (p01 - p00) * fy;
                    p1 = p02 + (p03 - p02) * fy;
                    p2 = p0 + (p1 - p0) * fz;
                    vval = (int)p2;
                    if (EDGE_MODE == 1) {
                        if (vval > mval) {
                            mval = vval;
                        }
                    } else if (EDGE_MODE == 2) {
                        if (vval < mval) {
                            mval = vval;
                        }
                    } else {
                        mval += vval;
                    }
                    ++ksteps;
                }
                ++k2;
            }
            if (ksteps <= 0) continue;
            if (EDGE_MODE == 0) {
                mval = (int)((double)mval * 1.0 / (double)ksteps);
            }
            outimg[yoffset + j2] = (short)mval;
            ++npixels;
        }
        return npixels;
    }

    private int fillLine(short[] vol, int vol_offset, short[] outimg, int y2, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep, double[] zstep, int EDGE_MODE) {
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int psize = dimx * dimy;
        int npixels = 0;
        int noContent = this.getNoContentPixel();
        double rix = sx + ystep[0] * (double)y2;
        double riy = sy + ystep[1] * (double)y2;
        double riz = sz + ystep[2] * (double)y2;
        double xstep_x = xstep[0];
        double xstep_y = xstep[1];
        double xstep_z = xstep[2];
        int yoffset = y2 * width;
        double numSteps = this.getNumSteps();
        double i_nsteps = Math.ceil(numSteps);
        double half_nsteps = (i_nsteps - 1.0) * 0.5;
        for (int j2 = x0; j2 <= x1; j2 += xskip) {
            int mval = 0;
            int ksteps = 0;
            if (EDGE_MODE == 1) {
                mval = Integer.MIN_VALUE;
            } else if (EDGE_MODE == 2) {
                mval = Integer.MAX_VALUE;
            }
            int k2 = 0;
            while ((double)k2 < i_nsteps) {
                double six = rix + xstep_x * (double)j2 + zstep[0] * ((double)k2 - half_nsteps);
                double siy = riy + xstep_y * (double)j2 + zstep[1] * ((double)k2 - half_nsteps);
                double siz = riz + xstep_z * (double)j2 + zstep[2] * ((double)k2 - half_nsteps);
                int ix = (int)six;
                int iy = (int)siy;
                int iz = (int)siz;
                double fx = six - (double)ix;
                double fy = siy - (double)iy;
                double fz = siz - (double)iz;
                int voffset = vol_offset + psize * iz + iy * dimx + ix;
                int v0 = noContent;
                int v1 = noContent;
                int v2 = noContent;
                int v3 = noContent;
                int v4 = noContent;
                int v5 = noContent;
                int v6 = noContent;
                int v7 = noContent;
                if (six >= 0.0 && six < (double)dimx && siy >= 0.0 && siy < (double)dimy && siz >= 0.0 && siz < (double)dimz) {
                    v0 = vol[voffset];
                    if (ix < dimx - 1) {
                        v1 = vol[voffset + 1];
                    }
                    if (iy < dimy - 1) {
                        v2 = vol[voffset + dimx];
                    }
                    if (ix < dimx - 1 && iy < dimy - 1) {
                        v3 = vol[voffset + dimx + 1];
                    }
                    if (iz < dimz - 1) {
                        v4 = vol[voffset + psize];
                        if (ix < dimx - 1) {
                            v5 = vol[voffset + psize + 1];
                        }
                        if (iy < dimy - 1) {
                            v6 = vol[voffset + psize + dimx];
                        }
                        if (ix < dimx - 1 && iy < dimy - 1) {
                            v7 = vol[voffset + psize + dimx + 1];
                        }
                    }
                    if (six < 0.0) {
                        v1 = noContent;
                        v3 = noContent;
                        v5 = noContent;
                        v7 = noContent;
                        fx = -fx;
                    }
                    if (siy < 0.0) {
                        v2 = noContent;
                        v3 = noContent;
                        v6 = noContent;
                        v7 = noContent;
                        fy = -fy;
                    }
                    if (siz < 0.0) {
                        v4 = noContent;
                        v5 = noContent;
                        v6 = noContent;
                        v7 = noContent;
                        fz = -fz;
                    }
                    double p00 = (double)v0 + (double)(v1 - v0) * fx;
                    double p01 = (double)v2 + (double)(v3 - v2) * fx;
                    double p02 = (double)v4 + (double)(v5 - v4) * fx;
                    double p03 = (double)v6 + (double)(v7 - v6) * fx;
                    double p0 = p00 + (p01 - p00) * fy;
                    double p1 = p02 + (p03 - p02) * fy;
                    double p2 = p0 + (p1 - p0) * fz;
                    int vval = (int)p2;
                    if (EDGE_MODE == 1) {
                        if (vval > mval) {
                            mval = vval;
                        }
                    } else if (EDGE_MODE == 2) {
                        if (vval < mval) {
                            mval = vval;
                        }
                    } else {
                        mval += vval;
                    }
                    ++ksteps;
                }
                ++k2;
            }
            if (ksteps <= 0) continue;
            if (EDGE_MODE == 0) {
                mval = (int)((double)mval * 1.0 / (double)ksteps);
            }
            outimg[yoffset + j2] = (short)mval;
            ++npixels;
        }
        return npixels;
    }
}

