/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.terra.jami.j3d.VoxelCombiner;
import com.ge.med.terra.jami.j3d.mpr.mprMultiVolume;
import java.util.Arrays;

public class thickmprMultiVolume
extends mprMultiVolume {
    int AVG_EDGE = 0;
    int MIP_EDGE = 1;
    int MINIP_EDGE = 2;

    private static int startval(int val, int vstart, int modval) {
        int v2;
        for (v2 = val; v2 < vstart + 1; v2 += modval) {
        }
        return v2;
    }

    private void thickmipMultiVolume_tl(int threadNo, int x0, int y0, int x1, int y1, int xskip, int yskip, short[][] vol, int vol_offset, short[] img, int w2, int h2) {
        int i2;
        VoxelCombiner combiner = this.getCombiner();
        int nocontentPixel = -2000;
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int[] xstart_arr = this.getXStartArray();
        int[] xend_arr = this.getXEndArray();
        short[] t0_raster = this.getT0Raster();
        short[] t1_raster = this.getT1Raster();
        short[] depth_buffer = this.getDepthBuffer();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int izstep_stride_x = (int)(zstep[0] * 32768.0);
        int izstep_stride_y = (int)(zstep[1] * 32768.0);
        int izstep_stride_z = (int)(zstep[2] * 32768.0);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int psize = dx * dy;
        ystart -= ystart % yskip;
        int ybegin = ystart + y0;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        double startX = thickmprMultiVolume.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
        double startY = thickmprMultiVolume.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
        double startZ = thickmprMultiVolume.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
        int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
        int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
        int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
        int ylast = ybegin;
        for (i2 = ybegin; i2 < yend; i2 += yskip) {
            int yoffset = i2 * w2;
            int xstart = thickmprMultiVolume.startval(x0, xstart_arr[i2], xskip);
            int xend = xend_arr[i2];
            ylast = i2;
            int six = rix + ixstep_x * xstart;
            int siy = riy + ixstep_y * xstart;
            int siz = riz + ixstep_z * xstart;
            int xlast = xstart;
            for (int j2 = xstart; j2 < xend; j2 += xskip) {
                int t0 = t0_raster[yoffset + j2];
                short t1 = t1_raster[yoffset + j2];
                short mval = -2000;
                int jix = six + t0 * izstep_x;
                int jiy = siy + t0 * izstep_y;
                int jiz = siz + t0 * izstep_z;
                int khit = 8192;
                short[][] voxels = new short[vol.length][t1 - t0 + 1];
                for (int k2 = t0; k2 <= t1; ++k2) {
                    int frac0_x = jix & Short.MAX_VALUE;
                    int frac0_y = jiy & Short.MAX_VALUE;
                    int frac0_z = jiz & Short.MAX_VALUE;
                    ix = jix >> 15;
                    iy = jiy >> 15;
                    iz = jiz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int roffset1 = roffset0 + dx;
                    int poffset1 = poffset0 + psize;
                    for (int v2 = 0; v2 < vol.length; ++v2) {
                        short voxel0 = vol[v2][poffset0 + roffset0 + ix];
                        short voxel1 = vol[v2][poffset0 + roffset0 + ix + 1];
                        short voxel2 = vol[v2][poffset0 + roffset1 + ix];
                        short voxel3 = vol[v2][poffset0 + roffset1 + ix + 1];
                        short voxel4 = vol[v2][poffset1 + roffset0 + ix];
                        short voxel5 = vol[v2][poffset1 + roffset0 + ix + 1];
                        short voxel6 = vol[v2][poffset1 + roffset1 + ix];
                        short voxel7 = vol[v2][poffset1 + roffset1 + ix + 1];
                        int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                        int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                        int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                        int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                        int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                        int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                        voxels[v2][k2 - t0] = (short)(voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15));
                    }
                    jix += izstep_stride_x;
                    jiy += izstep_stride_y;
                    jiz += izstep_stride_z;
                }
                short[] res = new short[voxels[0].length];
                combiner.combine(threadNo, res, voxels, 0, 0, 1, 1, res.length);
                for (int v3 = 0; v3 < res.length; ++v3) {
                    if (res[v3] <= mval) continue;
                    mval = res[v3];
                    khit = v3;
                }
                img[yoffset + j2] = mval;
                depth_buffer[yoffset + j2] = (short)khit;
                six += xskip_x;
                siy += xskip_y;
                siz += xskip_z;
                xlast = j2;
            }
            if (this.isMajorAxisView()) {
                this.fillLineEdges(threadNo, vol, vol_offset, img, i2, w2, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, zstep, this.MIP_EDGE);
            }
            rix += yskip_x;
            riy += yskip_y;
            riz += yskip_z;
        }
        if (this.isMajorAxisView()) {
            int npix;
            for (i2 = ylast + yskip; i2 < h2 && (npix = this.fillLine(threadNo, vol, vol_offset, img, i2, w2, x0, w2 - 1, xskip, startX, startY, startZ, xstep, ystep, zstep, this.MIP_EDGE)) > 0; i2 += yskip) {
            }
        }
    }

    private void thickminipMultiVolume_tl(int threadNo, int x0, int y0, int x1, int y1, int xskip, int yskip, short[][] vol, int vol_offset, short[] img, int w2, int h2) {
        int i2;
        VoxelCombiner combiner = this.getCombiner();
        int nocontentPixel = -2000;
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int[] xstart_arr = this.getXStartArray();
        int[] xend_arr = this.getXEndArray();
        short[] t0_raster = this.getT0Raster();
        short[] t1_raster = this.getT1Raster();
        short[] depth_buffer = this.getDepthBuffer();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        double startX = thickmprMultiVolume.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
        double startY = thickmprMultiVolume.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
        double startZ = thickmprMultiVolume.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
        ystart -= ystart % yskip;
        int ybegin = ystart + y0;
        int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
        int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
        int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
        int ylast = ybegin;
        for (i2 = ybegin; i2 < yend; i2 += yskip) {
            int yoffset = i2 * w2;
            int xstart = thickmprMultiVolume.startval(x0, xstart_arr[i2], xskip);
            int xend = xend_arr[i2];
            ylast = i2;
            int six = rix + ixstep_x * xstart;
            int siy = riy + ixstep_y * xstart;
            int siz = riz + ixstep_z * xstart;
            int xlast = xstart;
            for (int j2 = xstart; j2 < xend; j2 += xskip) {
                int t0 = t0_raster[yoffset + j2];
                short t1 = t1_raster[yoffset + j2];
                short mval = 9999;
                int T = t1 - t0;
                int khit = 8192;
                if (T > 0) {
                    int jix = six + t0 * izstep_x;
                    int jiy = siy + t0 * izstep_y;
                    int jiz = siz + t0 * izstep_z;
                    short[][] voxels = new short[vol.length][t1 - t0 + 1];
                    for (int k2 = t0; k2 <= t1; ++k2) {
                        int frac0_x = jix & Short.MAX_VALUE;
                        int frac0_y = jiy & Short.MAX_VALUE;
                        int frac0_z = jiz & Short.MAX_VALUE;
                        ix = jix >> 15;
                        iy = jiy >> 15;
                        iz = jiz >> 15;
                        int poffset0 = vol_offset + iz * psize;
                        int roffset0 = iy * dx;
                        int roffset1 = roffset0 + dx;
                        int poffset1 = poffset0 + psize;
                        for (int v2 = 0; v2 < vol.length; ++v2) {
                            short voxel0 = vol[v2][poffset0 + roffset0 + ix];
                            short voxel1 = vol[v2][poffset0 + roffset0 + ix + 1];
                            short voxel2 = vol[v2][poffset0 + roffset1 + ix];
                            short voxel3 = vol[v2][poffset0 + roffset1 + ix + 1];
                            short voxel4 = vol[v2][poffset1 + roffset0 + ix];
                            short voxel5 = vol[v2][poffset1 + roffset0 + ix + 1];
                            short voxel6 = vol[v2][poffset1 + roffset1 + ix];
                            short voxel7 = vol[v2][poffset1 + roffset1 + ix + 1];
                            int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                            int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                            int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                            int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                            int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                            int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                            voxels[v2][k2 - t0] = (short)(voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15));
                        }
                        jix += izstep_x;
                        jiy += izstep_y;
                        jiz += izstep_z;
                    }
                    short[] res = new short[voxels[0].length];
                    combiner.combine(threadNo, res, voxels, 0, 0, 1, 1, res.length);
                    for (int v3 = 0; v3 < res.length; ++v3) {
                        if (res[v3] >= mval) continue;
                        mval = res[v3];
                        khit = v3;
                    }
                } else {
                    mval = -2000;
                }
                img[yoffset + j2] = mval;
                depth_buffer[yoffset + j2] = (short)khit;
                six += xskip_x;
                siy += xskip_y;
                siz += xskip_z;
                xlast = j2;
            }
            if (this.isMajorAxisView()) {
                this.fillLineEdges(threadNo, vol, vol_offset, img, i2, w2, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, zstep, this.MINIP_EDGE);
            }
            rix += yskip_x;
            riy += yskip_y;
            riz += yskip_z;
        }
        if (this.isMajorAxisView()) {
            int npix;
            for (i2 = ylast + yskip; i2 < h2 && (npix = this.fillLine(threadNo, vol, vol_offset, img, i2, w2, x0, w2 - 1, xskip, startX, startY, startZ, xstep, ystep, zstep, this.MINIP_EDGE)) > 0; i2 += yskip) {
            }
        }
    }

    private void thickavgMultiVolume_tl(int threadNo, int x0, int y0, int x1, int y1, int xskip, int yskip, short[][] vol, int vol_offset, short[] img, int w2, int h2) {
        int i2;
        VoxelCombiner combiner = this.getCombiner();
        int nocontentPixel = -2000;
        double[] lookpt = this.getLookPt();
        double[] xstep = this.getXStep();
        double[] ystep = this.getYStep();
        double[] zstep = this.getZStep();
        int dx = this.getVolDimX();
        int dy = this.getVolDimY();
        int dz = this.getVolDimZ();
        int ystart = this.getYStart();
        int yend = this.getYEnd();
        int[] xstart_arr = this.getXStartArray();
        int[] xend_arr = this.getXEndArray();
        short[] t0_raster = this.getT0Raster();
        short[] t1_raster = this.getT1Raster();
        short[] depth_buffer = this.getDepthBuffer();
        int izstep_x = (int)(zstep[0] * 32768.0);
        int izstep_y = (int)(zstep[1] * 32768.0);
        int izstep_z = (int)(zstep[2] * 32768.0);
        int iystep_x = (int)(ystep[0] * 32768.0);
        int iystep_y = (int)(ystep[1] * 32768.0);
        int iystep_z = (int)(ystep[2] * 32768.0);
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x * xskip;
        int xskip_y = ixstep_y * xskip;
        int xskip_z = ixstep_z * xskip;
        int yskip_x = iystep_x * yskip;
        int yskip_y = iystep_y * yskip;
        int yskip_z = iystep_z * yskip;
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        double startX = thickmprMultiVolume.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
        double startY = thickmprMultiVolume.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
        double startZ = thickmprMultiVolume.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
        ystart -= ystart % yskip;
        int ybegin = ystart + y0;
        int rix = (int)((startX + ystep[0] * (double)ybegin) * 32768.0);
        int riy = (int)((startY + ystep[1] * (double)ybegin) * 32768.0);
        int riz = (int)((startZ + ystep[2] * (double)ybegin) * 32768.0);
        int ylast = ybegin;
        for (i2 = ybegin; i2 < yend; i2 += yskip) {
            int yoffset = i2 * w2;
            int xstart = thickmprMultiVolume.startval(x0, xstart_arr[i2], xskip);
            int xend = xend_arr[i2];
            ylast = i2;
            int six = rix + ixstep_x * xstart;
            int siy = riy + ixstep_y * xstart;
            int siz = riz + ixstep_z * xstart;
            int xlast = xstart;
            for (int j2 = xstart; j2 < xend; j2 += xskip) {
                int t0 = t0_raster[yoffset + j2];
                short t1 = t1_raster[yoffset + j2];
                int mval = 0;
                int T = t1 - t0 + 1;
                if (T > 0) {
                    double AVG_SCALE = 1.0 / (double)T;
                    int jix = six + t0 * izstep_x;
                    int jiy = siy + t0 * izstep_y;
                    int jiz = siz + t0 * izstep_z;
                    short[][] voxels = new short[vol.length][t1 - t0 + 1];
                    for (int k2 = t0; k2 <= t1; ++k2) {
                        int frac0_x = jix & Short.MAX_VALUE;
                        int frac0_y = jiy & Short.MAX_VALUE;
                        int frac0_z = jiz & Short.MAX_VALUE;
                        ix = jix >> 15;
                        iy = jiy >> 15;
                        iz = jiz >> 15;
                        int poffset0 = vol_offset + iz * psize;
                        int roffset0 = iy * dx;
                        int roffset1 = roffset0 + dx;
                        int poffset1 = poffset0 + psize;
                        for (int v2 = 0; v2 < vol.length; ++v2) {
                            short voxel0 = vol[v2][poffset0 + roffset0 + ix];
                            short voxel1 = vol[v2][poffset0 + roffset0 + ix + 1];
                            short voxel2 = vol[v2][poffset0 + roffset1 + ix];
                            short voxel3 = vol[v2][poffset0 + roffset1 + ix + 1];
                            short voxel4 = vol[v2][poffset1 + roffset0 + ix];
                            short voxel5 = vol[v2][poffset1 + roffset0 + ix + 1];
                            short voxel6 = vol[v2][poffset1 + roffset1 + ix];
                            short voxel7 = vol[v2][poffset1 + roffset1 + ix + 1];
                            int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                            int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                            int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                            int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                            int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                            int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                            voxels[v2][k2 - t0] = (short)(voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15));
                        }
                        jix += izstep_x;
                        jiy += izstep_y;
                        jiz += izstep_z;
                    }
                    short[] res = new short[voxels[0].length];
                    combiner.combine(threadNo, res, voxels, 0, 0, 1, 1, res.length);
                    double avg = 0.0;
                    for (int r2 = 0; r2 < res.length; ++r2) {
                        avg += (double)res[r2] * AVG_SCALE;
                    }
                    mval = (short)avg;
                } else {
                    mval = -2000;
                }
                img[yoffset + j2] = (short)mval;
                depth_buffer[yoffset + j2] = 0;
                six += xskip_x;
                siy += xskip_y;
                siz += xskip_z;
                xlast = j2;
            }
            if (this.isMajorAxisView()) {
                this.fillLineEdges(threadNo, vol, vol_offset, img, i2, w2, xstart, xlast, xskip, startX, startY, startZ, xstep, ystep, zstep, this.AVG_EDGE);
            }
            rix += yskip_x;
            riy += yskip_y;
            riz += yskip_z;
        }
        if (this.isMajorAxisView()) {
            int npix;
            for (i2 = ylast + yskip; i2 < h2 && (npix = this.fillLine(threadNo, vol, vol_offset, img, i2, w2, x0, w2 - 1, xskip, startX, startY, startZ, xstep, ystep, zstep, this.AVG_EDGE)) > 0; i2 += yskip) {
            }
        }
    }

    public void thick_mipMultiVolume(int threadNo, int x0, int y0, int ww, int hh, int xskip, int yskip, short[][] vol, int vol_offset, short[] img, short[] outoverlay, int w2, int h2) {
        double nsteps = this.getNumSteps();
        if (nsteps < 1.5) {
            this.mprMultiVolume_tl(threadNo, x0, y0, ww, hh, xskip, yskip, vol, vol_offset, img, w2, h2);
        } else {
            this.thickmipMultiVolume_tl(threadNo, x0, y0, x0 + ww, y0 + hh, xskip, yskip, vol, vol_offset, img, w2, h2);
        }
    }

    public void thick_minipMultiVolume(int threadNo, int x0, int y0, int width, int height, int xskip, int yskip, short[][] vol, int vol_offset, short[] img, short[] outoverlay, int w2, int h2) {
        double nsteps = this.getNumSteps();
        if (nsteps < 1.5) {
            this.mprMultiVolume_tl(threadNo, x0, y0, width, height, xskip, yskip, vol, vol_offset, img, w2, h2);
        } else {
            this.thickminipMultiVolume_tl(threadNo, x0, y0, x0 + width, y0 + height, xskip, yskip, vol, vol_offset, img, w2, h2);
        }
    }

    public void thick_avgMultiVolume(int threadNo, int x0, int y0, int width, int height, int xskip, int yskip, short[][] vol, int vol_offset, short[] img, short[] outoverlay, int w2, int h2) {
        double nsteps = this.getNumSteps();
        if (nsteps < 1.5) {
            this.mprMultiVolume_tl(threadNo, x0, y0, width, height, xskip, yskip, vol, vol_offset, img, w2, h2);
        } else {
            this.thickavgMultiVolume_tl(threadNo, x0, y0, x0 + width, y0 + height, xskip, yskip, vol, vol_offset, img, w2, h2);
        }
    }

    private int fillLineEdges(int threadNo, short[][] vols, int vol_offset, short[] outimg, int y2, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep, double[] zstep, int EDGE_MODE) {
        int vval;
        double p2;
        double p1;
        double p0;
        double p03;
        double p02;
        double p01;
        double p00;
        int voffset;
        double fz;
        double fy;
        double fx;
        int iz;
        int iy;
        int ix;
        int v7;
        int v6;
        int v5;
        int v4;
        int v3;
        int v2;
        int v1;
        int v0;
        double siz;
        double siy;
        double six;
        int k2;
        int ksteps;
        int mval;
        int j2;
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int noContent = -2000;
        int psize = dimx * dimy;
        int npixels = 0;
        VoxelCombiner combiner = this.getCombiner();
        double rix = sx + ystep[0] * (double)y2;
        double riy = sy + ystep[1] * (double)y2;
        double riz = sz + ystep[2] * (double)y2;
        int yoffset = y2 * width;
        double numSteps = this.getNumSteps();
        double i_nsteps = Math.ceil(numSteps);
        double half_nsteps = (i_nsteps - 1.0) * 0.5;
        int vollen = vols.length;
        short[][] vals = new short[vollen][8];
        short[] combined = new short[8];
        for (j2 = x0 - xskip; j2 >= 0; j2 -= xskip) {
            mval = 0;
            if (EDGE_MODE == this.MIP_EDGE) {
                mval = Integer.MIN_VALUE;
            } else if (EDGE_MODE == this.MINIP_EDGE) {
                mval = Integer.MAX_VALUE;
            }
            ksteps = 0;
            k2 = 0;
            while ((double)k2 < i_nsteps) {
                six = rix + xstep[0] * (double)j2 + zstep[0] * ((double)k2 - half_nsteps);
                siy = riy + xstep[1] * (double)j2 + zstep[1] * ((double)k2 - half_nsteps);
                siz = riz + xstep[2] * (double)j2 + zstep[2] * ((double)k2 - half_nsteps);
                v0 = -2000;
                v1 = -2000;
                v2 = -2000;
                v3 = -2000;
                v4 = -2000;
                v5 = -2000;
                v6 = -2000;
                v7 = -2000;
                ix = (int)six;
                iy = (int)siy;
                iz = (int)siz;
                fx = six - (double)ix;
                fy = siy - (double)iy;
                fz = siz - (double)iz;
                voffset = vol_offset + psize * iz + iy * dimx + ix;
                if (ix >= 0 && ix < dimx && iy >= 0 && iy < dimy && iz >= 0 && iz < dimz) {
                    for (int v8 = 0; v8 < vollen; ++v8) {
                        Arrays.fill(vals[v8], (short)-2000);
                        vals[v8][0] = vols[v8][voffset];
                        if (ix < dimx - 1) {
                            vals[v8][1] = vols[v8][voffset + 1];
                        }
                        if (iy < dimy - 1) {
                            vals[v8][2] = vols[v8][voffset + dimx];
                        }
                        if (ix < dimx - 1 && iy < dimy - 1) {
                            vals[v8][3] = vols[v8][voffset + dimx + 1];
                        }
                        if (iz >= dimz - 1) continue;
                        vals[v8][4] = vols[v8][voffset + psize];
                        if (ix < dimx - 1) {
                            vals[v8][5] = vols[v8][voffset + psize + 1];
                        }
                        if (iy < dimy - 1) {
                            vals[v8][6] = vols[v8][voffset + psize + dimx];
                        }
                        if (ix >= dimx - 1 || iy >= dimy - 1) continue;
                        vals[v8][7] = vols[v8][voffset + psize + dimx + 1];
                    }
                    combiner.combine(threadNo, combined, vals, 0, 0, 1, 1, 8);
                    v0 = combined[0];
                    v1 = combined[1];
                    v2 = combined[2];
                    v3 = combined[3];
                    v4 = combined[4];
                    v5 = combined[5];
                    v6 = combined[6];
                    v7 = combined[7];
                    if (six < 0.0) {
                        v1 = -2000;
                        v3 = -2000;
                        v5 = -2000;
                        v7 = -2000;
                        fx = -fx;
                    }
                    if (siy < 0.0) {
                        v2 = -2000;
                        v3 = -2000;
                        v6 = -2000;
                        v7 = -2000;
                        fy = -fy;
                    }
                    if (siz < 0.0) {
                        v4 = -2000;
                        v5 = -2000;
                        v6 = -2000;
                        v7 = -2000;
                        fz = -fz;
                    }
                    p00 = (double)v0 + (double)(v1 - v0) * fx;
                    p01 = (double)v2 + (double)(v3 - v2) * fx;
                    p02 = (double)v4 + (double)(v5 - v4) * fx;
                    p03 = (double)v6 + (double)(v7 - v6) * fx;
                    p0 = p00 + (p01 - p00) * fy;
                    p1 = p02 + (p03 - p02) * fy;
                    p2 = p0 + (p1 - p0) * fz;
                    vval = (int)p2;
                    if (EDGE_MODE == this.MIP_EDGE) {
                        if (vval > mval) {
                            mval = vval;
                        }
                    } else if (EDGE_MODE == this.MINIP_EDGE) {
                        if (vval < mval) {
                            mval = vval;
                        }
                    } else {
                        mval += vval;
                    }
                    ++ksteps;
                }
                ++k2;
            }
            if (ksteps <= 0) continue;
            if (EDGE_MODE == this.AVG_EDGE) {
                mval = (int)((double)mval * 1.0 / (double)ksteps);
            }
            outimg[yoffset + j2] = (short)mval;
            ++npixels;
        }
        for (j2 = x1 + xskip; j2 < width; j2 += xskip) {
            mval = 0;
            if (EDGE_MODE == this.MIP_EDGE) {
                mval = Integer.MIN_VALUE;
            } else if (EDGE_MODE == this.MINIP_EDGE) {
                mval = Integer.MAX_VALUE;
            }
            ksteps = 0;
            k2 = 0;
            while ((double)k2 < i_nsteps) {
                six = rix + xstep[0] * (double)j2 + zstep[0] * ((double)k2 - half_nsteps);
                siy = riy + xstep[1] * (double)j2 + zstep[1] * ((double)k2 - half_nsteps);
                siz = riz + xstep[2] * (double)j2 + zstep[2] * ((double)k2 - half_nsteps);
                v0 = -2000;
                v1 = -2000;
                v2 = -2000;
                v3 = -2000;
                v4 = -2000;
                v5 = -2000;
                v6 = -2000;
                v7 = -2000;
                ix = (int)six;
                iy = (int)siy;
                iz = (int)siz;
                fx = six - (double)ix;
                fy = siy - (double)iy;
                fz = siz - (double)iz;
                voffset = vol_offset + psize * iz + iy * dimx + ix;
                if (ix >= 0 && ix < dimx && iy >= 0 && iy < dimy && iz >= 0 && iz < dimz) {
                    for (int v9 = 0; v9 < vollen; ++v9) {
                        Arrays.fill(vals[v9], (short)-2000);
                        vals[v9][0] = vols[v9][voffset];
                        if (ix < dimx - 1) {
                            vals[v9][1] = vols[v9][voffset + 1];
                        }
                        if (iy < dimy - 1) {
                            vals[v9][2] = vols[v9][voffset + dimx];
                        }
                        if (ix < dimx - 1 && iy < dimy - 1) {
                            vals[v9][3] = vols[v9][voffset + dimx + 1];
                        }
                        if (iz >= dimz - 1) continue;
                        vals[v9][4] = vols[v9][voffset + psize];
                        if (ix < dimx - 1) {
                            vals[v9][5] = vols[v9][voffset + psize + 1];
                        }
                        if (iy < dimy - 1) {
                            vals[v9][6] = vols[v9][voffset + psize + dimx];
                        }
                        if (ix >= dimx - 1 || iy >= dimy - 1) continue;
                        vals[v9][7] = vols[v9][voffset + psize + dimx + 1];
                    }
                    combiner.combine(threadNo, combined, vals, 0, 0, 1, 1, 8);
                    v0 = combined[0];
                    v1 = combined[1];
                    v2 = combined[2];
                    v3 = combined[3];
                    v4 = combined[4];
                    v5 = combined[5];
                    v6 = combined[6];
                    v7 = combined[7];
                    if (six < 0.0) {
                        v1 = -2000;
                        v3 = -2000;
                        v5 = -2000;
                        v7 = -2000;
                        fx = -fx;
                    }
                    if (siy < 0.0) {
                        v2 = -2000;
                        v3 = -2000;
                        v6 = -2000;
                        v7 = -2000;
                        fy = -fy;
                    }
                    if (siz < 0.0) {
                        v4 = -2000;
                        v5 = -2000;
                        v6 = -2000;
                        v7 = -2000;
                        fz = -fz;
                    }
                    p00 = (double)v0 + (double)(v1 - v0) * fx;
                    p01 = (double)v2 + (double)(v3 - v2) * fx;
                    p02 = (double)v4 + (double)(v5 - v4) * fx;
                    p03 = (double)v6 + (double)(v7 - v6) * fx;
                    p0 = p00 + (p01 - p00) * fy;
                    p1 = p02 + (p03 - p02) * fy;
                    p2 = p0 + (p1 - p0) * fz;
                    vval = (int)p2;
                    if (EDGE_MODE == this.MIP_EDGE) {
                        if (vval > mval) {
                            mval = vval;
                        }
                    } else if (EDGE_MODE == this.MINIP_EDGE) {
                        if (vval < mval) {
                            mval = vval;
                        }
                    } else {
                        mval += vval;
                    }
                    ++ksteps;
                }
                ++k2;
            }
            if (ksteps <= 0) continue;
            if (EDGE_MODE == this.AVG_EDGE) {
                mval = (int)((double)mval * 1.0 / (double)ksteps);
            }
            outimg[yoffset + j2] = (short)mval;
            ++npixels;
        }
        return npixels;
    }

    private int fillLine(int threadNo, short[][] vols, int vol_offset, short[] outimg, int y2, int width, int x0, int x1, int xskip, double sx, double sy, double sz, double[] xstep, double[] ystep, double[] zstep, int EDGE_MODE) {
        int dimx = this.getVolDimX();
        int dimy = this.getVolDimY();
        int dimz = this.getVolDimZ();
        int psize = dimx * dimy;
        int npixels = 0;
        int noContent = -2000;
        double rix = sx + ystep[0] * (double)y2;
        double riy = sy + ystep[1] * (double)y2;
        double riz = sz + ystep[2] * (double)y2;
        double xstep_x = xstep[0];
        double xstep_y = xstep[1];
        double xstep_z = xstep[2];
        VoxelCombiner combiner = this.getCombiner();
        int yoffset = y2 * width;
        double numSteps = this.getNumSteps();
        double i_nsteps = Math.ceil(numSteps);
        double half_nsteps = (i_nsteps - 1.0) * 0.5;
        int vollen = vols.length;
        short[][] vals = new short[vollen][8];
        short[] combined = new short[8];
        for (int j2 = x0; j2 <= x1; j2 += xskip) {
            int mval = 0;
            int ksteps = 0;
            if (EDGE_MODE == this.MIP_EDGE) {
                mval = Integer.MIN_VALUE;
            } else if (EDGE_MODE == this.MINIP_EDGE) {
                mval = Integer.MAX_VALUE;
            }
            int k2 = 0;
            while ((double)k2 < i_nsteps) {
                double six = rix + xstep_x * (double)j2 + zstep[0] * ((double)k2 - half_nsteps);
                double siy = riy + xstep_y * (double)j2 + zstep[1] * ((double)k2 - half_nsteps);
                double siz = riz + xstep_z * (double)j2 + zstep[2] * ((double)k2 - half_nsteps);
                int ix = (int)six;
                int iy = (int)siy;
                int iz = (int)siz;
                double fx = six - (double)ix;
                double fy = siy - (double)iy;
                double fz = siz - (double)iz;
                int voffset = vol_offset + psize * iz + iy * dimx + ix;
                int v0 = -2000;
                int v1 = -2000;
                int v2 = -2000;
                int v3 = -2000;
                int v4 = -2000;
                int v5 = -2000;
                int v6 = -2000;
                int v7 = -2000;
                if (six >= 0.0 && six < (double)dimx && siy >= 0.0 && siy < (double)dimy && siz >= 0.0 && siz < (double)dimz) {
                    for (int v8 = 0; v8 < vollen; ++v8) {
                        Arrays.fill(vals[v8], (short)-2000);
                        vals[v8][0] = vols[v8][voffset];
                        if (ix < dimx - 1) {
                            vals[v8][1] = vols[v8][voffset + 1];
                        }
                        if (iy < dimy - 1) {
                            vals[v8][2] = vols[v8][voffset + dimx];
                        }
                        if (ix < dimx - 1 && iy < dimy - 1) {
                            vals[v8][3] = vols[v8][voffset + dimx + 1];
                        }
                        if (iz >= dimz - 1) continue;
                        vals[v8][4] = vols[v8][voffset + psize];
                        if (ix < dimx - 1) {
                            vals[v8][5] = vols[v8][voffset + psize + 1];
                        }
                        if (iy < dimy - 1) {
                            vals[v8][6] = vols[v8][voffset + psize + dimx];
                        }
                        if (ix >= dimx - 1 || iy >= dimy - 1) continue;
                        vals[v8][7] = vols[v8][voffset + psize + dimx + 1];
                    }
                    combiner.combine(threadNo, combined, vals, 0, 0, 1, 1, 8);
                    v0 = combined[0];
                    v1 = combined[1];
                    v2 = combined[2];
                    v3 = combined[3];
                    v4 = combined[4];
                    v5 = combined[5];
                    v6 = combined[6];
                    v7 = combined[7];
                    if (six < 0.0) {
                        v1 = -2000;
                        v3 = -2000;
                        v5 = -2000;
                        v7 = -2000;
                        fx = -fx;
                    }
                    if (siy < 0.0) {
                        v2 = -2000;
                        v3 = -2000;
                        v6 = -2000;
                        v7 = -2000;
                        fy = -fy;
                    }
                    if (siz < 0.0) {
                        v4 = -2000;
                        v5 = -2000;
                        v6 = -2000;
                        v7 = -2000;
                        fz = -fz;
                    }
                    double p00 = (double)v0 + (double)(v1 - v0) * fx;
                    double p01 = (double)v2 + (double)(v3 - v2) * fx;
                    double p02 = (double)v4 + (double)(v5 - v4) * fx;
                    double p03 = (double)v6 + (double)(v7 - v6) * fx;
                    double p0 = p00 + (p01 - p00) * fy;
                    double p1 = p02 + (p03 - p02) * fy;
                    double p2 = p0 + (p1 - p0) * fz;
                    int vval = (int)p2;
                    if (EDGE_MODE == this.MIP_EDGE) {
                        if (vval > mval) {
                            mval = vval;
                        }
                    } else if (EDGE_MODE == this.MINIP_EDGE) {
                        if (vval < mval) {
                            mval = vval;
                        }
                    } else {
                        mval += vval;
                    }
                    ++ksteps;
                }
                ++k2;
            }
            if (ksteps <= 0) continue;
            if (EDGE_MODE == this.AVG_EDGE) {
                mval = (int)((double)mval * 1.0 / (double)ksteps);
            }
            outimg[yoffset + j2] = (short)mval;
            ++npixels;
        }
        return npixels;
    }
}

