/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.j3d.mprender.IRenderer;
import com.ge.med.terra.jami.j3d.mprender.IterativeRenderEngine;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class BaseIRE
implements IterativeRenderEngine {
    protected String mode = null;
    protected BufferedImage scr;
    protected int[] scrbuff;
    protected Image backBuffer;
    protected BufferedImage scr2;
    protected int[] scrbuff2;
    protected boolean resizeBuffer = false;
    protected int bgColor = 255;
    private int renderMode = 0;
    protected IRenderer ren;
    public final int NOT = Integer.parseInt(System.getProperty("not", Runtime.getRuntime().availableProcessors() + ""));
    protected Object[] thread_data = new Object[this.NOT];
    protected transient boolean noChange = true;
    protected Object lock = new Object();
    protected Component scrcomp;
    protected boolean blue = false;
    protected boolean done = true;
    private boolean keeprunning = true;
    private Rectangle r = new Rectangle(0, 0, 0, 0);

    @Override
    public void setComponent(Component c2) {
        this.scrcomp = c2;
        this.bufferResize();
        Thread rt = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BaseIRE.this.renderThread();
            }
        };
        rt.setName("render thread");
        rt.setDaemon(true);
        rt.start();
    }

    @Override
    public void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
    }

    @Override
    public int getRenderMode() {
        return this.renderMode;
    }

    @Override
    public boolean isRendered(int x2, int y2) {
        if (this.scr != null) {
            int w2 = this.scr.getWidth();
            int i2 = x2 + y2 * w2;
            return this.scrbuff[i2] < 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.keeprunning = false;
        Object object = this.lock;
        synchronized (object) {
            this.noChange = false;
            this.lock.notify();
        }
    }

    private void bufferResize() {
        int w2 = this.scrcomp.getWidth();
        int h2 = this.scrcomp.getHeight();
        if (w2 == 0 && h2 == 0) {
            return;
        }
        this.scr = new BufferedImage(w2, h2, 1);
        this.scrbuff = ((DataBufferInt)this.scr.getRaster().getDataBuffer()).getData();
        this.backBuffer = this.scrcomp.createImage(w2, h2);
        this.scr2 = new BufferedImage(w2, h2, 1);
        this.scrbuff2 = ((DataBufferInt)this.scr2.getRaster().getDataBuffer()).getData();
        this.backBuffer = this.scr2;
        XpLog.logger().fine("BASEIRE: bufferResize to " + w2 + "," + h2);
        this.ren.setDisplayBuffer(this.scrbuff, w2, h2);
        this.ren.updateWorld();
        this.imageChange(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderThread() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                while (this.noChange) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.keeprunning) break;
            if (this.resizeBuffer) {
                this.bufferResize();
                this.resizeBuffer = false;
            }
            if (this.scrbuff == null) {
                this.noChange = true;
                continue;
            }
            this.bgColor = this.scrcomp.getBackground().getRGB() & 0xFFFFFF;
            this.ren.clearDisplayBuffer();
            this.noChange = true;
            try {
                this.ren.updateWorld();
                this.multiPassRender();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        XpLog.logger().fine("-- Goodbye BaseIRE thread.");
        this.scrcomp = null;
        this.ren = null;
    }

    @Override
    public void setRenderable(IRenderer r2) {
        this.ren = r2;
        for (int i2 = 0; i2 < this.NOT; ++i2) {
            this.thread_data[i2] = r2.createThreadData();
        }
    }

    private final int diff(int a2, int b2) {
        int pne1 = a2 & 0xFF;
        int pne2 = a2 >> 8 & 0xFF;
        int pne3 = a2 >> 16 & 0xFF;
        int pse1 = b2 & 0xFF;
        int pse2 = b2 >> 8 & 0xFF;
        int pse3 = b2 >> 16 & 0xFF;
        int d1 = pne1 - pse1;
        int d2 = pne2 - pse2;
        int d3 = pne3 - pse3;
        return d1 * d1 + d2 * d2 + d3 * d3 >> 5;
    }

    public void multiPassRender() {
        this.r.x = 0;
        this.r.y = 0;
        int baseRes = 32;
        int baseSteps = 4;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        int w2 = this.scr.getWidth();
        int h2 = this.scr.getHeight();
        int highbyte = -16777216;
        for (int i2 = 0; i2 < this.scrbuff.length; ++i2) {
            this.scrbuff[i2] = this.bgColor;
        }
        for (int pas = 0; pas < 4; pas += 2) {
            this.r.x += pas;
            this.r.y += pas;
            this.ren.castRays(this.r, 32, 32, 0, 1, null);
            this.r.x -= pas;
            this.r.y -= pas;
            this.highbit(this.scrbuff, w2, this.r, 32, 32);
            for (int res = 0; res < 4; ++res) {
                int b2;
                int a2;
                int pb;
                int test;
                int x2;
                int step = 32 >> res;
                int hstep = step / 2;
                int pa = this.scrbuff[0];
                for (x2 = 0; x2 < w2 - step; x2 += step) {
                    test = x2 + hstep;
                    pb = this.scrbuff[test + hstep];
                    if (this.scrbuff[test] >= 0) {
                        a2 = pa >> 1 & 0x7F7F7F;
                        b2 = pb >> 1 & 0x7F7F7F;
                        this.scrbuff[test] = a2 + b2;
                    }
                    pa = pb;
                }
                pa = this.scrbuff[0];
                for (int y2 = this.r.y; y2 < this.r.height - step; y2 += step) {
                    test = y2 * w2 + hstep * w2;
                    if (this.scrbuff[test] < 0) continue;
                    pb = this.scrbuff[test + hstep * w2];
                    a2 = pa >> 1 & 0x7F7F7F;
                    b2 = pb >> 1 & 0x7F7F7F;
                    this.scrbuff[test] = a2 + b2;
                    pa = pb;
                }
                for (int y3 = this.r.y + hstep; y3 < this.r.height - step; y3 += step) {
                    for (x2 = this.r.x + hstep; x2 < this.r.width - step; x2 += step) {
                        int pb2;
                        int pa2;
                        int b3;
                        int a3;
                        int i3 = y3 * w2 + x2;
                        int test2 = i3 + hstep;
                        if (this.scrbuff[test2] >= 0) {
                            int pne = this.scrbuff[test2 - hstep * w2];
                            int pse = this.scrbuff[test2 + hstep * w2];
                            a3 = pne >> 1 & 0x7F7F7F;
                            b3 = pse >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a3 + b3;
                        }
                        if (this.scrbuff[test2 = i3 + hstep * w2] >= 0) {
                            pa2 = this.scrbuff[test2 - hstep];
                            pb2 = this.scrbuff[test2 + hstep];
                            a3 = pa2 >> 1 & 0x7F7F7F;
                            b3 = pb2 >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a3 + b3;
                        }
                        if (this.scrbuff[test2 = i3] < 0) continue;
                        pa2 = this.scrbuff[test2 - hstep];
                        pb2 = this.scrbuff[test2 + hstep];
                        a3 = pa2 >> 1 & 0x7F7F7F;
                        b3 = pb2 >> 1 & 0x7F7F7F;
                        this.scrbuff[test2] = a3 + b3;
                    }
                }
            }
            for (int y4 = this.r.y; y4 < this.r.height - 2; y4 += 2) {
                for (int x3 = this.r.x; x3 < this.r.width - 2; x3 += 2) {
                    int v21;
                    int v01;
                    int i4 = x3 + y4 * w2;
                    int v00 = this.scrbuff[i4] >> 1 & 0x7F7F7F;
                    int v02 = this.scrbuff[i4 + 2] >> 1 & 0x7F7F7F;
                    this.scrbuff[i4 + 1] = v01 = v00 + v02;
                    int v20 = this.scrbuff[i4 + 2 * w2] >> 1 & 0x7F7F7F;
                    this.scrbuff[i4 + w2] = v00 + v20;
                    int v22 = this.scrbuff[i4 + 2 * w2 + 2] >> 1 & 0x7F7F7F;
                    this.scrbuff[i4 + w2 * 2 + 1] = v21 = v20 + v22;
                    this.scrbuff[i4 + w2 + 2] = v02 + v22;
                    v01 = v01 >> 1 & 0x7F7F7F;
                    v21 = v21 >> 1 & 0x7F7F7F;
                    this.scrbuff[i4 + w2 + 1] = v01 + v21;
                }
            }
            Thread.yield();
            this.copyToBackBuff();
            this.scrcomp.repaint();
            if (this.noChange) continue;
            this.ren.updateWorld();
            return;
        }
        ++this.r.x;
        ++this.r.y;
        this.ren.castRays(this.r, 2, 2, 0, 1, null);
        this.highbit(this.scrbuff, w2, this.r, 2, 2);
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        --this.r.y;
        this.ren.castRays(this.r, 2, 2, 0, 1, null);
        this.highbit(this.scrbuff, w2, this.r, 2, 2);
        this.copyToBackBuff();
        Thread.yield();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        --this.r.x;
        ++this.r.y;
        this.ren.castRays(this.r, 2, 2, 0, 1, null);
        this.highbit(this.scrbuff, w2, this.r, 2, 2);
        --this.r.y;
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        for (int y5 = this.r.y; y5 < this.r.height; ++y5) {
            for (int x4 = this.r.x; x4 < this.r.width; ++x4) {
                int i5 = x4 + y5 * w2;
                if (this.scrbuff[i5] < 0) continue;
                this.scrbuff[i5] = this.ren.castRay(x4, y5, 0, 1, null);
            }
        }
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
    }

    protected void highbit(int[] img, int iw, Rectangle r2, int sx, int sy) {
        for (int y2 = r2.y; y2 < r2.height; y2 += sy) {
            for (int x2 = r2.x; x2 < r2.width; x2 += sx) {
                int n2 = iw * y2 + x2;
                img[n2] = img[n2] | 0xFF000000;
            }
        }
    }

    public void copyToBackBuff() {
        System.arraycopy(this.scrbuff, 0, this.scrbuff2, 0, this.scrbuff2.length);
    }

    public void copyToBackBuffLPF() {
        int p2;
        int x2;
        int y2;
        int h2 = this.scr.getHeight();
        int w2 = this.scr.getWidth();
        for (y2 = 1; y2 < h2 - 1; ++y2) {
            for (x2 = 0; x2 < w2 - 1; ++x2) {
                p2 = x2 + y2 * w2;
                int t1 = this.avg(this.scrbuff[p2 - 1], this.scrbuff[p2 + 1]);
                int t2 = this.avg(this.scrbuff[p2 - w2], this.scrbuff[p2 + w2]);
                this.scrbuff2[p2] = this.avg(t1, t2);
            }
        }
        for (y2 = 1; y2 < h2 - 1; ++y2) {
            int p3 = 0 + y2 * w2;
            this.scrbuff[p3] = this.scrbuff[p3];
            this.scrbuff[p3 += w2 - 1] = this.scrbuff[p3];
        }
        int offy = (h2 - 1) * w2;
        for (x2 = 0; x2 < w2; ++x2) {
            p2 = x2;
            this.scrbuff[p2] = this.scrbuff[p2];
            this.scrbuff[p2 += offy] = this.scrbuff[p2];
        }
    }

    private final int avg(int a2, int b2) {
        return (a2 >> 1 & 0x7F7F7F) + (b2 >> 1 & 0x7F7F7F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageChange(String str, byte[] ray_mask) {
        this.mode = str;
        Object object = this.lock;
        synchronized (object) {
            this.noChange = false;
            this.lock.notify();
        }
    }

    @Override
    public void paint(Graphics g2) {
        if (this.scr == null || this.scrcomp.getWidth() != this.scr.getWidth() || this.scrcomp.getHeight() != this.scr.getHeight()) {
            this.resizeBuffer = true;
            this.imageChange(null, null);
            return;
        }
        g2.drawImage(this.backBuffer, 0, 0, null);
    }

    @Override
    public BufferedImage getDisplayBuffer() {
        return this.scr2;
    }

    @Override
    public boolean isFinal() {
        return this.done;
    }
}

