/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.jnu.geom.JnPoint;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import java.util.Arrays;

public abstract class BaseMultipassAlgorithm
implements MultipassAlgorithm {
    private ParallelTaskManager tp = null;
    private IterativeRenderer ren = null;
    public int NOT = 0;
    private Object[] thread_data = null;
    private MPWorker[] worker = null;
    private RunnerData[] runnerdata = null;
    private byte[] bitmap = null;
    private int rowlen = 0;
    private int scrw = 0;
    private int scrh = 0;
    private boolean parallelRendering = true;
    private int curr_passno = -1;

    public BaseMultipassAlgorithm(boolean parallelRendering) {
        this.parallelRendering = parallelRendering;
        this.tp = new ParallelTaskManager();
        this.init();
    }

    @Override
    public void shutdown() {
        this.ren = null;
        this.thread_data = null;
        this.worker = null;
        for (RunnerData rd : this.runnerdata) {
            rd.shutdown();
        }
        this.runnerdata = null;
    }

    public BaseMultipassAlgorithm(ParallelTaskManager ptm, boolean parallelRendering) {
        this.parallelRendering = parallelRendering;
        this.tp = ptm;
        this.init();
    }

    @Override
    public String getDescriptor() {
        return "";
    }

    private void init() {
        this.NOT = ParallelTaskManager.getNumCPU();
        this.thread_data = new Object[this.NOT];
        this.worker = new MPWorker[this.NOT];
        this.runnerdata = new RunnerData[this.NOT];
        for (int i2 = 0; i2 < this.NOT; ++i2) {
            this.worker[i2] = new MPWorker(this.tp, i2);
            this.runnerdata[i2] = new RunnerData();
        }
        this.tp.setWorkers(this.worker);
    }

    public void launch(Runner[] r2, Object data) {
        for (int i2 = 0; i2 < this.NOT; ++i2) {
            this.runnerdata[i2].thread_data = this.thread_data[i2];
            this.runnerdata[i2].global_data = data;
            this.runnerdata[i2].runner = r2[i2];
            this.runnerdata[i2].passno = this.curr_passno;
        }
        this.tp.launch(this.runnerdata);
    }

    public void launch(Runner[] r2) {
        this.launch(r2, null);
    }

    protected Object getThreadData(int cpuId) {
        return this.thread_data[cpuId];
    }

    @Override
    public IterativeRenderer getT3DIRenderer() {
        return this.ren;
    }

    private void syncPixmap() {
        int w2 = this.ren.getBufferWidth();
        int h2 = this.ren.getBufferHeight();
        if (this.bitmap == null || w2 != this.scrw || h2 != this.scrh) {
            this.scrw = w2;
            this.scrh = h2;
            this.rowlen = w2 >> 3;
            if (w2 % 8 != 0) {
                ++this.rowlen;
            }
            this.bitmap = new byte[this.rowlen * h2];
        }
    }

    public void setPriority(int p2) {
    }

    @Override
    public final int render(int x2, int y2, int w2, int h2, int renderOutputLayer, int passno) {
        this.syncPixmap();
        if (passno == 0) {
            this.clearBitmap();
        }
        this.curr_passno = passno;
        return this.renderMPass(x2, y2, w2, h2, renderOutputLayer, passno);
    }

    @Override
    public void fill(int x2, int y2, int w2, int h2, int renderOutputLayer, int passno) {
        this.curr_passno = passno;
        this.fillMPass(x2, y2, w2, h2, renderOutputLayer, passno);
    }

    protected final boolean isParallelRendering() {
        return this.parallelRendering;
    }

    public abstract int renderMPass(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillMPass(int var1, int var2, int var3, int var4, int var5, int var6);

    public void clearBitmap() {
        Arrays.fill(this.bitmap, (byte)0);
    }

    protected final void markbit(int x2, int y2) {
        int bidx = x2 >> 3;
        int idx = y2 * this.rowlen + bidx;
        int bmod = x2 & 7;
        this.bitmap[idx] = (byte)(this.bitmap[idx] | 1 << bmod);
    }

    protected final void markbits(int x0, int y0, int width, int height, int sx, int sy) {
        for (int y2 = y0; y2 < height; y2 += sy) {
            int yoffset = y2 * this.rowlen;
            for (int x2 = x0; x2 < width; x2 += sx) {
                int bidx = x2 >> 3;
                int bmod = x2 & 7;
                int idx = yoffset + bidx;
                this.bitmap[idx] = (byte)(this.bitmap[idx] | 1 << bmod);
            }
        }
    }

    protected final void markallbits() {
        Arrays.fill(this.bitmap, (byte)-1);
    }

    @Override
    public void setT3DIRenderer(IterativeRenderer renderer) {
        this.ren = renderer;
        for (int i2 = 0; i2 < this.NOT; ++i2) {
            this.thread_data[i2] = this.ren.createThreadData();
            this.runnerdata[i2].ren = renderer;
            this.runnerdata[i2].thread_data = this.thread_data[i2];
        }
    }

    public static interface Runner {
        public void work(int var1, int var2, int var3, IterativeRenderer var4, Object var5, Object var6);
    }

    private static class MPWorker
    extends Worker {
        public MPWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int workers, Object data) {
            RunnerData[] rdata = (RunnerData[])data;
            RunnerData r2 = rdata[workerId];
            r2.runner.work(workerId, workers, r2.passno, r2.ren, r2.global_data, r2.thread_data);
        }
    }

    private static class RunnerData {
        public Object thread_data = null;
        public Runner runner = null;
        public int passno = -1;
        public Object global_data = null;
        public IterativeRenderer ren = null;

        private RunnerData() {
        }

        public void shutdown() {
            this.thread_data = null;
            this.runner = null;
            this.global_data = null;
            this.ren = null;
        }
    }

    protected static class RenderData {
        public JnPoint p = new JnPoint();
        public int outLayer = 0;
        public JnRectangle outputArea = null;

        protected RenderData() {
        }
    }
}

