/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.jnu.geom.JnPoint;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.j3d.mprender.BaseGridMultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.BaseMultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.MPFillerStrategy;

public class Grid2x2MultipassAlgorithm
extends BaseGridMultipassAlgorithm {
    private static final int BASERES = 2;
    private BaseMultipassAlgorithm.Runner[] pixren;
    private BaseMultipassAlgorithm.Runner[] fillrgb;
    private BaseMultipassAlgorithm.Runner[] filllum;
    private int[][] offset;

    public Grid2x2MultipassAlgorithm(ParallelTaskManager ptm, boolean parallelRender) {
        super(ptm, parallelRender);
        this.pixren = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.fillrgb = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.filllum = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.offset = new int[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
        this.init();
    }

    public Grid2x2MultipassAlgorithm(boolean parallelRender) {
        super(parallelRender);
        this.pixren = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.fillrgb = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.filllum = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.offset = new int[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
        this.init();
    }

    public Grid2x2MultipassAlgorithm(ParallelTaskManager ptm) {
        this(ptm, true);
    }

    public Grid2x2MultipassAlgorithm() {
        this(true);
    }

    @Override
    public void shutdown() {
        this.pixren = null;
        this.fillrgb = null;
        this.filllum = null;
        super.shutdown();
    }

    @Override
    public int getXStep(int passno) {
        return 2;
    }

    @Override
    public int getYStep(int passno) {
        return 2;
    }

    @Override
    public int getXStart(int passno) {
        return this.offset[passno][0];
    }

    @Override
    public int getYStart(int passno) {
        return this.offset[passno][1];
    }

    private void init() {
        int i2;
        for (i2 = 0; i2 < this.NOT; ++i2) {
            this.pixren[i2] = new BaseMultipassAlgorithm.Runner(){

                @Override
                public void work(int k2, int workers, int passno, IterativeRenderer ren, Object global_data, Object thread_data) {
                    BaseMultipassAlgorithm.RenderData rd = (BaseMultipassAlgorithm.RenderData)global_data;
                    JnPoint p2 = rd.p;
                    int outLayer = rd.outLayer;
                    int xoff = p2.x;
                    int yoff = p2.y;
                    int w2 = ren.getBufferWidth();
                    int h2 = ren.getBufferHeight();
                    int x2 = k2 * 2 + xoff;
                    int y2 = yoff;
                    int width = w2 - k2 * 2 - xoff;
                    int height = h2 - yoff;
                    ren.renderPixels(k2, outLayer, x2, y2, width, height, 2 * Grid2x2MultipassAlgorithm.this.NOT, 2, thread_data);
                    Grid2x2MultipassAlgorithm.this.markbits(x2, y2, width, height, 2 * Grid2x2MultipassAlgorithm.this.NOT, 2);
                }
            };
        }
        for (i2 = 0; i2 < this.NOT; ++i2) {
            this.fillrgb[i2] = new BaseMultipassAlgorithm.Runner(){

                @Override
                public void work(int k2, int workers, int passno, IterativeRenderer ren, Object global_data, Object thread_data) {
                    int[] buff = (int[])global_data;
                    short[] zbuffer = ren.getZBuffer();
                    int w2 = ren.getBufferWidth();
                    int h2 = ren.getBufferHeight();
                    switch (passno) {
                        case 0: {
                            MPFillerStrategy.fill2x2(k2, workers, buff, w2, h2);
                            if (zbuffer == null) break;
                            MPFillerStrategy.fill2x2s(k2, workers, zbuffer, w2, h2);
                        }
                    }
                }
            };
        }
        for (i2 = 0; i2 < this.NOT; ++i2) {
            this.filllum[i2] = new BaseMultipassAlgorithm.Runner(){

                @Override
                public void work(int k2, int workers, int passno, IterativeRenderer ren, Object global_data, Object thread_data) {
                    short[] buff = (short[])global_data;
                    short[] zbuffer = ren.getZBuffer();
                    int w2 = ren.getBufferWidth();
                    int h2 = ren.getBufferHeight();
                    switch (passno) {
                        case 0: {
                            MPFillerStrategy.fill2x2s(k2, workers, buff, w2, h2);
                            if (zbuffer == null) break;
                            MPFillerStrategy.fill2x2s(k2, workers, zbuffer, w2, h2);
                        }
                    }
                }
            };
        }
    }

    @Override
    public int renderMPass(int x2, int y2, int w2, int h2, int renderOutputLayer, int passno) {
        if (this.isParallelRendering()) {
            if (passno >= this.offset.length) {
                return 0;
            }
            int xoff = this.offset[passno][0];
            int yoff = this.offset[passno][1];
            BaseMultipassAlgorithm.RenderData rd = new BaseMultipassAlgorithm.RenderData();
            rd.p = new JnPoint(xoff, yoff);
            rd.outputArea = new JnRectangle(x2, y2, w2, h2);
            rd.outLayer = renderOutputLayer;
            this.launch(this.pixren, rd);
            return this.offset.length - passno - 1;
        }
        IterativeRenderer ren = this.getT3DIRenderer();
        int width = ren.getBufferWidth();
        int height = ren.getBufferHeight();
        int xstep = this.getXStep(passno);
        int ystep = this.getYStep(passno);
        int x0 = this.getXStart(passno);
        int y0 = this.getYStart(passno);
        ren.renderPixels(0, renderOutputLayer, x0, y0, width, height, xstep, ystep, this.getThreadData(0));
        return xstep * ystep - passno - 1;
    }

    @Override
    public void fillMPass(int x2, int y2, int w2, int h2, int renderOutputLayer, int passno) {
        IterativeRenderer ren = this.getT3DIRenderer();
        Object buff = ren.getPixelBuffer();
        BaseMultipassAlgorithm.Runner[] r2 = this.filllum;
        if (buff instanceof int[]) {
            r2 = this.fillrgb;
        }
        this.launch(r2, buff);
    }
}

