/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.remote;

import com.ge.med.idc.Capable;
import com.ge.med.idc.GridMultipassAlgorithm;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.capable.SegmentationCapable;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.T3DRenderEngineDefs;
import com.ge.med.terra.jami.j3d.remote.Rm3DClientServerIF;
import com.ge.med.terra.jami.j3d.vr.RayTracer;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.jami.remote.RmServerEngine;
import com.ge.med.terra.jami.remote.RmServerThreadRender;
import com.ge.med.terra.jami.remote.codec.PassThruPBCodec;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class RmServer3DEngine
implements RmServerEngine,
T3DRenderEngine,
Rm3DClientServerIF,
T3DRenderEngineDefs {
    private static int RMSERVER_CNT = 0;
    private static int VOLMODEL_ID_CTR = 100;
    private static Map vm_map = new HashMap();
    private T3DRenderEngine engine = null;
    private MultipassAlgorithm grid1x1 = null;
    private int rstyle = -1;
    private int rmserver_id = 0;
    private RmPixelBufferCodec pbcodec = new PassThruPBCodec();
    private RmServerThreadRender trender = new RmServerThreadRender(this);
    private int outWidth = 0;
    private int outHeight = 0;
    private int currentKey = -1;

    public RmServer3DEngine(T3DRenderEngine local_engine) {
        this.engine = local_engine;
        this.rmserver_id = RMSERVER_CNT++;
        MultipassAlgorithm[] malgs = this.engine.getSupportedMultipassAlgorithms();
        if (malgs != null) {
            for (int i2 = 0; i2 < malgs.length; ++i2) {
                if (!(malgs[i2] instanceof GridMultipassAlgorithm)) continue;
                GridMultipassAlgorithm gma = (GridMultipassAlgorithm)malgs[i2];
                int xstep = gma.getXStep(0);
                int ystep = gma.getYStep(0);
                if (xstep != 1 || ystep != 1) continue;
                this.grid1x1 = gma;
            }
        } else {
            throw new RuntimeException("There are not multipass algorithms supported, cannot be a server-side render engine: " + local_engine.getClass());
        }
        this.rstyle = this.getRenderStyleCode(this.engine.getRenderStyle());
    }

    @Override
    public void shutdown() {
    }

    public int getServer3DEngineId() {
        return this.rmserver_id;
    }

    @Override
    public RmPixelBufferCodec getPixelBufferCodec() {
        return this.pbcodec;
    }

    public Object executeCommand(RmCommand rm_cmd) {
        byte cmdId = rm_cmd.getCommandId();
        Object[] args = rm_cmd.getArgs();
        Object retval = null;
        switch (cmdId) {
            case 0: {
                XjVolumeInfo rmvol = (XjVolumeInfo)args[0];
                this.setVolume(rmvol);
                XjVolumeModel vm = this.getVolumeModel();
                Integer vmId = new Integer(VOLMODEL_ID_CTR++);
                vm_map.put(vmId, vm);
                retval = vmId;
                break;
            }
            case 1: {
                Integer vol_idx = (Integer)args[0];
                Integer vmId = (Integer)args[1];
                XjVolumeModel lvm = (XjVolumeModel)vm_map.get(vmId);
                this.setVolumeModel(lvm);
                break;
            }
            case 2: {
                String style = (String)args[0];
                this.setRenderStyle(style);
                break;
            }
            case 3: {
                int rgbbackground = (Integer)args[0];
                int lumbackground = (Integer)args[1];
                this.setBackground(rgbbackground, lumbackground);
                break;
            }
            case 9: {
                this.clearBuffers();
                break;
            }
            case 5: {
                int renderOutputLayer = (Integer)args[0];
                int passno = (Integer)args[1];
                byte renderType = (Byte)args[2];
                int rempasses = 0;
                MultipassAlgorithm ma = null;
                byte[] txbuffer = null;
                int[] buffInfo = null;
                if (renderType == 55) {
                    if (passno == 0 && renderOutputLayer == 0) {
                        this.currentKey = this.trender.beginRender();
                    }
                    buffInfo = this.trender.requestBufferInfo(this.currentKey, renderOutputLayer, passno);
                    txbuffer = this.trender.getBuffer();
                } else {
                    this.trender.syncPixelBuffers();
                    this.clearBuffers();
                    this.initRender();
                    int width = this.getBufferWidth();
                    int height = this.getBufferHeight();
                    ma = this.grid1x1;
                    rempasses = ma.render(0, 0, width, height, renderOutputLayer, passno);
                    this.trender.encodePixelBuffer(ma, renderOutputLayer, passno, rempasses);
                    buffInfo = this.trender.getBufferInfo(renderOutputLayer, passno);
                    txbuffer = this.trender.getBuffer();
                }
                int offset = buffInfo[0];
                int length = buffInfo[1];
                retval = new Object[]{new Integer(offset), new Integer(length), txbuffer};
                break;
            }
            case 8: {
                this.outWidth = (Integer)args[0];
                this.outHeight = (Integer)args[1];
                break;
            }
            case 10: {
                int x0 = (Integer)args[0];
                int y0 = (Integer)args[1];
                int width = (Integer)args[2];
                int height = (Integer)args[3];
                int stepx = (Integer)args[4];
                int stepy = (Integer)args[5];
                this.clearPixels(x0, y0, width, height, stepx, stepy);
                break;
            }
            case 11: {
                String[] rstyles = this.getSupportedRenderStyles();
                retval = rstyles;
                break;
            }
            case 12: {
                String propName = (String)args[0];
                Object value = args[1];
                this.setProperty(propName, value);
                break;
            }
            case 13: {
                boolean b2 = (Boolean)args[0];
                this.setPerspective(b2);
                break;
            }
            case 14: {
                double[] lookpt = (double[])args[0];
                this.setLookPoint(lookpt);
                break;
            }
            case 15: {
                double[] eyept = (double[])args[0];
                this.setEyePoint(eyept);
                break;
            }
            case 16: {
                double[] up = (double[])args[0];
                this.setUp(up);
                break;
            }
            case 17: {
                double[] eyept = (double[])args[0];
                double[] lookpt = (double[])args[1];
                double[] up = (double[])args[2];
                this.setCamera(eyept, lookpt, up);
                break;
            }
            case 18: {
                double[] clipOffsets = (double[])args[0];
                this.setViewClip(clipOffsets);
                break;
            }
            case 19: {
                double viewHeight = (Double)args[0];
                this.setViewHeight(viewHeight);
                break;
            }
            case 20: {
                int x2 = (Integer)args[0];
                int y2 = (Integer)args[1];
                int step = this.getDepthStep(x2, y2);
                retval = new Integer(step);
                break;
            }
            case 21: {
                int x3 = (Integer)args[0];
                int y3 = (Integer)args[1];
                double[] rasCoords = new double[3];
                this.getRASCoords(x3, y3, rasCoords);
                retval = rasCoords;
                break;
            }
            case 22: {
                int x4 = (Integer)args[0];
                int y4 = (Integer)args[1];
                double[] volCoords = new double[3];
                this.getVolumeCoords(x4, y4, volCoords);
                retval = volCoords;
                break;
            }
            case 23: {
                int x5 = (Integer)args[0];
                int y5 = (Integer)args[1];
                double value = this.getValue(x5, y5);
                retval = new Double(value);
                break;
            }
            case 24: {
                MultipassAlgorithm[] mpalg = this.getSupportedMultipassAlgorithms();
                Class[] mpclass = new Class[mpalg.length];
                for (int i2 = 0; i2 < mpalg.length; ++i2) {
                    mpclass[i2] = mpalg[i2].getClass();
                }
                retval = mpclass;
                break;
            }
            case 25: {
                VrPreset preset = (VrPreset)args[0];
                VrCapable vrc = (VrCapable)this.getCapable(VrCapable.class.getCanonicalName());
                if (vrc == null) break;
                vrc.setPreset(preset);
                break;
            }
            case 26: {
                VrColorLut clut = (VrColorLut)args[0];
                VrCapable vrc = (VrCapable)this.getCapable(VrCapable.class.getCanonicalName());
                if (vrc == null) break;
                vrc.setColorLut(clut);
                break;
            }
            case 27: {
                SegmentationCapable sc = (SegmentationCapable)((Object)this.getCapable(SegmentationCapable.class.getCanonicalName()));
                boolean res = false;
                if (sc == null) break;
                Object arg = args[0];
                Integer i3 = (Integer)args[1];
                if (arg instanceof byte[]) {
                    res = sc.applySegmentation((byte[])arg);
                } else if (arg instanceof short[]) {
                    res = sc.applySegmentation((short[])arg, i3);
                }
                retval = res;
                break;
            }
            case 28: {
                SegmentationCapable sc = (SegmentationCapable)((Object)this.getCapable(SegmentationCapable.class.getCanonicalName()));
                if (sc == null) break;
                sc.clearSegmentation();
                break;
            }
            case 29: {
                SegmentationCapable sc = (SegmentationCapable)((Object)this.getCapable(SegmentationCapable.class.getCanonicalName()));
                if (sc == null) break;
                sc.intersect((byte[])args[0]);
                break;
            }
            case 30: {
                SegmentationCapable sc = (SegmentationCapable)((Object)this.getCapable(SegmentationCapable.class.getCanonicalName()));
                if (sc == null) break;
                sc.union((byte[])args[0]);
                break;
            }
            case 31: {
                SegmentationCapable sc = (SegmentationCapable)((Object)this.getCapable(SegmentationCapable.class.getCanonicalName()));
                if (sc == null) break;
                sc.negation();
                break;
            }
            case 32: {
                SegmentationCapable sc = (SegmentationCapable)((Object)this.getCapable(SegmentationCapable.class.getCanonicalName()));
                if (sc == null) break;
                sc.setSegmentationVisible((Boolean)args[0]);
                break;
            }
            case 33: {
                SegmentationCapable sc = (SegmentationCapable)((Object)this.getCapable(SegmentationCapable.class.getCanonicalName()));
                if (sc == null) break;
                int[] seg_cmap = (int[])args[0];
                sc.setSegmentationColorMap(seg_cmap);
                break;
            }
            case 34: {
                RayTracer rt = (RayTracer)args[0];
                VrCapable vrc = (VrCapable)this.getCapable(VrCapable.class.getCanonicalName());
                if (vrc == null) break;
                vrc.setRayTracer(rt);
                break;
            }
            case 35: {
                retval = SUPPORTED_CODECS;
                break;
            }
            case 36: {
                String codec = (String)args[0];
                boolean isSupported = false;
                for (int i4 = 0; i4 < SUPPORTED_CODECS.length; ++i4) {
                    if (!SUPPORTED_CODECS[i4].equals(codec)) continue;
                    isSupported = true;
                    break;
                }
                if (isSupported) {
                    try {
                        Class<?> c2 = Class.forName(codec);
                        Constructor<?> con = c2.getConstructor(null);
                        this.pbcodec = (RmPixelBufferCodec)con.newInstance(null);
                        retval = new Boolean(true);
                    }
                    catch (Exception e2) {
                        isSupported = false;
                        retval = new Boolean(false);
                    }
                    break;
                }
                retval = new Boolean(false);
            }
        }
        return retval;
    }

    @Override
    public void setVolume(XjVolumeInfo volume) {
        this.engine.setVolume(volume);
    }

    @Override
    public XjVolumeInfo getVolume() {
        return this.engine.getVolume();
    }

    @Override
    public void setVolumeModel(XjVolumeModel volumeModel) {
        this.engine.setVolumeModel(volumeModel);
    }

    @Override
    public XjVolumeModel getVolumeModel() {
        return this.engine.getVolumeModel();
    }

    @Override
    public double getRescaleSlope(int renderOutputLayer) {
        return this.engine.getRescaleSlope(renderOutputLayer);
    }

    @Override
    public double getRescaleIntercept(int renderOutputLayer) {
        return this.engine.getRescaleIntercept(renderOutputLayer);
    }

    @Override
    public void setOutput(int[] rgbBuff, short[] luminanceBuff, int width, int height) {
        this.engine.setOutput(rgbBuff, luminanceBuff, width, height);
    }

    @Override
    public void syncRender() {
        int w2 = this.getBufferWidth();
        int h2 = this.getBufferHeight();
        int engineWidth = this.engine.getBufferWidth();
        int engineHeight = this.engine.getBufferHeight();
        if (this.engine.getPixelBuffer() == null || w2 != engineWidth || h2 != engineHeight) {
            int[] rgbBuff = new int[w2 * h2];
            short[] luminanceBuff = new short[w2 * h2];
            this.setOutput(rgbBuff, luminanceBuff, w2, h2);
        }
    }

    @Override
    public void clearPixels(int x0, int y0, int width, int height, int stepx, int stepy) {
        this.engine.clearPixels(x0, y0, width, height, stepx, stepy);
    }

    @Override
    public void setOverlay(short[] overlayBuff) {
        this.engine.setOverlay(overlayBuff);
    }

    @Override
    public void initRender() {
        this.engine.initRender();
    }

    @Override
    public void render(int renderOutputLayer) {
        this.engine.render(renderOutputLayer);
    }

    @Override
    public int getNumOutputs() {
        return this.engine.getNumOutputs();
    }

    protected int getRenderStyleCode() {
        return this.rstyle;
    }

    protected int getRenderStyleCode(String style) {
        return Commons3D.getRenderStyleCode(style);
    }

    @Override
    public MultipassAlgorithm getMultipassAlgorithm(int renderOutputLayer) {
        return this.engine.getMultipassAlgorithm(renderOutputLayer);
    }

    @Override
    public MultipassAlgorithm[] getSupportedMultipassAlgorithms() {
        return this.engine.getSupportedMultipassAlgorithms();
    }

    @Override
    public void setProperty(String propName, Object value) {
        this.engine.setProperty(propName, value);
    }

    @Override
    public Object getProperty(String propName) {
        return this.engine.getProperty(propName);
    }

    @Override
    public void setBackground(int rgbbackground, int lumbackground) {
        this.engine.setBackground(rgbbackground, lumbackground);
    }

    @Override
    public void addTaskMonitor(TaskMonitor tm) {
        this.engine.addTaskMonitor(tm);
    }

    @Override
    public void removeTaskMonitor(TaskMonitor tm) {
        this.engine.removeTaskMonitor(tm);
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener l2) {
        this.engine.removePropertyChangeListener(propName, l2);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.engine.addPropertyChangeListener(l2);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.engine.addPropertyChangeListener(prop, l2);
    }

    @Override
    public void addChangeListener(XjChangeListener cl) {
        this.engine.addChangeListener(cl);
    }

    @Override
    public void removeChangeListener(XjChangeListener cl) {
        this.engine.removeChangeListener(cl);
    }

    @Override
    public void transform(double[] src_pt, int srcCoords, double[] dest_pt, int destCoords) {
        this.engine.transform(src_pt, srcCoords, dest_pt, destCoords);
    }

    @Override
    public double[] getTransform(int srcCoords, int destCoords, double[] transform) {
        return this.engine.getTransform(srcCoords, destCoords, transform);
    }

    @Override
    public int addVolume(XjVolumeInfo vol) {
        return this.engine.addVolume(vol);
    }

    @Override
    public int addVolumeModel(XjVolumeModel volumeModel) {
        return this.engine.addVolumeModel(volumeModel);
    }

    @Override
    public void setVolume(XjVolumeInfo vol, int idx) {
        this.engine.setVolume(vol, idx);
    }

    @Override
    public void setVolumeModel(XjVolumeModel vm, int idx) {
        this.engine.setVolumeModel(vm, idx);
    }

    @Override
    public int removeVolumeModel(int idx) {
        return this.engine.removeVolumeModel(idx);
    }

    @Override
    public XjVolumeModel getVolumeModel(int vol_idx) {
        return this.engine.getVolumeModel(vol_idx);
    }

    @Override
    public int getNumVolumes() {
        return this.engine.getNumVolumes();
    }

    @Override
    public int getBufferWidth() {
        return this.outWidth;
    }

    @Override
    public int getBufferHeight() {
        return this.outHeight;
    }

    @Override
    public int getBPP() {
        Object buff = this.getPixelBuffer();
        if (buff instanceof int[]) {
            return 8;
        }
        if (buff instanceof short[]) {
            String modality;
            XjVolumeInfo vol = this.getVolume();
            if (vol != null && (modality = ("" + vol.getValue(8, 96)).toUpperCase()).equals("CT")) {
                return 12;
            }
            return 16;
        }
        if (buff instanceof byte[]) {
            return 8;
        }
        return 0;
    }

    @Override
    public int getNumChannels() {
        Object buff = this.getPixelBuffer();
        if (buff instanceof int[]) {
            return 3;
        }
        return 1;
    }

    @Override
    public Object getPixelBuffer() {
        return this.engine.getPixelBuffer();
    }

    @Override
    public short[] getZBuffer() {
        return this.engine.getZBuffer();
    }

    @Override
    public int getBackgroundColor() {
        return this.engine.getBackgroundColor();
    }

    @Override
    public void clearBuffers() {
        this.engine.clearBuffers();
    }

    @Override
    public Capable getCapable(String capableIFName) {
        try {
            Class<?> cap = this.engine.getClass();
            Class<?> cl = Class.forName(capableIFName);
            if (cl.isAssignableFrom(cap) && cl.isInstance(this.engine)) {
                return this.engine;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isAutoRepaint() {
        return false;
    }

    @Override
    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        this.engine.getWorldBounds(ulc, xside, yside, zside);
    }

    @Override
    public void setLookPoint(double[] point) {
        this.engine.setLookPoint(point);
    }

    @Override
    public double[] getLookPoint(double[] look_pt) {
        return this.engine.getLookPoint(look_pt);
    }

    @Override
    public void setEyePoint(double[] point) {
        this.engine.setEyePoint(point);
    }

    @Override
    public double[] getEyePoint(double[] eye_pt) {
        return this.engine.getEyePoint(eye_pt);
    }

    @Override
    public void setUp(double[] vec) {
        this.engine.setUp(vec);
    }

    @Override
    public double[] getUp(double[] up_vect) {
        return this.engine.getUp(up_vect);
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.engine.setCamera(eyepoint, lookpoint, up);
    }

    @Override
    public void setViewHeight(double height) {
        this.engine.setViewHeight(height);
    }

    @Override
    public double getViewHeight() {
        return this.engine.getViewHeight();
    }

    @Override
    public void setAspectRatio(double aspect) {
        this.engine.setAspectRatio(aspect);
    }

    @Override
    public double getAspectRatio() {
        return this.engine.getAspectRatio();
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        this.engine.setViewClip(clipOffsets);
    }

    @Override
    public double[] getViewClip(double[] viewClip) {
        return this.engine.getViewClip(viewClip);
    }

    @Override
    public void setPerspective(boolean b2) {
        this.engine.setPerspective(b2);
    }

    @Override
    public boolean isPerspective() {
        return this.engine.isPerspective();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.engine.removePropertyChangeListener(l2);
    }

    @Override
    public void repaint() {
        this.engine.repaint();
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
    }

    @Override
    public String[] getSupportedRenderStyles() {
        return this.engine.getSupportedRenderStyles();
    }

    @Override
    public void setRenderStyle(String style) {
        this.rstyle = this.getRenderStyleCode(style);
        this.engine.setRenderStyle(style);
    }

    @Override
    public String getRenderStyle() {
        return this.engine.getRenderStyle();
    }

    @Override
    public int getDepthStep(int x2, int y2) {
        return this.engine.getDepthStep(x2, y2);
    }

    @Override
    public double[] getVolumeCoords(int x2, int y2, double[] volCoords) {
        return this.engine.getVolumeCoords(x2, y2, volCoords);
    }

    @Override
    public double[] getRASCoords(int x2, int y2, double[] rasCoords) {
        return this.engine.getRASCoords(x2, y2, rasCoords);
    }

    @Override
    public double getValue(int x2, int y2) {
        return this.engine.getValue(x2, y2);
    }

    @Override
    public void getDepthBuffer(float[] depthbuffer) {
        this.engine.getDepthBuffer(depthbuffer);
    }

    @Override
    public void getDepthBuffer(float[] depthbuffer, int x2, int y2, int width, int height) {
        this.engine.getDepthBuffer(depthbuffer, x2, y2, width, height);
    }

    @Override
    public void stateChanged(EventObject e2) {
        System.err.println(">>>>>>>>>>>>>>>> STATE CHANGED IN SERVER RENDER ENGINE!!!");
    }

    @Override
    public double[] getInitialUp() {
        return this.engine.getInitialUp();
    }

    @Override
    public void setInitialUp(double[] initialUp) {
        this.engine.setInitialUp(initialUp);
    }

    @Override
    public double[] getInitialView() {
        return this.engine.getInitialView();
    }

    @Override
    public void setInitialView(double[] initialView) {
        this.engine.setInitialView(initialView);
    }
}

