/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.surface;

import com.ge.med.terra.jami.j3d.vr.VrColor;
import com.ge.med.terra.jami.j3d.vr.vr;

public class RectSubVolumeRayTracer
extends vr.RaySplitColorLut {
    private static final int FRAC_MASK = 65535;
    private static final int INTNBITS = 8;
    private static final int DIV_SCALEF = 16;
    public static final float AMBIENT_LIGHT = 0.2f;
    public static final float DIRECTIONAL_LIGHT = 0.8f;

    @Override
    public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
        byte[] bingrid = this.bingrid;
        short[] volume = this.volume;
        if (bingrid == null || volume == null) {
            return 0;
        }
        boolean first = true;
        int totalvoxels = 0;
        int six = (int)(65536.0 * (fromX - 0.5));
        int siy = (int)(65536.0 * (fromY - 0.5));
        int siz = (int)(65536.0 * (fromZ - 0.5));
        double contrib_max1 = 0.0;
        double light = color.light;
        double vr2 = 0.0;
        double vg = 0.0;
        double vb = 0.0;
        color.step_num = (short)8192;
        for (int z2 = t0; z2 <= t1; ++z2) {
            int ix = six >> 16;
            int iy = siy >> 16;
            int iz = siz >> 16;
            int bx = ix;
            int by = iy;
            int bz = iz;
            int bgrid_offset = bz * this.pg_size + by * this.dx + bx;
            int bgrid_pos = bgrid_offset >> 3;
            int bgrid_mod = bgrid_offset & 7;
            int interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
            if (iy < this.vol.dy / 2 && iz < this.vol.dz / 2) {
                interesting = 0;
            }
            if (interesting != 0) {
                ++totalvoxels;
                int fx = (six & 0xFFFF) >> 8;
                int fy = (siy & 0xFFFF) >> 8;
                int fz = (siz & 0xFFFF) >> 8;
                if (first) {
                    color.step_num = (short)z2;
                    first = false;
                }
                int iy_0 = iy * this.dx;
                int iy_down = (iy + 1) * this.dx;
                int iy_downdown = (iy + 2) * this.dx;
                int iy_up = (iy - 1) * this.dx;
                double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                int BASE_PG_1 = this.VOL_OFFSET + iz * this.pg_size;
                short v7 = volume[BASE_PG_1 + iy_0 + ix];
                short v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                short v11 = volume[BASE_PG_1 + iy_down + ix];
                short v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                short v19 = volume[BASE_PG_2 + iy_0 + ix];
                short v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                short v23 = volume[BASE_PG_2 + iy_down + ix];
                short v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                int val = RectSubVolumeRayTracer.trilineardi(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz);
                int ival = val >> 16;
                double opacity = opacity_table[ival + 8192];
                if (opacity > 1.0E-4) {
                    short v4 = volume[BASE_PG_1 + iy_up + ix];
                    short v5 = volume[BASE_PG_1 + iy_up + ix + 1];
                    short v6 = volume[BASE_PG_1 + iy_0 + ix - 1];
                    short v9 = volume[BASE_PG_1 + iy_0 + ix + 2];
                    short v10 = volume[BASE_PG_1 + iy_down + ix - 1];
                    short v13 = volume[BASE_PG_1 + iy_down + ix + 2];
                    short v14 = volume[BASE_PG_1 + iy_downdown + ix];
                    short v15 = volume[BASE_PG_1 + iy_downdown + ix + 1];
                    short v16 = volume[BASE_PG_2 + iy_up + ix];
                    short v17 = volume[BASE_PG_2 + iy_up + ix + 1];
                    short v18 = volume[BASE_PG_2 + iy_0 + ix - 1];
                    short v21 = volume[BASE_PG_2 + iy_0 + ix + 2];
                    short v22 = volume[BASE_PG_2 + iy_down + ix - 1];
                    short v25 = volume[BASE_PG_2 + iy_down + ix + 2];
                    short v26 = volume[BASE_PG_2 + iy_downdown + ix];
                    short v27 = volume[BASE_PG_2 + iy_downdown + ix + 1];
                    int BASE_PG_0 = this.VOL_OFFSET + (iz - 1) * this.pg_size;
                    short v0 = volume[BASE_PG_0 + iy_0 + ix];
                    short v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                    short v2 = volume[BASE_PG_0 + iy_down + ix];
                    short v3 = volume[BASE_PG_0 + iy_down + ix + 1];
                    int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                    short v28 = volume[BASE_PG_3 + iy_0 + ix];
                    short v29 = volume[BASE_PG_3 + iy_0 + ix + 1];
                    short v30 = volume[BASE_PG_3 + iy_down + ix];
                    short v31 = volume[BASE_PG_3 + iy_down + ix + 1];
                    int vx0 = RectSubVolumeRayTracer.trilineardi(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz);
                    int vx1 = RectSubVolumeRayTracer.trilineardi(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz);
                    int gr_x = vx1 - vx0 >> 16;
                    int vy0 = RectSubVolumeRayTracer.trilineardi(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz);
                    int vy1 = RectSubVolumeRayTracer.trilineardi(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz);
                    int gr_y = vy1 - vy0 >> 16;
                    int vz0 = RectSubVolumeRayTracer.trilineardi(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz);
                    int vz1 = RectSubVolumeRayTracer.trilineardi(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz);
                    int gr_z = vz1 - vz0 >> 16;
                    int gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                    if (gnrm > 1) {
                        double contrib = opacity * light;
                        double DOT = (double)gr_x * this.lightDir[0] + (double)gr_y * this.lightDir[1] + (double)gr_z * this.lightDir[2];
                        double gcomponent = Math.abs(DOT) * (double)RectSubVolumeRayTracer.fastInvSqrt(gnrm);
                        double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                        int rgbidx = 3 * (ival + 8192);
                        double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                        double r2 = lutrgb[rgbidx];
                        double g2 = lutrgb[rgbidx + 1];
                        double b2 = lutrgb[rgbidx + 2];
                        vr2 += r2 * lightval;
                        vg += g2 * lightval;
                        vb += b2 * lightval;
                        light -= contrib;
                        if (contrib > contrib_max1) {
                            contrib_max1 = contrib;
                            color.step_num = (short)z2;
                        }
                        if (light < (double)0.02f) break;
                    }
                }
            }
            six += irayX;
            siy += irayY;
            siz += irayZ;
        }
        color.red = vr2;
        color.green = vg;
        color.blue = vb;
        color.light = light;
        return totalvoxels;
    }

    private static int trilineardi(int v000, int v100, int v010, int v110, int v001, int v101, int v011, int v111, int dx, int dy, int dz) {
        int t1 = RectSubVolumeRayTracer.LININTD(v000, v100, dx);
        int t2 = RectSubVolumeRayTracer.LININTD(v010, v110, dx);
        int ty1 = RectSubVolumeRayTracer.LININTD(t1, t2, dy) >> 8;
        int t3 = RectSubVolumeRayTracer.LININTD(v001, v101, dx);
        int t4 = RectSubVolumeRayTracer.LININTD(v011, v111, dx);
        int ty2 = RectSubVolumeRayTracer.LININTD(t3, t4, dy) >> 8;
        return RectSubVolumeRayTracer.LININTD(ty1, ty2, dz);
    }

    private static int LININTD(int x0, int x1, int dx) {
        return (x0 << 8) + dx * (x1 - x0);
    }

    private static float fastInvSqrt(float x2) {
        float xhalf = 0.5f * x2;
        int i2 = Float.floatToRawIntBits(x2);
        i2 = 1597463007 - (i2 >> 1);
        x2 = Float.intBitsToFloat(i2);
        x2 *= 1.5f - xhalf * x2 * x2;
        return x2;
    }
}

