/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.surface;

import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.surface.JnFilterSurface;
import com.ge.med.jnu.surface.JnSmoothSurface;
import com.ge.med.jnu.surface.JnSurface;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;

public class SurfaceUtils {
    public static JnSurface generateSurface(J3DVolumeModel vol, boolean genNormals, int mcX, int mcY, int mcZ, int thresh) {
        short[] inData = ((JVolume.LinearShort)vol.j_vol).volume;
        int offset = vol.j_vol.PAD;
        int[] dims = new int[]{vol.j_vol.dx, vol.j_vol.dy, vol.j_vol.dz};
        JnMatrix4d vol2Ras = vol.getVoxel2RASTransform();
        int offsetForMarchingCubes = offset;
        if (offsetForMarchingCubes >= dims[0] * dims[1]) {
            dims[2] = dims[2] + 2;
            vol2Ras = new JnMatrix4d(vol2Ras);
            vol2Ras.translate(-vol2Ras.m02, -vol2Ras.m02, -vol2Ras.m02);
            offsetForMarchingCubes -= dims[0] * dims[1];
        }
        int vMax = Short.MIN_VALUE;
        for (int i2 = vol.j_vol.PAD; i2 < inData.length - vol.j_vol.PAD; ++i2) {
            vMax = (short)Math.max(inData[i2], vMax);
        }
        JnSurface surface1 = SurfaceUtils.generateSurface(inData, offsetForMarchingCubes, dims, vol2Ras, genNormals, mcX, mcY, mcZ, thresh);
        return surface1;
    }

    private static JnSurface generateSurface(short[] volData, int volDataOffset, int[] dims, JnMatrix4d vol2Ras, boolean genNormals, int mcX, int mcY, int mcZ, int thresh) {
        JnSurface surface = new JnSurface();
        surface.extractSurface(volData, volDataOffset, dims, (short)thresh, false, mcX, mcY, mcZ, null);
        JnFilterSurface.transform((JnSurface)surface, (JnMatrix4d)vol2Ras);
        JnSmoothSurface smoothFilter = new JnSmoothSurface();
        smoothFilter.setSurface(surface);
        smoothFilter.setRelaxationFactor(0.33);
        smoothFilter.smoothSurface();
        if (genNormals) {
            surface.generatePointNormals();
        }
        return surface;
    }
}

