/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Preset {
    public double[] opacityPos = new double[]{103.0, 603.0};
    public double[] opacityBefore = new double[]{0.0, 1.0};
    public double[] opacityAfter = new double[]{0.0, 1.0};
    public int opacityMode = 1;
    public boolean blackwhitemode = false;
    public int contrastEnhancementMode = 0;
    public boolean enhanceContours = true;
    public int transparency = 10;
    public double[] rgbPos = null;
    public double[] rgbStepPosRatio = null;
    public double[] opacityAtColor = null;
    public int[] rgbValue = null;
    public boolean rgbNNeighbour = false;
    public double brightness = 1.0;
    public double start = -4096.0;
    public double incr = 1.0;
    public int rgbSelected = -1;
    public int opacitySelected = -1;
    public static final String RGBMODE_CHANGED = "rgbmode_changed";
    public static final String OPMODE_CHANGED = "opmode_changed";
    public static final int OPMODE_FREE = 0;
    public static final int OPMODE_RAMP_UP = 1;
    public static final int OPMODE_RAMP_DOWN = 2;
    public static final int OPMODE_HUMP_UP = 3;
    public static final int OPMODE_HUMP_DOWN = 4;
    public static final int OPMODE_EDGE = 5;
    public static final int OPMODE_ATTACH = 6;
    public static final int CONTRAST_ENH_MODE_NONE = 0;
    public static final int CONTRAST_ENH_MODE_MILD = 1;
    public static final int CONTRAST_ENH_MODE_STRONG = 2;
    public static final String COLOR_BW_MODE_CHANGED = "bwmode";
    public static final String CONTRAST_ENH_MODE_CHANGED = "contrastEnhModeChanged";
    public static final String BRIGHTNESS_CHANGED = "brightness";
    public static final String RELOAD = "load";
    public static final double RAMP_RANGE = 0.2;
    BufferedImage icon;
    String iconPath;
    String name;
    String category;
    Date lastUsed;
    public static final String POSTFIX = ".vrpreset";
    public static final String COLOR_SELECT = "color_select";
    public static final String TRANSPARENCY_CHANGED = "transparency";
    public static final String ENHANCE_CONTOURS = "enhanceContours";
    public static final String COLOR_CHANGED = "color_changed";
    public static final String PAINT_CACHE_PROPERTY = "paintCache";
    public static final String PAINT_CACHE_NOALPHA_PROPERTY = "paintCacheNoAlpha";
    transient Vector actionListeners = new Vector();
    Hashtable props = new Hashtable();
    public static final String CNO_CLIENT_PROPERTY = "CNO_PROPERTY";
    public static final String HISTOGRAM_CLIENT_PROPERTY = "HIST_PROPERTY";

    public Preset() {
        this.rgbPos = new double[5];
        this.rgbValue = new int[5];
        this.rgbStepPosRatio = new double[4];
        this.rgbValue[0] = new Color(255, 150, 127).getRGB();
        this.rgbPos[0] = -179.0;
        this.rgbValue[1] = new Color(169, 255, 250).getRGB();
        this.rgbPos[1] = 121.0;
        this.rgbValue[2] = new Color(255, 78, 80).getRGB();
        this.rgbPos[2] = 146.0;
        this.rgbValue[3] = new Color(255, 201, 113).getRGB();
        this.rgbPos[3] = 221.0;
        this.rgbValue[4] = new Color(255, 254, 243).getRGB();
        this.rgbPos[4] = 452.0;
        this.rgbNNeighbour = false;
        for (int i2 = 0; i2 < this.rgbStepPosRatio.length; ++i2) {
            this.rgbStepPosRatio[i2] = 0.5;
        }
    }

    public void print() {
        int i2;
        if (this.blackwhitemode) {
            System.out.println("black and white");
        }
        if (this.rgbNNeighbour) {
            System.out.println("rgbNNeighbour mode");
        }
        System.out.println("opacityMode" + this.opacityMode);
        for (i2 = 0; i2 < this.rgbValue.length; ++i2) {
            System.out.print("rgb[" + i2 + "] " + this.rgbPos[i2] + " ");
            String hex = "000000" + Integer.toHexString(this.rgbValue[i2]);
            System.out.println("0x" + hex.substring(hex.length() - 6));
        }
        if (this.opacityAtColor != null) {
            for (i2 = 0; i2 < this.opacityAtColor.length; ++i2) {
                System.out.println("OpacityAtColor[" + i2 + "] = " + this.opacityAtColor[i2]);
            }
        } else {
            System.out.println("opacityAtColor = null");
        }
        for (i2 = 0; i2 < this.opacityPos.length; ++i2) {
            System.out.println("opacity[" + i2 + "]=" + this.opacityPos[i2] + " " + this.opacityBefore[i2] + "  " + this.opacityAfter[i2]);
        }
    }

    public Preset(String fileName) throws FileNotFoundException, IOException {
        this.load(fileName);
    }

    public void load(Preset p2) {
        this.opacityPos = Preset.dup(p2.opacityPos);
        this.opacityBefore = Preset.dup(p2.opacityBefore);
        this.opacityAfter = Preset.dup(p2.opacityAfter);
        this.opacityMode = p2.opacityMode;
        this.blackwhitemode = p2.blackwhitemode;
        this.enhanceContours = p2.enhanceContours;
        this.transparency = p2.transparency;
        this.contrastEnhancementMode = p2.contrastEnhancementMode;
        this.rgbPos = Preset.dup(p2.rgbPos);
        this.rgbValue = Preset.dup(p2.rgbValue);
        this.opacityAtColor = Preset.dup(p2.opacityAtColor);
        this.rgbNNeighbour = p2.rgbNNeighbour;
        this.brightness = p2.brightness;
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, CONTRAST_ENH_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, RELOAD));
    }

    public Object clone() {
        Preset p2 = new Preset();
        p2.load(this);
        return p2;
    }

    public Preset(InputStream stream) {
        this.load(stream);
    }

    public void load(String fileName) throws FileNotFoundException, IOException {
        File f2 = new File(fileName);
        if (f2.exists()) {
            FileInputStream istream = new FileInputStream(fileName);
            this.load(istream);
            ((InputStream)istream).close();
        } else if (!fileName.endsWith(POSTFIX)) {
            this.load(fileName + POSTFIX);
        }
    }

    public void load(InputStream stream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Element elem = doc.getDocumentElement();
            this.name = elem.getAttribute("name");
            this.iconPath = elem.getAttribute("icon");
            this.lastUsed = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(elem.getAttribute("date"));
            for (Node n2 = elem.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                String[] v2;
                String s2;
                if ("opacity".equalsIgnoreCase(n2.getNodeName())) {
                    Node nnm = n2.getAttributes().getNamedItem("opacityMode");
                    this.opacityMode = 1;
                    if (nnm != null) {
                        this.opacityMode = Integer.parseInt(nnm.getNodeValue());
                    }
                    String s3 = n2.getFirstChild().getNodeValue().trim();
                    String[] v3 = s3.split("\\s+");
                    this.opacityPos = new double[v3.length / 3];
                    this.opacityBefore = new double[v3.length / 3];
                    this.opacityAfter = new double[v3.length / 3];
                    for (int i2 = 0; i2 < v3.length / 3; ++i2) {
                        this.opacityPos[i2] = Double.parseDouble(v3[i2 * 3]);
                        this.opacityBefore[i2] = Double.parseDouble(v3[i2 * 3 + 1]);
                        this.opacityAfter[i2] = Double.parseDouble(v3[i2 * 3 + 2]);
                        System.out.println("opacityAfter[" + i2 + "]=" + this.opacityAfter[i2]);
                    }
                }
                if ("RGB".equalsIgnoreCase(n2.getNodeName())) {
                    this.blackwhitemode = Preset.getAttribute(n2, "blackwhitemode", this.blackwhitemode);
                    this.rgbNNeighbour = Preset.getAttribute(n2, "rgbNNeighbour", this.rgbNNeighbour);
                    this.brightness = Preset.getAttribute(n2, BRIGHTNESS_CHANGED, this.brightness);
                    s2 = n2.getFirstChild().getNodeValue().trim();
                    v2 = s2.split("\\s+");
                    this.rgbPos = new double[v2.length / 2];
                    this.rgbValue = new int[v2.length / 2];
                    for (int i3 = 0; i3 < v2.length / 2; ++i3) {
                        this.rgbPos[i3] = Double.parseDouble(v2[i3 * 2]);
                        this.rgbValue[i3] = Integer.decode(v2[i3 * 2 + 1]);
                    }
                }
                if (!"AttachedObjects".equalsIgnoreCase(n2.getNodeName())) continue;
                s2 = n2.getFirstChild().getNodeValue().trim();
                v2 = s2.split("\\s+");
                this.opacityAtColor = new double[v2.length];
                for (int i4 = 0; i4 < this.opacityAtColor.length; ++i4) {
                    this.opacityAtColor[i4] = Double.parseDouble(v2[i4]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, RELOAD));
    }

    private static boolean getAttribute(Node n2, String name, boolean b2) {
        Node nnm = n2.getAttributes().getNamedItem(name);
        if (nnm != null) {
            return "true".equalsIgnoreCase(nnm.getNodeValue());
        }
        return b2;
    }

    private static double getAttribute(Node n2, String name, double def) {
        Node nnm = n2.getAttributes().getNamedItem(name);
        if (nnm != null) {
            return Double.parseDouble(nnm.getNodeValue());
        }
        return def;
    }

    private static int getAttribute(Node n2, String name, int def) {
        Node nnm = n2.getAttributes().getNamedItem(name);
        if (nnm != null) {
            return Integer.parseInt(nnm.getNodeValue());
        }
        return def;
    }

    public static void printFile(String fileName) {
        System.out.println("=========================== " + fileName + "======================");
        FileReader fr = null;
        BufferedReader lr = null;
        try {
            String st;
            fr = new FileReader(fileName);
            lr = new LineNumberReader(fr);
            while ((st = ((LineNumberReader)lr).readLine()) != null) {
                System.out.println(st);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            if (lr != null) {
                lr.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        System.out.println("=========================== " + fileName + "======================\n");
        System.out.flush();
        System.err.flush();
    }

    public static void main(String[] args) {
        Preset p2 = new Preset();
        p2.save("default", "c:\\def");
        System.out.println("saved\n\n");
        Preset.printFile("c:\\def.vrpreset");
        try {
            Preset p22 = new Preset("c:\\def");
            System.out.println("loaded\n\n");
            System.out.flush();
            Thread.sleep(100L);
            p22.save("default", "c:\\def2");
            Preset.printFile("c:\\def2.vrpreset");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String name, String fileName) {
        String iconStr = "";
        if (fileName.endsWith(POSTFIX)) {
            fileName = fileName.substring(0, fileName.length() - POSTFIX.length());
        }
        if (this.icon != null) {
            iconStr = " icon=\"" + fileName + ".icon\"";
        }
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            int i2;
            fw = new FileWriter(fileName + POSTFIX);
            pw = new PrintWriter(fw);
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            pw.println("<VRPresets name=\"" + name + "\"" + iconStr + " date=\"" + new Date() + "\">");
            pw.println("  <opacity   opacityMode=\"" + this.opacityMode + "\">");
            for (i2 = 0; i2 < this.opacityPos.length; ++i2) {
                pw.println("    " + this.opacityPos[i2] + " " + this.opacityBefore[i2] + " " + this.opacityAfter[i2]);
            }
            pw.println("  </opacity>");
            pw.println("  <RGB blackwhitemode=\"" + this.blackwhitemode + "\" contrastEnhancementMode=\"" + this.contrastEnhancementMode + "\" rgbNNeighbour=\"" + this.rgbNNeighbour + "\" brightness=\"" + this.brightness + "\">");
            for (i2 = 0; i2 < this.rgbPos.length; ++i2) {
                String s2 = Integer.toHexString(this.rgbValue[i2] & 0xFFFFFF);
                String out = "00000000".substring(s2.length()) + s2;
                pw.println("    " + this.rgbPos[i2] + " 0x" + out);
            }
            pw.println("  </RGB>");
            if (this.opacityMode == 6 && !this.blackwhitemode) {
                pw.println("  <AttachedObjects>");
                for (i2 = 0; i2 < this.opacityAtColor.length; ++i2) {
                    pw.println("    " + this.opacityAtColor[i2]);
                }
                pw.println("  </AttachedObjects>");
            }
            pw.println("</VRPresets>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        System.out.println("done saving..." + fileName + POSTFIX);
    }

    public String getXMLelement() {
        int i2;
        StringBuffer buf = new StringBuffer();
        buf.append("<VRPresets name=\"" + this.name + "\">\n");
        buf.append("  <opacity   opacityMode=\"" + this.opacityMode + "\">\n");
        for (i2 = 0; i2 < this.opacityPos.length; ++i2) {
            buf.append("    " + this.opacityPos[i2] + " " + this.opacityBefore[i2] + " " + this.opacityAfter[i2] + "\n");
        }
        buf.append("  </opacity>\n");
        buf.append("  <RGB blackwhitemode=\"" + this.blackwhitemode + "\" contrastEnhancementMode=\"" + this.contrastEnhancementMode + "\" rgbNNeighbour=\"" + this.rgbNNeighbour + "\" brightness=\"" + this.brightness + "\">\n");
        for (i2 = 0; i2 < this.rgbPos.length; ++i2) {
            String s2 = Integer.toHexString(this.rgbValue[i2] & 0xFFFFFF);
            String out = "00000000".substring(s2.length()) + s2;
            buf.append("    " + this.rgbPos[i2] + " 0x" + out + "\n");
        }
        buf.append("  </RGB>\n");
        if (this.opacityMode == 6 && !this.blackwhitemode) {
            buf.append("  <AttachedObjects>\n");
            for (i2 = 0; i2 < this.opacityAtColor.length; ++i2) {
                buf.append("    " + this.opacityAtColor[i2] + "\n");
            }
            buf.append("  </AttachedObjects>\n");
        }
        buf.append("</VRPresets>");
        return buf.toString();
    }

    public double[] fillRGB() {
        if (this.blackwhitemode) {
            double[] rgb = new double[196608];
            double br = 1.0 + (this.brightness - 1.0) / 10.0;
            Arrays.fill(rgb, br);
            return rgb;
        }
        if (this.rgbNNeighbour) {
            return this.fillRGBNNeighbour();
        }
        return this.fillRGBlinear();
    }

    double[] fillRGBNNeighbour() {
        double d2;
        double[] rgb = new double[196608];
        int k2 = 0;
        int r0 = this.rgbValue[0] & 0xFF;
        int g0 = this.rgbValue[0] >> 8 & 0xFF;
        int b0 = this.rgbValue[0] >> 16 & 0xFF;
        double scale = (1.0 + (this.brightness - 1.0) / 10.0) / 255.0;
        for (d2 = this.start; d2 < this.rgbPos[0]; d2 += this.incr) {
            rgb[k2 * 3 + 0] = (double)b0 * scale;
            rgb[k2 * 3 + 1] = (double)g0 * scale;
            rgb[k2 * 3 + 2] = (double)r0 * scale;
            ++k2;
        }
        for (int i2 = 1; i2 < this.rgbPos.length; ++i2) {
            int r1 = this.rgbValue[i2] & 0xFF;
            int g1 = this.rgbValue[i2] >> 8 & 0xFF;
            int b1 = this.rgbValue[i2] >> 16 & 0xFF;
            while (d2 < this.rgbPos[i2]) {
                double t1 = (d2 - this.rgbPos[i2 - 1]) / (this.rgbPos[i2] - this.rgbPos[i2 - 1]);
                if (t1 > 0.5) {
                    rgb[k2 * 3 + 0] = (double)b1 * scale;
                    rgb[k2 * 3 + 1] = (double)g1 * scale;
                    rgb[k2 * 3 + 2] = (double)r1 * scale;
                } else {
                    rgb[k2 * 3 + 0] = (double)b0 * scale;
                    rgb[k2 * 3 + 1] = (double)g0 * scale;
                    rgb[k2 * 3 + 2] = (double)r0 * scale;
                }
                ++k2;
                d2 += this.incr;
            }
            r0 = r1;
            g0 = g1;
            b0 = b1;
        }
        while (k2 < rgb.length / 3) {
            rgb[k2 * 3 + 0] = (double)b0 * scale;
            rgb[k2 * 3 + 1] = (double)g0 * scale;
            rgb[k2 * 3 + 2] = (double)r0 * scale;
            ++k2;
        }
        return rgb;
    }

    double[] fillRGBlinear() {
        double d2;
        double[] rgb = new double[196608];
        int k2 = 0;
        int r0 = this.rgbValue[0] & 0xFF;
        int g0 = this.rgbValue[0] >> 8 & 0xFF;
        int b0 = this.rgbValue[0] >> 16 & 0xFF;
        double scale = (1.0 + (this.brightness - 1.0) / 10.0) / 255.0;
        for (d2 = this.start; d2 < this.rgbPos[0]; d2 += this.incr) {
            rgb[k2 * 3 + 0] = (double)b0 * scale;
            rgb[k2 * 3 + 1] = (double)g0 * scale;
            rgb[k2 * 3 + 2] = (double)r0 * scale;
            ++k2;
        }
        for (int i2 = 1; i2 < this.rgbPos.length; ++i2) {
            int r1 = this.rgbValue[i2] & 0xFF;
            int g1 = this.rgbValue[i2] >> 8 & 0xFF;
            int b1 = this.rgbValue[i2] >> 16 & 0xFF;
            while (d2 < this.rgbPos[i2]) {
                double t1 = (d2 - this.rgbPos[i2 - 1]) / (this.rgbPos[i2] - this.rgbPos[i2 - 1]);
                double t0 = (1.0 - t1) * scale;
                rgb[k2 * 3 + 0] = (double)b0 * t0 + (double)b1 * (t1 *= scale);
                rgb[k2 * 3 + 1] = (double)g0 * t0 + (double)g1 * t1;
                rgb[k2 * 3 + 2] = (double)r0 * t0 + (double)r1 * t1;
                ++k2;
                d2 += this.incr;
            }
            r0 = r1;
            g0 = g1;
            b0 = b1;
        }
        while (k2 < rgb.length / 3) {
            rgb[k2 * 3 + 0] = (double)b0 * scale;
            rgb[k2 * 3 + 1] = (double)g0 * scale;
            rgb[k2 * 3 + 2] = (double)r0 * scale;
            ++k2;
        }
        return rgb;
    }

    public double[] fillOpacity() {
        double d2;
        double[] opacityTab = new double[65536];
        int k2 = 0;
        for (d2 = this.start; d2 < this.opacityPos[0]; d2 += this.incr) {
            opacityTab[k2++] = this.opacityBefore[0];
        }
        for (int i2 = 1; i2 < this.opacityPos.length; ++i2) {
            double op0 = this.opacityAfter[i2 - 1];
            double op1 = this.opacityBefore[i2];
            while (d2 < this.opacityPos[i2]) {
                double t1 = (d2 - this.opacityPos[i2 - 1]) / (this.opacityPos[i2] - this.opacityPos[i2 - 1]);
                double t0 = 1.0 - t1;
                opacityTab[k2++] = op0 * t0 + op1 * t1;
                d2 += this.incr;
            }
        }
        double op0 = this.opacityAfter[this.opacityAfter.length - 1];
        while (k2 < opacityTab.length) {
            opacityTab[k2] = op0;
            ++k2;
        }
        return opacityTab;
    }

    public synchronized void addActionListener(ActionListener l2) {
        this.actionListeners.add(l2);
    }

    public synchronized void removeActionListener(ActionListener l2) {
        this.actionListeners.remove(l2);
    }

    public void fireActionPerformed(ActionEvent e2) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ActionListener)listeners.elementAt(i2)).actionPerformed(e2);
            }
        }
    }

    public void setRGBnn(boolean b2) {
        this.rgbNNeighbour = b2;
        this.fireActionPerformed(new ActionEvent(this, 0, RGBMODE_CHANGED));
    }

    public void setBrightness(double b2) {
        this.brightness = b2;
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
    }

    public void setBlackWhite(boolean bw) {
        this.blackwhitemode = bw;
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
    }

    public void setContrastEnhancementMode(int mode) {
        if (mode != this.contrastEnhancementMode) {
            this.contrastEnhancementMode = mode;
            this.fireActionPerformed(new ActionEvent(this, 0, CONTRAST_ENH_MODE_CHANGED));
        }
    }

    public void setOpacityMode(int mode) {
        boolean changed = mode != this.opacityMode;
        this.opacityMode = mode;
        double max = this.opacityAfter.length == 1 ? Math.max(this.opacityAfter[0], this.opacityAfter[0]) : Math.max(this.opacityAfter[0], this.opacityAfter[1]);
        switch (mode) {
            case 0: 
            case 6: {
                break;
            }
            case 4: {
                if (!changed) break;
                this.opacityAfter = Preset.realloc(this.opacityAfter, 4);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 4);
                this.opacityPos = Preset.realloc(this.opacityPos, 4);
                this.opacityAfter[0] = this.opacityBefore[0] = max;
                this.opacityBefore[1] = 0.0;
                this.opacityAfter[1] = 0.0;
                this.opacityBefore[2] = 0.0;
                this.opacityAfter[2] = 0.0;
                this.opacityAfter[3] = this.opacityBefore[3] = max;
                this.opacityPos[2] = this.opacityPos[1] + (this.opacityPos[1] - this.opacityPos[0]);
                this.opacityPos[3] = this.opacityPos[2] + (this.opacityPos[1] - this.opacityPos[0]);
                break;
            }
            case 3: {
                if (changed) {
                    this.opacityAfter = Preset.realloc(this.opacityAfter, 4);
                    this.opacityBefore = Preset.realloc(this.opacityBefore, 4);
                    this.opacityPos = Preset.realloc(this.opacityPos, 4);
                    this.opacityBefore[0] = 0.0;
                    this.opacityAfter[0] = 0.0;
                    this.opacityAfter[1] = this.opacityBefore[1] = max;
                    this.opacityAfter[2] = this.opacityBefore[2] = max;
                    this.opacityBefore[3] = 0.0;
                    this.opacityAfter[3] = 0.0;
                    this.opacityPos[2] = this.opacityPos[1] + (this.opacityPos[1] - this.opacityPos[0]);
                    this.opacityPos[3] = this.opacityPos[2] + (this.opacityPos[1] - this.opacityPos[0]);
                    break;
                }
                this.opacityBefore[0] = 0.0;
                this.opacityAfter[0] = 0.0;
                this.opacityAfter[1] = this.opacityBefore[1] = max;
                this.opacityAfter[2] = this.opacityBefore[2] = max;
                this.opacityBefore[3] = 0.0;
                this.opacityAfter[3] = 0.0;
                if (this.opacityPos[1] == 0.0) {
                    this.opacityPos[1] = this.opacityPos[0] + 30.0;
                }
                this.opacityPos[2] = this.opacityPos[1] + (this.opacityPos[1] - this.opacityPos[0]);
                this.opacityPos[3] = this.opacityPos[2] + (this.opacityPos[1] - this.opacityPos[0]);
                break;
            }
            case 2: {
                this.opacityAfter = Preset.realloc(this.opacityAfter, 2);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 2);
                this.opacityPos = Preset.realloc(this.opacityPos, 2);
                this.opacityAfter[0] = this.opacityBefore[0] = max;
                this.opacityBefore[1] = 0.0;
                this.opacityAfter[1] = 0.0;
                if (this.opacityPos[1] != 0.0) break;
                this.opacityPos[1] = this.opacityPos[0] + 30.0;
                break;
            }
            case 1: {
                this.opacityAfter = Preset.realloc(this.opacityAfter, 2);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 2);
                this.opacityPos = Preset.realloc(this.opacityPos, 2);
                this.opacityAfter[1] = this.opacityBefore[1] = max;
                this.opacityBefore[0] = 0.0;
                this.opacityAfter[0] = 0.0;
                if (this.opacityPos[1] != 0.0) break;
                this.opacityPos[1] = this.opacityPos[0] + 30.0;
                break;
            }
            case 5: {
                this.opacityAfter = Preset.realloc(this.opacityAfter, 1);
                this.opacityBefore = Preset.realloc(this.opacityBefore, 1);
                this.opacityPos = Preset.realloc(this.opacityPos, 1);
                this.opacityAfter[0] = max;
                this.opacityBefore[0] = 0.0;
            }
        }
        if (this.opacityMode != 6) {
            this.opacityAtColor = null;
        } else {
            this.opacityAtColor = new double[this.rgbPos.length];
            Arrays.fill(this.opacityAtColor, -1.0);
        }
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
    }

    public int getOpacityMode() {
        return this.opacityMode;
    }

    public void removeSelectedOpacity() {
        if (this.opacitySelected == -1) {
            return;
        }
        if (this.opacityMode != 0) {
            return;
        }
        double[] nPos = new double[this.opacityPos.length - 1];
        double[] nBef = new double[this.opacityBefore.length - 1];
        double[] nAft = new double[this.opacityAfter.length - 1];
        int off = 0;
        for (int i2 = 0; i2 < nPos.length; ++i2) {
            if (i2 == this.opacitySelected) {
                ++off;
            }
            nPos[i2] = this.opacityPos[i2 + off];
            nBef[i2] = this.opacityBefore[i2 + off];
            nAft[i2] = this.opacityAfter[i2 + off];
        }
        if (this.opacitySelected == nPos.length) {
            --this.opacitySelected;
        }
        this.opacityPos = nPos;
        this.opacityBefore = nBef;
        this.opacityAfter = nAft;
    }

    public void addNewOpacity(double v2) {
        if (this.opacityMode != 0) {
            return;
        }
        this.opacityPos = Preset.realloc(this.opacityPos, this.opacityPos.length + 1);
        this.opacityBefore = Preset.realloc(this.opacityBefore, this.opacityBefore.length + 1);
        this.opacityAfter = Preset.realloc(this.opacityAfter, this.opacityAfter.length + 1);
        this.opacityAfter[this.opacityPos.length - 1] = 0.5;
        this.opacityBefore[this.opacityPos.length - 1] = 0.5;
        this.opacityPos[this.opacityPos.length - 1] = v2;
        this.opacitySelected = this.opacityPos.length - 1;
        this.sortOpacity();
    }

    public void sortOpacity() {
        boolean swap = false;
        do {
            swap = false;
            for (int i2 = 1; i2 < this.opacityPos.length; ++i2) {
                if (!(this.opacityPos[i2 - 1] > this.opacityPos[i2])) continue;
                swap = true;
                double tPos = this.opacityPos[i2 - 1];
                double tBefore = this.opacityBefore[i2 - 1];
                double tAfter = this.opacityAfter[i2 - 1];
                this.opacityPos[i2 - 1] = this.opacityPos[i2];
                this.opacityBefore[i2 - 1] = this.opacityBefore[i2];
                this.opacityAfter[i2 - 1] = this.opacityAfter[i2];
                this.opacityPos[i2] = tPos;
                this.opacityBefore[i2] = tBefore;
                this.opacityAfter[i2] = tAfter;
                if (this.opacitySelected == i2) {
                    this.opacitySelected = i2 - 1;
                    continue;
                }
                if (this.opacitySelected != i2 - 1) continue;
                this.opacitySelected = i2;
            }
        } while (swap);
    }

    public void removeSelectedColor() {
        int i2;
        double[] nPos = new double[this.rgbPos.length - 1];
        int[] nVal = new int[this.rgbValue.length - 1];
        double[] nRatio = new double[this.rgbStepPosRatio.length - 1];
        double[] nOpacityAtColor = null;
        if (this.opacityMode == 6) {
            nOpacityAtColor = new double[this.opacityAtColor.length - 1];
        }
        int off = 0;
        for (i2 = 0; i2 < nVal.length; ++i2) {
            if (i2 == this.rgbSelected) {
                ++off;
            }
            nPos[i2] = this.rgbPos[i2 + off];
            nVal[i2] = this.rgbValue[i2 + off];
            if (this.opacityMode != 6) continue;
            nOpacityAtColor[i2] = this.opacityAtColor[i2 + off];
        }
        if (nRatio.length > 0) {
            for (i2 = 0; i2 < this.rgbSelected - 1; ++i2) {
                nRatio[i2] = this.rgbStepPosRatio[i2];
            }
            if (this.rgbSelected > 0 && this.rgbSelected < this.rgbPos.length - 1) {
                nRatio[this.rgbSelected - 1] = 0.5;
            }
            for (i2 = this.rgbSelected; i2 < nRatio.length; ++i2) {
                nRatio[i2] = this.rgbStepPosRatio[i2 + 1];
            }
        }
        if (this.rgbSelected == nVal.length) {
            --this.rgbSelected;
        }
        this.rgbPos = nPos;
        this.rgbValue = nVal;
        this.rgbStepPosRatio = nRatio;
        if (this.opacityMode == 6) {
            this.opacityAtColor = nOpacityAtColor;
            this.updateOpacityPts();
        }
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_SELECT));
    }

    public void addNewColor(double v2) {
        this.addNewColor(v2, 0xFFFFFF);
    }

    public void addNewColor(double v2, int rgb) {
        int i2;
        int insertIndex = -1;
        for (int i3 = 0; i3 < this.rgbPos.length; ++i3) {
            if (!(v2 < this.rgbPos[i3])) continue;
            insertIndex = i3;
            break;
        }
        if (insertIndex == -1) {
            insertIndex = this.rgbPos.length;
        }
        double[] nPos = new double[this.rgbPos.length + 1];
        int[] nVal = new int[this.rgbPos.length + 1];
        double[] nRatio = new double[this.rgbStepPosRatio.length + 1];
        for (i2 = 0; i2 < insertIndex; ++i2) {
            nPos[i2] = this.rgbPos[i2];
            nVal[i2] = this.rgbValue[i2];
        }
        nPos[insertIndex] = v2;
        nVal[insertIndex] = rgb;
        for (i2 = insertIndex + 1; i2 < nPos.length; ++i2) {
            nPos[i2] = this.rgbPos[i2 - 1];
            nVal[i2] = this.rgbValue[i2 - 1];
        }
        for (i2 = 0; i2 < insertIndex - 1; ++i2) {
            nRatio[i2] = this.rgbStepPosRatio[i2];
        }
        if (insertIndex > 0) {
            nRatio[insertIndex - 1] = 0.5;
        }
        if (insertIndex < nRatio.length) {
            nRatio[insertIndex] = 0.5;
        }
        for (i2 = insertIndex + 1; i2 < nRatio.length; ++i2) {
            nRatio[i2] = this.rgbStepPosRatio[i2 - 1];
        }
        if (this.opacityMode == 6) {
            double[] nOAC = new double[this.rgbPos.length + 1];
            if (this.opacityAtColor != null) {
                int i4;
                for (i4 = 0; i4 < insertIndex; ++i4) {
                    nOAC[i4] = this.opacityAtColor[i4];
                }
                nOAC[insertIndex] = -1.0;
                for (i4 = insertIndex + 1; i4 < nPos.length; ++i4) {
                    nOAC[i4] = this.opacityAtColor[i4 - 1];
                }
            } else {
                Arrays.fill(nOAC, -1.0);
            }
            this.opacityAtColor = nOAC;
        }
        this.rgbSelected = insertIndex;
        this.rgbPos = nPos;
        this.rgbValue = nVal;
        this.rgbStepPosRatio = nRatio;
        this.updateOpacityPts();
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_SELECT));
    }

    public void sortColor() {
        boolean cont;
        if (this.rgbPos.length < 2) {
            return;
        }
        boolean sorted = true;
        for (int i2 = 0; i2 < this.rgbPos.length - 1; ++i2) {
            if (!(this.rgbPos[i2] > this.rgbPos[i2 + 1])) continue;
            sorted = false;
            break;
        }
        if (sorted) {
            return;
        }
        double position = this.rgbPos[this.rgbSelected];
        int color = this.rgbValue[this.rgbSelected];
        if (this.rgbSelected > 0) {
            this.rgbStepPosRatio[this.rgbSelected - 1] = 0.5;
        }
        if (this.rgbSelected < this.rgbPos.length - 1) {
            this.rgbStepPosRatio[this.rgbSelected] = 0.5;
        }
        do {
            cont = false;
            for (int i3 = 1; i3 < this.rgbPos.length; ++i3) {
                if (!(this.rgbPos[i3 - 1] > this.rgbPos[i3])) continue;
                double tmpPos = this.rgbPos[i3 - 1];
                int tmpVal = this.rgbValue[i3 - 1];
                this.rgbPos[i3 - 1] = this.rgbPos[i3];
                this.rgbValue[i3 - 1] = this.rgbValue[i3];
                this.rgbPos[i3] = tmpPos;
                this.rgbValue[i3] = tmpVal;
                if (this.opacityAtColor != null) {
                    double tmpOp = this.opacityAtColor[i3 - 1];
                    this.opacityAtColor[i3 - 1] = this.opacityAtColor[i3];
                    this.opacityAtColor[i3] = tmpOp;
                }
                if (this.rgbSelected == i3) {
                    this.rgbSelected = i3 - 1;
                } else if (this.rgbSelected == i3 - 1) {
                    this.rgbSelected = i3;
                }
                cont = true;
            }
        } while (cont);
        if (this.rgbSelected > 0) {
            this.rgbStepPosRatio[this.rgbSelected - 1] = 0.5;
        }
        if (this.rgbSelected < this.rgbPos.length - 1) {
            this.rgbStepPosRatio[this.rgbSelected] = 0.5;
        }
    }

    protected static int[] realloc(int[] src, int len) {
        if (src == null) {
            return new int[len];
        }
        if (src.length == len) {
            return src;
        }
        int[] ret = new int[len];
        System.arraycopy(src, 0, ret, 0, Math.min(len, src.length));
        return ret;
    }

    protected static float[] realloc(float[] src, int len) {
        if (src == null) {
            return new float[len];
        }
        if (src.length == len) {
            return src;
        }
        float[] ret = new float[len];
        System.arraycopy(src, 0, ret, 0, Math.min(len, src.length));
        return ret;
    }

    protected static double[] realloc(double[] src, int len) {
        if (src == null) {
            return new double[len];
        }
        if (src.length == len) {
            return src;
        }
        double[] ret = new double[len];
        System.arraycopy(src, 0, ret, 0, Math.min(len, src.length));
        return ret;
    }

    private static int[] dup(int[] src) {
        if (src == null) {
            return null;
        }
        int[] ret = new int[src.length];
        System.arraycopy(src, 0, ret, 0, src.length);
        return ret;
    }

    private static float[] dup(float[] src) {
        if (src == null) {
            return null;
        }
        float[] ret = new float[src.length];
        System.arraycopy(src, 0, ret, 0, src.length);
        return ret;
    }

    private static double[] dup(double[] src) {
        if (src == null) {
            return null;
        }
        double[] ret = new double[src.length];
        System.arraycopy(src, 0, ret, 0, src.length);
        return ret;
    }

    public double getDelta() {
        return this.incr;
    }

    public double getStartX() {
        return this.start;
    }

    public void setStartX(double nStart) {
        this.start = nStart;
    }

    public String getName() {
        return this.name;
    }

    public void load(Element elem) {
        for (Node n2 = elem.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if ("opacity".equalsIgnoreCase(n2.getNodeName())) {
                Node nnm = n2.getAttributes().getNamedItem("opacityMode");
                this.opacityMode = 1;
                if (nnm != null) {
                    this.opacityMode = Integer.parseInt(nnm.getNodeValue());
                }
                String s2 = n2.getFirstChild().getNodeValue().trim();
                String[] v2 = s2.split("\\s+");
                this.opacityPos = new double[v2.length / 3];
                this.opacityBefore = new double[v2.length / 3];
                this.opacityAfter = new double[v2.length / 3];
                for (int i2 = 0; i2 < v2.length / 3; ++i2) {
                    this.opacityPos[i2] = Double.parseDouble(v2[i2 * 3]);
                    this.opacityBefore[i2] = Double.parseDouble(v2[i2 * 3 + 1]);
                    this.opacityAfter[i2] = Double.parseDouble(v2[i2 * 3 + 2]);
                    System.out.println("opacityAfter[" + i2 + "]=" + this.opacityAfter[i2]);
                }
            }
            if (!"RGB".equalsIgnoreCase(n2.getNodeName())) continue;
            this.blackwhitemode = Preset.getAttribute(n2, "blackwhitemode", this.blackwhitemode);
            this.contrastEnhancementMode = Preset.getAttribute(n2, "contrastEnhancementMode", 0);
            this.rgbNNeighbour = Preset.getAttribute(n2, "rgbNNeighbour", this.rgbNNeighbour);
            this.brightness = Preset.getAttribute(n2, BRIGHTNESS_CHANGED, this.brightness);
            String s3 = n2.getFirstChild().getNodeValue().trim();
            String[] v3 = s3.split("\\s+");
            this.rgbPos = new double[v3.length / 2];
            this.rgbValue = new int[v3.length / 2];
            for (int i3 = 0; i3 < v3.length / 2; ++i3) {
                this.rgbPos[i3] = Double.parseDouble(v3[i3 * 2]);
                this.rgbValue[i3] = Integer.decode(v3[i3 * 2 + 1]);
            }
        }
        this.putProperty(PAINT_CACHE_PROPERTY, null);
        this.fireActionPerformed(new ActionEvent(this, 0, BRIGHTNESS_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, COLOR_BW_MODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, OPMODE_CHANGED));
        this.fireActionPerformed(new ActionEvent(this, 0, RELOAD));
    }

    public void attachObjectAt(int pos) {
        if (this.opacityMode == 6) {
            if (this.opacityAtColor == null) {
                this.opacityAtColor = new double[this.rgbPos.length];
                Arrays.fill(this.opacityAtColor, -1.0);
            }
            this.opacityAtColor[pos] = 1.0;
            this.updateOpacityPts();
        }
    }

    public void detachObjectAt(int pos) {
        if (this.opacityMode == 6) {
            this.opacityAtColor[pos] = -1.0;
            this.updateOpacityPts();
        }
    }

    public void updateOpacityPts() {
        if (this.opacityMode == 6 && this.opacityAtColor != null) {
            int numPts = 0;
            for (int i2 = 0; i2 < this.opacityAtColor.length; ++i2) {
                if (!(this.opacityAtColor[i2] >= 0.0)) continue;
                ++numPts;
            }
            if (numPts > 0) {
                this.opacityBefore = Preset.realloc(this.opacityBefore, numPts * 5);
                this.opacityAfter = Preset.realloc(this.opacityAfter, numPts * 5);
                this.opacityPos = Preset.realloc(this.opacityPos, numPts * 5);
                int humpIndex = 0;
                for (int i3 = 0; i3 < this.opacityAtColor.length; ++i3) {
                    double dist;
                    if (this.opacityAtColor[i3] < 0.0) continue;
                    if (i3 == 0) {
                        this.opacityBefore[0] = this.opacityAtColor[i3];
                        this.opacityAfter[0] = this.opacityAtColor[i3];
                        this.opacityPos[0] = this.rgbPos[i3] - 10.0;
                        this.opacityBefore[1] = this.opacityAtColor[i3];
                        this.opacityAfter[1] = this.opacityAtColor[i3];
                        this.opacityPos[1] = this.rgbPos[i3] - 5.0;
                    } else {
                        dist = this.rgbPos[i3] - this.rgbPos[i3 - 1];
                        if (this.opacityAtColor[i3 - 1] < 0.0) {
                            this.opacityBefore[humpIndex * 5] = 0.0;
                            this.opacityAfter[humpIndex * 5] = 0.0;
                            this.opacityPos[humpIndex * 5] = this.rgbPos[i3 - 1] + dist * 0.8 * 0.5;
                        } else {
                            this.opacityBefore[humpIndex * 5] = (this.opacityAtColor[i3] + this.opacityAtColor[i3 - 1]) * 0.5;
                            this.opacityAfter[humpIndex * 5] = this.opacityBefore[humpIndex * 5];
                            this.opacityPos[humpIndex * 5] = this.rgbPos[i3 - 1] + dist * 0.5 + 0.01;
                        }
                        this.opacityBefore[humpIndex * 5 + 1] = this.opacityAtColor[i3];
                        this.opacityAfter[humpIndex * 5 + 1] = this.opacityAtColor[i3];
                        this.opacityPos[humpIndex * 5 + 1] = this.rgbPos[i3 - 1] + dist * 1.2 * 0.5;
                    }
                    this.opacityBefore[humpIndex * 5 + 2] = this.opacityAtColor[i3];
                    this.opacityAfter[humpIndex * 5 + 2] = this.opacityAtColor[i3];
                    this.opacityPos[humpIndex * 5 + 2] = this.rgbPos[i3];
                    if (i3 != this.opacityAtColor.length - 1) {
                        dist = this.rgbPos[i3 + 1] - this.rgbPos[i3];
                        this.opacityBefore[humpIndex * 5 + 3] = this.opacityAtColor[i3];
                        this.opacityAfter[humpIndex * 5 + 3] = this.opacityAtColor[i3];
                        this.opacityPos[humpIndex * 5 + 3] = this.rgbPos[i3] + dist * 0.8 * 0.5;
                        if (this.opacityAtColor[i3 + 1] < 0.0) {
                            this.opacityBefore[humpIndex * 5 + 4] = 0.0;
                            this.opacityAfter[humpIndex * 5 + 4] = 0.0;
                            this.opacityPos[humpIndex * 5 + 4] = this.rgbPos[i3] + dist * 1.2 * 0.5;
                        } else {
                            this.opacityBefore[humpIndex * 5 + 4] = (this.opacityAtColor[i3] + this.opacityAtColor[i3 + 1]) * 0.5;
                            this.opacityAfter[humpIndex * 5 + 4] = this.opacityBefore[humpIndex * 5 + 4];
                            this.opacityPos[humpIndex * 5 + 4] = this.rgbPos[i3] + dist * 0.5;
                        }
                    } else {
                        this.opacityBefore[humpIndex * 5 + 3] = this.opacityAtColor[i3];
                        this.opacityAfter[humpIndex * 5 + 3] = this.opacityAtColor[i3];
                        this.opacityPos[humpIndex * 5 + 3] = this.rgbPos[i3] + 5.0;
                        this.opacityBefore[humpIndex * 5 + 4] = this.opacityAtColor[i3];
                        this.opacityAfter[humpIndex * 5 + 4] = this.opacityAtColor[i3];
                        this.opacityPos[humpIndex * 5 + 4] = this.rgbPos[i3] + 10.0;
                    }
                    ++humpIndex;
                }
            } else {
                this.opacityBefore = Preset.realloc(this.opacityBefore, 2);
                this.opacityAfter = Preset.realloc(this.opacityAfter, 2);
                this.opacityPos = Preset.realloc(this.opacityPos, 2);
                Arrays.fill(this.opacityBefore, 0.0);
                Arrays.fill(this.opacityAfter, 0.0);
                this.opacityPos[0] = 0.0;
                this.opacityPos[1] = 1.0;
            }
        }
    }

    public void setRGBselected(int temp) {
        if (temp != this.rgbSelected) {
            this.rgbSelected = temp;
            this.fireActionPerformed(new ActionEvent(this, 0, COLOR_SELECT));
        }
    }

    public void setTransparency(int num) {
        if (num != this.transparency) {
            this.transparency = num;
            this.fireActionPerformed(new ActionEvent(this, 0, TRANSPARENCY_CHANGED));
        }
    }

    public void setEnhanceContours(boolean b2) {
        if (this.enhanceContours != b2) {
            this.enhanceContours = b2;
            this.fireActionPerformed(new ActionEvent(this, 0, ENHANCE_CONTOURS));
        }
    }

    public void putProperty(Object key, Object value) {
        if (value == null) {
            this.props.remove(key);
        } else {
            this.props.put(key, value);
        }
    }

    public Object getProperty(Object key) {
        return this.props.get(key);
    }
}

