/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.terra.jami.CodecUtils;

public class VrColorLut {
    public static final String COLORLUT_PROPERTY = "COLORLUT_PROPERTY";
    public double[] colorlut = null;
    public double startX = 0.0;
    public double deltaX = 1.0;

    public VrColorLut(double[] clut, double startX, double deltaX) {
        this.colorlut = new double[clut.length];
        System.arraycopy(clut, 0, this.colorlut, 0, clut.length);
        this.startX = startX;
        this.deltaX = deltaX;
    }

    public VrColorLut(VrColorLut colorLut) {
        this.colorlut = new double[colorLut.colorlut.length];
        this.startX = colorLut.startX;
        this.deltaX = colorLut.deltaX;
        System.arraycopy(colorLut.colorlut, 0, this.colorlut, 0, this.colorlut.length);
    }

    public Object clone() {
        return new VrColorLut(this);
    }

    public int toBytes(byte[] buffer, int offset) {
        int writeOffset = offset;
        CodecUtils.putFloat(buffer, writeOffset, (float)this.startX);
        CodecUtils.putFloat(buffer, writeOffset += 4, (float)this.deltaX);
        CodecUtils.putInt(buffer, writeOffset += 4, this.colorlut.length);
        writeOffset += 4;
        for (int i2 = 0; i2 < this.colorlut.length; ++i2) {
            CodecUtils.putFloat(buffer, writeOffset, (float)this.colorlut[i2]);
            writeOffset += 4;
        }
        return writeOffset;
    }

    public static Object createFromBytes(byte[] buffer, int offset, int[] length) {
        int readOffset = offset;
        double startX = CodecUtils.getFloat(buffer, readOffset);
        double deltaX = CodecUtils.getFloat(buffer, readOffset += 4);
        int len = CodecUtils.getInt(buffer, readOffset += 4);
        readOffset += 4;
        double[] clut = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            clut[i2] = CodecUtils.getFloat(buffer, readOffset);
            readOffset += 4;
        }
        VrColorLut vcl = new VrColorLut(clut, startX, deltaX);
        length[0] = readOffset;
        return vcl;
    }
}

