/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.VrPresetCurves;
import com.ge.med.terra.jami.render.PixelWindowing;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VrContext {
    public static final int MINMAX_SIDE_DIV = 2;
    public static final int MINMAX_DIV = 6;
    public static final int BINGRID_DIV = 3;
    public static final int BINGRID_MOD = 7;
    private static final String REFRESH_BINGRID = "REFRESH_BINGRID";
    public static final double CONTRIB_THRESHOLD = 1.0E-4;
    public JVolume.LinearVolume vol = null;
    public VrPreset preset = null;
    public VrPresetCurves presetCurves = null;
    private short[] mingrid = null;
    private short[] maxgrid = null;
    private byte[] bingrid = null;
    private byte[] base_bingrid = null;
    private byte[] seg_bingrid = null;
    public BoundingBox bbox = new BoundingBox();
    public int[] wlTable = new int[65536];
    private PixelWindowing pw = new PixelWindowing();
    private XpImagePixelAttributes ipa = new XpImagePixelAttributes();
    private List taskMonitors = new ArrayList();
    private static WeakReference weak_ptm;
    private ParallelTaskManager ptm = null;
    private Object minmaxLock = new Object();
    private boolean initMinMax = true;

    private ParallelTaskManager getThreadPool() {
        ParallelTaskManager ptm;
        if (weak_ptm != null && weak_ptm.get() != null) {
            ptm = (ParallelTaskManager)weak_ptm.get();
        } else {
            ptm = new ParallelTaskManager();
            weak_ptm = new WeakReference<ParallelTaskManager>(ptm);
        }
        return ptm;
    }

    public VrContext(JVolume.LinearVolume vol) {
        this.vol = vol;
        this.bbox.init();
        this.setWindowing(vol.initWW, vol.initWL);
    }

    private VrContext(JVolume.LinearVolume vol, VrPreset preset, byte[] bingrid, byte[] basebingrid, byte[] segbingrid, BoundingBox bb) {
        this(vol);
        this.preset = preset;
        this.base_bingrid = new byte[basebingrid.length];
        System.arraycopy(basebingrid, 0, this.base_bingrid, 0, basebingrid.length);
        this.bingrid = new byte[bingrid.length];
        System.arraycopy(bingrid, 0, this.bingrid, 0, bingrid.length);
        this.seg_bingrid = new byte[segbingrid.length];
        System.arraycopy(segbingrid, 0, this.seg_bingrid, 0, segbingrid.length);
        this.bbox.set(bb);
        this.init(false);
    }

    public void savePreset(String fileName) {
        if (this.presetCurves != null) {
            this.presetCurves.savePreset(fileName);
        }
    }

    public void setWindowing(double ww, double wl) {
        this.ipa.setWindowing(ww, wl);
        this.pw.fillColorTable(this.ipa, this.wlTable, this.vol.rescaleSlope, this.vol.rescaleIntercept, this.vol.pixelRepresentation);
    }

    public static VrContext genContext(JVolume.LinearVolume vol, VrPreset preset) {
        VrContext vrc = new VrContext(vol);
        vrc.setPreset(preset);
        return vrc;
    }

    public int[] createColorLut() {
        return this.presetCurves.createColorLut();
    }

    public void setPreset(VrPreset preset) {
        this.preset = preset;
        this.init(true);
    }

    public void setColorLut(VrColorLut clut) {
        this.presetCurves.build_colortable(clut.colorlut, clut.startX, clut.deltaX);
    }

    public final void refreshVrContext(int[] zpos, int zposlen) {
        double preset_scale = this.getModalityPresetScale();
        int[] rawthresh = this.modalityThreshToRaw(this.preset.thresh1, this.preset.thresh2, preset_scale);
        this.refresh_bingrid(rawthresh[0], rawthresh[1], zpos, zposlen, false, false);
    }

    private final void init(boolean initBingrid) {
        double preset_scale = this.getModalityPresetScale();
        int[] rawthresh = this.modalityThreshToRaw(this.preset.thresh1, this.preset.thresh2, preset_scale);
        this.presetCurves = new VrPresetCurves(this.preset, preset_scale, this.vol.rescaleSlope, this.vol.rescaleIntercept, this.vol.ras_spx, this.vol.ras_spy);
        if (initBingrid) {
            this.init_bingrid(rawthresh[0], rawthresh[1]);
        }
    }

    private double getModalityPresetScale() {
        double preset_scale = 1.0;
        if (this.preset != null && this.preset.modality.toUpperCase().equals("PET")) {
            preset_scale = 1000.0;
        }
        return preset_scale;
    }

    private int[] modalityThreshToRaw(int modthresh1, int modthresh2, double preset_scale) {
        JVolume.LinearVolume jvs = this.vol;
        double slope = jvs.rescaleSlope;
        double intercept = jvs.rescaleIntercept;
        double thresh1 = (double)modthresh1 * preset_scale;
        double thresh2 = (double)modthresh2 * preset_scale;
        int rawthresh1 = VrContext.raw_value(thresh1, slope, intercept);
        int rawthresh2 = VrContext.raw_value(thresh2, slope, intercept);
        return new int[]{rawthresh1, rawthresh2};
    }

    public final boolean bingridAnd(byte[] mask) {
        if (this.seg_bingrid != null && this.seg_bingrid.length == mask.length) {
            for (int i2 = 0; i2 < this.seg_bingrid.length; ++i2) {
                int mval = mask[i2] & 0xFF;
                int bval = this.seg_bingrid[i2] & 0xFF;
                int sval = mval & bval;
                this.seg_bingrid[i2] = (byte)sval;
                int bbval = this.base_bingrid[i2] & 0xFF;
                this.bingrid[i2] = (byte)(sval & bbval);
            }
            return true;
        }
        if (this.seg_bingrid != null) {
            XpLog.logger().warning("bingrid mismatch!" + this.seg_bingrid.length + " <-> " + mask.length);
        }
        return false;
    }

    public final boolean bingridOr(byte[] mask) {
        if (this.seg_bingrid != null && this.seg_bingrid.length == mask.length) {
            for (int i2 = 0; i2 < this.seg_bingrid.length; ++i2) {
                int mval = mask[i2] & 0xFF;
                int bval = this.seg_bingrid[i2] & 0xFF;
                int sval = mval | bval;
                this.seg_bingrid[i2] = (byte)sval;
                int bbval = this.base_bingrid[i2] & 0xFF;
                this.bingrid[i2] = (byte)(sval & bbval);
            }
            return true;
        }
        if (this.seg_bingrid != null) {
            XpLog.logger().warning("bingrid mismatch!" + this.seg_bingrid.length + " <-> " + mask.length);
        }
        return false;
    }

    public final boolean setSegBingrid(byte[] mask) {
        if (this.seg_bingrid != null && this.seg_bingrid.length == mask.length) {
            System.arraycopy(mask, 0, this.seg_bingrid, 0, this.seg_bingrid.length);
            for (int i2 = 0; i2 < this.seg_bingrid.length; ++i2) {
                int bval = this.seg_bingrid[i2] & 0xFF;
                int bbval = this.base_bingrid[i2] & 0xFF;
                this.bingrid[i2] = (byte)(bval & bbval);
            }
            return true;
        }
        if (this.seg_bingrid != null) {
            XpLog.logger().warning("bingrid mismatch!" + this.seg_bingrid.length + " <-> " + mask.length);
        }
        return false;
    }

    public final boolean bingridNot() {
        for (int i2 = 0; i2 < this.seg_bingrid.length; ++i2) {
            int bval = this.seg_bingrid[i2] & 0xFF;
            int sval = ~bval;
            this.seg_bingrid[i2] = (byte)sval;
            int bbval = this.base_bingrid[i2] & 0xFF;
            this.bingrid[i2] = (byte)(sval & bbval);
        }
        return true;
    }

    public final void resetBingrid() {
        System.arraycopy(this.base_bingrid, 0, this.bingrid, 0, this.bingrid.length);
        Arrays.fill(this.seg_bingrid, (byte)-1);
        this.bbox.init();
        this.getBoundingBox(this.bingrid, this.vol.dx, this.vol.dy, this.vol.dz, this.bbox);
    }

    public void init_bingrid(double thresh1, double thresh2) {
        long t0 = System.currentTimeMillis();
        int[] zpos = new int[this.vol.dz];
        for (int i2 = 0; i2 < zpos.length; ++i2) {
            zpos[i2] = i2;
        }
        int visible_voxels = this.refresh_bingrid(thresh1, thresh2, zpos, zpos.length, true, true);
        int totalvoxels = this.vol.dx * this.vol.dy * this.vol.dz;
        double pctvisible = (double)visible_voxels / (double)totalvoxels * 100.0;
        long t2 = System.currentTimeMillis() - t0;
        XpLog.logger().config("VrContext.init_bingrid: " + t2 + "  [" + pctvisible + "]");
        System.err.println("VrContext.init_bingrid: " + t2 + "  [" + pctvisible + "]");
    }

    public static double visible_grid(byte[] grid, int dx, int dy, int dz) {
        int rowlen = dx + 7 >> 3;
        int pgsize = rowlen * dy;
        int visible = 0;
        for (int z2 = 0; z2 < dz; ++z2) {
            int zoffset = pgsize * z2;
            for (int y2 = 0; y2 < dy; ++y2) {
                int offset = zoffset + y2 * rowlen;
                for (int xx = 0; xx < rowlen; ++xx) {
                    byte grid_item = grid[offset + xx];
                    for (int i2 = 0; i2 < 8; ++i2) {
                        int bit = grid_item >> i2 & 1;
                        visible += bit;
                    }
                }
            }
        }
        double pct = (double)visible / (double)(dx * dy * dz);
        return pct;
    }

    private static void mark_bingrid8(byte[] bingrid, int x2, int y2, int z2, int bx, int by) {
        int ix = x2;
        int iy = y2;
        int iz = z2;
        int bpsize = bx * by >> 3;
        int brsize = bx >> 3;
        int idx = iz * bx * by + iy * bx + ix;
        int mod = idx & 7;
        int v2 = 1 << mod;
        int n2 = idx >>= 3;
        bingrid[n2] = (byte)(bingrid[n2] | v2);
        int n3 = idx - brsize;
        bingrid[n3] = (byte)(bingrid[n3] | v2);
        int n4 = idx - bpsize;
        bingrid[n4] = (byte)(bingrid[n4] | v2);
        int n5 = idx - bpsize - brsize;
        bingrid[n5] = (byte)(bingrid[n5] | v2);
        if (mod > 0) {
            v2 = 1 << mod - 1;
            int n6 = idx;
            bingrid[n6] = (byte)(bingrid[n6] | v2);
            int n7 = idx - brsize;
            bingrid[n7] = (byte)(bingrid[n7] | v2);
            int n8 = idx - bpsize;
            bingrid[n8] = (byte)(bingrid[n8] | v2);
            int n9 = idx - bpsize - brsize;
            bingrid[n9] = (byte)(bingrid[n9] | v2);
        } else {
            v2 = 128;
            int n10 = --idx;
            bingrid[n10] = (byte)(bingrid[n10] | v2);
            int n11 = idx - brsize;
            bingrid[n11] = (byte)(bingrid[n11] | v2);
            int n12 = idx - bpsize;
            bingrid[n12] = (byte)(bingrid[n12] | v2);
            int n13 = idx - bpsize - brsize;
            bingrid[n13] = (byte)(bingrid[n13] | v2);
        }
    }

    private void build_minmax_thread(int x0, int xstep, int mdx, int mdy, int mdz, int mpgsize) {
        int MINMAX_SIDE = 4;
        int VOL_OFFSET = this.vol.PAD;
        int pgsize = this.vol.dx * this.vol.dy;
        if (this.vol instanceof JVolume.LinearShort) {
            short[] volume = ((JVolume.LinearShort)this.vol).volume;
            for (int z2 = 0; z2 < mdz - 1; ++z2) {
                int iz = z2 << 2;
                int zoffset = z2 * mpgsize;
                for (int y2 = 0; y2 < mdy - 1; ++y2) {
                    int iy = y2 << 2;
                    int moffset = zoffset + y2 * mdx;
                    for (int x2 = x0; x2 < mdx - 1; x2 += xstep) {
                        int ix = x2 << 2;
                        short s2 = Integer.MAX_VALUE;
                        short s3 = Integer.MIN_VALUE;
                        for (int zz = 0; zz <= 4; ++zz) {
                            int zzoffset = VOL_OFFSET + (iz + zz) * pgsize;
                            for (int yy = 0; yy <= 4; ++yy) {
                                int voffset = zzoffset + (iy + yy) * this.vol.dx;
                                for (int xx = 0; xx <= 4; ++xx) {
                                    short voxel = volume[voffset + ix + xx];
                                    if (voxel > s3) {
                                        s3 = voxel;
                                    }
                                    if (voxel >= s2) continue;
                                    s2 = voxel;
                                }
                            }
                        }
                        this.mingrid[moffset + x2] = s2;
                        this.maxgrid[moffset + x2] = s3;
                    }
                }
            }
        } else {
            byte[] volume = ((JVolume.LinearByte)this.vol).volume;
            for (int z3 = 0; z3 < mdz - 1; ++z3) {
                int iz = z3 << 2;
                int zoffset = z3 * mpgsize;
                for (int y3 = 0; y3 < mdy - 1; ++y3) {
                    int iy = y3 << 2;
                    int moffset = zoffset + y3 * mdx;
                    for (int x3 = x0; x3 < mdx - 1; x3 += xstep) {
                        int ix = x3 << 2;
                        int n2 = Integer.MAX_VALUE;
                        int n3 = Integer.MIN_VALUE;
                        for (int zz = 0; zz <= 4; ++zz) {
                            int zzoffset = VOL_OFFSET + (iz + zz) * pgsize;
                            for (int yy = 0; yy <= 4; ++yy) {
                                int voffset = zzoffset + (iy + yy) * this.vol.dx;
                                for (int xx = 0; xx <= 4; ++xx) {
                                    int voxel = volume[voffset + ix + xx] & 0xFF;
                                    if (voxel > n3) {
                                        n3 = voxel;
                                    }
                                    if (voxel >= n2) continue;
                                    n2 = voxel;
                                }
                            }
                        }
                        this.mingrid[moffset + x3] = (short)n2;
                        this.maxgrid[moffset + x3] = (short)n3;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build_minmax() {
        long t0 = System.currentTimeMillis();
        Object object = this.minmaxLock;
        synchronized (object) {
            if (this.initMinMax) {
                int PADIT = 3;
                int mdx = this.vol.dx + 3 >> 2;
                int mdy = this.vol.dy + 3 >> 2;
                int mdz = (int)Math.ceil((double)this.vol.dz / 4.0);
                int mlen = mdx * mdy * mdz;
                this.alloc_grids();
                if (this.mingrid == null || this.mingrid.length != mlen) {
                    this.mingrid = new short[mlen];
                    this.maxgrid = new short[mlen];
                }
                Arrays.fill(this.mingrid, (short)-32766);
                Arrays.fill(this.maxgrid, (short)32766);
                ParallelTaskManager ptm = this.getThreadPool();
                int nworkers = ParallelTaskManager.getNumCPU();
                Worker[] worker = new MinMaxGridWorker[nworkers];
                for (int i2 = 0; i2 < worker.length; ++i2) {
                    worker[i2] = new MinMaxGridWorker(ptm, i2);
                }
                ptm.setWorkers(worker);
                MinMaxGridWorkData wdata = new MinMaxGridWorkData();
                wdata.mdx = mdx;
                wdata.mdy = mdy;
                wdata.mdz = mdz;
                wdata.mpgsize = mdx * mdy;
                ptm.launch(wdata);
                this.initMinMax = false;
            }
        }
        long time = System.currentTimeMillis() - t0;
        System.err.println("----- new-min/maxgrid = " + time);
    }

    private static int updateBingridOpacity(double thresh1, double thresh2, int z0, int z1, int zdelta, int[] zpos, VrContext ctxt, int ctype, BoundingBox bbox, byte[] bingrid) {
        int visible_voxels = 0;
        int max_x = bbox.max[0];
        int max_y = bbox.max[1];
        int max_z = bbox.max[2];
        int min_x = bbox.min[0];
        int min_y = bbox.min[1];
        int min_z = bbox.min[2];
        double[] opacity_table = ctxt.presetCurves.opacity_table;
        JVolume.LinearVolume vol = ctxt.vol;
        int pgsize = vol.dx * vol.dy;
        int bx = vol.dx;
        int by = vol.dy;
        int bz = vol.dz;
        int blen = bx * by * bz;
        int bingrid_len = blen >> 3;
        int PAD = vol.PAD;
        if (vol instanceof JVolume.LinearShort) {
            short[] volume = ((JVolume.LinearShort)vol).volume;
            for (int zidx = z0; zidx < z1; zidx += zdelta) {
                short v0;
                int x2;
                int idx;
                int yoffset;
                int y2;
                int z2 = zpos[zidx];
                if (z2 == 0) continue;
                int zoffset = PAD + z2 * pgsize;
                if (ctype != 105) {
                    for (y2 = 1; y2 < vol.dy; ++y2) {
                        yoffset = y2 * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x2 = 1; x2 < vol.dx; ++x2) {
                            int n2 = idx++;
                            v0 = volume[n2];
                            if (!((double)v0 >= thresh1) || !((double)v0 <= thresh2)) continue;
                            VrContext.mark_bingrid8(bingrid, x2, y2, z2, bx, by);
                            ++visible_voxels;
                            if (max_x < x2) {
                                max_x = x2;
                            } else if (min_x > x2) {
                                min_x = x2;
                            }
                            if (max_y < y2) {
                                max_y = y2;
                            } else if (min_y > y2) {
                                min_y = y2;
                            }
                            max_z = z2;
                        }
                    }
                } else {
                    for (y2 = 1; y2 < vol.dy; ++y2) {
                        yoffset = y2 * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x2 = 1; x2 < vol.dx; ++x2) {
                            int n3 = idx++;
                            v0 = volume[n3];
                            double op_val = opacity_table[8192 + v0];
                            if (!(op_val > 0.0)) continue;
                            VrContext.mark_bingrid8(bingrid, x2, y2, z2, bx, by);
                            ++visible_voxels;
                            if (max_x < x2) {
                                max_x = x2;
                            } else if (min_x > x2) {
                                min_x = x2;
                            }
                            if (max_y < y2) {
                                max_y = y2;
                            } else if (min_y > y2) {
                                min_y = y2;
                            }
                            max_z = z2;
                        }
                    }
                }
                if (visible_voxels > 0 && z2 < min_z) {
                    min_z = z2;
                }
                ctxt.notifyTaskProgress(REFRESH_BINGRID, zidx);
            }
        } else if (vol instanceof JVolume.LinearByte) {
            byte[] volume = ((JVolume.LinearByte)vol).volume;
            for (int zidx = z0; zidx < z1; zidx += zdelta) {
                int v0;
                int x3;
                int idx;
                int yoffset;
                int y3;
                int z3 = zpos[zidx];
                if (z3 == 0) continue;
                int zoffset = PAD + z3 * pgsize;
                if (ctype != 105) {
                    for (y3 = 1; y3 < vol.dy; ++y3) {
                        yoffset = y3 * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x3 = 1; x3 < vol.dx; ++x3) {
                            int n4 = idx++;
                            v0 = volume[n4] & 0xFF;
                            if (!((double)v0 >= thresh1) || !((double)v0 <= thresh2)) continue;
                            VrContext.mark_bingrid8(bingrid, x3, y3, z3, bx, by);
                            ++visible_voxels;
                            if (max_x < x3) {
                                max_x = x3;
                            } else if (min_x > x3) {
                                min_x = x3;
                            }
                            if (max_y < y3) {
                                max_y = y3;
                            } else if (min_y > y3) {
                                min_y = y3;
                            }
                            max_z = z3;
                        }
                    }
                } else {
                    for (y3 = 1; y3 < vol.dy; ++y3) {
                        yoffset = y3 * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x3 = 1; x3 < vol.dx; ++x3) {
                            int n5 = idx++;
                            v0 = volume[n5] & 0xFF;
                            double op_val = opacity_table[8192 + v0];
                            if (!(op_val > 0.0)) continue;
                            VrContext.mark_bingrid8(bingrid, x3, y3, z3, bx, by);
                            ++visible_voxels;
                            if (max_x < x3) {
                                max_x = x3;
                            } else if (min_x > x3) {
                                min_x = x3;
                            }
                            if (max_y < y3) {
                                max_y = y3;
                            } else if (min_y > y3) {
                                min_y = y3;
                            }
                            max_z = z3;
                        }
                    }
                }
                if (visible_voxels > 0 && z3 < min_z) {
                    min_z = z3;
                }
                ctxt.notifyTaskProgress(REFRESH_BINGRID, zidx);
            }
        }
        VrContext.updateBingridBBox(bbox, min_x, min_y, min_z, max_x, max_y, max_z);
        return visible_voxels;
    }

    private void rebuild_bingrid() {
        for (int i2 = 0; i2 < this.seg_bingrid.length; ++i2) {
            int bval = this.seg_bingrid[i2] & 0xFF;
            int bbval = this.base_bingrid[i2] & 0xFF;
            this.bingrid[i2] = (byte)(bval & bbval);
        }
    }

    private void alloc_grids() {
        int bx = this.vol.dx;
        int by = this.vol.dy;
        int bz = this.vol.dz;
        int bingrid_len = ((bx - 1) / 8 + 1) * by * bz;
        if (this.bingrid == null || this.bingrid.length != bingrid_len) {
            this.bingrid = new byte[bingrid_len];
            this.base_bingrid = new byte[bingrid_len];
            this.seg_bingrid = new byte[bingrid_len];
            Arrays.fill(this.seg_bingrid, (byte)-1);
        }
    }

    private int refresh_bingrid(double thresh1, double thresh2, int[] zpos, int zposlen, boolean erase, boolean dilate) {
        int ctype = this.preset != null ? VrPresetCurves.vr_curvetype(this.preset.curvetype) : 301;
        this.alloc_grids();
        if (erase) {
            Arrays.fill(this.bingrid, (byte)0);
            Arrays.fill(this.base_bingrid, (byte)0);
            this.bbox.init();
        }
        this.notifyTaskBegin(REFRESH_BINGRID, zpos.length);
        int nworkers = ParallelTaskManager.getNumCPU();
        BingridWorkData bdata = new BingridWorkData(nworkers);
        Worker[] bworkers = new BingridWorker[nworkers];
        this.ptm = this.getThreadPool();
        bdata.clearVisibleVoxels();
        bdata.setBBox(this.bbox);
        bdata.thresh1 = thresh1;
        bdata.thresh2 = thresh2;
        bdata.zpos = zpos;
        bdata.ctype = ctype;
        bdata.opacity_table = this.presetCurves.opacity_table;
        bdata.bingrid = this.base_bingrid;
        bdata.ctxt = this;
        for (int i2 = 0; i2 < nworkers; ++i2) {
            bworkers[i2] = new BingridWorker(this.ptm, i2);
        }
        this.ptm.setWorkers(bworkers);
        this.ptm.launch(bdata);
        bdata.ctxt = null;
        bdata.bingrid = null;
        bdata.opacity_table = null;
        this.bbox.set(bdata.getBoundingBox());
        int visible_voxels = bdata.getVisibleVoxels();
        int max_x = this.bbox.max[0];
        int max_y = this.bbox.max[1];
        int max_z = this.bbox.max[2];
        int min_x = this.bbox.min[0];
        int min_y = this.bbox.min[1];
        int min_z = this.bbox.min[2];
        if (visible_voxels <= 0 && erase) {
            min_x = 0;
            min_y = 0;
            min_z = 0;
            max_x = this.vol.dx - 1;
            max_y = this.vol.dy - 1;
            max_z = this.vol.dz - 1;
        }
        VrContext.updateBingridBBox(this.bbox, min_x, min_y, min_z, max_x, max_y, max_z);
        if (dilate) {
            VrContext.dilate(this.base_bingrid, this.vol.dx, this.vol.dy, this.vol.dz);
        }
        this.rebuild_bingrid();
        this.notifyTaskDone(REFRESH_BINGRID);
        return visible_voxels;
    }

    private static void updateBingridBBox(BoundingBox bbox, int min_x, int min_y, int min_z, int max_x, int max_y, int max_z) {
        bbox.min[0] = bbox.min[0] > min_x ? min_x : bbox.min[0];
        bbox.min[1] = bbox.min[1] > min_y ? min_y : bbox.min[1];
        bbox.min[2] = bbox.min[2] > min_z ? min_z : bbox.min[2];
        bbox.max[0] = bbox.max[0] < max_x ? max_x : bbox.max[0];
        bbox.max[1] = bbox.max[1] < max_y ? max_y : bbox.max[1];
        bbox.max[2] = bbox.max[2] < max_z ? max_z : bbox.max[2];
        bbox.center[0] = bbox.min[0] + bbox.max[0] >> 1;
        bbox.center[1] = bbox.min[1] + bbox.max[1] >> 1;
        bbox.center[2] = bbox.min[2] + bbox.max[2] >> 1;
    }

    private void getBoundingBox(byte[] bingrid, int dx, int dy, int dz, BoundingBox bb) {
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        int min_x = dx - 1;
        int min_y = dy - 1;
        int min_z = dz - 1;
        int idx = 0;
        for (int z2 = 0; z2 < dz; ++z2) {
            for (int y2 = 0; y2 < dy; ++y2) {
                int x2 = 0;
                while (x2 < dx) {
                    int bidx = idx >> 3;
                    byte binval = bingrid[bidx];
                    int bpos = idx & 7;
                    int one = binval & 1 << bpos;
                    if (one != 0) {
                        if (max_x < x2) {
                            max_x = x2;
                        }
                        if (min_x > x2) {
                            min_x = x2;
                        }
                        if (max_y < y2) {
                            max_y = y2;
                        }
                        if (min_y > y2) {
                            min_y = y2;
                        }
                        if (max_z < z2) {
                            max_z = z2;
                        }
                        if (min_z > z2) {
                            min_z = z2;
                        }
                    }
                    ++x2;
                    ++idx;
                }
            }
        }
        this.bbox.min[0] = min_x;
        this.bbox.min[1] = min_y;
        this.bbox.min[2] = min_z;
        this.bbox.max[0] = max_x;
        this.bbox.max[1] = max_y;
        this.bbox.max[2] = max_z;
        this.bbox.center[0] = this.bbox.min[0] + this.bbox.max[0] >> 1;
        this.bbox.center[1] = this.bbox.min[1] + this.bbox.max[1] >> 1;
        this.bbox.center[2] = this.bbox.min[2] + this.bbox.max[2] >> 1;
    }

    private static double modality_value(double rawval, double slope, double intercept) {
        return (int)(rawval * slope + intercept);
    }

    private static int raw_value(double modval, double slope, double intercept) {
        return (int)((modval - intercept) / slope);
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.add(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.remove(tm);
    }

    protected void notifyTaskBegin(String taskName, int totalWork) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i2);
            tm.taskBegin(taskName, totalWork);
        }
    }

    protected void notifyTaskDone(String taskName) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i2);
            tm.taskDone(taskName);
        }
    }

    protected void notifyTaskProgress(String taskName, int units) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i2);
            tm.taskProgress(taskName, units);
        }
    }

    public static void dilate(byte[] bits, int dx, int dy, int dz) {
        VrContext.dilate_x(bits, dx, dy, dz);
        VrContext.dilate_y(bits, dx, dy, dz);
        VrContext.dilate_z(bits, dx, dy, dz);
    }

    public static void erode(byte[] bits, int dx, int dy, int dz) {
        int i2;
        for (i2 = 0; i2 < bits.length; ++i2) {
            bits[i2] = (byte)(~(bits[i2] & 0xFF));
        }
        VrContext.dilate(bits, dx, dy, dz);
        for (i2 = 0; i2 < bits.length; ++i2) {
            bits[i2] = (byte)(~(bits[i2] & 0xFF));
        }
    }

    private static void dilate_x(byte[] bits, int dx, int dy, int dz) {
        int idx = 0;
        for (int z2 = 0; z2 < dz; ++z2) {
            for (int y2 = 0; y2 < dy; ++y2) {
                byte m2;
                int x2 = 0;
                int a2 = 0;
                a2 = 0;
                for (x2 = 0; x2 < dx - 8; x2 += 8) {
                    m2 = bits[idx];
                    byte c2 = bits[idx + 1];
                    int val = (m2 | m2 << 1 | m2 >> 1 | a2 | c2) & 0xFF;
                    bits[idx++] = (byte)val;
                    a2 = (m2 & 0x80) >> 7;
                }
                m2 = bits[idx];
                int val = (m2 | m2 << 1 | m2 >> 1 | a2) & 0xFF;
                bits[idx++] = (byte)val;
            }
        }
    }

    private static void dilate_y(byte[] bits, int dx, int dy, int dz) {
        int SIZEOF_INT = 4;
        int lsize_int = dx / 8;
        int pglen = dx * dy / 8;
        int idx = 0;
        int z2 = 0;
        while (z2 < dz) {
            for (int x2 = 0; x2 < dx; x2 += 32) {
                int val;
                int idx1 = idx + (x2 >> 3);
                int b0 = bits[idx1] & 0xFF;
                int b1 = bits[idx1 + 1] & 0xFF;
                int b2 = bits[idx1 + 2] & 0xFF;
                int b3 = bits[idx1 + 3] & 0xFF;
                int b4 = b0 | b1 << 8 | b2 << 16 | b3 << 24;
                int y2 = 0;
                int a2 = 0;
                while (y2 < dy - 2) {
                    b0 = bits[idx1 + lsize_int] & 0xFF;
                    b1 = bits[idx1 + lsize_int + 1] & 0xFF;
                    b2 = bits[idx1 + lsize_int + 2] & 0xFF;
                    b3 = bits[idx1 + lsize_int + 3] & 0xFF;
                    int c2 = b0 | b1 << 8 | b2 << 16 | b3 << 24;
                    val = a2 | b4 | c2;
                    bits[idx1] = (byte)(val & 0xFF);
                    bits[idx1 + 1] = (byte)(val >> 8 & 0xFF);
                    bits[idx1 + 2] = (byte)(val >> 16 & 0xFF);
                    bits[idx1 + 3] = (byte)(val >> 24 & 0xFF);
                    ++y2;
                    a2 = b4;
                    b4 = c2;
                    idx1 += lsize_int;
                }
                val = a2 | b4;
                bits[idx1] = (byte)(val & 0xFF);
                bits[idx1 + 1] = (byte)(val >> 8 & 0xFF);
                bits[idx1 + 2] = (byte)(val >> 16 & 0xFF);
                bits[idx1 + 3] = (byte)(val >> 24 & 0xFF);
            }
            ++z2;
            idx += pglen;
        }
    }

    private static void dilate_z(byte[] bits, int dx, int dy, int dz) {
        int psize = dx * dy / 8;
        int SIZEOF_INT = 4;
        int idx = 0;
        byte[] tmpslice = new byte[psize];
        if (dx / 8 % 4 == 0 && tmpslice != null) {
            int z2 = 0;
            while (z2 < dz - 1) {
                int line1 = idx;
                int line2 = line1 + psize;
                int tmp = 0;
                int x2 = 0;
                while (x2 < psize) {
                    byte line1Val = bits[line1];
                    byte line2Val = bits[line2];
                    byte tmpVal = tmpslice[tmp];
                    int a2 = tmpVal | line1Val | line2Val;
                    tmpslice[tmp] = line1Val;
                    bits[line1] = (byte)a2;
                    ++x2;
                    ++line1;
                    ++line2;
                    ++tmp;
                }
                ++z2;
                idx += psize;
            }
        } else {
            int lplane = psize;
            int y2 = 0;
            while (y2 < dy) {
                for (int x3 = 0; x3 < dx; x3 += 8) {
                    int idx1 = idx + (x3 >> 3);
                    int z3 = 0;
                    byte a3 = 0;
                    byte b2 = bits[idx1];
                    while (z3 < dz - 1) {
                        byte c2 = bits[idx1 + lplane];
                        int val = a3 | b2 | c2;
                        bits[idx1] = (byte)val;
                        ++z3;
                        a3 = b2;
                        b2 = c2;
                        idx1 += lplane;
                    }
                    bits[idx1] = (byte)(a3 | b2);
                }
                ++y2;
                idx += dx / 8;
            }
        }
    }

    private static void bingrid_stats(byte[] bingrid) {
        int nones = 0;
        int nzeros = 0;
        int total = 0;
        for (int i2 = 0; i2 < bingrid.length; ++i2) {
            byte val = bingrid[i2];
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((val & 1 << j2) != 0) {
                    ++nones;
                } else {
                    ++nzeros;
                }
                ++total;
            }
        }
        double pct = (double)nones / (double)total * 100.0;
        System.err.println("BINGRID STATS:  #1s=" + nones + " [" + pct + "%]   #0s=" + nzeros);
    }

    public final byte[] getBaseBingrid() {
        return this.base_bingrid;
    }

    public final byte[] getBingrid() {
        return this.bingrid;
    }

    public final byte[] getSegBingrid() {
        return this.seg_bingrid;
    }

    public Object clone() {
        VrContext vrc = new VrContext(this.vol, this.preset, this.bingrid, this.base_bingrid, this.seg_bingrid, this.bbox);
        return vrc;
    }

    public void reset() {
        this.initMinMax = true;
    }

    public void initMip() {
        if (this.initMinMax) {
            this.build_minmax();
        }
    }

    public short[] getMingrid() {
        this.initMip();
        return this.mingrid;
    }

    public short[] getMaxgrid() {
        this.initMip();
        return this.maxgrid;
    }

    public boolean isDirtyMinMax() {
        return this.initMinMax;
    }

    private static class BingridWorker
    extends Worker {
        public BingridWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            BingridWorkData bwd = (BingridWorkData)data;
            int ref_zskip = nWorkers;
            int ref_zstart = workerId;
            bwd.visible_voxels[workerId] = VrContext.updateBingridOpacity(bwd.thresh1, bwd.thresh2, ref_zstart, bwd.zpos.length, ref_zskip, bwd.zpos, bwd.ctxt, bwd.ctype, bwd.bbox[workerId], bwd.bingrid);
        }
    }

    private static class BingridWorkData {
        public int[] visible_voxels = null;
        public BoundingBox[] bbox = null;
        private BoundingBox thebbox = new BoundingBox();
        public double thresh1;
        public double thresh2;
        public int[] zpos;
        public VrContext ctxt;
        public int ctype;
        public double[] opacity_table;
        public byte[] bingrid;

        public BingridWorkData(int nworkers) {
            this.thebbox.init();
            this.visible_voxels = new int[nworkers];
            this.bbox = new BoundingBox[nworkers];
            for (int i2 = 0; i2 < nworkers; ++i2) {
                this.bbox[i2] = new BoundingBox();
                this.bbox[i2].init();
            }
        }

        public void clearVisibleVoxels() {
            for (int i2 = 0; i2 < this.visible_voxels.length; ++i2) {
                this.visible_voxels[i2] = 0;
            }
        }

        public void setBBox(BoundingBox bb) {
            for (int i2 = 0; i2 < this.bbox.length; ++i2) {
                this.bbox[i2].set(bb);
            }
        }

        public int getVisibleVoxels() {
            int sum = 0;
            for (int i2 = 0; i2 < this.visible_voxels.length; ++i2) {
                sum += this.visible_voxels[i2];
            }
            return sum;
        }

        public BoundingBox getBoundingBox() {
            int i2;
            int s2;
            int dim;
            for (dim = 0; dim < 3; ++dim) {
                s2 = 9999999;
                for (i2 = 0; i2 < this.bbox.length; ++i2) {
                    if (this.bbox[i2].min[dim] >= s2) continue;
                    s2 = this.bbox[i2].min[dim];
                }
                this.thebbox.min[dim] = s2;
            }
            for (dim = 0; dim < 3; ++dim) {
                s2 = -9999999;
                for (i2 = 0; i2 < this.bbox.length; ++i2) {
                    if (this.bbox[i2].max[dim] <= s2) continue;
                    s2 = this.bbox[i2].max[dim];
                }
                this.thebbox.max[dim] = s2;
            }
            this.thebbox.center[0] = this.thebbox.min[0] + this.thebbox.max[0] >> 1;
            this.thebbox.center[1] = this.thebbox.min[1] + this.thebbox.max[1] >> 1;
            this.thebbox.center[2] = this.thebbox.min[2] + this.thebbox.max[2] >> 1;
            return this.thebbox;
        }
    }

    private class MinMaxGridWorker
    extends Worker {
        public MinMaxGridWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            MinMaxGridWorkData mworkData = (MinMaxGridWorkData)data;
            VrContext.this.build_minmax_thread(workerId, nWorkers, mworkData.mdx, mworkData.mdy, mworkData.mdz, mworkData.mpgsize);
        }
    }

    private static class MinMaxGridWorkData {
        public int mdx;
        public int mdy;
        public int mdz;
        public int mpgsize;

        private MinMaxGridWorkData() {
        }
    }

    public static class BoundingBox {
        public int[] min = new int[3];
        public int[] max = new int[3];
        public int[] center = new int[3];

        public BoundingBox() {
            this.init();
        }

        public String toString() {
            return " BBOX: min=[" + this.min[0] + "," + this.min[1] + "," + this.min[2] + "] max=[" + this.max[0] + "," + this.max[1] + "," + this.max[2] + "] center=[" + this.center[0] + "," + this.center[1] + "," + this.center[2] + "]";
        }

        public void init() {
            this.min[0] = 99999;
            this.min[1] = 99999;
            this.min[2] = 99999;
            this.max[0] = -99999;
            this.max[1] = -99999;
            this.max[2] = -99999;
        }

        public void set(BoundingBox other) {
            System.arraycopy(other.min, 0, this.min, 0, this.min.length);
            System.arraycopy(other.max, 0, this.max, 0, this.max.length);
            System.arraycopy(other.center, 0, this.center, 0, this.center.length);
        }
    }
}

