/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.terra.jami.j3d.vr.VrPreset;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class VrPresetCurves {
    public double[] opacity_table = new double[40960];
    public double[] intensity_table = new double[40960];
    public double[] lutrgb = new double[122880];
    public double[] colorEnhanceTable = null;
    public static final int COLOR_ENHANCE_TABLE_SIZE = 131072;
    public static final int TABLE_OFFSET = 8192;
    public static final int TABLE_SIZE = 32768;
    private static final int rangeMin = 0;
    private static final int rangeMax = 32768;
    private static final int internalVMin = 0;
    private static final int internalVMax = 32768;
    private VrPreset preset = null;
    private double preset_scale = 1.0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private double ras_spx = 1.0;
    private double ras_spy = 1.0;

    public VrPresetCurves(VrPreset preset, double preset_scale, double rescaleSlope, double rescaleIntercept, double ras_spx, double ras_spy) {
        this.preset = preset;
        this.preset_scale = preset_scale;
        this.rescaleSlope = rescaleSlope;
        this.rescaleIntercept = rescaleIntercept;
        this.ras_spx = ras_spx;
        this.ras_spy = ras_spy;
        double thresh1 = (double)preset.thresh1 * preset_scale;
        double thresh2 = (double)preset.thresh2 * preset_scale;
        int rawthresh1 = VrPresetCurves.raw_value(thresh1, rescaleSlope, rescaleIntercept);
        int rawthresh2 = VrPresetCurves.raw_value(thresh2, rescaleSlope, rescaleIntercept);
        this.buildVxTables(rawthresh1, rawthresh2);
        this.colorEnhanceTable = new double[131073];
        double lightVal = 0.0;
        double delta = 7.629336324033172E-6;
        int i2 = 0;
        while (i2 < this.colorEnhanceTable.length) {
            this.colorEnhanceTable[i2] = preset.attenuation * Math.pow(1.0 - lightVal, -0.5 - 0.5 * (preset.brightness - 1.0) / 6.0);
            ++i2;
            lightVal += delta;
        }
    }

    public int[] createColorLut() {
        int[] cmap = new int[this.lutrgb.length / 3];
        for (int i2 = 0; i2 < cmap.length; ++i2) {
            int a2 = (int)(this.opacity_table[i2] * 255.0) & 0xFF;
            int r2 = (int)(this.lutrgb[3 * i2] * 255.0);
            int g2 = (int)(this.lutrgb[3 * i2 + 1] * 255.0);
            int b2 = (int)(this.lutrgb[3 * i2 + 2] * 255.0);
            a2 = 1;
            cmap[i2] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
        }
        return cmap;
    }

    public void savePreset(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            PrintStream ps = new PrintStream(fos);
            double thresh1 = (double)this.preset.thresh1 * this.preset_scale;
            double thresh2 = (double)this.preset.thresh2 * this.preset_scale;
            int rawthresh1 = VrPresetCurves.raw_value(thresh1, this.rescaleSlope, this.rescaleIntercept);
            int rawthresh2 = VrPresetCurves.raw_value(thresh2, this.rescaleSlope, this.rescaleIntercept);
            ps.println("" + this.preset.modality + " " + 8192 + " " + 32768 + " " + rawthresh1 + " " + rawthresh2);
            for (int i2 = 0; i2 < 40960; ++i2) {
                ps.println("" + i2 + " " + this.opacity_table[i2] + " " + this.intensity_table[i2] + " " + this.lutrgb[3 * i2] + " " + this.lutrgb[3 * i2 + 1] + " " + this.lutrgb[3 * i2 + 2]);
            }
            ps.flush();
            fos.close();
            ps.close();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void buildVxTables(double thresh1, double thresh2) {
        int ctype = VrPresetCurves.vr_curvetype(this.preset.curvetype);
        int ltype = VrPresetCurves.vr_luttype(this.preset.luttype);
        int etype = VrPresetCurves.vr_enhancetype(this.preset.enhancetype);
        double max_opacity = this.preset.attenuation;
        double norm_factor = 1.0;
        double voxel_size = (this.ras_spx + this.ras_spy) * 0.5;
        if (this.preset.normalization) {
            norm_factor = 1.0 / voxel_size;
        }
        switch (ctype) {
            case 100: {
                VrPresetCurves.build_opacity_up(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 101: {
                VrPresetCurves.build_opacity_up(max_opacity, 0.5 * (thresh1 + thresh2) - 0.001, 0.5 * (thresh1 + thresh2) + 0.001, norm_factor, this.opacity_table);
                break;
            }
            case 103: {
                VrPresetCurves.build_opacity_down(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 102: {
                VrPresetCurves.build_opacity_bell(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 104: {
                VrPresetCurves.build_opacity_reverse_bell(max_opacity, thresh1, thresh2, norm_factor, this.opacity_table);
                break;
            }
            case 105: {
                this.build_custom_opacity(this.preset.opacity_lut, this.preset.startOpacity, this.preset.deltaOpacity, this.opacity_table);
            }
        }
        VrPresetCurves.build_intensity(0, 32768, ctype, etype, thresh1, thresh2, this.intensity_table);
        if (ltype == 305) {
            this.build_colortable(this.preset.colorlut.colorlut, this.preset.colorlut.startX, this.preset.colorlut.deltaX);
        } else {
            this.build_colortable(ltype, this.preset.colors);
        }
    }

    private void build_custom_opacity(double[] modopacity, double startX, double delta, double[] table) {
        double slope = this.rescaleSlope;
        double intercept = this.rescaleIntercept;
        double rstart = VrPresetCurves.raw_value(startX * this.preset_scale, slope, intercept);
        double rdelta = (double)VrPresetCurves.raw_value(delta * this.preset_scale, slope, intercept) + intercept;
        for (int i2 = 0; i2 < table.length; ++i2) {
            int rval = i2 - 8192;
            double idx = ((double)rval - rstart) / rdelta;
            table[i2] = 0.0;
            if (idx >= 0.0 && idx < (double)(modopacity.length - 1)) {
                int intidx = (int)idx;
                double f2 = idx - (double)intidx;
                double v0 = modopacity[intidx];
                double v1 = modopacity[intidx + 1];
                table[i2] = v0 + f2 * (v1 - v0);
                continue;
            }
            if (!(idx >= (double)modopacity.length)) continue;
            table[i2] = modopacity[modopacity.length - 1];
        }
    }

    static void build_opacity_up(double max_opacity, double thresh0, double thresh1, double norm_factor, double[] table) {
        double a2 = 0.0;
        double t0 = Math.min(thresh0, (double)(table.length - 1 - 8192));
        double t1 = Math.min(thresh1, (double)(table.length - 1 - 8192));
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double dx = max_opacity / (thresh1 - thresh0);
        int x2 = 0;
        while ((double)x2 < t0) {
            table[x2 + 8192] = 0.0;
            ++x2;
        }
        if (norm_factor == 1.0) {
            while ((double)x2 < t1) {
                table[x2 + 8192] = a2;
                ++x2;
                a2 += dx;
            }
        } else {
            while ((double)x2 < t1) {
                table[x2 + 8192] = Math.pow(a2, norm_factor);
                ++x2;
                a2 += dx;
            }
        }
        while (x2 < 32768) {
            table[x2 + 8192] = max_opacity;
            ++x2;
        }
    }

    static void build_opacity_down(double max_opacity, double thresh0, double thresh1, double norm_factor, double[] table) {
        double t0 = Math.min(thresh0, (double)(table.length - 1 - 8192));
        double t1 = Math.min(thresh1, (double)(table.length - 1 - 8192));
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double a2 = max_opacity;
        double dx = -max_opacity / (thresh1 - thresh0);
        int x2 = 0;
        while ((double)x2 < t0) {
            table[x2 + 8192] = max_opacity;
            ++x2;
        }
        if (norm_factor == 1.0) {
            while ((double)x2 < t1) {
                table[x2 + 8192] = a2;
                ++x2;
                a2 += dx;
            }
        } else {
            while ((double)x2 < t1) {
                table[x2 + 8192] = Math.pow(a2, norm_factor);
                ++x2;
                a2 += dx;
            }
        }
        while (x2 < 32768) {
            table[x2 + 8192] = 0.0;
            ++x2;
        }
    }

    static void build_opacity_bell(double max_opacity, double thresh2, double thresh3, double norm_factor, double[] table) {
        double k2 = 0.75;
        double a2 = 0.0;
        double mid = 0.5 * (thresh2 + thresh3);
        double delta = k2 * (thresh3 - thresh2);
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double b1 = mid - 0.5 * delta;
        double b2 = mid + 0.5 * delta;
        double dx = max_opacity / (b1 - thresh2);
        int x2 = 0;
        while ((double)x2 < thresh2) {
            table[x2 + 8192] = 0.0;
            ++x2;
        }
        if (norm_factor == 1.0) {
            a2 = 0.0;
            while ((double)x2 < b1) {
                table[x2 + 8192] = a2;
                ++x2;
                a2 += dx;
            }
            while ((double)x2 < b2) {
                table[x2 + 8192] = max_opacity;
                ++x2;
            }
            a2 = max_opacity;
            while ((double)x2 < thresh3) {
                table[x2 + 8192] = a2;
                ++x2;
                a2 -= dx;
            }
        } else {
            a2 = 0.0;
            while ((double)x2 < b1) {
                table[x2 + 8192] = Math.pow(a2, norm_factor);
                ++x2;
                a2 += dx;
            }
            while ((double)x2 < b2) {
                table[x2 + 8192] = max_opacity;
                ++x2;
            }
            a2 = max_opacity;
            while ((double)x2 < thresh3) {
                table[x2 + 8192] = Math.pow(a2, norm_factor);
                ++x2;
                a2 -= dx;
            }
        }
        while (x2 < 32768) {
            table[x2 + 8192] = 0.0;
            ++x2;
        }
    }

    static void build_opacity_reverse_bell(double max_opacity, double thresh2, double thresh3, double norm_factor, double[] table) {
        double k2 = 0.75;
        double a2 = 0.0;
        double mid = 0.5 * (thresh2 + thresh3);
        double delta = k2 * (thresh3 - thresh2);
        if (norm_factor != 1.0) {
            max_opacity = Math.pow(max_opacity, norm_factor);
        }
        double b1 = mid - 0.5 * delta;
        double b2 = mid + 0.5 * delta;
        double dx = max_opacity / (b1 - thresh2);
        int x2 = 0;
        while ((double)x2 < thresh2) {
            table[x2 + 8192] = max_opacity;
            ++x2;
        }
        if (norm_factor == 1.0) {
            a2 = max_opacity;
            while ((double)x2 < b1) {
                table[x2 + 8192] = a2;
                ++x2;
                a2 -= dx;
            }
            while ((double)x2 < b2) {
                table[x2 + 8192] = 0.0;
                ++x2;
            }
            a2 = 0.0;
            while ((double)x2 < thresh3) {
                table[x2 + 8192] = a2;
                ++x2;
                a2 += dx;
            }
        } else {
            a2 = max_opacity;
            while ((double)x2 < b1) {
                table[x2 + 8192] = Math.pow(a2, norm_factor);
                ++x2;
                a2 -= dx;
            }
            while ((double)x2 < b2) {
                table[x2 + 8192] = 0.0;
                ++x2;
            }
            a2 = 0.0;
            while ((double)x2 < thresh3) {
                table[x2 + 8192] = Math.pow(a2, norm_factor);
                ++x2;
                a2 += dx;
            }
        }
        while (x2 < 32768) {
            table[x2 + 8192] = max_opacity;
            ++x2;
        }
    }

    private static void build_intensity(int rangeMin, int rangeMax, int curveType, int enhanceType, double thresh2, double thresh3, double[] table) {
        int x2;
        double ithresh2 = 0.0;
        double ithresh3 = 4095.0;
        double a2 = 0.0;
        switch (enhanceType) {
            case 201: {
                if (curveType != 103) {
                    ithresh2 = thresh2 < 50.0 ? 0.0 : thresh2 - 50.0;
                    ithresh3 = 4095.0;
                    break;
                }
                ithresh2 = 0.0;
                ithresh3 = thresh3 > 4045.0 ? 4095.0 : thresh3 + 50.0;
                break;
            }
            case 202: {
                ithresh2 = thresh2 < 50.0 ? 0.0 : thresh2 - 50.0;
                ithresh3 = thresh3 > 4045.0 ? 4095.0 : thresh3 + 50.0;
                break;
            }
            case 200: {
                ithresh2 = 0.0;
                ithresh3 = 4095.0;
                break;
            }
            case 203: {
                for (x2 = 0; x2 < 32768; ++x2) {
                    table[x2 + 8192] = 4095.0;
                }
                break;
            }
        }
        double dx = 4095.0 / (ithresh3 - ithresh2);
        x2 = 0;
        while ((double)x2 < ithresh2) {
            table[x2 + 8192] = 0.0;
            ++x2;
        }
        while ((double)x2 < ithresh3) {
            table[x2 + 8192] = a2;
            ++x2;
            a2 += dx;
        }
        while (x2 < 32768) {
            table[x2 + 8192] = 4095.0;
            ++x2;
        }
    }

    public void build_colortable(double[] modrgblut, double startX, double delta) {
        double slope = this.rescaleSlope;
        double intercept = this.rescaleIntercept;
        double rstart = VrPresetCurves.raw_value(startX * this.preset_scale, slope, intercept);
        double rdelta = (double)VrPresetCurves.raw_value(delta * this.preset_scale, slope, intercept) + intercept;
        int ncolors = modrgblut.length / 3;
        int ti = 0;
        int i2 = 0;
        i2 = 0;
        for (ti = 0; ti < this.lutrgb.length; ti += 3) {
            int rval = i2 - 8192;
            double idx = ((double)rval - rstart) / rdelta;
            this.lutrgb[ti] = 0.0;
            this.lutrgb[ti + 1] = 0.0;
            this.lutrgb[ti + 2] = 0.0;
            if (idx >= 0.0 && idx < (double)(ncolors - 1)) {
                int intidx = (int)idx;
                double f2 = idx - (double)intidx;
                double r0 = modrgblut[intidx *= 3];
                double r1 = modrgblut[intidx + 3];
                double g0 = modrgblut[intidx + 1];
                double g1 = modrgblut[intidx + 4];
                double b0 = modrgblut[intidx + 2];
                double b1 = modrgblut[intidx + 5];
                this.lutrgb[ti] = r0 + f2 * (r1 - r0);
                this.lutrgb[ti + 1] = g0 + f2 * (g1 - g0);
                this.lutrgb[ti + 2] = b0 + f2 * (b1 - b0);
            } else if (idx >= (double)ncolors) {
                this.lutrgb[ti] = modrgblut[modrgblut.length - 3];
                this.lutrgb[ti + 1] = modrgblut[modrgblut.length - 2];
                this.lutrgb[ti + 2] = modrgblut[modrgblut.length - 1];
            }
            ++i2;
        }
    }

    private void build_colortable(int lutType, List clist) {
        double slope = this.rescaleSlope;
        double intercept = this.rescaleIntercept;
        int len = clist.size();
        VrPreset.Color cfirst = (VrPreset.Color)clist.get(0);
        VrPreset.Color clast = (VrPreset.Color)clist.get(len - 1);
        double firstlevel = VrPresetCurves.raw_value(cfirst.level * this.preset_scale, slope, intercept);
        double lastlevel = VrPresetCurves.raw_value(clast.level * this.preset_scale, slope, intercept);
        switch (lutType) {
            case 301: {
                for (int i2 = 0; i2 < 32768; ++i2) {
                    double r2 = 0.0;
                    double g2 = 0.0;
                    double b2 = 0.0;
                    boolean fill = false;
                    for (int j2 = 0; j2 < len - 1; ++j2) {
                        VrPreset.Color c1 = (VrPreset.Color)clist.get(j2);
                        VrPreset.Color c2 = (VrPreset.Color)clist.get(j2 + 1);
                        double level1 = VrPresetCurves.raw_value(c1.level * this.preset_scale, slope, intercept);
                        double level2 = VrPresetCurves.raw_value(c2.level * this.preset_scale, slope, intercept);
                        if (!((double)i2 >= level1) || !((double)i2 <= level2)) continue;
                        double k2 = ((double)i2 - level1) / (level2 - level1);
                        r2 = c1.red + k2 * (c2.red - c1.red);
                        g2 = c1.green + k2 * (c2.green - c1.green);
                        b2 = c1.blue + k2 * (c2.blue - c1.blue);
                        fill = true;
                        break;
                    }
                    if (!fill) {
                        if ((double)i2 <= firstlevel) {
                            r2 = cfirst.red;
                            g2 = cfirst.green;
                            b2 = cfirst.blue;
                        } else if ((double)i2 >= lastlevel) {
                            r2 = clast.red;
                            g2 = clast.green;
                            b2 = clast.blue;
                        }
                    }
                    int rgbidx = 3 * (i2 + 8192);
                    this.lutrgb[rgbidx] = r2 / 255.0;
                    this.lutrgb[rgbidx + 1] = g2 / 255.0;
                    this.lutrgb[rgbidx + 2] = b2 / 255.0;
                }
                break;
            }
            default: {
                System.out.println("*** Unrecognized lutType: " + lutType);
            }
        }
    }

    private static int raw_value(double modval, double slope, double intercept) {
        return (int)((modval - intercept) / slope);
    }

    public static int vr_enhancetype(String enhance_type) {
        String t2 = enhance_type.toUpperCase();
        if (t2.equals("NONE")) {
            return 200;
        }
        return 200;
    }

    public static int vr_curvetype(String curve_type) {
        String t2 = curve_type.toUpperCase();
        if (t2.equals("UP")) {
            return 100;
        }
        if (t2.equals("DOWN")) {
            return 103;
        }
        if (t2.equals("BELL")) {
            return 102;
        }
        if (t2.equals("REVBELL")) {
            return 104;
        }
        return 105;
    }

    public static int vr_luttype(String lut_type) {
        String t2 = lut_type.toUpperCase();
        if (t2.equals("RAMP")) {
            return 301;
        }
        if (t2.equals("NEAREST")) {
            return 302;
        }
        if (t2.equals("CUSTOM")) {
            return 305;
        }
        return 300;
    }
}

