/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorCTL;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorMapUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.CursorValueUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.HistogramUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpacityCTL;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpacityMapUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpticksUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.TickMarksUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIelement;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrPresetsEditor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

class CNOplot
extends JPanel {
    UIelement[] ui = new UIelement[]{new OpacityMapUI(), new ColorMapUI(), new TickMarksUI(), new OpacityCTL(), new OpticksUI(), new ColorCTL(), new CursorValueUI(), new HistogramUI()};
    UIcontrol[] uic;
    UIcontrol activeCtl = null;
    Layout layout = new Layout();
    Preset preset;
    Cursor dragCursor = new Cursor(13);
    ImageIcon zoomIcon_ = new ImageIcon(CNOplot.class.getResource("zoomimagea1.png"));
    Cursor zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.zoomIcon_.getImage(), new Point(this.zoomIcon_.getIconWidth() / 2, this.zoomIcon_.getIconHeight() / 2), "Zoom");
    Rectangle vrect;
    int downX;
    int downY;
    int lastY;
    static final double ZOOM_INCREMENT = 0.05;
    static final double MAX_ZOOM = 40.0;
    static final double MIN_ZOOM = 0.5;
    private double zoom_ = 20.0;
    Rectangle r = new Rectangle();
    private VrHistogram histogram;
    boolean mousePan = true;

    public CNOplot() {
        this.setPreferredSize(new Dimension(2000, 100));
        ArrayList<UIelement> al2 = new ArrayList<UIelement>();
        for (int i2 = 0; i2 < this.ui.length; ++i2) {
            this.ui[i2].setLayout(this.layout);
            if (!(this.ui[i2] instanceof UIcontrol)) continue;
            al2.add(this.ui[i2]);
        }
        this.uic = al2.toArray(new UIcontrol[al2.size()]);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                CNOplot.this.lastY = e2.getY();
                CNOplot.this.activeCtl = null;
                CNOplot.this.vrect = CNOplot.this.getVisibleRect();
                CNOplot.this.downX = e2.getX() - CNOplot.this.vrect.x;
                CNOplot.this.downY = e2.getY() - CNOplot.this.vrect.y;
                for (int i2 = 0; i2 < CNOplot.this.uic.length; ++i2) {
                    if (!CNOplot.this.uic[i2].mousePressed(e2)) continue;
                    CNOplot.this.activeCtl = CNOplot.this.uic[i2];
                    break;
                }
                if (CNOplot.this.activeCtl == null) {
                    CNOplot.this.setCursor(CNOplot.this.mousePan ? CNOplot.this.dragCursor : CNOplot.this.zoomCursor);
                } else {
                    CNOplot.this.setCursor(CNOplot.this.dragCursor);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (CNOplot.this.activeCtl != null) {
                    CNOplot.this.activeCtl.mouseReleased(e2);
                } else {
                    CNOplot.this.setCursor(null);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                if (CNOplot.this.activeCtl != null) {
                    if (e2.getX() >= 0 && e2.getX() < CNOplot.this.getWidth() - 1) {
                        CNOplot.this.activeCtl.mouseDragged(e2);
                        Rectangle r2 = new Rectangle(e2.getX(), e2.getY(), 1, 1);
                        CNOplot.this.scrollRectToVisible(r2);
                    }
                } else if (CNOplot.this.mousePan) {
                    Rectangle r3 = new Rectangle(CNOplot.this.vrect);
                    Rectangle off = CNOplot.this.getVisibleRect();
                    r3.translate(CNOplot.this.downX - (e2.getX() - off.x), 0);
                    CNOplot.this.scrollRectToVisible(r3);
                } else {
                    int y2 = e2.getY();
                    double change = 1.0 - (double)(CNOplot.this.lastY - y2) / (double)e2.getComponent().getHeight();
                    CNOplot.this.setZoom(Math.min(40.0, Math.max(0.5, CNOplot.this.getZoom() * change)));
                    CNOplot.this.lastY = y2;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
                for (int i2 = 0; i2 < CNOplot.this.uic.length; ++i2) {
                    if (!CNOplot.this.uic[i2].mouseMoved(e2)) continue;
                    return;
                }
                CNOplot.this.setCursor(null);
            }
        });
    }

    public void setPresets(Preset p2) {
        this.preset = p2;
        for (int i2 = 0; i2 < this.ui.length; ++i2) {
            this.ui[i2].setPresets(p2);
        }
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("CNOplot.java");
        CNOplot p2 = new CNOplot();
        p2.setPresets(new Preset());
        f2.setContentPane(p2);
        f2.setBounds(100, 100, 512, 512);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g2) {
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        g2.setColor(this.getBackground());
        this.computeVisibleRect(this.r);
        g2.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
        for (int i2 = 0; i2 < this.ui.length; ++i2) {
            this.ui[i2].paint(g2, w2, h2, this.r);
        }
    }

    public void setCursorValue(double value) {
        for (int i2 = 0; i2 < this.ui.length; ++i2) {
            if (!(this.ui[i2] instanceof CursorValueUI)) continue;
            ((CursorValueUI)this.ui[i2]).setCursorValue(value);
        }
    }

    public void setCursorColor(Color c2) {
        for (int i2 = 0; i2 < this.ui.length; ++i2) {
            if (!(this.ui[i2] instanceof CursorValueUI)) continue;
            ((CursorValueUI)this.ui[i2]).setCursorColor(c2);
        }
    }

    public void setHistogram(VrHistogram h2) {
        this.histogram = h2;
        for (int i2 = 0; i2 < this.ui.length; ++i2) {
            if (!(this.ui[i2] instanceof HistogramUI)) continue;
            ((HistogramUI)this.ui[i2]).setHistogram(h2);
        }
    }

    public void setMousePan(boolean b2) {
        this.mousePan = b2;
    }

    public double getZoom() {
        return this.zoom_;
    }

    public void setZoom(double zoom) {
        double ratio = zoom / this.zoom_;
        this.zoom_ = zoom;
        Dimension d2 = new Dimension((int)((double)this.getParent().getParent().getParent().getSize().width * this.zoom_), this.getHeight());
        this.setSize(d2);
        d2.height = 0;
        this.setPreferredSize(d2);
        this.r.x = (int)(ratio * ((double)this.r.x + (double)this.r.width / 2.0)) - this.r.width / 2;
        this.scrollRectToVisible(this.r);
    }

    public void resetPanZoom() {
        if (VrPresetsEditor.FitHistogramOnInit && this.histogram != null && this.histogram.max > this.histogram.min) {
            this.setZoom((Layout.MAX - Layout.MIN) / (double)(this.histogram.max - this.histogram.min));
            int x2 = this.layout.getXpos(this.getWidth(), this.histogram.intercept);
            Rectangle r2 = new Rectangle(x2, 0, this.getWidth(), 0);
            this.scrollRectToVisible(r2);
        }
    }

    public VrHistogram getHistogram() {
        return this.histogram;
    }
}

