/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ColorWheel
extends JComponent {
    protected float hue = Float.NaN;
    protected float sat = Float.NaN;
    protected double rad;
    double brig = 0.99;
    boolean redraw = true;
    BufferedImage img = new BufferedImage(1, 1, 1);
    transient Vector changeListeners = new Vector();

    public ColorWheel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("ColorWheel");
        ColorWheel p2 = new ColorWheel();
        f2.setContentPane(p2);
        f2.setDefaultCloseOperation(3);
        f2.setBounds(10, 10, 512, 512);
        f2.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g2) {
        int h2 = this.getHeight();
        int w2 = this.getWidth();
        if (w2 != this.img.getWidth() || h2 != this.img.getHeight()) {
            this.img = new BufferedImage(w2, h2, 1);
            this.redraw = true;
        }
        if (this.redraw) {
            this.fillBufferWithWheel(this.img, w2, h2);
            this.redraw = false;
        }
        g2.drawImage(this.img, 0, 0, null);
        if ((double)this.hue == Double.NaN) {
            return;
        }
        if (Beans.isDesignTime()) {
            return;
        }
        this.paintBall(g2, w2, h2);
        Graphics g22 = g2.create();
        g22.setFont(this.getFont().deriveFont(1));
        g22.drawString("H:" + (int)((this.hue + 1.0f) * 180.0f) + " S:" + (float)((int)(this.sat * 100.0f)) / 100.0f, 5, h2 - 20);
    }

    public void fillBufferWithWheel(BufferedImage img, int w2, int h2) {
        this.rad = (w2 > h2 ? (double)h2 / 2.0 : (double)w2 / 2.0) - 10.0;
        int[] buff = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < buff.length; ++i2) {
            double sat;
            double hue;
            double x2 = (double)w2 / 2.0 - (double)(i2 % w2);
            double y2 = (double)h2 / 2.0 - (double)(i2 / w2);
            double ang = Math.atan2(x2, y2) / (Math.PI * 2);
            double dist = Math.sqrt(x2 * x2 + y2 * y2);
            if (dist > this.rad + 1.0) {
                buff[i2] = 0;
                continue;
            }
            if (dist > this.rad) {
                hue = ang;
                sat = (dist - 1.0) / this.rad;
                double b2 = this.brig * (1.0 + this.rad - dist);
                buff[i2] = Color.HSBtoRGB((float)hue, (float)sat, (float)b2);
                continue;
            }
            hue = ang;
            sat = dist / this.rad;
            buff[i2] = Color.HSBtoRGB((float)hue, (float)sat, (float)this.brig);
        }
    }

    public void paintBall(Graphics g2, int w2, int h2) {
        double x2 = (double)w2 / 2.0 - (double)this.sat * this.rad * Math.sin((double)(this.hue * 2.0f) * Math.PI);
        double y2 = (double)h2 / 2.0 - (double)this.sat * this.rad * Math.cos((double)(this.hue * 2.0f) * Math.PI);
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.fillArc((int)(x2 - 5.0), (int)(y2 - 5.0), 10, 10, 0, 370);
        g2.setColor(Color.getHSBColor(this.hue, this.sat, (float)this.brig));
        g2.fillArc((int)(x2 - 3.0), (int)(y2 - 3.0), 6, 6, 0, 3700);
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                ColorWheel.this.this_mouseDragged(e2);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                ColorWheel.this.this_mousePressed(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                ColorWheel.this.this_mouseReleased(e2);
            }
        });
    }

    public void this_mouseDragged(MouseEvent e2) {
        this.move(e2);
    }

    public void this_mousePressed(MouseEvent e2) {
        this.move(e2);
    }

    public void this_mouseReleased(MouseEvent e2) {
    }

    public void move(MouseEvent e2) {
        double xd = (double)this.getWidth() / 2.0 - (double)e2.getX();
        double yd = (double)this.getHeight() / 2.0 - (double)e2.getY();
        double dist = Math.min(Math.sqrt(xd * xd + yd * yd), this.rad);
        this.hue = (float)(Math.atan2(xd, yd) / (Math.PI * 2));
        this.sat = (float)(dist / this.rad);
        this.fireStateChanged(new ChangeEvent(this));
        this.repaint();
    }

    public double getHue() {
        return this.hue;
    }

    public double getSat() {
        return this.sat;
    }

    public void setSat(double sat) {
        this.sat = (float)sat;
    }

    public void setHue(double hue) {
        this.hue = (float)hue;
    }

    public void setBright(double br) {
        this.brig = br;
        this.redraw = true;
        this.fireStateChanged(new ChangeEvent(this));
        this.repaint();
    }

    public double getBright() {
        return this.brig;
    }

    public void setColor(int rgb) {
        float[] hsb = Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, null);
        this.hue = hsb[0];
        this.sat = hsb[1];
        this.brig = hsb[2];
        this.redraw = true;
        this.repaint();
    }

    public synchronized void addChangeListener(ChangeListener l2) {
        this.changeListeners.add(l2);
    }

    public synchronized void removeChangeListener(ChangeListener l2) {
        this.changeListeners.remove(l2);
    }

    protected void fireStateChanged(ChangeEvent e2) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ChangeListener)listeners.elementAt(i2)).stateChanged(e2);
            }
        }
    }
}

