/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.MouseCursors;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

class OpacityCTL
implements UIcontrol {
    private Layout l;
    private Preset p;
    public static final int HANDLE_HEIGHT = 12;
    static DecimalFormat format = new DecimalFormat("#####.#");
    public int selectedRegion;
    public int cursorOver;
    public int colorPos;
    JComponent source;
    public boolean mousePressed = false;
    public static final int REGION_LEFT = 1;
    public static final int REGION_RIGHT = 2;
    public static final int REGION_MIDDLE = 3;
    public static final int REGION_POS = 4;

    OpacityCTL() {
    }

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    @Override
    public void paint(Graphics g2, int w2, int h2, Rectangle r2) {
        this.l.setHeight(h2);
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        int tipY = this.l.color_bottom;
        Border ttborder = UIManager.getBorder("ToolTip.border");
        for (int i2 = 0; i2 < this.p.opacityPos.length; ++i2) {
            int x1 = this.l.getXpos(w2, this.p.opacityPos[i2]);
            if (this.mousePressed && this.p.opacitySelected == i2) {
                String s2 = format.format(this.p.opacityPos[i2]);
                FontMetrics f2 = g2.getFontMetrics();
                Rectangle2D rect = f2.getStringBounds(s2, g2);
                int off = 0;
                int rwidth = 5 + (int)rect.getWidth();
                if (r2.x + r2.width <= x1 + 1 + rwidth) {
                    off = -rwidth;
                }
                g2.setColor(UIManager.getColor("ToolTip.background"));
                int opTextPos = this.l.tick_bottom - 2;
                g2.fillRect(x1 + 1 + off, this.l.tick_bottom - f2.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                g2.setColor(Color.BLACK);
                ttborder.paintBorder(this.source, g2, x1 + 1 + off, this.l.tick_bottom - f2.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                g2.drawString(s2, x1 + 4 + off, opTextPos);
            }
            if (this.p.opacitySelected == i2) {
                g2.setColor(Color.lightGray);
            } else {
                g2.setColor(Color.gray);
            }
            if (this.showLine(i2)) {
                if (!this.showRHandle(i2) && !this.showLHandle(i2)) {
                    g2.draw3DRect(x1, this.l.BORDER.top, 1, tipY - this.l.BORDER.top - 1, true);
                } else {
                    int posBefore = (int)(this.p.opacityBefore[i2] * (hmax - hmin) + hmin);
                    int posAfter = (int)(this.p.opacityAfter[i2] * (hmax - hmin) + hmin);
                    int pos = Math.min(posBefore, posAfter);
                    g2.draw3DRect(x1, pos, 1, tipY - pos - 1, true);
                }
            }
            if (!this.showRHandle(i2)) continue;
            int pos = (int)(this.p.opacityBefore[i2] * (hmax - hmin) + hmin);
            if (this.p.opacityMode == 0 || this.p.opacityMode == 5) {
                if (this.showLHandle(i2)) {
                    pos = (int)(this.p.opacityBefore[i2] * (hmax - hmin) + hmin);
                    g2.fill3DRect(x1 - 5, pos - 6, 6, 12, true);
                }
                pos = (int)(this.p.opacityAfter[i2] * (hmax - hmin) + hmin);
                g2.fill3DRect(x1, pos - 6, 6, 12, true);
            } else if (this.showLHandle(i2) && this.showRHandle(i2)) {
                pos = (int)(this.p.opacityAfter[i2] * (hmax - hmin) + hmin);
                g2.fill3DRect(x1 - 5, pos - 6, 12, 12, true);
            }
            if (!this.mousePressed || this.p.opacitySelected != i2) continue;
            double op = -1.0;
            if (this.selectedRegion == 3) {
                op = this.p.opacityBefore[i2];
            } else if (this.selectedRegion == 1) {
                op = this.p.opacityBefore[i2];
            } else if (this.selectedRegion == 2) {
                op = this.p.opacityAfter[i2];
            }
            if (!(op >= 0.0)) continue;
            String s3 = format.format(op * 100.0) + "%";
            FontMetrics f3 = g2.getFontMetrics();
            Rectangle2D rect = f3.getStringBounds(s3, g2);
            int off = 0;
            int rwidth = 5 + (int)rect.getWidth();
            if (r2.x + r2.width <= x1 + 8 + rwidth) {
                off = -(rwidth + 16);
            }
            g2.setColor(UIManager.getColor("ToolTip.background"));
            g2.fillRect(x1 + 8 + off, (int)((double)pos - rect.getHeight() + 1.0), rwidth, 2 + (int)rect.getHeight());
            g2.setColor(Color.black);
            ttborder.paintBorder(this.source, g2, x1 + 8 + off, (int)((double)pos - rect.getHeight() + 1.0), rwidth, 2 + (int)rect.getHeight());
            g2.drawString(s3, x1 + 11 + off, pos - f3.getDescent() + 3);
        }
    }

    public boolean showRHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    public boolean showLHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    private boolean showAttachObjectControlAt(int pos) {
        if (this.p.opacityMode != 6) {
            throw new IllegalArgumentException("Not in attach object mode!");
        }
        return pos % 5 == 2;
    }

    public boolean showLine(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    @Override
    public void setPresets(Preset p2) {
        this.p = p2;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        int x2 = e2.getX();
        int y2 = e2.getY();
        JComponent c2 = (JComponent)e2.getSource();
        this.l.setHeight(c2.getHeight());
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        double pos = ((double)y2 - hmin) / (hmax - hmin);
        if (pos < 0.0) {
            pos = 0.0;
        }
        if (pos > 1.0) {
            pos = 1.0;
        }
        if (this.selectedRegion == 0) {
            return;
        }
        switch (this.selectedRegion) {
            case 1: {
                this.p.opacityBefore[this.p.opacitySelected] = pos;
                if (!e2.isShiftDown()) {
                    this.adjustPos(c2, x2);
                }
                c2.repaint();
                break;
            }
            case 2: {
                this.p.opacityAfter[this.p.opacitySelected] = pos;
                if (!e2.isShiftDown()) {
                    this.adjustPos(c2, x2);
                }
                c2.repaint();
                break;
            }
            case 3: {
                if (this.p.opacityMode != 6) {
                    int k2;
                    this.p.opacityBefore[this.p.opacitySelected] = pos;
                    this.p.opacityAfter[this.p.opacitySelected] = pos;
                    if (this.p.opacityMode == 3) {
                        k2 = this.p.opacitySelected + 1;
                        if (k2 > 2) {
                            k2 = 1;
                        }
                        this.p.opacityBefore[k2] = pos;
                        this.p.opacityAfter[k2] = pos;
                    }
                    if (this.p.opacityMode == 4) {
                        k2 = this.p.opacitySelected + 3;
                        if (k2 > 3) {
                            k2 = 0;
                        }
                        this.p.opacityBefore[k2] = pos;
                        this.p.opacityAfter[k2] = pos;
                    }
                    if (!e2.isShiftDown()) {
                        this.adjustPos(c2, x2);
                    }
                } else {
                    this.updateObjects(c2, x2, pos);
                }
                c2.repaint();
                break;
            }
            case 4: {
                if (this.p.opacityMode != 6) {
                    this.adjustPos(c2, x2);
                } else {
                    this.updateObjects(c2, x2, this.p.opacityAtColor[this.p.rgbSelected]);
                }
                c2.repaint();
            }
        }
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseDragged"));
    }

    private void updateObjects(JComponent c2, int x2, double opacity) {
        double v2 = this.l.getVfromX(c2.getWidth(), x2);
        this.p.opacityAtColor[this.p.rgbSelected] = opacity;
        this.p.rgbPos[this.p.rgbSelected] = v2;
        this.p.sortColor();
        this.p.updateOpacityPts();
    }

    public void adjustPos(JComponent c2, int x2) {
        double v2;
        this.p.opacityPos[this.p.opacitySelected] = v2 = this.l.getVfromX(c2.getWidth(), x2);
        if (this.p.opacityMode == 3) {
            this.p.opacityPos[0] = this.p.opacityPos[1] - (this.p.opacityPos[2] - this.p.opacityPos[1]);
            this.p.opacityPos[3] = this.p.opacityPos[2] + (this.p.opacityPos[2] - this.p.opacityPos[1]);
        } else if (this.p.opacityMode == 4) {
            double delta = (this.p.opacityPos[3] - this.p.opacityPos[0]) / 3.0;
            this.p.opacityPos[1] = this.p.opacityPos[0] + delta;
            this.p.opacityPos[2] = this.p.opacityPos[0] + 2.0 * delta;
        }
        this.p.sortOpacity();
        this.p.setOpacityMode(this.p.opacityMode);
    }

    @Override
    public boolean mousePressed(MouseEvent e2) {
        int region;
        this.source = (JComponent)e2.getSource();
        this.selectedRegion = region = this.getSelectedRegion(e2);
        if (region == 0) {
            return false;
        }
        this.mousePressed = true;
        this.p.opacitySelected = this.cursorOver;
        if (this.p.opacityMode == 6) {
            this.p.setRGBselected(this.colorPos);
        }
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.mousePressed = false;
        ((JComponent)e2.getSource()).repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseReleased"));
    }

    @Override
    public boolean mouseMoved(MouseEvent e2) {
        JComponent c2 = (JComponent)e2.getSource();
        int region = this.getSelectedRegion(e2);
        switch (region) {
            case 1: {
                c2.setCursor(MouseCursors.makeLeftUpDown());
                break;
            }
            case 2: {
                c2.setCursor(MouseCursors.makeRightUpDown());
                break;
            }
            case 3: {
                c2.setCursor(MouseCursors.makeCenterUpDown());
                break;
            }
            case 4: {
                c2.setCursor(MouseCursors.makeLeftRightCursor());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getSelectedRegion(MouseEvent e2) {
        if (this.p.opacityMode == 0) {
            return this.getFreeSelectedRegion(e2);
        }
        int n2 = this.getFreeSelectedRegion(e2);
        if (n2 == 4) {
            return n2;
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.p.opacityMode == 5) {
            return 2;
        }
        return 3;
    }

    public int getFreeSelectedRegion(MouseEvent e2) {
        int i2;
        JComponent c2 = (JComponent)e2.getSource();
        int h2 = c2.getHeight();
        this.l.setHeight(h2);
        int x2 = e2.getX();
        int y2 = e2.getY();
        if (this.p.opacityMode == 6) {
            for (i2 = 0; i2 < this.p.rgbPos.length; ++i2) {
                int x22 = this.l.getXpos(c2.getWidth(), this.p.rgbPos[i2]);
                if (Math.abs(x22 - x2) >= 10 || this.p.opacityAtColor == null || !(this.p.opacityAtColor[i2] >= 0.0)) continue;
                this.colorPos = i2;
                break;
            }
        }
        for (i2 = 0; i2 < this.p.opacityPos.length; ++i2) {
            int x1;
            if (!this.showLine(i2) || Math.abs((x1 = this.l.getXpos(c2.getWidth(), this.p.opacityPos[i2])) - x2) >= 10) continue;
            this.cursorOver = i2;
            double hmin = this.l.op_bottom;
            double hmax = this.l.op_top;
            int posBefore = (int)(this.p.opacityBefore[i2] * (hmax - hmin) + hmin);
            int posAfter = (int)(this.p.opacityAfter[i2] * (hmax - hmin) + hmin);
            boolean nearPosBefore = Math.abs(posBefore - y2) < 6;
            boolean nearPosAfter = Math.abs(posAfter - y2) < 6;
            int dx = x1 - x2;
            if (!this.showRHandle(i2) && y2 < this.l.color_bottom && y2 > posBefore && posBefore == posAfter) {
                return 4;
            }
            if (nearPosBefore && nearPosAfter) {
                if (dx > 5) {
                    return 1;
                }
                if (dx < -5) {
                    return 2;
                }
                return 3;
            }
            if (nearPosBefore) {
                return 1;
            }
            if (nearPosAfter) {
                return 2;
            }
            if (y2 >= this.l.color_bottom) continue;
            if (this.showRHandle(i2) || this.showLHandle(i2)) {
                if (y2 <= Math.min(posAfter, posBefore)) continue;
                return 4;
            }
            return 4;
        }
        return 0;
    }
}

