/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.JComponent;

class OpacityMapUI
implements UIcontrol {
    Preset p;
    Layout l = new Layout();
    public static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f);
    public static final BasicStroke CURVE_STROKE = new BasicStroke(1.5f);
    int[] xPoints;
    int[] yPoints;
    int[] curveXpoints;
    int[] curveYpoints;
    int ow;
    int oh;
    transient int counter = 0;
    static TexturePaint checker_;
    public boolean mousePressed = false;
    private int prevX_;
    private JComponent source;

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    public void fps() {
        Thread t2 = new Thread(){

            @Override
            public void run() {
                while (true) {
                    long t2 = System.currentTimeMillis();
                    OpacityMapUI.this.counter = 0;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    long t22 = System.currentTimeMillis();
                    if (OpacityMapUI.this.counter == 0) continue;
                    System.out.println(t22 % 10000L + " fps= " + 1000.0f * (float)OpacityMapUI.this.counter / (float)(t22 - t2));
                }
            }
        };
        t2.setDaemon(true);
        t2.start();
    }

    public void paintSbar(Graphics g2, int x2, int y2, int w2, int h2) {
        this.fillPolygon2(g2, x2, y2, w2, h2);
    }

    @Override
    public void paint(Graphics g2, int w2, int h2, Rectangle r2) {
        this.l.setHeight(h2);
        ++this.counter;
        if (this.p == null) {
            return;
        }
        if (this.p.getProperty("paintCache") == null || w2 != this.ow || h2 != this.oh) {
            this.ow = w2;
            this.oh = h2;
            this.updatePaintCache(this.p, w2, h2);
        }
        g2.setColor(Color.GRAY);
        g2.fillRect(this.l.BORDER.left, 0, w2, this.l.op_bottom);
        this.fillPolygon(g2, w2, h2);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, this.l.op_bottom, w2, 1);
    }

    @Override
    public void setPresets(Preset p2) {
        this.p = p2;
        this.setupPoints();
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                OpacityMapUI.this.p.putProperty("paintCache", null);
            }
        });
    }

    public void setupPoints() {
        this.xPoints = new int[4 + 2 * this.p.opacityPos.length];
        this.yPoints = new int[4 + 2 * this.p.opacityPos.length];
    }

    public void fillPolygon(Graphics g2, int w2, int h2) {
        if (this.p == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g2;
        if (4 + 2 * this.p.opacityPos.length != this.xPoints.length) {
            this.setupPoints();
        }
        this.l.setHeight(h2);
        int xrange = w2 - this.l.BORDER.left - this.l.BORDER.right;
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        this.xPoints[0] = this.l.BORDER.left;
        this.yPoints[0] = (int)hmin;
        this.xPoints[1] = this.l.BORDER.left;
        this.yPoints[1] = (int)(this.p.opacityBefore[0] * (hmax - hmin) + hmin);
        for (int i2 = 0; i2 < this.p.opacityPos.length; ++i2) {
            int xpos;
            int ypos = (int)(this.p.opacityBefore[i2] * (hmax - hmin) + hmin);
            this.xPoints[i2 * 2 + 2] = xpos = this.l.getXpos(w2, this.p.opacityPos[i2]);
            this.yPoints[i2 * 2 + 2] = ypos;
            ypos = (int)(this.p.opacityAfter[i2] * (hmax - hmin) + hmin);
            this.xPoints[i2 * 2 + 3] = xpos;
            this.yPoints[i2 * 2 + 3] = ypos;
        }
        this.xPoints[2 + this.p.opacityPos.length * 2] = w2 - this.l.BORDER.right;
        this.yPoints[2 + this.p.opacityPos.length * 2] = (int)(this.p.opacityAfter[this.p.opacityPos.length - 1] * (hmax - hmin) + hmin);
        this.xPoints[3 + this.p.opacityPos.length * 2] = w2 - this.l.BORDER.right;
        this.yPoints[3 + this.p.opacityPos.length * 2] = (int)hmin;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(OpacityMapUI.getCheckerPattern());
        g2.fillPolygon(this.xPoints, this.yPoints, this.yPoints.length);
        g2d.setPaint((Paint)this.p.getProperty("paintCache"));
        g2.fillPolygon(this.xPoints, this.yPoints, this.yPoints.length);
        Stroke oldStroke = g2d.getStroke();
        if (this.p.opacityMode == 6) {
            g2.setColor(Color.GRAY);
            g2d.setStroke(DASHED_STROKE);
            int humpIndex = 0;
            for (int i3 = 0; this.p.opacityAtColor != null && i3 < this.p.opacityAtColor.length; ++i3) {
                int ypos1;
                int xpos1;
                int ypos;
                int xpos;
                if (this.p.opacityAtColor[i3] < 0.0) continue;
                if (i3 > 0 && this.p.opacityAtColor[i3 - 1] >= 0.0) {
                    xpos = (int)((double)xrange * (this.p.opacityPos[(humpIndex - 1) * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos = (int)hmin;
                    xpos1 = (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos1 = (int)(this.p.opacityAtColor[i3] * (hmax - hmin) + hmin);
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                if (i3 < this.p.opacityAtColor.length - 1 && this.p.opacityAtColor[i3 + 1] >= 0.0) {
                    xpos = (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos = (int)(this.p.opacityAtColor[i3] * (hmax - hmin) + hmin);
                    xpos1 = (int)((double)xrange * (this.p.opacityPos[(humpIndex + 1) * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + this.l.BORDER.left;
                    ypos1 = (int)hmin;
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                ++humpIndex;
            }
            g2d.setStroke(oldStroke);
        }
        g2d.setStroke(CURVE_STROKE);
        g2.setColor(Color.BLACK);
        g2d.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length - 1);
        g2d.setStroke(oldStroke);
    }

    public void fillPolygon2(Graphics g2, int x2, int y2, int w2, int h2) {
        if (this.p == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g2;
        if (4 + 2 * this.p.opacityPos.length != this.xPoints.length) {
            this.setupPoints();
        }
        BufferedImage img = new BufferedImage(w2, 1, 1);
        int[] buff = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        if (this.p.blackwhitemode) {
            int gray = Color.GRAY.getRGB();
            Arrays.fill(buff, gray);
        } else {
            for (int i2 = 0; i2 < w2; ++i2) {
                double pos = (Layout.MAX - Layout.MIN) * (double)i2 / (double)(w2 - 1) + Layout.MIN;
                buff[i2] = this.getColorAtLocataion(pos);
            }
        }
        TexturePaint paint = new TexturePaint(img, new Rectangle2D.Double(x2, y2, w2, h2));
        int xrange = w2;
        double hmin = h2;
        double hmax = y2;
        this.xPoints[0] = x2;
        this.yPoints[0] = (int)hmin;
        this.xPoints[1] = x2;
        this.yPoints[1] = (int)(this.p.opacityBefore[0] * (hmax - hmin) + hmin) + y2;
        for (int i3 = 0; i3 < this.p.opacityPos.length; ++i3) {
            int xpos;
            int ypos = (int)(this.p.opacityBefore[i3] * (hmax - hmin) + hmin);
            this.xPoints[i3 * 2 + 2] = xpos = x2 + (int)((double)xrange * (this.p.opacityPos[i3] - Layout.MIN) / (Layout.MAX - Layout.MIN)) + 0;
            this.yPoints[i3 * 2 + 2] = ypos;
            ypos = (int)(this.p.opacityAfter[i3] * (hmax - hmin) + hmin);
            this.xPoints[i3 * 2 + 3] = xpos;
            this.yPoints[i3 * 2 + 3] = ypos;
        }
        this.xPoints[2 + this.p.opacityPos.length * 2] = x2 + w2;
        this.yPoints[2 + this.p.opacityPos.length * 2] = (int)(this.p.opacityAfter[this.p.opacityPos.length - 1] * (hmax - hmin) + hmin);
        this.xPoints[3 + this.p.opacityPos.length * 2] = x2 + w2;
        this.yPoints[3 + this.p.opacityPos.length * 2] = (int)hmin;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(paint);
        g2.fillPolygon(this.xPoints, this.yPoints, this.yPoints.length);
        Stroke oldStroke = g2d.getStroke();
        if (this.p.opacityMode == 6) {
            g2.setColor(Color.GRAY);
            g2d.setStroke(DASHED_STROKE);
            int humpIndex = 0;
            for (int i4 = 0; this.p.opacityAtColor != null && i4 < this.p.opacityAtColor.length; ++i4) {
                int ypos1;
                int xpos1;
                int ypos;
                int xpos;
                if (this.p.opacityAtColor[i4] < 0.0) continue;
                if (i4 > 0 && this.p.opacityAtColor[i4 - 1] >= 0.0) {
                    xpos = x2 + (int)((double)xrange * (this.p.opacityPos[(humpIndex - 1) * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos = (int)hmin;
                    xpos1 = x2 + (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos1 = (int)(this.p.opacityAtColor[i4] * (hmax - hmin) + hmin);
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                if (i4 < this.p.opacityAtColor.length - 1 && this.p.opacityAtColor[i4 + 1] >= 0.0) {
                    xpos = x2 + (int)((double)xrange * (this.p.opacityPos[humpIndex * 5 + 3] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos = (int)(this.p.opacityAtColor[i4] * (hmax - hmin) + hmin);
                    xpos1 = x2 + (int)((double)xrange * (this.p.opacityPos[(humpIndex + 1) * 5 + 1] - Layout.MIN) / (Layout.MAX - Layout.MIN));
                    ypos1 = (int)hmin;
                    g2d.drawLine(xpos, ypos, xpos1, ypos1);
                }
                ++humpIndex;
            }
            g2d.setStroke(oldStroke);
        }
        g2d.setStroke(CURVE_STROKE);
        g2.setColor(Color.BLACK);
        g2d.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length - 1);
        g2d.setStroke(oldStroke);
    }

    public int getColorAtLocataion(double pos) {
        if (pos <= this.p.rgbPos[0]) {
            return this.p.rgbValue[0] & 0xFFFFFF;
        }
        if (pos >= this.p.rgbPos[this.p.rgbPos.length - 1]) {
            return this.p.rgbValue[this.p.rgbPos.length - 1] & 0xFFFFFF;
        }
        for (int i2 = 1; i2 < this.p.rgbPos.length; ++i2) {
            if (!(pos < this.p.rgbPos[i2])) continue;
            int c1 = this.p.rgbValue[i2];
            int c0 = this.p.rgbValue[i2 - 1];
            double t2 = (pos - this.p.rgbPos[i2 - 1]) / (this.p.rgbPos[i2] - this.p.rgbPos[i2 - 1]);
            if (this.p.rgbNNeighbour) {
                return t2 > 0.5 ? c1 : c0;
            }
            int b2 = (int)((double)(c1 & 0xFF) * t2 + (double)(c0 & 0xFF) * (1.0 - t2));
            int g2 = (int)((double)((c1 >>= 8) & 0xFF) * t2 + (double)((c0 >>= 8) & 0xFF) * (1.0 - t2));
            int r2 = (int)((double)((c1 >>= 8) & 0xFF) * t2 + (double)((c0 >>= 8) & 0xFF) * (1.0 - t2));
            int c2 = (r2 & 0xFF) << 16 | (g2 & 0xFF) << 8 | b2 & 0xFF;
            return c2;
        }
        return 0;
    }

    public double getOpacityAtLocation(double pos) {
        int i2;
        for (i2 = 0; i2 < this.p.opacityPos.length && !(this.p.opacityPos[i2] > pos); ++i2) {
        }
        if (i2 > 0 && i2 < this.p.opacityPos.length) {
            double p0 = this.p.opacityPos[i2 - 1];
            double p1 = this.p.opacityPos[i2];
            double o0 = this.p.opacityAfter[i2 - 1];
            double o1 = this.p.opacityBefore[i2];
            return o0 + (pos - p0) / (p1 - p0) * (o1 - o0);
        }
        if (i2 == 0) {
            return this.p.opacityBefore[0];
        }
        return this.p.opacityAfter[this.p.opacityPos.length - 1];
    }

    public void updatePaintCache(Preset p2, int sw, int sh) {
        int w2 = this.l.getXRange(sw);
        if (w2 <= 1) {
            p2.putProperty("paintCache", new GradientPaint(0.0f, 0.0f, Color.black, 10.0f, 10.0f, Color.GRAY));
            p2.putProperty("paintCacheNoAlpha", new GradientPaint(0.0f, 0.0f, Color.black, 10.0f, 10.0f, Color.GRAY));
            return;
        }
        int h2 = sh - this.l.BORDER.top - this.l.BORDER.bottom;
        BufferedImage img = new BufferedImage(w2, 1, 2);
        int[] buff = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        BufferedImage imgNoAlpha = new BufferedImage(w2, 1, 1);
        int[] buffNoAlpha = ((DataBufferInt)imgNoAlpha.getRaster().getDataBuffer()).getData();
        if (p2.blackwhitemode) {
            p2.putProperty("paintCacheNoAlpha", Color.GRAY);
            int gray = Color.GRAY.getRGB() & 0xFFFFFF;
            for (int i2 = 0; i2 < w2; ++i2) {
                double pos = (Layout.MAX - Layout.MIN) * (double)i2 / (double)(w2 - 1) + Layout.MIN;
                double alpha = this.getOpacityAtLocation(pos);
                buff[i2] = gray | (int)(alpha * 255.0) << 24;
            }
            p2.putProperty("paintCache", new TexturePaint(img, new Rectangle2D.Double(this.l.BORDER.left, this.l.BORDER.top, w2, h2)));
            return;
        }
        for (int i3 = 0; i3 < w2; ++i3) {
            double pos = (Layout.MAX - Layout.MIN) * (double)i3 / (double)(w2 - 1) + Layout.MIN;
            buffNoAlpha[i3] = this.getColorAtLocataion(pos);
            double alpha = this.getOpacityAtLocation(pos);
            buff[i3] = buffNoAlpha[i3] & 0xFFFFFF | (int)(Math.pow(alpha, 0.1) * 255.0) << 24;
        }
        p2.putProperty("paintCache", new TexturePaint(img, new Rectangle2D.Double(this.l.BORDER.left, this.l.BORDER.top, w2, h2)));
        p2.putProperty("paintCacheNoAlpha", new TexturePaint(imgNoAlpha, new Rectangle2D.Double(this.l.BORDER.left, this.l.BORDER.top, w2, h2)));
    }

    public static Paint getCheckerPattern() {
        if (checker_ == null) {
            int checkerSize = 8;
            int white = Color.WHITE.getRGB();
            int gray = Color.GRAY.getRGB();
            BufferedImage im = new BufferedImage(16, 16, 1);
            int[] buff = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
            for (int i2 = 0; i2 < buff.length; ++i2) {
                int row = i2 / 8 / 2 / 8;
                int col = i2 % 16 / 8;
                buff[i2] = row == 0 && col == 0 || row == 1 && col == 1 ? white : gray;
            }
            checker_ = new TexturePaint(im, new Rectangle2D.Double(0.0, 0.0, 16.0, 16.0));
        }
        return checker_;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (!this.mousePressed) {
            return;
        }
        int x2 = e2.getX();
        double translation = this.l.getVfromX(this.source.getWidth(), x2) - this.l.getVfromX(this.source.getWidth(), this.prevX_);
        if (this.p.opacityMode != 6) {
            int i2 = 0;
            while (i2 < this.p.opacityPos.length) {
                int n2 = i2++;
                this.p.opacityPos[n2] = this.p.opacityPos[n2] + translation;
            }
        } else {
            int i3 = 0;
            while (i3 < this.p.rgbPos.length) {
                int n3 = i3++;
                this.p.rgbPos[n3] = this.p.rgbPos[n3] + translation;
            }
            this.p.updateOpacityPts();
        }
        this.source.repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseDragged"));
        this.prevX_ = x2;
    }

    @Override
    public boolean mouseMoved(MouseEvent e2) {
        JComponent c2 = (JComponent)e2.getSource();
        this.l.setHeight(c2.getHeight());
        boolean onCurve = this.onCurve(e2.getX(), e2.getY(), c2.getWidth());
        if (onCurve) {
            c2.setCursor(Cursor.getPredefinedCursor(12));
            return true;
        }
        return false;
    }

    public boolean onCurve(int x2, int y2, int w2) {
        double pos = this.l.getVfromX(w2, x2);
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        int index = -1;
        for (int i2 = 0; i2 < this.p.opacityPos.length; ++i2) {
            int x1 = this.l.getXpos(w2, this.p.opacityPos[i2]);
            if (x2 >= x1) continue;
            index = i2;
            break;
        }
        if (index >= 0) {
            double opacityAtCurve = 0.0;
            if (index == 0) {
                opacityAtCurve = this.p.opacityBefore[0];
            } else if (index == -1) {
                opacityAtCurve = this.p.opacityAfter[this.p.opacityPos.length - 1];
            } else {
                double y1 = this.p.opacityAfter[index - 1];
                double y22 = this.p.opacityBefore[index];
                double x1 = this.p.opacityPos[index - 1];
                double x22 = this.p.opacityPos[index];
                opacityAtCurve = y1 + (pos - x1) * (y22 - y1) / (x22 - x1);
            }
            int opAtCurveOnPlot = (int)(opacityAtCurve * (hmax - hmin) + hmin);
            if (Math.abs(y2 - opAtCurveOnPlot) < 5) {
                boolean onhandle = false;
                for (int i3 = 0; i3 < this.p.opacityPos.length; ++i3) {
                    int x1;
                    if (!this.showLine(i3) || Math.abs((x1 = this.l.getXpos(w2, this.p.opacityPos[i3])) - x2) >= 10) continue;
                    int posBefore = (int)(this.p.opacityBefore[i3] * (hmax - hmin) + hmin);
                    int posAfter = (int)(this.p.opacityAfter[i3] * (hmax - hmin) + hmin);
                    boolean nearPosBefore = Math.abs(posBefore - y2) < 6;
                    boolean nearPosAfter = Math.abs(posAfter - y2) < 6;
                    int dx = x1 - x2;
                    if (!this.showRHandle(i3) && y2 < this.l.color_bottom && y2 > posBefore && posBefore == posAfter) break;
                    if (nearPosBefore && nearPosAfter) {
                        onhandle = true;
                        break;
                    }
                    if (nearPosBefore) {
                        onhandle = true;
                        break;
                    }
                    if (nearPosAfter) {
                        onhandle = true;
                        break;
                    }
                    if (y2 >= this.l.color_bottom) break;
                    break;
                }
                return !onhandle;
            }
        }
        return false;
    }

    public boolean showRHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    private boolean showAttachObjectControlAt(int pos) {
        if (this.p.opacityMode != 6) {
            throw new IllegalArgumentException("Not in attach object mode!");
        }
        return pos % 5 == 2;
    }

    public boolean showLine(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    public boolean showLHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent e2) {
        this.source = (JComponent)e2.getSource();
        if (this.onCurve(e2.getX(), e2.getY(), this.source.getWidth())) {
            this.mousePressed = true;
            this.prevX_ = e2.getX();
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.mousePressed = false;
        ((JComponent)e2.getSource()).repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseReleased"));
    }
}

