/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIelement;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

class TickMarksUI
implements UIelement {
    public static String UNIT = "HU";
    Layout l;
    Preset p;
    double actualTickSpacing;
    final int MIN_TICK_PIXELS = 50;
    final int TICK_HEIGHT = 20;
    Component c;
    static final double[] spacings = new double[]{0.1, 0.2, 0.25, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 25.0, 50.0, 100.0, 200.0, 250.0, 500.0, 1000.0, 2000.0, 2500.0, 5000.0, 10000.0, 20000.0, 25000.0, 50000.0, 100000.0, 200000.0, 250000.0, 500000.0};

    @Override
    public void paint(Graphics g2, int w2, int h2, Rectangle r2) {
        this.l.setHeight(h2);
        int gridWidth = w2 - this.l.BORDER.left - this.l.BORDER.right;
        double iwidth = Layout.MAX - Layout.MIN;
        int maxTickSpacing = 100;
        int minTickSpacing = 80;
        double tsMax = iwidth * (double)maxTickSpacing / (double)gridWidth;
        double tsMin = iwidth * (double)minTickSpacing / (double)gridWidth;
        double ts = 100000.0;
        for (int i2 = 0; i2 < spacings.length; ++i2) {
            if (!(spacings[i2] > tsMin)) continue;
            ts = spacings[i2];
            break;
        }
        int ystart = this.l.tick_top;
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(Color.BLACK);
        int strh = fm.getHeight();
        int ylen = (28 - strh) / 2 + 3;
        int strY = ystart + 28 - strh + fm.getAscent();
        double cw = (double)fm.stringWidth("-123456789.0") / 24.0;
        double start = Layout.MIN - Layout.MIN % ts;
        g2.drawRect(this.l.BORDER.left, ystart, w2, 1);
        double i3 = start;
        while (true) {
            if (!(i3 <= Layout.MAX)) break;
            int x2 = (int)((double)gridWidth * (i3 - Layout.MIN) / iwidth) + this.l.BORDER.left;
            String s2 = Float.toString((float)i3);
            g2.fillRect(x2, ystart + 1, 1, ylen);
            g2.drawString(s2, x2 - (int)((double)s2.length() * cw), strY + 1);
            i3 += ts;
        }
        g2.drawRect(this.l.BORDER.left, ystart + 28 + 2, w2, 0);
        Rectangle2D rect = fm.getStringBounds(UNIT, g2);
        g2.drawString(UNIT, (int)((double)(r2.x + r2.width) - rect.getWidth()), this.l.tick_bottom - 2);
    }

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    @Override
    public void setPresets(Preset p2) {
        this.p = p2;
    }
}

