/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.marker.XpPointMarker;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JFrame;

public class segend {
    private static final double ZHIST_SCALE = 4.0;
    private static final int ZMIN = 2;
    private static final int ZMAX = 256;
    private static final int THRESHOLD = 1038;
    private static final int MAX_LEVEL = 4096;
    private double[] pixels = null;
    private double[] lookpt = new double[3];
    private double[] xstep = new double[3];
    private double[] ystep = new double[3];
    private double[] zstep = new double[3];
    private boolean from_inside = false;
    private int width = 0;
    private int height = 0;
    private double[] zminmax = new double[2];
    private JVolume.LinearShort jvolume = null;
    private ZImageCtxt ctxt = new ZImageCtxt();
    private static int totalpix = 0;
    private double[] limit = new double[3];
    private double[] Vdist = new double[3];
    private double[] sx = new double[3];
    private double[] sy = new double[3];
    private double[] sz = new double[3];
    private double[] center = new double[3];
    private double[] vertex = new double[3];
    private double[] centerRpoint = new double[3];
    private double[] zhist = new double[1028];

    private void debug(String function, String msg) {
    }

    public void setSession(JVolume.LinearShort volume) {
        this.jvolume = volume;
    }

    public void setView(double[] lookpt, double[] xstep, double[] ystep, double[] zstep, int w2, int h2) {
        if (this.pixels == null || this.width != w2 || this.height != h2) {
            this.pixels = new double[w2 * h2];
        }
        this.width = w2;
        this.height = h2;
        System.arraycopy(lookpt, 0, this.lookpt, 0, 3);
        System.arraycopy(xstep, 0, this.xstep, 0, 3);
        System.arraycopy(ystep, 0, this.ystep, 0, 3);
        System.arraycopy(zstep, 0, this.zstep, 0, 3);
        this.endo_compute_zminmax(this.zminmax);
        this.from_inside = lookpt[0] > 0.0 && lookpt[1] > 0.0 && lookpt[2] > 0.0 && lookpt[0] < (double)(this.jvolume.dx - 1) && lookpt[1] < (double)(this.jvolume.dy - 1) && lookpt[2] < (double)(this.jvolume.dz - 1);
    }

    public int render(int x0, int y0, int x1, int y1, int xskip, int yskip, RenderCtxt rctxt) {
        for (int y2 = y0; y2 <= y1; y2 += yskip) {
            this.scaleAdd(this.lookpt, (double)y2 - (double)this.height * 0.5, this.ystep, rctxt.point_sl);
            for (int x2 = x0; x2 <= x1; x2 += xskip) {
                this.scaleAdd(rctxt.point_sl, (double)x2 - (double)this.width * 0.5, this.xstep, rctxt.point_cur);
                this.endo_raytrace_nothresh_n(rctxt.point_cur, this.zstep, this.pixels, x2, y2, rctxt);
            }
        }
        return 0;
    }

    public void post_render(short[] img, boolean[] lines) {
        this.endo_translatezimage(img, this.pixels, 256.0, lines);
    }

    private int endo_raytrace_nothresh_p(double[] point, double[] ray_cur, double[] pixels, int x2, int y2, RenderCtxt rctxt) {
        double zmin = this.zminmax[0];
        double zmax = this.zminmax[1];
        int idx = y2 * this.width + x2;
        double z_cur = zmin;
        double[] dz = new double[1];
        double[] point_cur = new double[3];
        Cached_values[] caches = rctxt.caches;
        this.scaleAdd(point, z_cur, ray_cur, point_cur);
        int cache_cur = (int)z_cur;
        while (z_cur < zmax) {
            if (this.voxel_analyze_nothresh_p(1038, point_cur, ray_cur, caches, cache_cur, dz)) {
                z_cur += dz[0];
                break;
            }
            if (this.from_inside && caches[cache_cur].out) {
                z_cur = zmax;
                break;
            }
            z_cur += 1.0;
            JnVector3d.add(point_cur, ray_cur, point_cur);
            ++cache_cur;
        }
        pixels[idx] = z_cur;
        return 1;
    }

    private int endo_raytrace_nothresh_n(double[] point, double[] ray_cur, double[] pixels, int x2, int y2, RenderCtxt rctxt) {
        double zmin = this.zminmax[0];
        double zmax = this.zminmax[1];
        int idx = y2 * this.width + x2;
        double z_cur = zmin;
        double[] dz = new double[1];
        double[] point_cur = new double[3];
        Cached_values[] caches = rctxt.caches;
        this.scaleAdd(point, z_cur, ray_cur, point_cur);
        int cache_cur = (int)z_cur;
        caches[cache_cur - 1].fvalues = this.get_value_nothresh_n(point_cur, 1038, caches[cache_cur - 1]);
        while (z_cur < zmax) {
            dz[0] = 0.0;
            if (this.voxel_analyze_nothresh_n(1038, point_cur, ray_cur, caches, cache_cur, dz)) {
                z_cur += dz[0];
                break;
            }
            if (this.from_inside && caches[cache_cur].out) {
                z_cur = zmax;
                break;
            }
            z_cur += 1.0;
            JnVector3d.add(point_cur, ray_cur, point_cur);
            ++cache_cur;
        }
        pixels[idx] = z_cur;
        return 1;
    }

    private double get_value_nothresh_p(double[] point, int threshold, Cached_values caches) {
        int xf = (int)point[0];
        int yf = (int)point[1];
        int zf = (int)point[2];
        short[] points = caches.values;
        int xyz = zf | yf << 12 | xf << 22;
        if (caches.xyz != xyz) {
            int size = segend.LN_2(this.jvolume.dx);
            int vsize_ = this.jvolume.dx;
            int vsize = vsize_ - 1;
            caches.xyz = xyz;
            if (xf < 1 || xf >= vsize || yf < 1 || yf >= vsize || zf < 1 || zf >= this.jvolume.dz - 1) {
                caches.notempty = false;
                caches.out = true;
                return 0.0;
            }
            caches.out = false;
            short[] dens_list = this.jvolume.volume;
            int dens_ptr = 0;
            int dens_list_xy = this.jvolume.PAD + (xf | yf << size);
            double dx = point[0] - (double)xf;
            double dy = point[1] - (double)yf;
            dens_ptr = dens_list_xy + (zf << (size << 1));
            points[0] = dens_list[dens_ptr];
            points[1] = dens_list[dens_ptr + 1];
            points[2] = dens_list[dens_ptr += vsize_];
            points[3] = dens_list[dens_ptr + 1];
            dens_ptr = dens_list_xy + (zf + 1 << (size << 1));
            points[4] = dens_list[dens_ptr];
            points[5] = dens_list[dens_ptr + 1];
            points[6] = dens_list[dens_ptr += vsize_];
            points[7] = dens_list[dens_ptr + 1];
            if (points[0] >= threshold || points[1] >= threshold || points[2] >= threshold || points[3] >= threshold || points[4] >= threshold || points[5] >= threshold || points[6] >= threshold || points[7] >= threshold) {
                caches.notempty = true;
                double t1 = this.LININT(points[0], points[1], dx);
                double t3 = this.LININT(t1, this.LININT(points[2], points[3], dx), dy);
                t1 = this.LININT(points[4], points[5], dx);
                t1 = this.LININT(t1, this.LININT(points[6], points[7], dx), dy);
                return this.LININT(t3, t1, point[2] - (double)zf);
            }
            caches.notempty = false;
            return -1.0;
        }
        if (caches.notempty) {
            double dx = point[0] - (double)xf;
            double dy = point[1] - (double)yf;
            double t1 = this.LININT(points[0], points[1], dx);
            double t3 = this.LININT(t1, this.LININT(points[2], points[3], dx), dy);
            t1 = this.LININT(points[4], points[5], dx);
            t1 = this.LININT(t1, this.LININT(points[6], points[7], dx), dy);
            return this.LININT(t3, t1, point[2] - (double)zf);
        }
        return -1.0;
    }

    private double get_value_nothresh_n(double[] point, int threshold, Cached_values caches) {
        int xf = (int)point[0];
        int yf = (int)point[1];
        int zf = (int)point[2];
        short[] points = caches.values;
        int xyz = zf | yf << 12 | xf << 22;
        if (caches.xyz != xyz) {
            int size = segend.LN_2(this.jvolume.dx);
            int vsize = this.jvolume.dx - 1;
            caches.xyz = xyz;
            if (xf < 1 || xf >= vsize || yf < 1 || yf >= vsize || zf < 1 || zf >= this.jvolume.dz - 1) {
                caches.notempty = false;
                caches.out = true;
                return 0.0;
            }
            caches.out = false;
            short[] dens_list = this.jvolume.volume;
            int dens_list_xy = this.jvolume.PAD + (yf << size) + xf;
            int dens_ptr = dens_list_xy + (zf << (size << 1));
            points[0] = dens_list[dens_ptr];
            points[1] = dens_list[dens_ptr + 1];
            points[2] = dens_list[dens_ptr += this.jvolume.dx];
            points[3] = dens_list[dens_ptr + 1];
            dens_ptr = dens_list_xy + (zf + 1 << (size << 1));
            points[4] = dens_list[dens_ptr];
            points[5] = dens_list[dens_ptr + 1];
            points[6] = dens_list[dens_ptr += this.jvolume.dx];
            points[7] = dens_list[dens_ptr + 1];
            if (points[0] <= threshold || points[1] <= threshold || points[2] <= threshold || points[3] <= threshold || points[4] <= threshold || points[5] <= threshold || points[6] <= threshold || points[7] <= threshold) {
                double dx = point[0] - (double)xf;
                double dy = point[1] - (double)yf;
                double dz = point[2] - (double)zf;
                caches.notempty = true;
                double t1 = this.LININT(points[0], points[1], dx);
                double t3 = this.LININT(t1, this.LININT(points[2], points[3], dx), dy);
                t1 = this.LININT(points[4], points[5], dx);
                t1 = this.LININT(t1, this.LININT(points[6], points[7], dx), dy);
                return this.LININT(t3, t1, dz);
            }
            caches.notempty = false;
            return -1.0;
        }
        if (caches.notempty) {
            double dx = point[0] - (double)xf;
            double dy = point[1] - (double)yf;
            double t1 = this.LININT(points[0], points[1], dx);
            double t3 = this.LININT(t1, this.LININT(points[2], points[3], dx), dy);
            t1 = this.LININT(points[4], points[5], dx);
            t1 = this.LININT(t1, this.LININT(points[6], points[7], dx), dy);
            return this.LININT(t3, t1, point[2] - (double)zf);
        }
        return -1.0;
    }

    private boolean voxel_analyze_nothresh_p(int threshold, double[] point_cur, double[] ray_cur, Cached_values[] caches, int cidx, double[] retdz) {
        double dz = retdz[0];
        caches[cidx].fvalues = this.get_value_nothresh_p(point_cur, threshold, caches[cidx]);
        if (caches[cidx].fvalues < (double)threshold) {
            return false;
        }
        int cached_prev = cidx - 1;
        if (caches[cached_prev].fvalues < 0.0) {
            if (caches[cached_prev].out) {
                dz = 0.0;
                retdz[0] = 0.0;
                return true;
            }
            short[] points = caches[cached_prev].values;
            double _dx = point_cur[0] - ray_cur[0];
            _dx -= (double)((int)_dx);
            double _dy = point_cur[1] - ray_cur[1];
            _dy -= (double)((int)_dy);
            double t1 = this.LININT(points[0], points[1], _dx);
            double t3 = this.LININT(t1, this.LININT(points[2], points[3], _dx), _dy);
            t1 = this.LININT(points[4], points[5], _dx);
            t1 = this.LININT(t1, this.LININT(points[6], points[7], _dx), _dy);
            double _dz = point_cur[2] - ray_cur[2];
            _dz -= (double)((int)_dz);
            caches[cached_prev].fvalues = this.LININT(t3, t1, _dz);
        }
        retdz[0] = dz = -(caches[cidx].fvalues - (double)threshold) / (caches[cidx].fvalues - caches[cached_prev].fvalues);
        return true;
    }

    private boolean voxel_analyze_nothresh_n(int threshold, double[] point_cur, double[] ray_cur, Cached_values[] caches, int cidx, double[] retdz) {
        double dz = retdz[0];
        caches[cidx].fvalues = this.get_value_nothresh_n(point_cur, threshold, caches[cidx]);
        if (caches[cidx].fvalues == -1.0 || caches[cidx].fvalues > (double)threshold) {
            dz = 0.0;
            retdz[0] = 0.0;
            return false;
        }
        int cached_prev = cidx - 1;
        if (caches[cached_prev].fvalues < 0.0) {
            if (caches[cached_prev].out) {
                dz = 0.0;
                retdz[0] = 0.0;
                return true;
            }
            short[] points = caches[cached_prev].values;
            double _dx = point_cur[0] - ray_cur[0];
            _dx -= (double)((int)_dx);
            double _dy = point_cur[1] - ray_cur[1];
            _dy -= (double)((int)_dy);
            double t1 = this.LININT(points[0], points[1], _dx);
            double t3 = this.LININT(t1, this.LININT(points[2], points[3], _dx), _dy);
            t1 = this.LININT(points[4], points[5], _dx);
            t1 = this.LININT(t1, this.LININT(points[6], points[7], _dx), _dy);
            double _dz = point_cur[2] - ray_cur[2];
            _dz -= (double)((int)_dz);
            caches[cached_prev].fvalues = this.LININT(t3, t1, _dz);
        }
        dz = caches[cidx].fvalues != caches[cached_prev].fvalues ? -(caches[cidx].fvalues - (double)threshold) / (caches[cidx].fvalues - caches[cached_prev].fvalues) : 0.0;
        retdz[0] = dz;
        return true;
    }

    private void vprint(int x2, int y2, int z2, short[] pts, double val) {
        System.err.print("(" + x2 + "," + y2 + "," + z2 + ") [");
        for (int i2 = 0; i2 < pts.length; ++i2) {
            System.err.print(" " + pts[i2]);
        }
        System.err.println("] " + val);
    }

    private void endo_compute_zminmax(double[] zminmax) {
        double zmin = 0.0;
        double zmax = 0.0;
        zmax = this.find_maxdist_to_vertices(this.lookpt, this.zstep);
        if (zmax > 255.0) {
            zmax = 255.0;
        }
        zmin = this.lookpt[0] >= 0.0 && this.lookpt[1] >= 0.0 && this.lookpt[2] >= 0.0 && this.lookpt[0] < (double)this.jvolume.dx && this.lookpt[1] < (double)this.jvolume.dy && this.lookpt[2] < (double)this.jvolume.dz ? 2.0 : this.find_mindist_to_side(this.lookpt);
        double d2 = zmin = zmin > 2.0 ? zmin : 2.0;
        if (zmin > zmax) {
            zmax = zmin;
        }
        zminmax[0] = zmin;
        zminmax[1] = zmax;
        this.debug("endo_compute_zminmax", "" + zmin + " " + zmax);
    }

    private double find_mindist_to_side(double[] point) {
        this.limit[0] = this.jvolume.dx;
        this.limit[1] = this.jvolume.dy;
        this.limit[2] = this.jvolume.dz;
        for (int i2 = 0; i2 < 3; ++i2) {
            this.Vdist[i2] = point[i2] < 0.0 ? -point[i2] : (point[i2] > this.limit[i2] ? this.limit[i2] - point[i2] : 0.0);
        }
        return JnVector3d.length(this.Vdist);
    }

    private double find_maxdist_to_vertices(double[] point, double[] ray) {
        for (int a2 = 0; a2 < 3; ++a2) {
            this.sz[a2] = 0.0;
            this.sy[a2] = 0.0;
            this.sx[a2] = 0.0;
        }
        this.sx[0] = 0.5 * (double)this.jvolume.dx;
        this.sy[1] = 0.5 * (double)this.jvolume.dy;
        this.sz[2] = 0.5 * (double)this.jvolume.dz;
        this.center[0] = this.center[1] = 0.5 * (double)(this.jvolume.dx - 1);
        this.center[2] = 0.5 * (double)(this.jvolume.dz - 1);
        JnVector3d.sub(point, this.center, this.centerRpoint);
        double maxdist = 0.0;
        for (int i2 = -1; i2 <= 2; i2 += 2) {
            for (int j2 = -1; j2 <= 2; j2 += 2) {
                for (int k2 = -1; k2 <= 2; k2 += 2) {
                    double hypot3;
                    this.scaleAdd(this.centerRpoint, i2, this.sx, this.vertex);
                    this.scaleAdd(this.vertex, j2, this.sy, this.vertex);
                    this.scaleAdd(this.vertex, k2, this.sz, this.vertex);
                    if (!(JnVector3d.dot(this.vertex, ray) >= 0.0) || !((hypot3 = JnVector3d.length(this.vertex)) > maxdist)) continue;
                    maxdist = hypot3;
                }
            }
        }
        if (maxdist == 0.0) {
            maxdist = 2.0;
        }
        return maxdist;
    }

    private void scaleAdd(double[] v0, double s2, double[] v1, double[] res) {
        res[0] = v0[0] + s2 * v1[0];
        res[1] = v0[1] + s2 * v1[1];
        res[2] = v0[2] + s2 * v1[2];
    }

    private double LININT(double x0, double x1, double dx) {
        return x0 + dx * (x1 - x0);
    }

    private static int LN_2(int val) {
        for (int i2 = 0; i2 < 20; ++i2) {
            if (val > 1 << i2) continue;
            return i2;
        }
        return 0;
    }

    private static double hypot(double dx, double dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    private void get_normalized_z(double[] zhist, double[] zimage, boolean[] lines, double zmax, double maximg) {
        int i2;
        double light = 3.0;
        Arrays.fill(zhist, 0.0);
        int numpixels = 0;
        for (int y2 = 0; y2 < this.height; ++y2) {
            int ystart;
            if (!lines[y2]) continue;
            for (i2 = ystart = y2 * this.width; i2 < ystart + this.width; ++i2) {
                int zidx;
                int n2 = zidx = (int)(4.0 * zimage[i2]);
                zhist[n2] = zhist[n2] + 1.0;
            }
            numpixels += this.width;
        }
        double k2 = 4.0 / (double)numpixels;
        int maxi = 1028;
        double v2 = 0.0;
        double vt = maximg;
        int last_i = 0;
        double last_vt = vt;
        for (i2 = 0; i2 < maxi; ++i2) {
            double vn = zhist[i2] * k2;
            zhist[i2] = vt;
            if (vn == 0.0) continue;
            if ((v2 += vn) < 3.0) {
                vt = maximg - maximg * Math.sqrt(Math.sqrt(v2 / 3.0)) / 4.0;
            } else {
                double lightdiff = 4.0 - v2;
                if (lightdiff > -1.0E-5) {
                    lightdiff = 0.0;
                }
                double lval = Math.sqrt(lightdiff);
                vt = maximg - maximg * (1.0 - 3.0 * Math.sqrt(lval) / 4.0);
            }
            if (last_i < i2) {
                double dvt = (vt - last_vt) / (double)(i2 + 1 - last_i);
                for (int j2 = last_i + 1; j2 <= i2; ++j2) {
                    zhist[j2] = last_vt += dvt;
                }
            }
            last_i = i2 + 1;
            last_vt = vt;
        }
    }

    private void endo_translatezimage(short[] img, double[] zimage, double zmax, boolean[] lines) {
        int i2;
        double thresh = 3.0;
        double background = 2047.5;
        this.get_normalized_z(this.zhist, zimage, lines, zmax, 4095.0);
        int viewsize = this.width * this.height - this.width;
        zmax -= 0.001;
        for (i2 = 0; i2 < this.width; ++i2) {
            img[i2] = 2047;
        }
        for (i2 = this.width; i2 < viewsize; ++i2) {
            int lineno = i2 / this.width;
            if (!lines[lineno]) continue;
            double z2 = zimage[i2];
            if (z2 >= zmax) {
                img[i2] = 2047;
                continue;
            }
            double dx = zimage[i2 + 1] - zimage[i2 - 1];
            double dy = zimage[i2 + this.width] - zimage[i2 - this.width];
            double v2 = 3.0 / (3.0 + segend.hypot(dx, dy));
            int iz = (int)(4.0 * z2);
            double dz = 4.0 * z2 - (double)iz;
            img[i2] = (short)(v2 * ((1.0 - dz) * this.zhist[iz] + dz * this.zhist[iz + 1]));
        }
        for (i2 = 0; i2 < this.width; ++i2) {
            img[viewsize + i2] = 2047;
        }
    }

    private void endo_translatezimage_igrad(short[] img, double[] zimage, double zmax, boolean adjust_histo, int adjust_histo_min, int adjust_histo_max, boolean[] lines) {
        this.get_normalized_z(this.zhist, zimage, lines, zmax, 4095.0);
        this.ctxt.zimage = zimage;
        this.ctxt.zhist = this.zhist;
        this.ctxt.zmax = zmax;
        this.ctxt.img = img;
        this.translatezimage_igrad_init(this.ctxt);
        this.translatezimage_igrad_w_nothresh_loop(0, this.height - 1, 1, 1, lines, this.ctxt);
        this.translatezimage_igrad_stop(this.ctxt);
        if (adjust_histo) {
            this.adjust_histo_mean(img, this.ctxt.histo, lines, adjust_histo_min, adjust_histo_max);
        }
    }

    private int translatezimage_igrad_init(ZImageCtxt ctxt) {
        Arrays.fill(ctxt.thread_histo, 0L);
        return 0;
    }

    private void translatezimage_igrad_stop(ZImageCtxt ctxt) {
        long[] histo_thread = ctxt.thread_histo;
        long[] histo_work = ctxt.histo;
        for (int i2 = 0; i2 < 4096; ++i2) {
            int n2 = i2;
            histo_work[n2] = histo_work[n2] + histo_thread[i2];
        }
    }

    private void translatezimage_igrad_w_nothresh_loop(int v0, int v1, int xskip, int yskip, boolean[] lines, ZImageCtxt ctxt) {
        int[] pxyz = new int[]{-1};
        int background = 2047;
        double zmax = ctxt.zmax;
        double[] zimage = ctxt.zimage;
        short[] img = ctxt.img;
        long[] histo = ctxt.histo;
        for (int y2 = v0; y2 <= v1; y2 += yskip) {
            if (!lines[y2]) continue;
            int yoffset = y2 * this.width;
            this.scaleAdd(this.zstep, (double)y2 - (double)this.height * 0.5, this.ystep, ctxt.ray_sl);
            for (int x2 = 0; x2 <= this.width - 1; x2 += xskip) {
                int idx = yoffset + x2;
                double zm = zimage[idx];
                if (zm >= zmax) {
                    img[idx] = 2047;
                    continue;
                }
                this.scaleAdd(ctxt.ray_sl, (double)x2 - (double)this.width * 0.5, this.xstep, ctxt.ray_cur);
                double nrm_ray_cur = JnVector3d.length(ctxt.ray_cur);
                System.arraycopy(ctxt.ray_cur, 0, ctxt.hit_point, 0, 3);
                JnVector3d.scale(ctxt.hit_point, zm / nrm_ray_cur);
                double zmprod = 4.0 * zm;
                int iz = (int)zmprod;
                double dz = zmprod - (double)iz;
                JnVector3d.add(ctxt.ray_cur, this.lookpt, ctxt.hit_point);
                double val = this.value_at_nothresh_sh(ctxt.hit_point, ctxt.ray_cur, pxyz, ctxt.samples);
                img[idx] = (short)((0.2 + 0.799 * val) * ((1.0 - dz) * this.zhist[iz] + dz * this.zhist[iz + 1]));
                short s2 = img[idx];
                histo[s2] = histo[s2] + 1L;
            }
        }
    }

    private void CLEARSAMPLES(short[] samples) {
        Arrays.fill(samples, (short)0);
    }

    private void LOADROW(short[] samples, int sidx, short[] dens, int idx) {
        System.arraycopy(dens, idx, samples, sidx, 4);
    }

    private void LOADPLANE(short[] samples, int sidx, short[] dens, int idx, int lsize) {
        this.LOADROW(samples, sidx, dens, idx);
        this.LOADROW(samples, sidx + 4, dens, idx += lsize);
        this.LOADROW(samples, sidx + 8, dens, idx += lsize);
        this.LOADROW(samples, sidx + 12, dens, idx += lsize);
    }

    private boolean sample_values_nothresh(int x2, int y2, int z2, int[] pxyz, short[] samples) {
        int xy;
        int tpxyz;
        short[] dens_list = this.jvolume.volume;
        int dx = this.jvolume.dx;
        int dy = this.jvolume.dy;
        int pgsize = dx * dy;
        if (pxyz[0] == (tpxyz = --z2 * pgsize + (xy = --x2 + --y2 * dx))) {
            return false;
        }
        pxyz[0] = tpxyz;
        if (x2 < 1 || y2 < 1 || z2 < 1) {
            this.CLEARSAMPLES(samples);
            return true;
        }
        int ixsize = dx - 3;
        int iysize = dy - 3;
        int icount = this.jvolume.dz - 3;
        if (x2 >= ixsize || y2 >= iysize || z2 >= icount) {
            this.CLEARSAMPLES(samples);
            return true;
        }
        int offset = this.jvolume.PAD + z2 * pgsize;
        int dens = offset + xy;
        this.LOADPLANE(samples, 0, dens_list, dens, dx);
        this.LOADPLANE(samples, 16, dens_list, dens += pgsize, dx);
        this.LOADPLANE(samples, 32, dens_list, dens += pgsize, dx);
        this.LOADPLANE(samples, 48, dens_list, dens += pgsize, dx);
        return false;
    }

    private int XYZ_SAMPLE_ADDR(int x2, int y2, int z2) {
        return x2 + 1 + 4 * (y2 + 1) + 16 * (z2 + 1);
    }

    private void VALUE2W_AT(short[] samples, int x2, int y2, int z2, double w2, double[] xyzg) {
        xyzg[0] = xyzg[0] + w2 * (double)(samples[this.XYZ_SAMPLE_ADDR(x2, y2, z2) + 1] - samples[this.XYZ_SAMPLE_ADDR(x2, y2, z2) - 1]);
        xyzg[1] = xyzg[1] + w2 * (double)(samples[this.XYZ_SAMPLE_ADDR(x2, y2, z2) + 4] - samples[this.XYZ_SAMPLE_ADDR(x2, y2, z2) - 4]);
        xyzg[2] = xyzg[2] + w2 * (double)(samples[this.XYZ_SAMPLE_ADDR(x2, y2, z2) + 16] - samples[this.XYZ_SAMPLE_ADDR(x2, y2, z2) - 16]);
    }

    private double value_at_nothresh_sh(double[] point, double[] dr, int[] pxyz, short[] samples) {
        double[] xyzg = new double[3];
        double ratio = 1.0;
        int x2 = (int)point[0];
        int y2 = (int)point[1];
        int z2 = (int)point[2];
        if (this.sample_values_nothresh(x2, y2, z2, pxyz, samples)) {
            return 0.0;
        }
        double dx = point[0] - (double)x2;
        double dy = point[1] - (double)y2;
        double dz = point[2] - (double)z2;
        xyzg[2] = 0.0;
        xyzg[1] = 0.0;
        xyzg[0] = 0.0;
        double w2 = (1.0 - dx) * (1.0 - dy) * (1.0 - dz);
        this.VALUE2W_AT(samples, 0, 0, 0, w2, xyzg);
        w2 = dx * (1.0 - dy) * (1.0 - dz);
        this.VALUE2W_AT(samples, 1, 0, 0, w2, xyzg);
        w2 = (1.0 - dx) * dy * (1.0 - dz);
        this.VALUE2W_AT(samples, 0, 1, 0, w2, xyzg);
        w2 = dx * dy * (1.0 - dz);
        this.VALUE2W_AT(samples, 1, 1, 0, w2, xyzg);
        w2 = (1.0 - dx) * (1.0 - dy) * dz;
        this.VALUE2W_AT(samples, 0, 0, 1, w2, xyzg);
        w2 = dx * (1.0 - dy) * dz;
        this.VALUE2W_AT(samples, 1, 0, 1, w2, xyzg);
        w2 = (1.0 - dx) * dy * dz;
        this.VALUE2W_AT(samples, 0, 1, 1, w2, xyzg);
        w2 = dx * dy * dz;
        this.VALUE2W_AT(samples, 1, 1, 1, w2, xyzg);
        xyzg[2] = xyzg[2] / ratio;
        double nrm = JnVector3d.dot(xyzg, xyzg);
        if (nrm < 0.1) {
            return 0.1;
        }
        double r2 = dr[2] * ratio;
        return Math.abs(dr[0] * xyzg[0] + dr[1] * xyzg[1] + r2 * xyzg[2]) / Math.sqrt(nrm * (dr[0] * dr[0] + dr[1] * dr[1] + r2 * r2));
    }

    private int adjust_histo_mean(short[] img, long[] histo, boolean[] lines, int mmin, int mmax) {
        int i2;
        double percent = 0.05;
        int[] adjust = new int[4096];
        long npixel = 0;
        for (i2 = 0; i2 < 4096; ++i2) {
            npixel += histo[i2];
        }
        if (npixel == 0L) {
            return -1;
        }
        int stop = (int)(0.05 * (double)npixel);
        int hmin = 0;
        int cumul = 0;
        while (cumul < stop) {
            cumul = (int)((long)cumul + histo[hmin]);
            ++hmin;
        }
        int hmax = 4095;
        cumul = 0;
        while (cumul < stop) {
            cumul = (int)((long)cumul + histo[hmax]);
            --hmax;
        }
        if (hmin >= hmax) {
            return -1;
        }
        double a2 = (float)(mmax - mmin) / (float)(hmax - hmin);
        double b2 = (double)mmax - (double)hmax * a2;
        for (i2 = 0; i2 < 4096; ++i2) {
            int tmp = (int)(a2 * (double)i2 + b2);
            adjust[i2] = tmp < 0 ? 0 : (tmp >= 4096 ? 4095 : tmp);
        }
        for (int y2 = 0; y2 < this.height; ++y2) {
            int ystart;
            if (!lines[y2]) continue;
            for (i2 = ystart = y2 * this.width; i2 < ystart + this.width; ++i2) {
                img[i2] = (short)adjust[img[i2]];
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        double ZOOM = 0.35;
        if (args.length == 0) {
            System.err.println("segend <volume dirname> <window dim>");
        }
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
        JVolume.LinearShort jv = new JVolume.LinearShort(vol);
        int DIM = args.length > 1 ? Integer.parseInt(args[1]) : 512;
        XpImageViewport iv = new XpImageViewport();
        iv.setPreferredSize(new Dimension(DIM, DIM));
        BufferedImage buffimg = new BufferedImage(DIM, DIM, 11);
        short[] lumdata = ((DataBufferUShort)buffimg.getRaster().getDataBuffer()).getData();
        XpBufferedImage medimg = new XpBufferedImage(buffimg, 1024.0, 1.0);
        iv.setImages(new XpMedicalImage[]{medimg});
        iv.setWindowing(5000.0, 1500.0);
        boolean[] lines = new boolean[DIM];
        XpPointMarker pm = new XpPointMarker((double)DIM * 0.5, (double)DIM * 0.5);
        pm.addPropertyChangeListener("VALUE_PROP", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                XpPointMarker pm = (XpPointMarker)evt.getSource();
                System.err.println("Value: " + evt.getNewValue() + " : " + pm.getImagePoint());
            }
        });
        iv.getMedicalImageVc().getImageVc().add(pm);
        JFrame jf = new JFrame("SEGEND");
        jf.setContentPane(iv);
        jf.pack();
        jf.setLocation(250, 0);
        jf.setDefaultCloseOperation(3);
        jf.setVisible(true);
        int ncpus = ParallelTaskManager.getNumCPU();
        System.out.println("--- NCPUS = " + ncpus);
        segend renderer = new segend();
        renderer.setSession(jv);
        double[] lookpt = new double[]{(double)jv.dx * 0.5, (double)jv.dy * 0.5, (double)jv.dz * 0.5};
        double[] xstep = new double[]{(double)jv.dx * 0.35 / (double)DIM, 0.0, 0.0};
        double[] ystep = new double[]{0.0, 0.0, (double)jv.dz * 0.35 / (double)DIM};
        double[] zstep = new double[]{0.0, 0.99, 0.0};
        renderer.setView(lookpt, xstep, ystep, zstep, DIM, DIM);
        RenderCtxt rctxt = new RenderCtxt();
        for (int i2 = 0; i2 < 2; ++i2) {
            long t0 = System.currentTimeMillis();
            renderer.render(0, 0, DIM - 1, DIM - 1, 1, 1, rctxt);
            long t1 = System.currentTimeMillis();
            Arrays.fill(lines, true);
            renderer.post_render(lumdata, lines);
            iv.refreshContents();
            long t2 = System.currentTimeMillis();
            long trender = t1 - t0;
            long tpost = t2 - t1;
            jf.repaint();
            System.err.println("Time = " + trender + " " + tpost);
        }
        System.err.println("----------------- END ----------------- " + totalpix);
    }

    private static class Cached_values {
        public short[] values = new short[8];
        public double fvalues;
        public int xyz;
        public boolean notempty;
        public boolean out;

        private Cached_values() {
        }
    }

    public static class RenderCtxt {
        public double[] point_sl = new double[3];
        public double[] point_cur = new double[3];
        public Cached_values[] caches = new Cached_values[256];

        public RenderCtxt() {
            for (int i2 = 0; i2 < this.caches.length; ++i2) {
                this.caches[i2] = new Cached_values();
            }
        }
    }

    public static class ZImageCtxt {
        public double[] zimage;
        public double[] zhist;
        public double zmax;
        public short[] img;
        public long[] histo = new long[4096];
        public long[] thread_histo = new long[4096];
        public double[] ray_cur = new double[3];
        public double[] ray_sl = new double[3];
        public double[] hit_point = new double[3];
        public short[] samples = new short[64];
    }
}

