/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.j3d.vr.RayTracer;
import com.ge.med.terra.jami.j3d.vr.VrCamera;
import com.ge.med.terra.jami.j3d.vr.VrColor;
import com.ge.med.terra.jami.j3d.vr.VrContext;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.vr;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JFrame;

public class vrperf {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("vr <volume dirname> <window dim>");
        }
        JnVector3d look_pt = new JnVector3d();
        JnVector3d eye_pt = new JnVector3d();
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        System.out.println("# Series: " + dmo.length);
        int series = 0;
        if (dmo.length >= 3) {
            series = 2;
        }
        DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[series]});
        JVolume.LinearShort jv = new JVolume.LinearShort(vol);
        VrContext vrc = new VrContext(jv);
        VrCamera vrcam = new VrCamera(vrc);
        int DIM = args.length > 1 ? Integer.parseInt(args[1]) : 600;
        BufferedImage rimg = new BufferedImage(DIM, DIM, 1);
        int[] output = ((DataBufferInt)rimg.getRaster().getDataBuffer()).getData();
        short[] dbuff = new short[DIM * DIM];
        try {
            InputStream is = VrPreset.class.getResourceAsStream("presets/GENERAL/vr_color.vrp");
            VrPreset preset = new VrPreset(is);
            vrc.setPreset(preset);
            vrcam.setDisplaySession(output, dbuff, DIM, DIM);
        }
        catch (IOException ex) {
            System.err.println("Cannot open preset stream.");
        }
        look_pt.set(jv.center.x, jv.center.y, jv.center.z);
        JnMatrix3d view = new JnMatrix3d();
        JnMatrix3d rotm = new JnMatrix3d();
        JFrame jf = XpImageUtils.displayImage(rimg, "VR");
        jf.setLocation(250, 0);
        jf.setDefaultCloseOperation(3);
        int ncpus = ParallelTaskManager.getNumCPU();
        System.out.println("--- NCPUS = " + ncpus);
        vr[] renderers = new vr[ncpus];
        Worker[] workers = new VRWorker[ncpus];
        ParallelTaskManager ptm = new ParallelTaskManager();
        for (int i2 = 0; i2 < ncpus; ++i2) {
            renderers[i2] = new vr();
            System.err.println("-- Using integer raytracer");
            renderers[i2].setRayTracer(new vr.RaySplitColorLut_i());
            workers[i2] = new VRWorker(ptm, i2, renderers[i2], ncpus, 1);
        }
        ptm.setWorkers(workers);
        int sum = 0;
        int TIMES = 8;
        view.rotZ(Math.toRadians(180.0));
        rotm.rotX(Math.toRadians(90.0));
        view.mul(rotm);
        Arrays.fill(output, vrcam.getBackground());
        eye_pt.set(look_pt);
        JnVector3d viewvec = new JnVector3d(view.m02, view.m12, view.m22);
        viewvec.scale(20.0);
        eye_pt.sub(viewvec);
        vrcam.setVRView(view, eye_pt.toArray(), look_pt.toArray(), jv.ras_dz, jv.ras_dz);
        for (int i3 = 0; i3 < ncpus; ++i3) {
            RayTracer rt = renderers[i3].getRayTracer();
            rt.setVrSession(vrcam);
        }
        long t2 = ptm.launch(vrcam);
        jf.repaint();
        System.err.println("-- vr perf: Will iterate 8 times.");
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        for (int i4 = 0; i4 < 8; ++i4) {
            System.out.println("Render: " + i4);
            t2 = ptm.launch(vrcam);
            jf.repaint();
            sum = (int)((long)sum + t2);
        }
        double avg_time = (double)sum / 8.0;
        System.out.println("-- VR Avg time: " + avg_time);
        System.out.println("----------------- END -----------------");
    }

    private static class VRWorker
    extends Worker {
        private vr renderer = null;
        private VrColor color = new VrColor();
        private int xskip;
        private int yskip;

        public VRWorker(ParallelTaskManager ptm, int workerId, vr renderer, int xskip, int yskip) {
            super(ptm, workerId);
            this.renderer = renderer;
            this.xskip = xskip;
            this.yskip = yskip;
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            VrCamera vc = (VrCamera)data;
            long t0 = System.currentTimeMillis();
            int nrays = this.renderer.render_vr(workerId, 0, this.xskip, this.yskip, vc, this.color);
            long t1 = System.currentTimeMillis();
            double avgPerRay = 0.0;
            if (nrays > 0) {
                avgPerRay = (double)(t1 - t0) / (double)nrays;
            }
            System.out.println("Time per ray=" + avgPerRay + " " + nrays);
        }
    }
}

