/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public abstract class DmImageCreator {
    private final Date creationDate = Calendar.getInstance().getTime();
    static String filePath = "dicomDict.txt";
    private XjTagValue[] tagsToFill = null;
    private XjTagValue[] userTags = null;
    private XjDicomObject seed = null;

    public DmImageCreator(XjDicomObject seed, XjTagValue[] tags) {
        this.seed = seed;
        this.tagsToFill = DmImageCreator.buildTags();
        seed.getValues(this.getTags());
        this.userTags = tags;
    }

    protected XjDicomObject getSeed() {
        return this.seed;
    }

    protected XjTagValue[] getTags() {
        return this.tagsToFill;
    }

    protected XjTagValue[] getOverrides() {
        return this.userTags;
    }

    protected Date getCreationDate() {
        return this.creationDate;
    }

    protected static boolean includeTag(int group, int element) {
        if (group == 32736) {
            return false;
        }
        return group != 83 || element != 4245 && element != 4246 && element != 4247 && element != 4250;
    }

    protected static XjTagValue[] buildTags() {
        XjTagValue[] tags = new XjTagValue[]{};
        try {
            String tagFilePath = System.getenv("TERRA_HOME");
            String externalFile = tagFilePath + File.separator + filePath;
            BufferedReader in = null;
            in = new File(externalFile).exists() ? new BufferedReader(new InputStreamReader(new FileInputStream(externalFile))) : new BufferedReader(new InputStreamReader(DicomComposite.class.getResourceAsStream("dicomDict.txt")));
            ArrayList<XjTagValue> l2 = new ArrayList<XjTagValue>();
            while (in.ready()) {
                int element;
                String str = in.readLine();
                StringTokenizer tok = new StringTokenizer(str, ";");
                String sgroup = tok.nextToken().toLowerCase().trim();
                String selement = tok.nextToken().toLowerCase().trim();
                boolean group16 = sgroup.startsWith("0x");
                boolean element16 = selement.startsWith("0x");
                int group = Integer.parseInt(sgroup.substring(group16 ? 2 : 0), group16 ? 16 : 10);
                if (!DmImageCreator.includeTag(group, element = Integer.parseInt(selement.substring(element16 ? 2 : 0), element16 ? 16 : 10))) continue;
                XjTagValue tv = new XjTagValue(group, element);
                l2.add(tv);
            }
            tags = l2.toArray(tags);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return tags;
    }

    protected void setValues(DicomComposite dcmComp, XjTagValue[] tvs) {
        for (XjTagValue tv : tvs) {
            this.setValue(dcmComp, tv);
        }
    }

    protected void setValue(DicomComposite dcmComp, XjTagValue tv) {
        if (null == tv.value) {
            dcmComp.removeTag(tv.group, tv.element);
        } else {
            Object value = tv.value;
            if (tv.vr == 21331 && tv.value instanceof Number || tv.group == 40 && tv.element == 288) {
                value = new Short(tv.value.toString());
            }
            try {
                dcmComp.setValue(tv.group, tv.element, value);
            }
            catch (DMException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected static int getSeriesNo(XjDicomObject refImage) {
        return DmImageCreator.getSeriesNo((String)refImage.getValue(32, 17));
    }

    protected static int getSeriesNo(String seriesNo) {
        int mfSeriesNo = Integer.parseInt(seriesNo) + 200000;
        return mfSeriesNo;
    }
}

