/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.CPICapable;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.GSPSComposite;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class XpDMgsps {
    private static final char MULTI_DELIM_CHAR = '\\';
    private static final String MULTI_DELIM = new String(new char[]{'\\', '\\'});
    private static boolean debug = XpPropertiesManager.getProperty("jami.gsps.debug") != null;
    private static dicomParser theDP = new dicomParser();
    private static XpDicomElement seriesNo = new XpDicomElement(32, 17);
    private static XpDicomElement imageNo = new XpDicomElement(32, 19);
    private static XpDicomElement sopCUID = new XpDicomElement(8, 22);
    private static XpDicomElement sopUID = new XpDicomElement(8, 24);
    private static XpDicomElement seriesInstUID = new XpDicomElement(32, 14);
    private XpDicomElement ppsInfo = new XpDicomElement(8, 4369);
    private GSPSComposite dmc = null;

    public XpDMgsps(XpViewport xv) {
        XpMedicalImage[] imgs = xv.getImages();
        XpCPI cpi = ((CPICapable)((Object)xv)).getCPI();
        this.init(imgs, cpi, null);
    }

    public XpDMgsps(XpMedicalImage[] imgs, XpCPI cpi, DMObject refObject) {
        this.init(imgs, cpi, refObject);
    }

    public XpDMgsps(XpViewport xv, DMObject refObject) {
        XpMedicalImage[] imgs = xv.getImages();
        XpCPI cpi = ((CPICapable)((Object)xv)).getCPI();
        this.init(imgs, cpi, refObject);
    }

    private void init(XpMedicalImage[] imgs, XpCPI cpi, DMObject refObject) {
        this.dmc = new GSPSComposite();
        if (null == refObject) {
            GSPSDicomObject ref = new GSPSDicomObject(imgs[0]);
            this.dmc.fill(ref);
        } else {
            this.dmc.fill(refObject);
        }
        this.fillPresentationState(imgs, cpi, refObject);
    }

    public static void setDebug(boolean db) {
        debug = db;
    }

    private void setValue(int group, int element, Object value) {
        this.dmc.setValue(group, element, value);
    }

    private void setValue(int group, int element, int i2, DicomData value) {
        this.dmc.setValue(group, element, i2, value);
    }

    private void setDateValue(int group, int element, Date date) {
        this.dmc.setDateValue(group, element, date);
    }

    private void setTimeValue(int group, int element, Date time) {
        this.dmc.setTimeValue(group, element, time);
    }

    public InputStream getGSPS() {
        InputStream is = this.dmc.getInputStream(false, DicomComposite.TS_ELE);
        return is;
    }

    public InputStream getGSPS(XpDicomElement[] overrides) {
        for (int i2 = 0; i2 < overrides.length; ++i2) {
            Object obj = this.dmc.getValue(overrides[i2].group, overrides[i2].element);
            if (obj == null) continue;
            this.setValue(overrides[i2].group, overrides[i2].element, overrides[i2].value);
        }
        return this.getGSPS();
    }

    private static tagValue getTagValue(tagValue[] tvs, int group, int element) {
        for (int i2 = 0; i2 < tvs.length; ++i2) {
            if (tvs[i2].group != group || tvs[i2].element != element) continue;
            return tvs[i2];
        }
        return null;
    }

    private static String[] getStringVals(String str) {
        ArrayList<String> l2 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, "\\");
        while (st.hasMoreTokens()) {
            String stVal = st.nextToken();
            l2.add(stVal);
        }
        int len = l2.size();
        if (len > 0) {
            String[] vals = new String[len];
            for (int i2 = 0; i2 < len; ++i2) {
                String stVal;
                vals[i2] = stVal = (String)l2.get(i2);
            }
            return vals;
        }
        return null;
    }

    public static String[] getSOPInstanceUids(InputStream is) {
        return null;
    }

    public static XpCPI getCPI(InputStream is) {
        tagValue tag2;
        XpCPI cpi = new XpCPI();
        if (debug) {
            XpLog.logger().info("-----------------PARSING GSPS object------------------");
        }
        try {
            theDP.clearFile();
            theDP.setFile(is);
        }
        catch (FileNotFoundException ex) {
            System.err.println("ERROR OPENING FILE...");
            return null;
        }
        int NTAGS = 17;
        Object[] tvs = new tagValue[NTAGS];
        tvs[0] = new tagValue(24, 5632);
        tvs[1] = new tagValue(24, 5634);
        tvs[2] = new tagValue(24, 5636);
        tvs[3] = new tagValue(24, 5638);
        tvs[4] = new tagValue(24, 5640);
        tvs[5] = new tagValue(24, 5648);
        tvs[6] = new tagValue(24, 5650);
        tvs[7] = new tagValue(24, 5664);
        tvs[8] = new tagValue(24, 5666);
        tvs[9] = new tagValue(40, 12560);
        tvs[10] = new tagValue(112, 1);
        tvs[11] = new tagValue(112, 65);
        tvs[12] = new tagValue(112, 66);
        tvs[13] = new tagValue(112, 90);
        tvs[14] = new tagValue(112, 96);
        tvs[15] = new tagValue(8272, 16);
        tvs[16] = new tagValue(8272, 32);
        Arrays.sort(tvs);
        theDP.fill((tagValue[])tvs);
        if (debug) {
            for (int i2 = 0; i2 < tvs.length; ++i2) {
                XpLog.logger().info("tagValue[" + i2 + "]=" + ((tagValue)tvs[i2]).value);
            }
        }
        tagValue tv = null;
        List<XpCPI.DisplayedArea> daList = cpi.getDisplayedArea();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 90);
        Object[] values = null;
        if (tv != null) {
            values = (Object[])tv.value;
        }
        if (values != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** DISPLAYED AREA MODULE ** [" + values.length + "]");
            }
            for (int i3 = 0; i3 < values.length; ++i3) {
                Object[] tags = (Object[])values[i3];
                XpCPI.DisplayedArea da = new XpCPI.DisplayedArea();
                daList.add(da);
                for (int j2 = 0; j2 < tags.length; ++j2) {
                    double zoom;
                    double y2;
                    tagValue tag3 = (tagValue)tags[j2];
                    if (tag3.group == 8 && tag3.element == 4416) {
                        Object[] rimgs = (Object[])tag3.value;
                        for (int k2 = 0; k2 < rimgs.length; ++k2) {
                            Object[] rimgVals = (Object[])rimgs[k2];
                            XpCPI.GSPSFrame frame = new XpCPI.GSPSFrame();
                            for (int a2 = 0; a2 < rimgVals.length; ++a2) {
                                tagValue tagVal = (tagValue)rimgVals[a2];
                                if (tagVal.group == 8 && tagVal.element == 4432) {
                                    frame.SOPClassUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 8 && tagVal.element == 4437) {
                                    frame.SOPInstanceUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group != 8 || tagVal.element != 4448) continue;
                                frame.ReferencedFrameNum = XpDMgsps.parseReferencedFrameNum(tagVal.value);
                            }
                            da.refImgSequence.add(frame);
                        }
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 82) {
                        Integer[] tlhc = (Integer[])tag3.value;
                        double x2 = tlhc[0].intValue();
                        y2 = tlhc[1].intValue();
                        da.tlDisplay.setLocation(x2, y2);
                        if (!debug) continue;
                        XpLog.logger().info("READ GSPS: " + i3 + " TLHC=" + da.tlDisplay);
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 83) {
                        Integer[] brhc = (Integer[])tag3.value;
                        double x3 = brhc[0].intValue();
                        y2 = brhc[1].intValue();
                        da.brDisplay.setLocation(x3, y2);
                        if (!debug) continue;
                        XpLog.logger().info("READ GSPS: " + i3 + " BRHC=" + da.brDisplay);
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 256) {
                        da.presSize = "" + tag3.value;
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 257) {
                        String[] pps = XpDMgsps.getStringVals("" + tag3.value);
                        double x4 = new Double(pps[0]);
                        y2 = new Double(pps[1]);
                        da.presPixelSpacing.setLocation(x4, y2);
                        continue;
                    }
                    if (tag3.group == 112 && tag3.element == 258) {
                        String[] ppa = XpDMgsps.getStringVals("" + tag3.value);
                        double x5 = new Double(ppa[0]);
                        y2 = new Double(ppa[1]);
                        da.presPixelAspectRatio.setLocation(x5, y2);
                        continue;
                    }
                    if (tag3.group != 112 || tag3.element != 259) continue;
                    da.pixelMagnificationRatio = zoom = new Double("" + tag3.value).doubleValue();
                    if (!debug) continue;
                    XpLog.logger().info("READ GSPS: ** " + i3 + " zoom=" + zoom);
                }
                if (!debug) continue;
                XpLog.logger().info("----------");
            }
            if (debug) {
                XpLog.logger().info("---------------------------------------------");
            }
        }
        List<XpCPI.GraphicAnnotation> gaList = cpi.getGraphicAnnotation();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 1);
        values = null;
        if (tv != null) {
            values = (Object[])tv.value;
        }
        if (values != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** GRAPHIC ANNOTATION MODULE **");
            }
            XpCPI.GraphicLayer roiLayer = new XpCPI.GraphicLayer("ROI layer");
            for (int i4 = 0; i4 < values.length; ++i4) {
                Object[] tags = (Object[])values[i4];
                XpCPI.GraphicAnnotation ga = new XpCPI.GraphicAnnotation(roiLayer);
                gaList.add(ga);
                for (int j3 = 0; j3 < tags.length; ++j3) {
                    int k3;
                    tagValue tag4 = (tagValue)tags[j3];
                    if (tag4.group == 8 && tag4.element == 4416) {
                        Object[] rimgs = (Object[])tag4.value;
                        for (k3 = 0; k3 < rimgs.length; ++k3) {
                            Object[] rimgVals = (Object[])rimgs[k3];
                            XpCPI.GSPSFrame frame = new XpCPI.GSPSFrame();
                            for (int a3 = 0; a3 < rimgVals.length; ++a3) {
                                tagValue tagVal = (tagValue)rimgVals[a3];
                                if (tagVal.group == 8 && tagVal.element == 4432) {
                                    frame.SOPClassUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 8 && tagVal.element == 4437) {
                                    frame.SOPInstanceUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group != 8 || tagVal.element != 4448) continue;
                                frame.ReferencedFrameNum = XpDMgsps.parseReferencedFrameNum(tagVal.value);
                            }
                            ga.refImgSequence.add(frame);
                        }
                        continue;
                    }
                    if (tag4.group == 112 && tag4.element == 2) {
                        ga.grxLayer.layerDescription = "" + tag4.value;
                        continue;
                    }
                    if (tag4.group == 112 && tag4.element == 8) {
                        Object[] tobjs = (Object[])tag4.value;
                        for (k3 = 0; k3 < tobjs.length; ++k3) {
                            Object[] tobjVals = (Object[])tobjs[k3];
                            XpCPI.TextObject to = new XpCPI.TextObject();
                            ga.textSequence.add(to);
                            boolean tlbb = false;
                            boolean brbb = false;
                            double tlbbX = 0.0;
                            double tlbbY = 0.0;
                            double brbbX = 0.0;
                            double brbbY = 0.0;
                            for (int a4 = 0; a4 < tobjVals.length; ++a4) {
                                Float[] vals;
                                String units;
                                tagValue tagVal = (tagValue)tobjVals[a4];
                                if (tagVal.group == 112 && tagVal.element == 3) {
                                    units = "" + tagVal.value;
                                    if (units.equals("PIXEL")) {
                                        to.bboxUnits = 0;
                                        continue;
                                    }
                                    if (!units.equals("DISPLAY")) continue;
                                    to.bboxUnits = (byte)3;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 4) {
                                    units = "" + tagVal.value;
                                    if (units.equals("PIXEL")) {
                                        to.anchorUnits = 0;
                                        continue;
                                    }
                                    if (!units.equals("DISPLAY")) continue;
                                    to.anchorUnits = (byte)3;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 6) {
                                    to.textValue = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 16) {
                                    tlbb = true;
                                    vals = (Float[])tagVal.value;
                                    tlbbX = vals[0].floatValue();
                                    tlbbY = vals[1].floatValue();
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 17) {
                                    brbb = true;
                                    vals = (Float[])tagVal.value;
                                    brbbX = vals[0].floatValue();
                                    brbbY = vals[1].floatValue();
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 18) {
                                    to.bboxJustification = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 112 && tagVal.element == 20) {
                                    vals = (Float[])tagVal.value;
                                    to.anchorPoint.setLocation(vals[0].floatValue(), vals[1].floatValue());
                                    continue;
                                }
                                if (tagVal.group != 112 || tagVal.element != 21) continue;
                                String stVal = "" + tagVal.value;
                                to.anchorVisibility = stVal.equals("Y");
                                if (!debug) continue;
                                XpLog.logger().info("GSPS: Anchor Visibility -- " + to.anchorVisibility + " [" + stVal + "]");
                            }
                            if (!tlbb || !brbb) continue;
                            double w2 = Math.abs(brbbX - tlbbX);
                            double h2 = Math.abs(brbbY - tlbbY);
                            to.boundingBox.setRect(tlbbX, tlbbY, w2, h2);
                        }
                        continue;
                    }
                    if (tag4.group != 112 || tag4.element != 9) continue;
                    Object[] gobjs = (Object[])tag4.value;
                    for (k3 = 0; k3 < gobjs.length; ++k3) {
                        Object[] gobjVals = (Object[])gobjs[k3];
                        XpCPI.GraphicObject go = new XpCPI.GraphicObject();
                        ga.graphicSequence.add(go);
                        int nPts = -1;
                        for (int a5 = 0; a5 < gobjVals.length; ++a5) {
                            tagValue tagVal = (tagValue)gobjVals[a5];
                            if (tagVal.group == 112 && tagVal.element == 5) {
                                String units = "" + tagVal.value;
                                if (units.equals("PIXEL")) {
                                    go.graphicUnits = 0;
                                    continue;
                                }
                                if (!units.equals("DISPLAY")) continue;
                                go.graphicUnits = 1;
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 32) {
                                go.graphicDim = new Integer("" + tagVal.value);
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 33) {
                                nPts = new Integer("" + tagVal.value);
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 34) {
                                Float[] vals = (Float[])tagVal.value;
                                int nPoints = vals.length / 2;
                                for (int b2 = 0; b2 < nPoints; ++b2) {
                                    Point2D.Double p2 = new Point2D.Double(vals[2 * b2].floatValue(), vals[2 * b2 + 1].floatValue());
                                    go.graphicData.add(p2);
                                }
                                continue;
                            }
                            if (tagVal.group == 112 && tagVal.element == 35) {
                                go.graphicType = "" + tagVal.value;
                                continue;
                            }
                            if (tagVal.group != 112 || tagVal.element != 36) continue;
                            String stVal = "" + tagVal.value;
                            go.filled = stVal.equals("Y");
                        }
                    }
                }
            }
            if (debug) {
                XpLog.logger().info("---------------------------------------------");
            }
        }
        XpCPI.SpatialTransformation st = cpi.getSpatialTransformation();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 65);
        if (tv != null && tv.value != null) {
            String flip = "" + tv.value;
            st.flipHorizontal = flip.toUpperCase().equals("Y");
            if (debug) {
                XpLog.logger().info("READ GSPS: Flip    : " + flip);
            }
        }
        if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 112, 66)) != null && tv.value != null) {
            String rot = "" + tv.value;
            if (debug) {
                XpLog.logger().info("READ GSPS: Rotation: " + rot);
            }
            int angle = Integer.parseInt(rot);
            st.angle = angle;
            st.angle = Math.toRadians(st.angle);
        }
        List<XpCPI.SoftcopyVoiLut> softList = cpi.getSoftcopyVoiLut();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 40, 12560);
        values = null;
        if (tv != null) {
            values = (Object[])tv.value;
        }
        if (values != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** SOFTCOPY VOI LUT MODULE **");
            }
            for (int i5 = 0; i5 < values.length; ++i5) {
                Object[] tags = (Object[])values[i5];
                XpCPI.SoftcopyVoiLut svl = new XpCPI.SoftcopyVoiLut();
                softList.add(svl);
                for (int j4 = 0; j4 < tags.length; ++j4) {
                    tag2 = (tagValue)tags[j4];
                    if (tag2.group == 8 && tag2.element == 4416) {
                        Object[] rimgs = (Object[])tag2.value;
                        for (int k4 = 0; k4 < rimgs.length; ++k4) {
                            Object[] rimgVals = (Object[])rimgs[k4];
                            XpCPI.GSPSFrame frame = new XpCPI.GSPSFrame();
                            for (int a6 = 0; a6 < rimgVals.length; ++a6) {
                                tagValue tagVal = (tagValue)rimgVals[a6];
                                if (tagVal.group == 8 && tagVal.element == 4432) {
                                    frame.SOPClassUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group == 8 && tagVal.element == 4437) {
                                    frame.SOPInstanceUID = "" + tagVal.value;
                                    continue;
                                }
                                if (tagVal.group != 8 || tagVal.element != 4448) continue;
                                frame.ReferencedFrameNum = XpDMgsps.parseReferencedFrameNum(tagVal.value);
                            }
                            svl.refImgSequence.add(frame);
                        }
                        continue;
                    }
                    if (tag2.group == 40 && tag2.element == 12304) continue;
                    if (tag2.group == 40 && tag2.element == 4176) {
                        svl.windowCenter = new Double("" + tag2.value);
                        svl.wwwlSpecified = true;
                        if (!debug) continue;
                        XpLog.logger().info("*** " + i5 + " wl=" + svl.windowCenter);
                        continue;
                    }
                    if (tag2.group == 40 && tag2.element == 4177) {
                        svl.windowWidth = new Double("" + tag2.value);
                        svl.wwwlSpecified = true;
                        if (!debug) continue;
                        XpLog.logger().info("*** " + i5 + " ww=" + svl.windowWidth);
                        continue;
                    }
                    if (tag2.group != 40 || tag2.element != 4181) continue;
                    svl.wwwlExplanation = "" + tag2.value;
                }
            }
            if (debug) {
                XpLog.logger().info("---------------------------------------------");
            }
        }
        XpCPI.SoftcopyPresentationLut spl = cpi.getSoftcopyPresentationLut();
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 8272, 16);
        if (tv != null && (values = (Object[])tv.value) != null) {
            if (debug) {
                XpLog.logger().info("READ GSPS: ** SOFTCOPY PRESENTATION MODULE **");
            }
            for (int i6 = 0; i6 < values.length; ++i6) {
                Object[] tags = (Object[])values[i6];
                for (int j5 = 0; j5 < tags.length; ++j5) {
                    Integer[] vals;
                    tag2 = (tagValue)tags[j5];
                    if (tag2.group == 40 && tag2.element == 12290) {
                        vals = (Integer[])tag2.value;
                        spl.lutDescriptor = vals;
                        continue;
                    }
                    if (tag2.group == 40 && tag2.element == 12291) {
                        spl.lutExplanation = "" + tag2.value;
                        continue;
                    }
                    if (tag2.group != 40 || tag2.element != 12294) continue;
                    vals = (Integer[])tag2.value;
                    spl.lutData = vals;
                }
            }
        }
        if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 8272, 32)) != null && tv.value != null) {
            String pLutShape = "" + tv.value;
            if (debug) {
                XpLog.logger().info("READ GSPS: pLutShape - " + pLutShape);
            }
            spl.pLutShape = pLutShape;
        }
        tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5632);
        XpCPI.DisplayShutter ds = null;
        if (tv != null && tv.value != null) {
            ds = new XpCPI.DisplayShutter();
            cpi.setDisplayShutter(ds, 0);
            ds.shutterShape = "" + tv.value;
            if (ds.shutterShape.equals("RECTANGULAR")) {
                double ulX = 0.0;
                double ulY = 0.0;
                double brX = 0.0;
                double brY = 0.0;
                tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5634);
                if (tv != null && tv.value != null) {
                    ulX = new Double("" + tv.value);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5636)) != null && tv.value != null) {
                    brX = new Double("" + tv.value);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5638)) != null && tv.value != null) {
                    ulY = new Double("" + tv.value);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5640)) != null && tv.value != null) {
                    brY = new Double("" + tv.value);
                }
                ds.rectULPoint.setLocation(ulX, ulY);
                ds.rectBRPoint.setLocation(brX, brY);
            } else if (ds.shutterShape.equals("CIRCULAR")) {
                tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5648);
                if (tv != null && tv.value != null) {
                    String[] ivals = XpDMgsps.getStringVals("" + tv.value);
                    double x6 = new Double(ivals[0]);
                    double y3 = new Double(ivals[1]);
                    ds.circularCenter.setLocation(x6, y3);
                }
                if ((tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5650)) != null && tv.value != null) {
                    ds.circularRadius = new Double("" + tv.value);
                }
            } else if (ds.shutterShape.equals("POLYGONAL")) {
                tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5664);
                ds.polygonalVertices = new ArrayList<Point2D>();
                if (tv != null && tv.value != null) {
                    String[] ivals = XpDMgsps.getStringVals("" + tv.value);
                    for (int i7 = 0; i7 < ivals.length; i7 += 2) {
                        double y4 = new Double(ivals[i7]);
                        double x7 = new Double(ivals[i7 + 1]);
                        Point2D.Double p3 = new Point2D.Double(x7, y4);
                        ds.polygonalVertices.add(p3);
                    }
                }
            }
            tv = XpDMgsps.getTagValue((tagValue[])tvs, 24, 5666);
            if (tv != null && tv.value != null) {
                ds.shutterPValue = new Integer("" + tv.value);
            }
        }
        theDP.clearFile();
        return cpi;
    }

    private static String[] dicomPtIS(Point2D p2) {
        int x2 = (int)p2.getX();
        int y2 = (int)p2.getY();
        return new String[]{"" + x2, "" + y2};
    }

    private static String[] dicomPtDS(Point2D p2) {
        return new String[]{"" + p2.getX(), "" + p2.getY()};
    }

    private static Float[] dicomPtJF(Point2D p2) {
        return new Float[]{new Float((float)p2.getX()), new Float((float)p2.getY())};
    }

    private static Long[] dicomPtJL(Point2D p2) {
        return new Long[]{new Long((long)p2.getX()), new Long((long)p2.getY())};
    }

    private static void fillRefImageSequence(DicomData dd, Collection<XpCPI.GSPSFrame> l2) {
        int index = 0;
        for (XpCPI.GSPSFrame frame : l2) {
            DicomData imgItem = new DicomData();
            imgItem.setValue(8, 4432, frame.SOPClassUID);
            imgItem.setValue(8, 4437, frame.SOPInstanceUID);
            if (frame.ReferencedFrameNum.size() > 0) {
                String frameStr = null;
                Iterator<Integer> itr = frame.ReferencedFrameNum.iterator();
                while (itr.hasNext()) {
                    String thisNum = Integer.toString(itr.next());
                    frameStr = null == frameStr ? thisNum : frameStr + '\\' + thisNum;
                }
                imgItem.setValue(8, 4448, frameStr);
            }
            dd.setValue(8, 4416, index, imgItem);
            ++index;
        }
    }

    private static String getGrxUnits(byte csystem) {
        if (csystem == 3) {
            return "DISPLAY";
        }
        return "PIXEL";
    }

    private void fillPresentationState(XpMedicalImage[] imgs, XpCPI cpi, DMObject refObject) {
        double degangle;
        XpCPI.GraphicAnnotation ga;
        int res;
        if (cpi == null) {
            return;
        }
        Point2D.Double temp = new Point2D.Double();
        XpMedicalImage src = imgs[0];
        this.fillRelationshipModule(imgs);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int cnt = 0;
        for (int k2 = 0; k2 < imgs.length && (res = imgs[k2].getValue(imageNo)) == 0; ++k2) {
            ++cnt;
            int val = 0;
            String intStr = ("" + XpDMgsps.imageNo.value).trim();
            if (intStr.length() > 0) {
                val = Integer.parseInt(intStr);
            }
            if (val < min) {
                min = val;
            }
            if (val <= max) continue;
            max = val;
        }
        String psDescription = "";
        if (src.getValue(seriesNo) == 0) {
            psDescription = psDescription + "SE " + XpDMgsps.seriesNo.value + " ";
        }
        if (cnt == imgs.length) {
            psDescription = psDescription + "IM " + min + " TO " + max;
        }
        this.setValue(112, 129, psDescription);
        boolean disablePPS = false;
        int res2 = src.getValue(this.ppsInfo);
        if (res2 == 0) {
            Object value = this.ppsInfo.value;
            if (value != null && value instanceof DMiSequence) {
                DMiSequence rscs = (DMiSequence)this.ppsInfo.value;
                DMiSeqItem item = rscs.getItem(0);
                String str = (String)item.getValue(new DMTag(8, 4437));
                if (str == null || str.length() == 0) {
                    disablePPS = true;
                }
            } else {
                disablePPS = true;
            }
        }
        if (debug) {
            XpLog.logger().info("** disablePPS = " + disablePPS);
        }
        if (!disablePPS) {
            String newSeriesUID = (String)this.dmc.getValue(32, 14);
            DicomData seqObj = new DicomData();
            seqObj.setValue(8, 4432, "1.2.840.10008.3.1.2.3.3");
            if (debug) {
                XpLog.logger().info("XpDMgsps: Setting ppsUID to ====" + newSeriesUID);
            }
            seqObj.setValue(8, 4437, newSeriesUID);
            this.setValue(8, 4369, seqObj);
            Number seriesNumber = (Number)this.dmc.getValue(32, 17);
            String ppsID = seriesNumber == null ? "" : "" + seriesNumber;
            this.setValue(64, 595, ppsID);
            this.setValue(64, 597, "");
            Date ppsDate = new Date();
            this.setDateValue(64, 580, ppsDate);
            this.setTimeValue(64, 581, ppsDate);
        }
        List<XpCPI.DisplayedArea> daList = cpi.getDisplayedArea();
        for (int i2 = 0; i2 < daList.size(); ++i2) {
            XpCPI.DisplayedArea da = daList.get(i2);
            List l2 = da.refImgSequence;
            DicomData daItem = new DicomData();
            XpDMgsps.fillRefImageSequence(daItem, l2);
            if (debug) {
                XpLog.logger().info("WRITE GSPS: tl=" + da.tlDisplay + "   br=" + da.brDisplay);
            }
            daItem.setValue(112, 82, da.getGSPSTopLeft());
            daItem.setValue(112, 83, da.getGSPSBottomRight());
            daItem.setValue(112, 256, da.presSize);
            if (da.presPixelSpacing.getX() != 0.0 && da.presPixelSpacing.getY() != 0.0) {
                daItem.setValue(112, 257, XpDMgsps.dicomPtDS(da.presPixelSpacing));
            } else if (da.presPixelAspectRatio.getX() != 0.0 || da.presPixelAspectRatio.getY() != 0.0) {
                daItem.setValue(112, 258, XpDMgsps.dicomPtIS(da.presPixelAspectRatio));
            } else {
                XpLog.logger().warning("invalid pixel aspect ratio and spacing");
            }
            daItem.setValue(112, 259, new Float(da.pixelMagnificationRatio));
            this.setValue(112, 90, i2, daItem);
        }
        List<XpCPI.GraphicAnnotation> gaList = cpi.getGraphicAnnotation();
        for (int i3 = 0; i3 < gaList.size(); ++i3) {
            ga = gaList.get(i3);
            List l3 = ga.refImgSequence;
            DicomData gaItem = new DicomData();
            XpDMgsps.fillRefImageSequence(gaItem, l3);
            gaItem.setValue(112, 2, ga.grxLayer.layerDescription);
            List<XpCPI.TextObject> textSeq = ga.textSequence;
            for (int j2 = 0; j2 < textSeq.size(); ++j2) {
                String value;
                XpCPI.TextObject to = textSeq.get(j2);
                DicomData textItem = new DicomData();
                textItem.setValue(112, 3, XpDMgsps.getGrxUnits(to.bboxUnits));
                textItem.setValue(112, 4, XpDMgsps.getGrxUnits(to.anchorUnits));
                textItem.setValue(112, 6, to.textValue);
                double x2 = to.boundingBox.getX();
                double y2 = to.boundingBox.getY();
                double w2 = to.boundingBox.getWidth();
                double h2 = to.boundingBox.getHeight();
                ((Point2D)temp).setLocation(x2, y2);
                textItem.setValue(112, 16, XpDMgsps.dicomPtJF(temp));
                ((Point2D)temp).setLocation(x2 + w2, y2 + h2);
                textItem.setValue(112, 17, XpDMgsps.dicomPtJF(temp));
                textItem.setValue(112, 18, to.bboxJustification);
                textItem.setValue(112, 20, XpDMgsps.dicomPtJF(to.anchorPoint));
                String string = value = to.anchorVisibility ? "Y" : "N";
                if (debug) {
                    XpLog.logger().info("GSPS: Anchor visibility -- " + value + "  [" + to.anchorVisibility + "]");
                }
                textItem.setValue(112, 21, value);
                gaItem.setValue(112, 8, j2, textItem);
            }
            List<XpCPI.GraphicObject> goSeq = ga.graphicSequence;
            for (int j3 = 0; j3 < goSeq.size(); ++j3) {
                XpCPI.GraphicObject go = goSeq.get(j3);
                DicomData goItem = new DicomData();
                goItem.setValue(112, 5, XpDMgsps.getGrxUnits(go.graphicUnits));
                goItem.setValue(112, 32, "" + go.graphicDim);
                goItem.setValue(112, 33, "" + go.graphicData.size());
                int len = go.graphicData.size();
                Float[] fdata = new Float[2 * len];
                for (int k3 = 0; k3 < len; ++k3) {
                    Point2D p2 = go.graphicData.get(k3);
                    fdata[2 * k3] = new Float(p2.getX());
                    fdata[2 * k3 + 1] = new Float(p2.getY());
                }
                goItem.setValue(112, 34, fdata);
                goItem.setValue(112, 35, go.graphicType);
                String val = go.filled ? "Y" : "N";
                goItem.setValue(112, 36, val);
                gaItem.setValue(112, 9, j3, goItem);
            }
            this.setValue(112, 1, i3, gaItem);
        }
        int size = gaList.size();
        if (size > 0 && (ga = gaList.get(0)) != null) {
            DicomData graphicLayer = new DicomData();
            graphicLayer.setValue(112, 2, ga.grxLayer.layerDescription);
            graphicLayer.setValue(112, 98, "1");
            graphicLayer.setValue(112, 102, "65535");
            Integer[] vals = new Integer[]{new Integer(65535), new Integer(65535), new Integer(65535)};
            graphicLayer.setValue(112, 103, vals);
            graphicLayer.setValue(112, 104, "GEHC Graphic Layer Module");
            this.setValue(112, 96, 0, graphicLayer);
        }
        XpCPI.SpatialTransformation st = cpi.getSpatialTransformation();
        for (degangle = Math.toDegrees(st.angle); degangle < 0.0; degangle += 360.0) {
        }
        int div = (int)(degangle / 90.0);
        int angle = (div %= 4) * 90;
        if (angle != 0 || st.flipHorizontal) {
            this.setValue(112, 66, "" + angle);
            String val = st.flipHorizontal ? "Y" : "N";
            this.setValue(112, 65, val);
            if (debug) {
                XpLog.logger().info("WRITE GSPS: Saving angle=" + angle + "  flip=" + val);
            }
        }
        List<XpCPI.SoftcopyVoiLut> softList = cpi.getSoftcopyVoiLut();
        for (int i4 = 0; i4 < softList.size(); ++i4) {
            XpCPI.SoftcopyVoiLut sa = softList.get(i4);
            List l4 = sa.refImgSequence;
            DicomData soItem = new DicomData();
            XpDMgsps.fillRefImageSequence(soItem, l4);
            if (debug) {
                XpLog.logger().info("WRITE GSPS: ww/wl: (" + sa.windowWidth + "," + sa.windowCenter + ")");
            }
            soItem.setValue(40, 4176, "" + sa.windowCenter);
            soItem.setValue(40, 4177, "" + sa.windowWidth);
            soItem.setValue(40, 4181, "" + sa.wwwlExplanation);
            this.setValue(40, 12560, i4, soItem);
        }
        XpCPI.SoftcopyPresentationLut spl = cpi.getSoftcopyPresentationLut();
        if (spl.lutData != null) {
            DicomData plutItem = new DicomData();
            if (debug) {
                XpLog.logger().info("Saving Presentation LUT: " + spl.lutExplanation + "  [" + spl.lutData.length + "]");
            }
            plutItem.setValue(40, 12290, spl.lutDescriptor);
            plutItem.setValue(40, 12291, spl.lutExplanation);
            plutItem.setValue(40, 12294, spl.lutData);
            this.setValue(8272, 16, 0, plutItem);
        }
        this.setValue(8272, 32, spl.pLutShape);
        XpCPI.DisplayShutter ds = cpi.getDisplayShutter(0);
        if (ds == null) {
            ds = cpi.getDisplayShutter(1);
        }
        if (ds != null) {
            this.setValue(24, 5632, ds.shutterShape);
            if (ds.shutterShape.equals("RECTANGULAR")) {
                this.setValue(24, 5634, "" + (int)ds.rectULPoint.getX());
                this.setValue(24, 5636, "" + (int)ds.rectBRPoint.getX());
                this.setValue(24, 5638, "" + (int)ds.rectULPoint.getY());
                this.setValue(24, 5640, "" + (int)ds.rectBRPoint.getY());
            } else if (ds.shutterShape.equals("CIRCULAR")) {
                this.setValue(24, 5648, XpDMgsps.dicomPtIS(ds.circularCenter));
                this.setValue(24, 5650, "" + (int)ds.circularRadius);
            } else if (ds.shutterShape.equals("POLYGONAL")) {
                List<Point2D> l5 = ds.polygonalVertices;
                int len = l5.size();
                String[] idata = new String[len * 2];
                for (int i5 = 0; i5 < len; ++i5) {
                    Point2D p3 = l5.get(i5);
                    idata[2 * i5] = "" + (int)p3.getY();
                    idata[2 * i5 + 1] = "" + (int)p3.getX();
                }
                this.setValue(24, 5664, idata);
            }
            this.setValue(24, 5666, "" + ds.shutterPValue);
        }
    }

    public static int getGSPSSeriesNo(XpDicomObject refImage) {
        refImage.getValue(seriesNo);
        int gspsSeriesNo = Integer.parseInt((String)XpDMgsps.seriesNo.value) + 100000;
        return gspsSeriesNo;
    }

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        if (args.length == 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "file";
            stringArray = stringArray2;
            stringArray2[1] = "D:/data/test/i18n/Japanese2/i147503.NMDC.62102";
        } else {
            stringArray = args;
        }
        String[] sargs = stringArray;
        String msg = "Creating DMSession with args:";
        for (int i2 = 0; i2 < sargs.length; ++i2) {
            msg = msg + " \"" + sargs[i2] + "\"";
        }
        System.out.println(msg);
        DMSession dms = new DMSession(sargs);
        DMObject[] studies = dms.getRelated("study");
        int nStudies = studies.length;
        System.out.println("Found " + nStudies + " stud" + (nStudies == 1 ? "y" : "ies"));
        DMTag[] dmTags = null;
        if (nStudies > 0) {
            DMObject[][] series = new DMObject[nStudies][];
            for (int examNo = 0; examNo < nStudies; ++examNo) {
                series[examNo] = studies[examNo].getRelated("series");
                int ns = series[examNo].length;
                for (int seriesNo = 0; seriesNo < ns; ++seriesNo) {
                    DMObject main = series[examNo][seriesNo];
                    DMImage[] dmimgs = main.getImages(dmTags);
                    int nImages = dmimgs.length;
                    XpMedicalImage[] mdi = new XpMedicalImage[nImages];
                    for (int i3 = 0; i3 < nImages; ++i3) {
                        mdi[i3] = new XpMedicalDmImage(dmimgs[i3]);
                    }
                    System.out.println("DMSession: Loading study/series: " + examNo + "/" + seriesNo + "   [" + mdi.length + " image" + (mdi.length == 1 ? "]" : "s]"));
                    XpImageViewport xpiv = new XpImageViewport();
                    xpiv.setPreferredSize(new Dimension(512, 512));
                    xpiv.setImages(mdi);
                    DicomData data = new DicomData();
                    data.read(xpiv.getGSPS());
                    data.printDebugInfo(System.out);
                }
            }
        }
    }

    private void fillRelationshipModule(XpMedicalImage[] imgs) {
        HashMap refSeriesMap = new HashMap();
        for (int i2 = 0; i2 < imgs.length; ++i2) {
            XpMedicalImage im = imgs[i2];
            im.getValue(seriesInstUID);
            im.getValue(sopUID);
            XpCPI.GSPSFrame gspsFrame = null;
            boolean isMultiFrame = XpCPI.isMultiFrame(im);
            HashSet<XpCPI.GSPSFrame> gspsFrameSet = (HashSet<XpCPI.GSPSFrame>)refSeriesMap.get(XpDMgsps.seriesInstUID.value);
            if (null == gspsFrameSet) {
                gspsFrameSet = new HashSet<XpCPI.GSPSFrame>();
            } else {
                for (XpCPI.GSPSFrame frame : gspsFrameSet) {
                    if (!frame.SOPInstanceUID.equals(XpDMgsps.sopUID.value)) continue;
                    gspsFrame = frame;
                    break;
                }
            }
            if (null == gspsFrame) {
                gspsFrame = XpCPI.createSimpleFrame(im);
            }
            if (isMultiFrame) {
                int frameNumber = XpCPI.getFrameNumber(im);
                gspsFrame.ReferencedFrameNum.add(frameNumber + 1);
            }
            gspsFrameSet.add(gspsFrame);
            refSeriesMap.put((String)XpDMgsps.seriesInstUID.value, gspsFrameSet);
        }
        int index = 0;
        for (Map.Entry seriesKey : refSeriesMap.entrySet()) {
            Set frameSet = (Set)seriesKey.getValue();
            DicomData seriesItem = new DicomData();
            XpDMgsps.fillRefImageSequence(seriesItem, frameSet);
            seriesItem.setValue(32, 14, seriesKey.getKey());
            this.setValue(8, 4373, index, seriesItem);
            ++index;
        }
    }

    private static Set<Integer> parseReferencedFrameNum(Object tagvalue) {
        String frameVal = tagvalue.toString();
        TreeSet<Integer> refFrameIndex = new TreeSet<Integer>();
        if (frameVal.indexOf(92) > -1) {
            String[] frameNumbers;
            for (String str : frameNumbers = frameVal.split(MULTI_DELIM)) {
                refFrameIndex.add(Integer.parseInt(str));
            }
        } else {
            refFrameIndex.add(Integer.parseInt(frameVal));
        }
        return refFrameIndex;
    }

    private static class GSPSDicomObject
    implements XjDicomObject {
        private XpDicomObject ref;

        public GSPSDicomObject(XpDicomObject src) {
            this.ref = src;
        }

        @Override
        public Object getValue(int group, int element) {
            XpDicomElement value = new XpDicomElement(group, element);
            this.ref.getValue(value);
            return value.value;
        }

        @Override
        public int getValues(XjTagValue[] tvs) {
            int counter = 0;
            for (int i2 = 0; i2 < tvs.length; ++i2) {
                tvs[i2].value = this.getValue(tvs[i2].group, tvs[i2].element);
                if (null == tvs[i2].value) continue;
                ++counter;
            }
            return counter;
        }
    }
}

