/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.tap.dm.DMImage;
import java.awt.image.RenderedImage;

public class XpMedicalDmImage
implements XpMedicalImage,
XjDicomObjectFrame {
    private DMImage dmi = null;
    private XpSlice _slice = null;
    private double deflevel = 0.0;
    private double defwidth = 0.0;
    private double rescaleIntercept = 0.0;
    private double rescaleSlope = 1.0;
    private double azimuth = 0.0;
    private boolean loadedDefWL = false;
    private boolean loadedDefWW = false;
    private double[] minmax = new double[2];
    private boolean init = false;
    private boolean loadedSlope = false;
    private boolean loadedIntercept = false;

    public XpMedicalDmImage(DMImage dmi) {
        this.dmi = dmi;
    }

    protected void setDefaultWindowLevel(double wl) {
        this.deflevel = wl;
        this.loadedDefWL = true;
    }

    protected void setDefaultWindowWidth(double ww) {
        this.defwidth = ww;
        this.loadedDefWW = true;
    }

    protected void setRescaleSlope(double rs) {
        this.rescaleSlope = rs;
        this.loadedSlope = true;
    }

    protected void setRescaleIntercept(double ri) {
        this.rescaleIntercept = ri;
        this.loadedIntercept = true;
    }

    protected void initImage() {
        double defwidth;
        double deflevel;
        if (this.init) {
            return;
        }
        this._slice = new XpSlice(this);
        if (!this.loadedDefWL && (deflevel = XpImageUtils.parseImageWL(this.dmi.getValue(40, 4176))) > -32767.0) {
            this.setDefaultWindowLevel(deflevel);
        }
        if (!this.loadedDefWW && (defwidth = XpImageUtils.parseImageWW(this.dmi.getValue(40, 4177))) >= 0.0) {
            this.setDefaultWindowWidth(defwidth);
        }
        if (this.defwidth == 0.0 && this.deflevel == 0.0) {
            this.loadedDefWW = false;
            this.loadedDefWL = false;
        }
        if (!this.loadedIntercept) {
            double defIntercept = XpImageUtils.parseImageRescaleIntercept(this.dmi.getValue(40, 4178));
            this.setRescaleIntercept(defIntercept);
        }
        if (!this.loadedSlope) {
            double defSlope = XpImageUtils.parseImageRescaleSlope(this.dmi.getValue(40, 4179));
            this.setRescaleSlope(defSlope);
        }
        if (this.rescaleSlope == 0.0) {
            this.rescaleSlope = 1.0;
        }
        this.loadedIntercept = true;
        this.loadedSlope = true;
        this.azimuth = XpImageUtils.gehcAzimuth(this);
        this.init = true;
    }

    @Override
    public RenderedImage getPixelData() {
        return this.dmi.getPixelData();
    }

    @Override
    public XpSlice getSlice() {
        this.initImage();
        return this._slice;
    }

    @Override
    public double getDefaultWindowWidth() {
        this.initImage();
        if (!this.loadedDefWW) {
            int subsample = 17;
            if (this._slice.width <= 128 && this._slice.height <= 128) {
                subsample = 5;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.defwidth;
    }

    @Override
    public double getDefaultWindowLevel() {
        this.initImage();
        if (!this.loadedDefWL) {
            int subsample = 16;
            if (this._slice.width <= 128 && this._slice.height <= 128) {
                subsample = 4;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.deflevel;
    }

    @Override
    public double getPixelDimensionX() {
        return this.getSlice().pixelSizeX;
    }

    @Override
    public double getPixelDimensionY() {
        return this.getSlice().pixelSizeY;
    }

    @Override
    public int getValue(XpDicomElement value) {
        value.value = value.group == 0 ? this.dmi.getProperty("" + value.group + "," + value.element) : this.dmi.getValue(value.group, value.element);
        if (value.value != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getValues(XpDicomElement[] values) {
        int notLoaded = 0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            int result = this.getValue(values[i2]);
            if (result != 1) continue;
            ++notLoaded;
        }
        return notLoaded;
    }

    public final DMImage getDMImage() {
        return this.dmi;
    }

    @Override
    public double getRescaleIntercept() {
        this.initImage();
        return this.rescaleIntercept;
    }

    @Override
    public double getRescaleSlope() {
        this.initImage();
        return this.rescaleSlope;
    }

    @Override
    public final double getAzimuth() {
        this.initImage();
        return this.azimuth;
    }

    public static XpMedicalImage[] wrapDMImages(DMImage[] dmi) {
        XpMedicalImage[] imgs = new XpMedicalImage[dmi.length];
        for (int i2 = 0; i2 < dmi.length; ++i2) {
            imgs[i2] = new XpMedicalDmImage(dmi[i2]);
        }
        return imgs;
    }

    @Override
    public int getFrameNumber() {
        return this.dmi.getFrameNumber();
    }

    @Override
    public int getNumberOfFrames() {
        return this.dmi.getNumberOfFrames();
    }

    @Override
    public XjDicomObjectFrame.MultiFrameType getMultiFrameType() {
        return this.dmi.getMultiFrameType();
    }

    @Override
    public Object getValue(String tagPath) {
        return this.dmi.getValue(tagPath);
    }

    @Override
    public Object getValue(XjTagValue tag2) {
        return this.dmi.getValue(tag2);
    }

    @Override
    public Object getValue(int frameNumber, int group, int element) {
        return this.dmi.getValue(frameNumber, group, element);
    }

    @Override
    public Object getValue(int frameNumber, XjTagValue tag2) {
        return this.dmi.getValue(frameNumber, tag2);
    }

    @Override
    public int getValues(int frameNumber, XjTagValue[] tags) {
        return this.dmi.getValues(frameNumber, tags);
    }

    @Override
    public Object getValue(int group, int element) {
        return this.dmi.getValue(this.dmi.getFrameNumber(), group, element);
    }

    @Override
    public int getValues(XjTagValue[] tags) {
        return this.dmi.getValues(this.dmi.getFrameNumber(), tags);
    }
}

