/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.plot;

import com.ge.med.terra.jami.plot.XpExternalDrawerIF;
import com.ge.med.terra.jami.plot.XpPlotter;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public abstract class XpMouseTrackerSupport
implements MouseListener,
MouseMotionListener,
XpExternalDrawerIF {
    private boolean mouse1Pressed = false;
    private boolean mouse2Pressed = false;
    private boolean mouse3Pressed = false;
    private int currX = -1;
    private int currY = -1;
    protected XpPlotter thePlotter = null;

    public XpMouseTrackerSupport(XpPlotter co) {
        this.thePlotter = co;
    }

    protected final boolean isMouse1Down() {
        return this.mouse1Pressed;
    }

    protected final boolean isMouse2Down() {
        return this.mouse2Pressed;
    }

    protected final boolean isMouse3Down() {
        return this.mouse3Pressed;
    }

    @Override
    public final void mouseClicked(MouseEvent e2) {
    }

    @Override
    public final void mouseEntered(MouseEvent e2) {
    }

    @Override
    public final void mouseExited(MouseEvent e2) {
    }

    @Override
    public final void mousePressed(MouseEvent e2) {
        int mod = e2.getModifiers();
        Point2D p2 = this.thePlotter.getPlotAreaOrigin();
        this.currX = e2.getX() - (int)p2.getX();
        this.currY = e2.getY() - (int)p2.getY();
        if ((mod & 0x10) != 0) {
            this.mouse1Pressed = true;
            this.pressMouse1(this.currX, this.currY);
        } else if ((mod & 8) != 0) {
            this.mouse2Pressed = true;
            this.pressMouse2(this.currX, this.currY);
        } else if ((mod & 4) != 0) {
            this.mouse3Pressed = true;
            this.pressMouse3(this.currX, this.currY);
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e2) {
        int mod = e2.getModifiers();
        Point2D p2 = this.thePlotter.getPlotAreaOrigin();
        this.currX = e2.getX() - (int)p2.getX();
        this.currY = e2.getY() - (int)p2.getY();
        if ((mod & 0x10) != 0) {
            this.mouse1Pressed = false;
            this.releaseMouse1(this.currX, this.currY);
        } else if ((mod & 8) != 0) {
            this.mouse2Pressed = false;
            this.releaseMouse2(this.currX, this.currY);
        } else if ((mod & 4) != 0) {
            this.mouse3Pressed = false;
            this.releaseMouse3(this.currX, this.currY);
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e2) {
        int mod = e2.getModifiers();
        Point2D p2 = this.thePlotter.getPlotAreaOrigin();
        this.currX = e2.getX() - (int)p2.getX();
        this.currY = e2.getY() - (int)p2.getY();
        if ((mod & 0x10) != 0) {
            this.dragMouse1(this.currX, this.currY);
        } else if ((mod & 8) != 0) {
            this.dragMouse2(this.currX, this.currY);
        } else if ((mod & 4) != 0) {
            this.dragMouse3(this.currX, this.currY);
        }
    }

    @Override
    public final void mouseMoved(MouseEvent e2) {
    }

    public void dragMouse1(int x2, int y2) {
    }

    public void dragMouse2(int x2, int y2) {
    }

    public void dragMouse3(int x2, int y2) {
    }

    public void pressMouse1(int x2, int y2) {
    }

    public void pressMouse2(int x2, int y2) {
    }

    public void pressMouse3(int x2, int y2) {
    }

    public void releaseMouse1(int x2, int y2) {
    }

    public void releaseMouse2(int x2, int y2) {
    }

    public void releaseMouse3(int x2, int y2) {
    }

    @Override
    public abstract void draw(Graphics2D var1);
}

