/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.session;

import com.ge.med.idc.RemoteImage;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.remote.session.WSCaller;
import com.ge.med.terra.jami.remote.session.WSImageInfo;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.Map;

public class WSImageSet {
    private XjImage[] imgs = null;
    private WSCaller caller = null;
    private String remotePath = null;
    private int imageSetId = -1;

    public WSImageSet(WSCaller caller, String remotePath) {
        this.caller = caller;
        this.remotePath = remotePath;
    }

    public XjImage[] getImages() {
        if (this.imgs == null) {
            this.imageSetId = this.caller.loadImageSet(this.remotePath);
            int nimgs = this.caller.getNumImages(this.imageSetId);
            this.imgs = new XjImage[nimgs];
            for (int i2 = 0; i2 < this.imgs.length; ++i2) {
                this.imgs[i2] = new WSImage(this.caller, this.imageSetId, i2);
            }
        }
        return this.imgs;
    }

    public int getImageSetID() {
        return this.imageSetId;
    }

    private double[] getStatistics(int id, Shape s2, double angle) {
        return null;
    }

    private void getPixels(int id, int x2, int y2, int w2, int h2, int[] pixels) {
    }

    private static class WSImage
    implements RemoteImage {
        private Map tagCache = new HashMap();
        private WSCaller caller = null;
        private int id = 0;
        private int imageSetId = -1;
        private WSImageInfo iinfo = null;

        public WSImage(WSCaller caller, int imageSetId, int id) {
            this.caller = caller;
            this.imageSetId = imageSetId;
            this.id = id;
        }

        private WSImageInfo getImageInfo() {
            if (this.iinfo == null) {
                this.iinfo = this.caller.getImage(this.imageSetId, this.id);
            }
            return this.iinfo;
        }

        @Override
        public String getRemoteDescriptor() {
            String dicom_cmp = this.getFilePath();
            int remoteSeparatorChar = dicom_cmp.lastIndexOf(47) >= 0 ? 47 : 92;
            int lastIndex = dicom_cmp.lastIndexOf(remoteSeparatorChar);
            String remoteDir = dicom_cmp.substring(0, lastIndex >= 0 ? lastIndex : dicom_cmp.length());
            return remoteDir;
        }

        @Override
        public double[] getStatistics(Shape s2, double angle) {
            return null;
        }

        @Override
        public int[] getPixels(int x2, int y2, int w2, int h2, int[] pixels) {
            if (pixels == null) {
                pixels = new int[w2 * h2];
            }
            return pixels;
        }

        @Override
        public String getFilePath() {
            return this.getImageInfo().getFilePath();
        }

        @Override
        public int getHeight() {
            return this.getImageInfo().getHeight();
        }

        @Override
        public RenderedImage getImageData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getPixelOffset() {
            return 0L;
        }

        @Override
        public int getWidth() {
            return this.getImageInfo().getWidth();
        }

        @Override
        public Object getValue(int group, int element) {
            if (group == 39321) {
                return new Integer(this.id);
            }
            if (group == 39320) {
                return new Integer(this.imageSetId);
            }
            String key = "" + group + "," + element;
            if (this.tagCache.containsKey(key)) {
                return this.tagCache.get(key);
            }
            XjTagValue tv = new XjTagValue(group, element);
            int nvals = this.caller.getValues(this.imageSetId, this.id, new XjTagValue[]{tv});
            this.tagCache.put("" + group + "," + element, tv.value);
            return tv.value;
        }

        @Override
        public int getValues(XjTagValue[] tv) {
            for (int i2 = 0; i2 < tv.length; ++i2) {
                Object value = this.getValue(tv[i2].group, tv[i2].element);
                if (value == null) continue;
                tv[i2].value = value;
            }
            return tv.length;
        }
    }
}

