/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.session;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public abstract class XmPixelTransferService
extends XmServiceAdapter {
    protected static final byte RESPONSE = 3;
    protected static final byte RESPOND = 4;
    protected static final byte EXCEPTION = 5;
    protected static final byte NO_RESPOND = 6;
    protected Method[] methods;
    protected boolean onServer = false;
    private static int tcount = 1234;
    private XmSession xms;
    private XmServiceStatus stat = new XmServiceStatus();
    private Vector que = new Vector();
    private boolean kill = false;
    private Msg SENT = new Msg(-1);
    private Object[] args = new Object[1];
    private Hashtable responseMap = new Hashtable();
    private Thread queMgr = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Vector vector = XmPixelTransferService.this.que;
                synchronized (vector) {
                    while (XmPixelTransferService.this.que.isEmpty()) {
                        try {
                            XmPixelTransferService.this.que.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!XmPixelTransferService.this.kill) continue;
                        return;
                    }
                }
                XmPixelTransferService.this.processValue((Msg)XmPixelTransferService.this.que.remove(0));
            }
        }
    };

    protected XmPixelTransferService() {
        this.queMgr.setDaemon(false);
        this.queMgr.setName(this.getClass().getSimpleName() + " Command Queue Thread");
        this.queMgr.start();
    }

    public void installInto(XmSession xms) {
        this.xms = xms;
        xms.installHandle(this);
    }

    protected XmSession getParent() {
        return this.xms;
    }

    @Override
    public void setParent(XmSession parent) {
        this.xms = parent;
        this.onServer = !parent.isClient();
    }

    public short getParentId() {
        short id = null != this.xms ? (short)this.xms.getId() : (short)-1;
        return id;
    }

    public void close() {
        this.xms.uninstallHandle(this.getID());
    }

    @Override
    public XmServiceStatus getStatus() {
        return this.stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionLost() {
        this.kill = true;
        Vector vector = this.que;
        synchronized (vector) {
            this.que.notifyAll();
        }
    }

    public boolean isClosed() {
        return this.kill;
    }

    protected void setMethods(String[] methodNames) {
        this.methods = new Method[methodNames.length];
        Class<?> c2 = this.getClass();
        for (int i2 = 0; i2 < methodNames.length; ++i2) {
            try {
                this.methods[i2] = c2.getMethod(methodNames[i2], byte[].class);
                continue;
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Unable to set methods associated to remote commands: ", ex);
            }
        }
    }

    public static synchronized int newTid() {
        return ++tcount;
    }

    public int call(byte cmd, byte sync, byte[] data) {
        return this.call(cmd, sync, data, 0, data.length);
    }

    public int call(byte cmd, byte sync, byte[] data, int offset, int length) {
        Msg out = new Msg(this.id);
        int tid = XmPixelTransferService.newTid();
        out.setData(cmd, sync, tid, data, offset, length);
        this.xms.writeMessage(out);
        return tid;
    }

    public byte[] callSync(byte cmd, byte[] data) {
        int tid = this.call(cmd, (byte)4, data);
        return this.waitForRsp(cmd, tid);
    }

    public byte[] callSync(byte cmd, byte[] data, int offset, int length) {
        int tid = this.call(cmd, (byte)4, data, offset, length);
        return this.waitForRsp(cmd, tid);
    }

    public byte[] callSync(byte cmd, byte[] data, long timeout) throws InterruptedException, TimeoutException {
        int tid = this.call(cmd, (byte)4, data);
        return this.waitForRsp(cmd, tid, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] waitForRsp(byte cmd, int tid) {
        Long msgT = this.computeMessageTag(cmd, tid);
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            while (!this.responseMap.containsKey(msgT)) {
                try {
                    this.responseMap.wait();
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            Msg m2 = (Msg)this.responseMap.remove(msgT);
            if (m2.command[1] == 5) {
                throw new RuntimeException((Throwable)Utils.bytesToObject(m2.msgBuffer));
            }
            return m2.msgBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] waitForRsp(byte cmd, int tid, long timeout) throws InterruptedException, TimeoutException {
        Long msgT = this.computeMessageTag(cmd, tid);
        long start = System.currentTimeMillis();
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            while (!this.responseMap.containsKey(msgT)) {
                this.responseMap.wait(timeout);
                if (System.currentTimeMillis() - start <= timeout) continue;
                throw new TimeoutException("Exceeed timeout " + timeout + " ms");
            }
            Msg m2 = (Msg)this.responseMap.remove(msgT);
            if (m2.command[1] == 5) {
                throw new RuntimeException((Throwable)Utils.bytesToObject(m2.msgBuffer));
            }
            return m2.msgBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readMessage(InputStream is) throws IOException {
        Msg m2 = new Msg(this.id);
        int ret = m2.readMessage(is);
        this.que.add(m2);
        Vector vector = this.que;
        synchronized (vector) {
            this.que.notifyAll();
        }
        return ret;
    }

    @Override
    public int writeMessage(OutputStream os, short mid) throws IOException {
        throw new RuntimeException("This should never be used");
    }

    private void processValue(Msg m2) {
        if (m2.getID() == -1) {
            this.messageSent();
            return;
        }
        Object ret = null;
        if (m2.command[1] == 3 || m2.command[1] == 5) {
            this.processResponse(m2);
            return;
        }
        if (m2.command[1] != 4) {
            m2.setTID(0);
        }
        if (this.methods.length <= m2.command[0] || this.methods[m2.command[0]] == null) {
            Tap.log.log(Level.WARNING, "No such command: {0}", m2.command[0]);
            this.sendResponse(m2, (byte)5, Utils.objectToBytes(new NoSuchMethodError("No such command: " + m2.command[0])));
            return;
        }
        try {
            this.args[0] = m2.msgBuffer;
            ret = this.methods[m2.command[0]].invoke((Object)this, this.args);
            if (m2.command[1] == 4) {
                this.sendResponse(m2, (byte)3, ret);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.sendResponse(m2, (byte)5, Utils.objectToBytes(e2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(Msg m2) {
        int tid = m2.getTID();
        if (0 == tid) {
            try {
                this.processAsyncException(m2);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return;
        }
        Long msgT = this.computeMessageTag(m2.getCommand(), tid);
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            this.responseMap.put(msgT, m2);
            this.responseMap.notifyAll();
        }
    }

    protected void messageSent() {
    }

    protected void processAsyncException(Msg errmsg) {
    }

    protected Long computeMessageTag(Msg msg) {
        return this.computeMessageTag(msg.getCommand(), msg.getTID());
    }

    protected Long computeMessageTag(byte cmd, int tid) {
        return new Long((long)cmd << 32 | (long)tid);
    }

    private void sendResponse(Msg m2, byte response, Object ret) {
        m2.command[1] = response;
        if (ret instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)ret;
            byte[] msg = bb.array();
            int offset = bb.position();
            int length = bb.limit() - offset;
            m2.setMessage(msg, offset, length);
        } else {
            m2.setMessage((byte[])ret);
        }
        this.xms.writeMessage(m2);
    }

    protected class Msg
    extends XmServiceAdapter {
        public static final int CMD = 0;
        public static final int RES = 1;
        public static final int TID = 2;
        public static final int LEN = 6;
        public byte[] command = new byte[10];
        public int offset;
        public int len;
        public byte[] msgBuffer;

        public Msg(short id) {
            this.id = id;
        }

        public void setData(byte cmd, byte sync, int tid, byte[] msg) {
            byte[] data = null == msg ? new byte[]{} : msg;
            this.setData(cmd, sync, tid, data, 0, data.length);
        }

        public void setData(byte cmd, byte sync, int tid, byte[] msg, int offset, int length) {
            byte[] data = null == msg ? new byte[]{} : msg;
            this.command[0] = cmd;
            this.command[1] = sync;
            Utils.putInt(this.command, 2, tid);
            Utils.putInt(this.command, 6, length);
            this.offset = offset;
            this.len = length;
            this.msgBuffer = data;
        }

        public void setMessage(byte[] msg) {
            this.setMessage(msg, 0, null == msg ? 0 : msg.length);
        }

        public void setMessage(byte[] msg, int offset, int length) {
            if (null == msg) {
                this.msgBuffer = new byte[0];
                this.offset = 0;
                this.setLen(this.msgBuffer.length);
            } else {
                this.msgBuffer = msg;
                this.offset = offset;
                this.setLen(length);
            }
        }

        public void setLen(int len) {
            this.len = len;
            Utils.putInt(this.command, 6, len);
        }

        public int getTID() {
            return Utils.getInt(this.command, 2);
        }

        public void setTID(int tid) {
            Utils.putInt(this.command, 2, tid);
        }

        public byte getCommand() {
            return this.command[0];
        }

        @Override
        public int readMessage(InputStream is) throws IOException {
            Utils.readFully(is, this.command);
            this.len = Utils.getInt(this.command, 6);
            this.msgBuffer = new byte[this.len];
            Utils.readFully(is, this.msgBuffer);
            return this.len + this.command.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int writeMessage(OutputStream os, short mid) throws IOException {
            os.write(this.command);
            os.write(this.msgBuffer, this.offset, this.len);
            XmPixelTransferService.this.que.add(XmPixelTransferService.this.SENT);
            Vector vector = XmPixelTransferService.this.que;
            synchronized (vector) {
                XmPixelTransferService.this.que.notifyAll();
            }
            return this.len + this.command.length;
        }

        public String toString() {
            String str = "";
            str = str + "(command=" + this.command[0] + ") ";
            str = str + "(response=" + this.command[1] + ") ";
            str = str + "(length=" + this.len + ")";
            return str;
        }
    }
}

