/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.render.PixelWindowingBase;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;

public class PixelWindowing
extends PixelWindowingBase {
    private int lIdx = 0;
    private int hIdx = 0;
    private int[] pColorTable = null;
    private boolean pVideoInverted = false;
    private ColorOverrides cover = null;

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), attr.isVideoInverted(), attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation);
    }

    public final void fillColorTable(XpImagePixelAttributes attr, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), attr.isVideoInverted(), attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation);
    }

    public final void fillColorTable(XpImageRenderAttributes attr, int[] rgb, boolean invVideo, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), invVideo, attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation);
    }

    public final void fillColorTable(XpImagePixelAttributes attr, int[] rgb, boolean invVideo, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        this.fillColorTable(attr.getWindowWidth(), attr.getWindowLevel(), invVideo, attr.getColormap(), rgb, rescaleSlope, rescaleIntercept, pixelRepresentation);
    }

    @Override
    protected final void fillColorTable(double winwidth, double winlevel, boolean ivideo, boolean isCMAP, boolean changeCM, int[] rgb, double rescaleSlope, double rescaleIntercept, int pixelRepresentation) {
        int MAXVALUE;
        double dp;
        int X_HI;
        boolean videoInverted = ivideo;
        double ww = winwidth / rescaleSlope;
        double wl = (winlevel - rescaleIntercept) / rescaleSlope;
        double plo = wl - 0.5 * ww;
        double phi = plo + ww;
        int ilo = (int)plo;
        if (ilo >= rgb.length) {
            ilo = rgb.length - 1;
        }
        int half = rgb.length >> 1;
        int X_LO = pixelRepresentation == 0 ? 0 : -half;
        int n2 = X_HI = pixelRepresentation == 0 ? rgb.length - 1 : half - 1;
        if (this.pColorTable != rgb || this.pVideoInverted != videoInverted || changeCM) {
            this.pColorTable = rgb;
            this.lIdx = X_LO;
            this.hIdx = X_HI;
            this.pVideoInverted = videoInverted;
        }
        double d2 = dp = isCMAP ? (double)this.cmap.length / ww : 255.0 / ww;
        if (ilo <= this.lIdx) {
            this.lIdx = Math.max(ilo, X_LO);
        }
        int i2 = Math.max(this.lIdx, X_LO);
        int overflowIdx = X_HI;
        int len = isCMAP ? this.cmap.length : 256;
        int OFFSET = 0;
        int SIGN = 1;
        int MINVALUE = isCMAP ? this.cmap[0] : -16777216;
        int n3 = MAXVALUE = isCMAP ? this.cmap[len - 1] : -1;
        if (videoInverted) {
            OFFSET = len - 1;
            SIGN = -1;
            MINVALUE = isCMAP ? MAXVALUE : -1;
            MAXVALUE = isCMAP ? this.cmap[0] : -16777216;
        }
        int M_VALUE = rgb.length - 1;
        try {
            int b2;
            while (i2 <= ilo) {
                rgb[i2 & M_VALUE] = MINVALUE;
                ++i2;
            }
            if (isCMAP) {
                while (i2 <= X_HI) {
                    b2 = (int)((double)(i2 - ilo) * dp);
                    if (b2 > len - 1) {
                        overflowIdx = i2;
                        break;
                    }
                    b2 = OFFSET + SIGN * b2;
                    rgb[i2 & M_VALUE] = this.cmap[b2];
                    ++i2;
                }
            } else {
                while (i2 <= X_HI) {
                    int x2;
                    b2 = (int)((double)(i2 - ilo) * dp);
                    if (b2 > 255) {
                        overflowIdx = i2;
                        break;
                    }
                    b2 = OFFSET + SIGN * b2;
                    rgb[i2 & M_VALUE] = x2 = 0xFF000000 | b2 << 16 | b2 << 8 | b2;
                    ++i2;
                }
            }
            while (i2 <= this.hIdx) {
                rgb[i2 & M_VALUE] = MAXVALUE;
                ++i2;
            }
            if (this.cover != null && this.cover.length > 0) {
                this.applyColorOverride(rgb);
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            int idx = i2 & M_VALUE;
            XpLog.logger().severe("Exception: WW/WL bad index=" + i2 + " uindex=" + idx + " ilo=" + ilo);
        }
        this.lIdx = ilo;
        this.hIdx = overflowIdx;
    }

    private static void printRGB(int idx, int v2) {
        int r2 = (v2 & 0xFF0000) >> 16;
        int g2 = (v2 & 0xFF00) >> 8;
        int b2 = v2 & 0xFF;
        short val = (short)idx;
        System.err.println("" + idx + "   " + val + "   : (r,g,b) = (" + r2 + "," + g2 + "," + b2 + ")");
    }

    private void applyColorOverride(int[] rgb) {
        for (int j2 = 0; j2 < this.cover.length; ++j2) {
            int color;
            int idx = this.cover.luminance[j2] & 0xFFFF;
            rgb[idx] = color = this.cover.color[j2];
        }
    }

    @Override
    protected void initializeColorOverrides(int size) {
        if (this.cmTable == null || this.cmTable.length != size) {
            this.cmTable = new int[size];
            this.cover = new ColorOverrides(size);
        }
        this.cover.reset();
    }

    @Override
    protected void loadColorOverrides(int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            int pixVal = this.cmTable[i2];
            int red = (pixVal & 0xFF0000) >> 16;
            int green = (pixVal & 0xFF00) >> 8;
            int blue = pixVal & 0xFF;
            if (red == green && red == blue) continue;
            this.cover.overrideColors(i2, pixVal);
        }
    }

    private static class ColorOverrides {
        public int[] luminance = null;
        public int[] color = null;
        public int length = 0;

        public ColorOverrides(int size) {
            this.luminance = new int[size];
            this.color = new int[size];
        }

        public final void reset() {
            this.length = 0;
        }

        public final void overrideColors(int lumIndex, int colorVal) {
            this.luminance[this.length] = lumIndex;
            this.color[this.length] = colorVal;
            ++this.length;
        }
    }
}

