/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpOverlayFilter;
import com.ge.med.terra.jami.render.XpPixels;

public abstract class XpImageDrawableBase {
    public static final String INT_RGB = "int_rgb";
    public static final String BYTE_BGR = "byte_bgr";
    public static final String LUMINANCE_BYTE = "luminance_byte";
    private static final int USHORT_MAX = 65535;
    private static final int ALPHA_MAX = 256;
    protected byte[] overlay_bytebuff = null;
    protected short[] overlay_shortbuff = null;

    public void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
    }

    public void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
    }

    public void pixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
        XpColorOverlay co = ira.getColorOverlay();
        boolean doMask = false;
        if (co != null) {
            int len = co.getLength();
            if (sourcePixels.getLength() == len) {
                doMask = true;
            }
        }
        if (doMask) {
            this.maskPixelTransfer(sourcePixels, colorTable, ira);
        } else {
            this.basicPixelTransfer(sourcePixels, colorTable, ira);
        }
    }

    public final void maskPixelTransferByteBGR(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira, int nPixels, byte[] pixels) {
        XpColorOverlay co = ira.getColorOverlay();
        int[] cmap = co.getColorMap();
        Object clayer = co.getOverlay();
        int overlayOffset = co.getOffset();
        int overlayLength = co.getLength();
        XpOverlayFilter f2 = co.getOverlayFilter();
        int len = sourcePixels.getLength();
        int offset = sourcePixels.getOffset();
        int bpp = sourcePixels.getBPP();
        int mask = (1 << bpp) - 1;
        int endOffset = offset + len;
        int idx = 0;
        int pixIdx = 0;
        short[] sData = sourcePixels.getShortData();
        byte[] bData = sourcePixels.getByteData();
        if (len != nPixels) {
            return;
        }
        try {
            if (sData != null) {
                if (clayer instanceof byte[]) {
                    byte[] overlay = (byte[])clayer;
                    if (f2 != null) {
                        if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlayLength) {
                            this.overlay_bytebuff = new byte[overlayLength];
                            this.overlay_shortbuff = null;
                        }
                        f2.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_bytebuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        byte b2;
                        byte g2;
                        byte r2;
                        int v2 = sData[srcIdx] & mask;
                        pixIdx = v2 & 0xFFFF;
                        int pixVal = colorTable[pixIdx];
                        int maskIdx = overlay[overlayIdx] & 0xFF;
                        if (maskIdx != 255) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            r2 = (byte)(pred &= 0xFF);
                            g2 = (byte)(pgreen &= 0xFF);
                            b2 = (byte)(pblue &= 0xFF);
                        } else {
                            r2 = (byte)(pixVal >> 16 & 0xFF);
                            g2 = (byte)(pixVal >> 8 & 0xFF);
                            b2 = (byte)(pixVal & 0xFF);
                        }
                        pixels[idx] = b2;
                        pixels[idx + 1] = g2;
                        pixels[idx + 2] = r2;
                        idx += 3;
                        ++srcIdx;
                        ++overlayIdx;
                    }
                } else {
                    short[] overlay = (short[])clayer;
                    if (f2 != null) {
                        if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                            this.overlay_shortbuff = new short[overlay.length];
                            this.overlay_bytebuff = null;
                        }
                        f2.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_shortbuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        byte b3;
                        byte g3;
                        byte r3;
                        int v3 = sData[srcIdx] & mask;
                        pixIdx = v3 & 0xFFFF;
                        int pixVal = colorTable[pixIdx];
                        int maskIdx = overlay[overlayIdx] & 0xFFFF;
                        if (maskIdx != 65535) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            r3 = (byte)(pred &= 0xFF);
                            g3 = (byte)(pgreen &= 0xFF);
                            b3 = (byte)(pblue &= 0xFF);
                        } else {
                            r3 = (byte)(pixVal >> 16 & 0xFF);
                            g3 = (byte)(pixVal >> 8 & 0xFF);
                            b3 = (byte)(pixVal & 0xFF);
                        }
                        pixels[idx] = b3;
                        pixels[idx + 1] = g3;
                        pixels[idx + 2] = r3;
                        idx += 3;
                        ++srcIdx;
                        ++overlayIdx;
                    }
                }
            } else if (clayer instanceof byte[]) {
                byte[] overlay = (byte[])clayer;
                if (f2 != null) {
                    if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlay.length) {
                        this.overlay_bytebuff = new byte[overlay.length];
                        this.overlay_shortbuff = null;
                    }
                    f2.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                    overlay = this.overlay_bytebuff;
                    overlayOffset = 0;
                }
                int srcIdx = offset;
                int overlayIdx = overlayOffset;
                while (srcIdx < endOffset) {
                    byte b4;
                    byte g4;
                    byte r4;
                    pixIdx = bData[srcIdx] & 0xFF;
                    int pixVal = colorTable[pixIdx];
                    byte maskIdx = overlay[overlayIdx];
                    if (maskIdx >= 0) {
                        int maskVal = cmap[maskIdx];
                        int red = (pixVal & 0xFF0000) >> 16;
                        int green = (pixVal & 0xFF00) >> 8;
                        int blue = pixVal & 0xFF;
                        int malpha = (maskVal & 0xFF000000) >> 24;
                        int mred = (maskVal & 0xFF0000) >> 16;
                        int mgreen = (maskVal & 0xFF00) >> 8;
                        int mblue = maskVal & 0xFF;
                        malpha = malpha < 0 ? 256 + malpha : malpha;
                        int ONE_MINALPHA = 256 - malpha;
                        int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                        int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                        int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                        r4 = (byte)(pred &= 0xFF);
                        g4 = (byte)(pgreen &= 0xFF);
                        b4 = (byte)(pblue &= 0xFF);
                    } else {
                        r4 = (byte)(pixVal >> 16 & 0xFF);
                        g4 = (byte)(pixVal >> 8 & 0xFF);
                        b4 = (byte)(pixVal & 0xFF);
                    }
                    pixels[idx] = b4;
                    pixels[idx + 1] = g4;
                    pixels[idx + 2] = r4;
                    idx += 3;
                    ++srcIdx;
                    ++overlayIdx;
                }
            } else {
                short[] overlay = (short[])clayer;
                if (f2 != null) {
                    if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                        this.overlay_shortbuff = new short[overlay.length];
                        this.overlay_bytebuff = null;
                    }
                    f2.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                    overlay = this.overlay_shortbuff;
                    overlayOffset = 0;
                }
                int srcIdx = offset;
                int overlayIdx = overlayOffset;
                while (srcIdx < endOffset) {
                    byte b5;
                    byte g5;
                    byte r5;
                    pixIdx = bData[srcIdx] & 0xFF;
                    int pixVal = colorTable[pixIdx];
                    short maskIdx = overlay[overlayIdx];
                    if (maskIdx >= 0) {
                        int maskVal = cmap[maskIdx];
                        int red = (pixVal & 0xFF0000) >> 16;
                        int green = (pixVal & 0xFF00) >> 8;
                        int blue = pixVal & 0xFF;
                        int malpha = (maskVal & 0xFF000000) >> 24;
                        int mred = (maskVal & 0xFF0000) >> 16;
                        int mgreen = (maskVal & 0xFF00) >> 8;
                        int mblue = maskVal & 0xFF;
                        malpha = malpha < 0 ? 256 + malpha : malpha;
                        int ONE_MINALPHA = 256 - malpha;
                        int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                        int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                        int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                        r5 = (byte)(pred &= 0xFF);
                        g5 = (byte)(pgreen &= 0xFF);
                        b5 = (byte)(pblue &= 0xFF);
                    } else {
                        r5 = (byte)(pixVal >> 16 & 0xFF);
                        g5 = (byte)(pixVal >> 8 & 0xFF);
                        b5 = (byte)(pixVal & 0xFF);
                    }
                    pixels[idx] = b5;
                    pixels[idx + 1] = g5;
                    pixels[idx + 2] = r5;
                    idx += 3;
                    ++srcIdx;
                    ++overlayIdx;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            XpLog.logger().severe("Invalid Array Index: " + pixIdx + "  length=" + colorTable.length);
        }
    }

    public final void basicPixelTransferByteBGR(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira, int nPixels, byte[] pixels) {
        int len = sourcePixels.getLength();
        int offset = sourcePixels.getOffset();
        int bpp = sourcePixels.getBPP();
        int mask = (1 << bpp) - 1;
        int endOffset = offset + len;
        int idx = 0;
        int pixIdx = 0;
        short[] sData = sourcePixels.getShortData();
        byte[] bData = sourcePixels.getByteData();
        if (len != nPixels) {
            return;
        }
        try {
            if (sData != null) {
                for (int i2 = offset; i2 < endOffset; ++i2) {
                    byte b2;
                    int v2 = sData[i2] & mask;
                    pixIdx = v2 & 0xFFFF;
                    int pixVal = colorTable[pixIdx];
                    byte r2 = (byte)(pixVal >> 16 & 0xFF);
                    byte g2 = (byte)(pixVal >> 8 & 0xFF);
                    pixels[idx] = b2 = (byte)(pixVal & 0xFF);
                    pixels[idx + 1] = g2;
                    pixels[idx + 2] = r2;
                    idx += 3;
                }
            } else {
                for (int i3 = offset; i3 < endOffset; ++i3) {
                    byte b3;
                    pixIdx = bData[i3] & 0xFF;
                    int pixVal = colorTable[pixIdx];
                    byte r3 = (byte)(pixVal >> 16 & 0xFF);
                    byte g3 = (byte)(pixVal >> 8 & 0xFF);
                    pixels[idx] = b3 = (byte)(pixVal & 0xFF);
                    pixels[idx + 1] = g3;
                    pixels[idx + 2] = r3;
                    idx += 3;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            XpLog.logger().severe("Invalid Array Index: " + pixIdx + "  length=" + colorTable.length);
        }
    }

    public final void maskPixelTransferIntRGB(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira, int[] pixels) {
        XpColorOverlay co = ira.getColorOverlay();
        int[] cmap = co.getColorMap();
        Object clayer = co.getOverlay();
        int overlayOffset = co.getOffset();
        int overlayLength = co.getLength();
        XpOverlayFilter f2 = co.getOverlayFilter();
        int len = sourcePixels.getLength();
        int offset = sourcePixels.getOffset();
        int bpp = sourcePixels.getBPP();
        int mask = (1 << bpp) - 1;
        int endOffset = offset + len;
        int dlen = pixels.length;
        int pixIdx = 0;
        int idx = 0;
        int destIdx = 0;
        short[] sData = sourcePixels.getShortData();
        byte[] bData = sourcePixels.getByteData();
        if (len != dlen) {
            return;
        }
        try {
            if (sData != null) {
                destIdx = 0;
                if (clayer instanceof byte[]) {
                    byte[] overlay = (byte[])clayer;
                    if (f2 != null) {
                        if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlayLength) {
                            this.overlay_bytebuff = new byte[overlay.length];
                            this.overlay_shortbuff = null;
                        }
                        f2.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_bytebuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        idx = srcIdx;
                        int v2 = sData[srcIdx] & mask;
                        pixIdx = v2 & 0xFFFF;
                        int pixVal = colorTable[pixIdx];
                        int maskIdx = overlay[overlayIdx] & 0xFF;
                        if (maskIdx != 255) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                        }
                        pixels[destIdx] = pixVal & 0xFFFFFFFF;
                        ++srcIdx;
                        ++overlayIdx;
                        ++destIdx;
                    }
                } else {
                    short[] overlay = (short[])clayer;
                    if (f2 != null) {
                        if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                            this.overlay_shortbuff = new short[overlay.length];
                            this.overlay_bytebuff = null;
                        }
                        f2.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_shortbuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        idx = srcIdx;
                        int v3 = sData[srcIdx] & mask;
                        pixIdx = v3 & 0xFFFF;
                        int pixVal = colorTable[pixIdx];
                        int maskIdx = overlay[overlayIdx] & 0xFFFF;
                        if (maskIdx != 65535) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                        }
                        pixels[destIdx] = pixVal & 0xFFFFFFFF;
                        ++srcIdx;
                        ++overlayIdx;
                        ++destIdx;
                    }
                }
            } else {
                destIdx = 0;
                if (clayer instanceof byte[]) {
                    byte[] overlay = (byte[])clayer;
                    if (f2 != null) {
                        if (this.overlay_bytebuff == null || this.overlay_bytebuff.length != overlay.length) {
                            this.overlay_bytebuff = new byte[overlay.length];
                            this.overlay_shortbuff = null;
                        }
                        f2.filter(overlay, overlayOffset, this.overlay_bytebuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_bytebuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        idx = srcIdx;
                        pixIdx = bData[srcIdx] & 0xFF;
                        int pixVal = colorTable[pixIdx];
                        byte maskIdx = overlay[overlayOffset];
                        if (maskIdx >= 0) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                        }
                        pixels[destIdx] = pixVal & 0xFFFFFFFF;
                        ++srcIdx;
                        ++overlayIdx;
                        ++destIdx;
                    }
                } else {
                    short[] overlay = (short[])clayer;
                    if (f2 != null) {
                        if (this.overlay_shortbuff == null || this.overlay_shortbuff.length != overlay.length) {
                            this.overlay_shortbuff = new short[overlay.length];
                            this.overlay_bytebuff = null;
                        }
                        f2.filter(overlay, overlayOffset, this.overlay_shortbuff, 0, this.getWidth(), this.getHeight());
                        overlay = this.overlay_shortbuff;
                        overlayOffset = 0;
                    }
                    int srcIdx = offset;
                    int overlayIdx = overlayOffset;
                    while (srcIdx < endOffset) {
                        idx = srcIdx;
                        pixIdx = bData[srcIdx] & 0xFF;
                        int pixVal = colorTable[pixIdx];
                        short maskIdx = overlay[overlayIdx];
                        if (maskIdx >= 0) {
                            int maskVal = cmap[maskIdx];
                            int red = (pixVal & 0xFF0000) >> 16;
                            int green = (pixVal & 0xFF00) >> 8;
                            int blue = pixVal & 0xFF;
                            int malpha = (maskVal & 0xFF000000) >> 24;
                            int mred = (maskVal & 0xFF0000) >> 16;
                            int mgreen = (maskVal & 0xFF00) >> 8;
                            int mblue = maskVal & 0xFF;
                            malpha = malpha < 0 ? 256 + malpha : malpha;
                            int ONE_MINALPHA = 256 - malpha;
                            int pred = malpha * mred + ONE_MINALPHA * red >> 8;
                            int pgreen = malpha * mgreen + ONE_MINALPHA * green >> 8;
                            int pblue = malpha * mblue + ONE_MINALPHA * blue >> 8;
                            pixVal = 0xFF000000 | (pred &= 0xFF) << 16 | (pgreen &= 0xFF) << 8 | (pblue &= 0xFF);
                        }
                        pixels[destIdx] = pixVal & 0xFFFFFFFF;
                        ++srcIdx;
                        ++overlayIdx;
                        ++destIdx;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            int dataLen = 0;
            dataLen = sData != null ? sData.length : bData.length;
            XpLog.logger().severe("Invalid Array Index= [" + dataLen + "," + pixIdx + "," + idx + "] Length= [" + colorTable.length + "," + len + "," + dlen + "]");
            aiob.printStackTrace();
        }
    }

    public final void basicPixelTransferIntRGB(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira, int[] pixels) {
        int len = sourcePixels.getLength();
        int offset = sourcePixels.getOffset();
        int bpp = sourcePixels.getBPP();
        int mask = (1 << bpp) - 1;
        int endOffset = offset + len;
        int dlen = pixels.length;
        int pixIdx = 0;
        int idx = 0;
        int destIdx = 0;
        short[] sData = sourcePixels.getShortData();
        byte[] bData = sourcePixels.getByteData();
        int dtype = sourcePixels.getDataType();
        if (len != dlen) {
            return;
        }
        try {
            if (sData != null) {
                destIdx = 0;
                boolean signed = dtype == 1;
                int i2 = offset;
                while (i2 < endOffset) {
                    idx = i2;
                    int v2 = sData[i2] & mask;
                    pixIdx = v2 & 0xFFFF;
                    int pixVal = colorTable[pixIdx];
                    pixels[destIdx] = pixVal & 0xFFFFFFFF;
                    ++i2;
                    ++destIdx;
                }
            } else {
                destIdx = 0;
                int i3 = offset;
                while (i3 < endOffset) {
                    idx = i3;
                    pixIdx = bData[i3] & 0xFF;
                    int pixVal = colorTable[pixIdx];
                    pixels[destIdx] = pixVal & 0xFFFFFFFF;
                    ++i3;
                    ++destIdx;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            int dataLen = 0;
            dataLen = sData != null ? sData.length : bData.length;
            XpLog.logger().severe("Invalid Array Index= [" + dataLen + "," + pixIdx + "," + idx + "] Length= [" + colorTable.length + "," + len + "," + dlen + "]");
        }
    }

    public final void maskPixelTransferLuminanceByte(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira, byte[] pixels) {
        this.basicPixelTransferLuminanceByte(sourcePixels, colorTable, ira, pixels);
    }

    public final void basicPixelTransferLuminanceByte(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira, byte[] pixels) {
        int len = sourcePixels.getLength();
        int offset = sourcePixels.getOffset();
        int endOffset = offset + len;
        int dlen = pixels.length;
        int pixIdx = 0;
        byte[] bData = sourcePixels.getByteData();
        short[] sData = sourcePixels.getShortData();
        if (len != dlen) {
            return;
        }
        try {
            int didx = 0;
            if (bData != null) {
                int i2 = offset;
                while (i2 < endOffset) {
                    pixIdx = bData[i2] & 0xFF;
                    int pixVal = colorTable[pixIdx];
                    int val = pixVal & 0xFF;
                    pixels[didx] = (byte)val;
                    ++i2;
                    ++didx;
                }
            } else {
                int i3 = offset;
                while (i3 < endOffset) {
                    pixIdx = sData[i3] & 0xFFFF;
                    int pixVal = colorTable[pixIdx];
                    int val = pixVal & 0xFF;
                    pixels[didx] = (byte)val;
                    ++i3;
                    ++didx;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            XpLog.logger().severe("Invalid Array Index: " + pixIdx + "  length=" + colorTable.length);
        }
    }

    public abstract int getWidth();

    public abstract int getHeight();
}

