/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributesBase;
import java.util.ArrayList;
import java.util.List;

public class XpImageRenderAttributes
extends XpImageRenderAttributesBase
implements Cloneable {
    public static final int SCALE_TO_FIT = 100;
    public static final int TRUE_SIZE = 101;
    public static final int MAGNIFY = 102;
    private double zoom = 1.0;
    private int presentationSizeMode = 100;
    private List imageOpList = new ArrayList();
    private XpColorOverlay cOverlay = null;

    public final double getWindowWidth() {
        return this.getImagePixelAttributes().getWindowWidth();
    }

    public final double getWindowLevel() {
        return this.getImagePixelAttributes().getWindowLevel();
    }

    public final void setWindowMinMax(double min, double max) {
        this.getImagePixelAttributes().setWindowMinMax(min, max);
    }

    public final double getWindowMin() {
        return this.getImagePixelAttributes().getWindowMin();
    }

    public final double getWindowMax() {
        return this.getImagePixelAttributes().getWindowMax();
    }

    public final void setWindowWidth(double w2) {
        this.getImagePixelAttributes().setWindowWidth(w2);
    }

    public final void setWindowLevel(double l2) {
        this.getImagePixelAttributes().setWindowLevel(l2);
    }

    public final void setWindowing(double ww, double wl) {
        this.getImagePixelAttributes().setWindowing(ww, wl);
    }

    public final double getPanX() {
        return this.getImageOrientation().getPanX();
    }

    public final double getPanY() {
        return this.getImageOrientation().getPanY();
    }

    public final void setPan(double panx, double pany) {
        this.getImageOrientation().setPan(panx, pany);
    }

    public final double getZoom() {
        return this.zoom;
    }

    public final void setZoom(double z2) {
        this.zoom = z2;
    }

    public final int getPresentationSizeMode() {
        return this.presentationSizeMode;
    }

    public final void setPresentationSizeMode(int presentationSizeMode) {
        this.presentationSizeMode = presentationSizeMode;
    }

    public final double getAngle() {
        return this.getImageOrientation().getAngle();
    }

    public void setAngle(double a2) {
        this.getImageOrientation().setAngle(a2);
    }

    public final void setVideoInverted(boolean inverse) {
        this.getImagePixelAttributes().setVideoInverted(inverse);
    }

    public final boolean isVideoInverted() {
        return this.getImagePixelAttributes().isVideoInverted();
    }

    public final void addImageOperation(XpImageOp imageOp) {
        this.imageOpList.add(imageOp);
    }

    public final void setImageOperationList(List imgOpList) {
        if (imgOpList == this.imageOpList) {
            return;
        }
        this.imageOpList.clear();
        int len = imgOpList.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Object o2 = imgOpList.get(i2);
            this.imageOpList.add(o2);
        }
    }

    public final List getImageOperations() {
        return this.imageOpList;
    }

    public final void clearImageOperations() {
        this.imageOpList.clear();
    }

    public final void clearColorMap() {
        this.getImagePixelAttributes().clearColorMap();
    }

    public final void setImageOrientation(XpImageOrientation aior) {
        this.getImageOrientation().set(aior);
    }

    public final void setColorOverlay(XpColorOverlay overlay) {
        this.cOverlay = overlay;
    }

    public final XpColorOverlay getColorOverlay() {
        return this.cOverlay;
    }

    public XpImageRenderAttributes() {
    }

    public XpImageRenderAttributes(XpImageRenderAttributes other) {
        this.set(other);
    }

    public final void set(XpImageRenderAttributes other) {
        this.getImagePixelAttributes().set(other.getImagePixelAttributes());
        this.zoom = other.zoom;
        this.clipShape = other.clipShape;
        this.imageClipShape = other.imageClipShape;
        this.getImageOrientation().set(other.getImageOrientation());
        this.setImageOperationList(other.getImageOperations());
    }

    public Object clone() {
        return new XpImageRenderAttributes(this);
    }

    public final boolean equals(XpImageRenderAttributes other) {
        return this.equalsPixelTransfer(other) && this.equalsGeometry(other);
    }

    public final boolean equalsGeometry(XpImageRenderAttributes other) {
        if (this == other) {
            return true;
        }
        if (this.zoom != other.getZoom()) {
            return false;
        }
        if (this.getImageOrientation().getPanX() != other.getImageOrientation().getPanX()) {
            return false;
        }
        if (this.getImageOrientation().getPanY() != other.getImageOrientation().getPanY()) {
            return false;
        }
        return this.getImageOrientation().equals(other.getImageOrientation());
    }

    public final boolean equalsPixelTransfer(XpImageRenderAttributes other) {
        if (this == other) {
            return true;
        }
        if (!this.getImagePixelAttributes().equalsPixelTransfer(other.getImagePixelAttributes())) {
            return false;
        }
        return this.cOverlay == other.cOverlay;
    }

    @Override
    protected final boolean equalsPixelTransfer(XpColorOverlay cOverlay) {
        return cOverlay == this.cOverlay;
    }

    public final void reset() {
        this.resetAffine();
        this.clipShape = null;
        this.imageClipShape = null;
        this.getImagePixelAttributes().reset();
        this.cOverlay = null;
    }

    public final void resetAffine() {
        this.getImageOrientation().setPan(0.0, 0.0);
        this.zoom = 1.0;
        this.getImageOrientation().reset();
    }

    public final void resetPixel(double ww, double wl) {
        this.getImagePixelAttributes().resetPixel(ww, wl);
        this.cOverlay = null;
    }

    public String toString() {
        double windowWidth = this.getImagePixelAttributes().getWindowWidth();
        double windowLevel = this.getImagePixelAttributes().getWindowLevel();
        return this.getClass().getName() + ": {" + windowWidth + "W " + windowLevel + "L (" + this.getImageOrientation().getPanX() + "," + this.getImageOrientation().getPanY() + ")=pan " + this.zoom + "=zoom " + this.getImageOrientation().getAngle() + "=angle " + this.getImagePixelAttributes().getColormap() + "=colormap [" + this.clipShape + "]=clipShape [" + this.imageClipShape + "]=imageClipShape}";
    }
}

