/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.render.PixelWindowing;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpOffscreenRendererBase;
import com.ge.med.terra.jami.render.XpPipeline;
import java.util.Arrays;

public abstract class XpOffscreenRenderer
extends XpOffscreenRendererBase {
    private static final double EPSILON = 0.009;
    private static final int TABLE_SIZE = 65536;
    protected int[] colorTable = new int[65536];
    private PixelWindowing pw = new PixelWindowing();
    private JnAffineTransform tx = null;
    private XpImagePixelAttributes ipa = new XpImagePixelAttributes();
    private XpImage image = null;
    private int owidth = 0;
    private int oheight = 0;
    private int iwidth = 0;
    private int iheight = 0;
    private double ww = 0.0;
    private double wl = 0.0;
    private boolean ivideo = false;
    private boolean doPixelTransfer = true;
    private int pixelRepresentation = 1;
    private int pixelPaddingValue = 0;
    private XpDicomElement[] pixvalues = new XpDicomElement[]{new XpDicomElement(40, 256), new XpDicomElement(40, 257), new XpDicomElement(40, 259), new XpDicomElement(40, 288)};
    private double[] ident = new double[6];

    public XpOffscreenRenderer(int owidth, int oheight) {
        this.owidth = owidth;
        this.oheight = oheight;
        this.tx = new JnAffineTransform();
        this.tx.setToIdentity();
    }

    public abstract int[] getRaster();

    public final XpImagePixelAttributes getImagePixelAttributes() {
        return this.ipa;
    }

    public final void setImagePixelAttributes(XpImagePixelAttributes ipa) {
        this.ipa = ipa;
        if (this.ww != ipa.getWindowWidth() || this.wl != ipa.getWindowLevel() || this.ivideo != ipa.isVideoInverted() || this.icm != ipa.getColormap()) {
            this.doPixelTransfer = true;
            this.ww = ipa.getWindowWidth();
            this.wl = ipa.getWindowLevel();
            this.ivideo = ipa.isVideoInverted();
            this.icm = ipa.getColormap();
        }
    }

    public final boolean isPixelTransfer() {
        return this.doPixelTransfer;
    }

    protected void setPixelTransfer(boolean doPixelTransfer) {
        this.doPixelTransfer = doPixelTransfer;
    }

    protected PixelWindowing getPixelWindowing() {
        return this.pw;
    }

    @Override
    public final XpImage getImage() {
        return this.image;
    }

    public final void setImage(XpImage image) {
        this.image = image;
        if (image != null) {
            this.iwidth = image.getSlice().width;
            this.iheight = image.getSlice().height;
            boolean loadBitsAlloc = false;
            boolean loadBitsStored = false;
            boolean loadPixelRep = false;
            boolean loadPixelPadding = false;
            if (image instanceof XpDicomObject) {
                XpDicomObject dobj = (XpDicomObject)((Object)image);
                loadBitsAlloc = dobj.getValue(this.pixvalues[0]) == 0;
                loadBitsStored = dobj.getValue(this.pixvalues[1]) == 0;
                loadPixelRep = dobj.getValue(this.pixvalues[2]) == 0;
                boolean bl = loadPixelPadding = dobj.getValue(this.pixvalues[3]) == 0;
                if (loadBitsAlloc) {
                    String bits_alloc = "" + this.pixvalues[0].value;
                    try {
                        this.bitsAllocated = Integer.parseInt(bits_alloc);
                        if (this.bitsAllocated <= 0) {
                            loadBitsAlloc = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsAlloc = false;
                    }
                }
                if (loadBitsStored) {
                    String bits_stored = "" + this.pixvalues[1].value;
                    try {
                        this.bitsStored = Integer.parseInt(bits_stored);
                        if (this.bitsStored <= 0) {
                            loadBitsStored = false;
                        }
                    }
                    catch (NumberFormatException ne) {
                        loadBitsStored = false;
                    }
                }
                if (loadPixelRep) {
                    try {
                        this.pixelRepresentation = Integer.parseInt("" + this.pixvalues[2].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelRep = false;
                    }
                }
                if (loadPixelPadding) {
                    try {
                        this.pixelPaddingValue = Integer.parseInt("" + this.pixvalues[3].value);
                    }
                    catch (NumberFormatException ne) {
                        loadPixelPadding = false;
                    }
                }
            }
            if (!loadBitsAlloc) {
                this.bitsAllocated = -1;
            }
            if (!loadBitsStored) {
                this.bitsStored = -1;
            }
            if (!loadPixelRep) {
                this.pixelRepresentation = 1;
            }
            if (!loadPixelPadding) {
                this.pixelPaddingValue = -2000;
            }
            this.newImage();
        }
    }

    @Override
    public final void setImage(XpImage image, JnAffineTransform at) {
        this.setImage(image);
        this.tx = at;
    }

    @Override
    public final JnAffineTransform getJnAffineTransform() {
        return this.tx;
    }

    @Override
    protected boolean isIdentity(JnAffineTransform at) {
        at.getMatrix(this.ident);
        boolean id = true;
        id = id && Math.abs(this.ident[0] - 1.0) < 0.009;
        id = id && Math.abs(this.ident[1]) < 0.009;
        id = id && Math.abs(this.ident[2]) < 0.009;
        id = id && Math.abs(this.ident[3] - 1.0) < 0.009;
        id = id && Math.abs(this.ident[4] - 1.0) < 0.009;
        id = id && Math.abs(this.ident[5] - 1.0) < 0.009;
        return id;
    }

    @Override
    public final void setImage(XpImage image, JnPoint2D UL, JnPoint2D UR, JnPoint2D BR) {
        this.setImage(image);
        this.geomUtils.calcAffineTransform(UL, UR, BR, this.iwidth, this.iheight, this.owidth, this.oheight, this.tx);
    }

    public final int getWidth() {
        return this.owidth;
    }

    public final int getHeight() {
        return this.oheight;
    }

    public final int getInputWidth() {
        return this.iwidth;
    }

    public final int getInputHeight() {
        return this.iheight;
    }

    public abstract short[] getLuminanceRaster();

    public abstract int getLuminanceRasterWidth();

    public abstract int getLuminanceRasterHeight();

    protected final void calcInverse(JnAffineTransform src, JnAffineTransform dest) {
        this.geomUtils.calcInverse(src, dest);
    }

    protected static double min(double a2, double b2) {
        if (a2 < b2) {
            return a2;
        }
        return b2;
    }

    protected static double max(double a2, double b2) {
        if (a2 > b2) {
            return a2;
        }
        return b2;
    }

    public abstract void render(Object var1, double var2);

    protected abstract void newImage();

    public void refresh() {
    }

    protected final void shortToARGB(short[] sData, int offset, int len, int[] colorTable, int[] pixels) {
        int bpp = this.getBitsStored();
        int msk = (1 << bpp) - 1;
        int endOffset = offset + len;
        int dlen = pixels.length;
        int pixIdx = 0;
        int idx = 0;
        int destIdx = 0;
        try {
            if (sData != null) {
                destIdx = 0;
                int i2 = offset;
                while (i2 < endOffset) {
                    idx = i2;
                    int v2 = sData[i2] & msk;
                    pixIdx = v2 & 0xFFFF;
                    int pixVal = colorTable[pixIdx];
                    pixels[destIdx] = pixVal & 0xFFFFFFFF;
                    ++i2;
                    ++destIdx;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            int dataLen = sData.length;
            XpLog.logger().severe("Invalid Array Index= [" + dataLen + "," + pixIdx + "," + idx + "] Length= [" + colorTable.length + "," + len + "," + dlen + "]");
        }
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getPixelPaddingValue() {
        return this.pixelPaddingValue;
    }

    public static class ARGBAffineWWWL
    extends XpOffscreenRenderer {
        private short[] drawable = null;
        private int[] outbuffer = null;
        private double[] tx = new double[6];
        private double[] itx = new double[6];
        private JnAffineTransform inverse = new JnAffineTransform();
        private JnPoint2D iul = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D ibl = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D iur = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D ibr = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D tx_iul = new JnPoint2D.Double();
        private JnPoint2D tx_ibl = new JnPoint2D.Double();
        private JnPoint2D tx_iur = new JnPoint2D.Double();
        private JnPoint2D tx_ibr = new JnPoint2D.Double();
        private boolean do_tx = true;

        public ARGBAffineWWWL(int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = new int[owidth * oheight];
        }

        public ARGBAffineWWWL(int[] outbuffer, int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = outbuffer;
        }

        @Override
        protected void newImage() {
            int owidth = this.getWidth();
            int oheight = this.getHeight();
            this.drawable = new short[owidth * oheight];
        }

        @Override
        public int[] getRaster() {
            return this.outbuffer;
        }

        @Override
        public short[] getLuminanceRaster() {
            return this.drawable;
        }

        @Override
        public int getLuminanceRasterWidth() {
            return this.getWidth();
        }

        @Override
        public int getLuminanceRasterHeight() {
            return this.getHeight();
        }

        @Override
        public void refresh() {
            super.refresh();
            this.do_tx = true;
            this.setPixelTransfer(true);
        }

        @Override
        public final void render(Object interpolationHint, double shiftpixel) {
            boolean doPixelTransfer = this.isPixelTransfer();
            XpImagePixelAttributes ipa = this.getImagePixelAttributes();
            XpImage image = this.getImage();
            int owidth = this.getWidth();
            int oheight = this.getHeight();
            PixelWindowing pw = this.getPixelWindowing();
            double ww = ipa.getWindowWidth();
            double wl = ipa.getWindowLevel();
            double slope = image.getRescaleSlope();
            double intercept = image.getRescaleIntercept();
            if (this.do_tx) {
                this.renderLuminance(interpolationHint, shiftpixel);
                this.do_tx = false;
            }
            if (doPixelTransfer) {
                this.setPixelTransfer(false);
                pw.fillColorTable(ww, wl, ipa.isVideoInverted(), ipa.getColormap(), this.colorTable, slope, intercept, this.getPixelRepresentation());
                int len = owidth * oheight;
                this.shortToARGB(this.drawable, 0, len, this.colorTable, this.outbuffer);
            }
        }

        private void renderLuminance(Object interpolationHint, double shiftpixel) {
            double yy;
            JnAffineTransform at = this.getJnAffineTransform();
            int inWidth = this.getInputWidth();
            int inHeight = this.getInputHeight();
            int outWidth = this.getWidth();
            int outHeight = this.getHeight();
            short[] sdata = this.getLuminanceRasterARGBWWWLAffine();
            int offset = this.getLuminanceRasterOffsetARGBWWWLAffine();
            double miny = 0.0;
            double maxy = 0.0;
            double minx = 0.0;
            double maxx = 0.0;
            int iminy = 0;
            int imaxy = 0;
            int iminx = 0;
            int imaxx = 0;
            int w2 = inWidth;
            int h2 = inHeight;
            short background = sdata[0];
            if (shiftpixel != 0.0) {
                at = new JnAffineTransform(at);
                at.translate(shiftpixel, shiftpixel);
            }
            boolean identity = this.isIdentity(at);
            at.getMatrix(this.tx);
            this.calcInverse(at, this.inverse);
            this.inverse.getMatrix(this.itx);
            double dx = this.itx[0] * 1.0 + this.itx[2] * 0.0;
            double dy = this.itx[1] * 1.0 + this.itx[3] * 0.0;
            double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
            double deg = Math.toDegrees(angle) * 10000.0;
            int ideg = (int)deg;
            boolean uprightFlag = ideg % 3600000 == 0;
            int pixelRepresentation = this.getPixelRepresentation();
            int img_bpp = this.getBitsStored();
            this.ibl.setLocation(0.0, h2);
            this.iur.setLocation(w2, 0.0);
            this.ibr.setLocation(w2, h2);
            at.transform(this.iul, this.tx_iul);
            double xx = this.tx_iul.getX();
            miny = yy = this.tx_iul.getY();
            maxy = yy;
            minx = xx;
            maxx = xx;
            at.transform(this.ibl, this.tx_ibl);
            xx = this.tx_ibl.getX();
            yy = this.tx_ibl.getY();
            miny = ARGBAffineWWWL.min(miny, yy);
            maxy = ARGBAffineWWWL.max(maxy, yy);
            minx = ARGBAffineWWWL.min(minx, xx);
            maxx = ARGBAffineWWWL.max(maxx, xx);
            at.transform(this.iur, this.tx_iur);
            xx = this.tx_iur.getX();
            yy = this.tx_iur.getY();
            miny = ARGBAffineWWWL.min(miny, yy);
            maxy = ARGBAffineWWWL.max(maxy, yy);
            minx = ARGBAffineWWWL.min(minx, xx);
            maxx = ARGBAffineWWWL.max(maxx, xx);
            at.transform(this.ibr, this.tx_ibr);
            xx = this.tx_ibr.getX();
            yy = this.tx_ibr.getY();
            miny = ARGBAffineWWWL.min(miny, yy);
            maxy = ARGBAffineWWWL.max(maxy, yy);
            minx = ARGBAffineWWWL.min(minx, xx);
            maxx = ARGBAffineWWWL.max(maxx, xx);
            miny = ARGBAffineWWWL.max(miny, 0.0);
            iminy = (int)miny;
            maxy = ARGBAffineWWWL.min(maxy, outHeight - 1);
            imaxy = (int)maxy;
            minx = ARGBAffineWWWL.max(minx, 0.0);
            iminx = (int)minx;
            maxx = ARGBAffineWWWL.min(maxx, outWidth - 1);
            imaxx = (int)maxx;
            if (this.interpolationHintIsNearestNeighbor(interpolationHint)) {
                XpPipeline.doNearestNeighborShortToShort(this.itx, sdata, offset, w2, h2, pixelRepresentation, img_bpp, this.drawable, outWidth, outHeight, iminx, imaxx, iminy, imaxy, background);
            } else if (uprightFlag) {
                if (identity && sdata.length == this.drawable.length) {
                    System.arraycopy(sdata, offset, this.drawable, 0, sdata.length);
                } else {
                    Arrays.fill(this.drawable, background);
                    XpPipeline.doBilinearShortToShortUpright(this.tx, this.itx, sdata, offset, w2, h2, pixelRepresentation, img_bpp, this.drawable, outWidth, outHeight, background);
                }
            } else {
                XpPipeline.doBilinearShortToShort(this.itx, sdata, offset, w2, h2, pixelRepresentation, img_bpp, this.drawable, outWidth, outHeight, iminx, imaxx, iminy, imaxy, background);
            }
        }
    }

    public static class ARGBWWWLAffine
    extends XpOffscreenRenderer {
        private int[] drawable = null;
        private int[] outbuffer = null;
        private double[] tx = new double[6];
        private double[] itx = new double[6];
        private JnAffineTransform inverse = new JnAffineTransform();
        private JnPoint2D iul = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D ibl = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D iur = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D ibr = new JnPoint2D.Double(0.0, 0.0);
        private JnPoint2D tx_iul = new JnPoint2D.Double();
        private JnPoint2D tx_ibl = new JnPoint2D.Double();
        private JnPoint2D tx_iur = new JnPoint2D.Double();
        private JnPoint2D tx_ibr = new JnPoint2D.Double();

        public ARGBWWWLAffine(int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = new int[owidth * oheight];
        }

        public ARGBWWWLAffine(int[] outbuffer, int owidth, int oheight) {
            super(owidth, oheight);
            this.outbuffer = outbuffer;
        }

        @Override
        protected void newImage() {
            int w2 = this.getInputWidth();
            int h2 = this.getInputHeight();
            this.drawable = new int[w2 * h2];
        }

        @Override
        public int[] getRaster() {
            return this.outbuffer;
        }

        @Override
        public short[] getLuminanceRaster() {
            return this.getLuminanceRasterARGBWWWLAffine();
        }

        @Override
        public int getLuminanceRasterWidth() {
            return this.getImage().getSlice().width;
        }

        @Override
        public int getLuminanceRasterHeight() {
            return this.getImage().getSlice().height;
        }

        @Override
        public final void render(Object interpolationHint, double shiftpixel) {
            boolean doPixelTransfer = this.isPixelTransfer();
            XpImagePixelAttributes ipa = this.getImagePixelAttributes();
            XpImage image = this.getImage();
            int iwidth = this.getInputWidth();
            int iheight = this.getInputHeight();
            PixelWindowing pw = this.getPixelWindowing();
            if (doPixelTransfer) {
                this.setPixelTransfer(false);
                pw.fillColorTable(ipa.getWindowWidth(), ipa.getWindowLevel(), ipa.isVideoInverted(), ipa.getColormap(), this.colorTable, image.getRescaleSlope(), image.getRescaleIntercept(), this.getPixelRepresentation());
                short[] sdata = this.getLuminanceRaster();
                int len = iwidth * iheight;
                int offset = this.getLuminanceRasterOffsetARGBWWWLAffine();
                this.shortToARGB(sdata, offset, len, this.colorTable, this.drawable);
            }
            this.renderImageWWWLAffine(interpolationHint);
        }

        private void renderImageWWWLAffine(Object interpolationHint) {
            double yy;
            JnAffineTransform at = this.getJnAffineTransform();
            int inWidth = this.getInputWidth();
            int inHeight = this.getInputHeight();
            int outWidth = this.getWidth();
            int outHeight = this.getHeight();
            double miny = 0.0;
            double maxy = 0.0;
            double minx = 0.0;
            double maxx = 0.0;
            int iminy = 0;
            int imaxy = 0;
            int iminx = 0;
            int imaxx = 0;
            int w2 = inWidth;
            int h2 = inHeight;
            at.getMatrix(this.tx);
            this.calcInverse(at, this.inverse);
            this.inverse.getMatrix(this.itx);
            double dx = this.itx[0] * 1.0 + this.itx[2] * 0.0;
            double dy = this.itx[1] * 1.0 + this.itx[3] * 0.0;
            double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
            double deg = Math.toDegrees(angle) * 10000.0;
            int ideg = (int)deg;
            boolean uprightFlag = ideg % 900000 == 0;
            this.ibl.setLocation(0.0, h2);
            this.iur.setLocation(w2, 0.0);
            this.ibr.setLocation(w2, h2);
            at.transform(this.iul, this.tx_iul);
            double xx = this.tx_iul.getX();
            miny = yy = this.tx_iul.getY();
            maxy = yy;
            minx = xx;
            maxx = xx;
            at.transform(this.ibl, this.tx_ibl);
            xx = this.tx_ibl.getX();
            yy = this.tx_ibl.getY();
            miny = ARGBWWWLAffine.min(miny, yy);
            maxy = ARGBWWWLAffine.max(maxy, yy);
            minx = ARGBWWWLAffine.min(minx, xx);
            maxx = ARGBWWWLAffine.max(maxx, xx);
            at.transform(this.iur, this.tx_iur);
            xx = this.tx_iur.getX();
            yy = this.tx_iur.getY();
            miny = ARGBWWWLAffine.min(miny, yy);
            maxy = ARGBWWWLAffine.max(maxy, yy);
            minx = ARGBWWWLAffine.min(minx, xx);
            maxx = ARGBWWWLAffine.max(maxx, xx);
            at.transform(this.ibr, this.tx_ibr);
            xx = this.tx_ibr.getX();
            yy = this.tx_ibr.getY();
            miny = ARGBWWWLAffine.min(miny, yy);
            maxy = ARGBWWWLAffine.max(maxy, yy);
            minx = ARGBWWWLAffine.min(minx, xx);
            maxx = ARGBWWWLAffine.max(maxx, xx);
            miny = ARGBWWWLAffine.max(miny, 0.0);
            iminy = (int)miny;
            maxy = ARGBWWWLAffine.min(maxy, outHeight - 1);
            imaxy = (int)maxy;
            minx = ARGBWWWLAffine.max(minx, 0.0);
            iminx = (int)minx;
            maxx = ARGBWWWLAffine.min(maxx, outWidth - 1);
            imaxx = (int)maxx;
            if (this.interpolationHintIsNearestNeighbor(interpolationHint)) {
                XpPipeline.doNearestNeighborINT_RGB(this.itx, this.drawable, w2, h2, this.outbuffer, outWidth, outHeight, iminx, imaxx, iminy, imaxy, 0);
            } else if (uprightFlag) {
                XpPipeline.doBilinearToINT_RGBUpright(this.tx, this.itx, this.drawable, 0, w2, h2, this.outbuffer, outWidth, outHeight, this.iul, this.ibl, this.iur, this.ibr, 0);
            } else {
                XpPipeline.doBilinearToINT_RGB(this.itx, this.drawable, w2, h2, this.outbuffer, outWidth, outHeight, iminx, imaxx, iminy, imaxy, 0);
            }
        }
    }
}

